# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class InstanceSearchConfiguration(Model):
    """Represents search configuration of an instance.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param entity_config: Gets search configurations for entities
    :type entity_config:
     list[~dynamics.customerinsights.api.models.EntitySearchConfiguration]
    :param is_system_generated: Gets a value indicating whether the
     configuration was system generated
    :type is_system_generated: bool
    :ivar version: Gets the version number of this object.
    :vartype version: long
    :ivar updated_by: Gets the UPN of the user who last updated this record.
    :vartype updated_by: str
    :ivar updated_utc: Gets the time the object was last updated.
    :vartype updated_utc: datetime
    :ivar created_by: Gets the email address of the user who created this
     record.
    :vartype created_by: str
    :ivar created_utc: Gets the time the object was initially created.
    :vartype created_utc: datetime
    :ivar instance_id: Gets the Customer Insights instance id associated with
     this object.
    :vartype instance_id: str
    """

    _validation = {
        'version': {'readonly': True},
        'updated_by': {'readonly': True},
        'updated_utc': {'readonly': True},
        'created_by': {'readonly': True},
        'created_utc': {'readonly': True},
        'instance_id': {'readonly': True},
    }

    _attribute_map = {
        'entity_config': {'key': 'entityConfig', 'type': '[EntitySearchConfiguration]'},
        'is_system_generated': {'key': 'isSystemGenerated', 'type': 'bool'},
        'version': {'key': 'version', 'type': 'long'},
        'updated_by': {'key': 'updatedBy', 'type': 'str'},
        'updated_utc': {'key': 'updatedUtc', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_utc': {'key': 'createdUtc', 'type': 'iso-8601'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
    }

    def __init__(self, *, entity_config=None, is_system_generated: bool=None, **kwargs) -> None:
        super(InstanceSearchConfiguration, self).__init__(**kwargs)
        self.entity_config = entity_config
        self.is_system_generated = is_system_generated
        self.version = None
        self.updated_by = None
        self.updated_utc = None
        self.created_by = None
        self.created_utc = None
        self.instance_id = None
