# Generated by Django 3.2.12 on 2022-03-28 19:12

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('sites', '0002_alter_domain_unique'),
        ('simpel_products', '0001_initial'),
        ('simpel_themes', '0004_alter_screenshoot_template'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Deliverable',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('issued_date', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Issued date')),
                ('customer_id', models.IntegerField(blank=True, null=True, verbose_name='Customer ID')),
                ('template', models.CharField(blank=True, editable=False, max_length=255, null=True, verbose_name='Deliverable Template')),
                ('attachment', models.FileField(blank=True, null=True, upload_to='', verbose_name='attachment')),
                ('live', models.BooleanField(default=False)),
                ('customer_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='deliverable_customers', to='contenttypes.contenttype', verbose_name='Customer Type')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_projects.deliverable_set+', to='contenttypes.contenttype')),
            ],
            options={
                'verbose_name': 'Deliverable',
                'verbose_name_plural': 'Deliverables',
                'db_table': 'simpel_project_deliverable',
                'permissions': (('import_deliverable', 'Can import Deliverable'), ('export_deliverable', 'Can export Deliverable')),
            },
        ),
        migrations.CreateModel(
            name='FinalDocument',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('status', models.IntegerField(choices=[(0, 'Processed'), (0, 'Complete')], default=0)),
                ('created_at', models.DateTimeField(blank=True, default=django.utils.timezone.now, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, default=django.utils.timezone.now, editable=False, null=True)),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_projects.finaldocument_set+', to='contenttypes.contenttype')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='final_documents', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Final Document',
                'verbose_name_plural': 'Final Documents',
                'db_table': 'simpel_project_final_document',
                'permissions': (('import_finaldocument', 'Can import Final Document'), ('export_finaldocument', 'Can export Final Document')),
            },
        ),
        migrations.CreateModel(
            name='CancelationDeliverable',
            fields=[
                ('deliverable_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_projects.deliverable')),
                ('reason', models.CharField(blank=True, max_length=255, null=True, verbose_name='Cancelation reason')),
            ],
            options={
                'verbose_name': 'Cancelation Note',
                'verbose_name_plural': 'Cancelation Notes',
                'db_table': 'simpel_project_cancelation_note',
                'permissions': (('import_cancelationdeliverable', 'Can import Cancelation Note'), ('export_cancelationdeliverable', 'Can export Cancelation Note')),
            },
            bases=('simpel_projects.deliverable',),
        ),
        migrations.CreateModel(
            name='DocumentDeliverable',
            fields=[
                ('deliverable_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='simpel_projects.deliverable')),
            ],
            options={
                'verbose_name': 'Document Deliverable',
                'verbose_name_plural': 'Document Deliverables',
                'db_table': 'simpel_project_deliverable_document',
                'permissions': (('import_documentdeliverable', 'Can import Document Deliverable'), ('export_documentdeliverable', 'Can export Document Deliverable')),
            },
            bases=('simpel_projects.deliverable',),
        ),
        migrations.CreateModel(
            name='WorkOrder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('date_trashed', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date trashed')),
                ('date_drafted', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date drafted')),
                ('date_validated', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date validated')),
                ('date_completed', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='date completed')),
                ('status', models.IntegerField(choices=[(0, 'Draft'), (0, 'Trash'), (0, 'Valid'), (0, 'Complete')], default=0)),
                ('customer_id', models.IntegerField(blank=True, null=True, verbose_name='Customer ID')),
                ('reference_id', models.CharField(max_length=255, null=True, verbose_name='Reference')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('content', models.CharField(blank=True, max_length=255, null=True, verbose_name='Content')),
                ('data', models.JSONField(blank=True, help_text='Extra data in JSON format.', null=True, verbose_name='Data')),
                ('autoprocess', models.BooleanField(blank=True, default=True, help_text='Auto proccess reference when work order validated.', null=True, verbose_name='Auto Process')),
                ('autoclose', models.BooleanField(blank=True, default=True, help_text='Auto close reference whene all task done.', null=True, verbose_name='Auto Close')),
                ('progress', models.DecimalField(decimal_places=2, default=0.0, editable=False, max_digits=5, verbose_name='Progress')),
                ('customer_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='workorder_customers', to='contenttypes.contenttype', verbose_name='Customer Type')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='workorders', to='simpel_products.group', verbose_name='Group')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_projects.workorder_set+', to='contenttypes.contenttype')),
                ('reference_type', models.ForeignKey(help_text='Please select reference type, then provide valid inner id as reference, otherwise leave it blank.', limit_choices_to={'model__in': ['salesorder']}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='workorders', to='contenttypes.contenttype')),
                ('user', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='workorders', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'Work Order',
                'verbose_name_plural': 'Work Orders',
                'db_table': 'simpel_project_workorder',
                'permissions': (('import_workorder', 'Can import Work Order'), ('export_workorder', 'Can export Work Order'), ('validate_workorder', 'Can validate Work Order'), ('process_workorder', 'Can process Work Order'), ('complete_workorder', 'Can complete Work Order')),
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('position', models.IntegerField(default=0, help_text='Enable sortable position', verbose_name='position')),
                ('start_at', models.DateField(default=django.utils.timezone.now, verbose_name='Start')),
                ('end_at', models.DateField(default=django.utils.timezone.now, verbose_name='End')),
                ('name', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='name')),
                ('reference_id', models.CharField(max_length=255, null=True, verbose_name='Reference')),
                ('quantity', models.PositiveIntegerField(default=1, verbose_name='Quantity')),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_simpel_projects.task_set+', to='contenttypes.contenttype')),
                ('reference_type', models.ForeignKey(help_text='Please select reference type, then provide valid inner id as reference, otherwise leave it blank.', limit_choices_to={'model__in': ['salesorderitem']}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='tasks', to='contenttypes.contenttype')),
                ('workorder', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='simpel_projects.workorder')),
            ],
            options={
                'verbose_name': 'Task',
                'verbose_name_plural': 'Tasks',
                'db_table': 'simpel_project_task',
                'ordering': ('position',),
                'permissions': (('import_task', 'Can import Task'), ('export_task', 'Can export Tasks'), ('export_complete', 'Can complete Tasks')),
            },
        ),
        migrations.CreateModel(
            name='ProjectsSetting',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('invoice_template', models.ForeignKey(blank=True, help_text='Custom Work Order template.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='simpel_themes.pathmodeltemplate', verbose_name='Work Order Template')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FinalDocumentRegistry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reg_number', models.PositiveIntegerField(blank=True, editable=False, null=True, verbose_name='Reg number')),
                ('inner_id', models.CharField(blank=True, editable=False, max_length=50, null=True, unique=True, verbose_name='Inner ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='created at')),
                ('final_document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='registers', to='simpel_projects.finaldocument')),
            ],
            options={
                'verbose_name': 'Final Document Registry',
                'verbose_name_plural': 'Final Document Registries',
                'db_table': 'simpel_project_final_document_registry',
                'permissions': (('import_finaldocumentregistry', 'Can import Final Document Registry'), ('export_finaldocumentregistry', 'Can export Final Document Registries')),
            },
        ),
        migrations.CreateModel(
            name='FinalDocumentItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, default=django.utils.timezone.now, editable=False, null=True)),
                ('updated_at', models.DateTimeField(blank=True, default=django.utils.timezone.now, editable=False, null=True)),
                ('reference', models.CharField(max_length=255, verbose_name='Deliverable Number')),
                ('note', models.CharField(blank=True, max_length=255, null=True, verbose_name='Note')),
                ('deliverable', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='finaldocument_items', to='simpel_projects.deliverable', verbose_name='Deliverable')),
                ('final_document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='simpel_projects.finaldocument', verbose_name='Final Document')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Final Document Item',
                'verbose_name_plural': 'Final Document Items',
                'db_table': 'simpel_project_final_document_item',
                'permissions': (('import_finaldocumentitem', 'Can import Final Document Item'), ('export_finaldocumentitem', 'Can export Final Document Item')),
            },
        ),
        migrations.AddField(
            model_name='finaldocument',
            name='workorder',
            field=models.OneToOneField(limit_choices_to={'status__in': [2, 6, 7]}, on_delete=django.db.models.deletion.CASCADE, related_name='final_document', to='simpel_projects.workorder', verbose_name='Sales Order'),
        ),
        migrations.AddField(
            model_name='deliverable',
            name='task',
            field=models.ForeignKey(limit_choices_to={'workorder__status': 0}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='deliverables', to='simpel_projects.task', verbose_name='Task'),
        ),
    ]
