"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabContainerRunner = exports.InstanceInterruptionBehavior = exports.BlockDuration = void 0;
const path = require("path");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @experimental
 */
var BlockDuration;
(function (BlockDuration) {
    BlockDuration[BlockDuration["ONE_HOUR"] = 60] = "ONE_HOUR";
    BlockDuration[BlockDuration["TWO_HOURS"] = 120] = "TWO_HOURS";
    BlockDuration[BlockDuration["THREE_HOURS"] = 180] = "THREE_HOURS";
    BlockDuration[BlockDuration["FOUR_HOURS"] = 240] = "FOUR_HOURS";
    BlockDuration[BlockDuration["FIVE_HOURS"] = 300] = "FIVE_HOURS";
    BlockDuration[BlockDuration["SIX_HOURS"] = 360] = "SIX_HOURS";
    BlockDuration[BlockDuration["SEVEN_HOURS"] = 420] = "SEVEN_HOURS";
    BlockDuration[BlockDuration["EIGHT_HOURS"] = 480] = "EIGHT_HOURS";
    BlockDuration[BlockDuration["NINE_HOURS"] = 540] = "NINE_HOURS";
    BlockDuration[BlockDuration["TEN_HOURS"] = 600] = "TEN_HOURS";
    BlockDuration[BlockDuration["ELEVEN_HOURS"] = 660] = "ELEVEN_HOURS";
    BlockDuration[BlockDuration["TWELVE_HOURS"] = 720] = "TWELVE_HOURS";
    BlockDuration[BlockDuration["THIRTEEN_HOURS"] = 780] = "THIRTEEN_HOURS";
    BlockDuration[BlockDuration["FOURTEEN_HOURS"] = 840] = "FOURTEEN_HOURS";
    BlockDuration[BlockDuration["FIFTEEN_HOURS"] = 900] = "FIFTEEN_HOURS";
    BlockDuration[BlockDuration["SIXTEEN_HOURS"] = 960] = "SIXTEEN_HOURS";
    BlockDuration[BlockDuration["SEVENTEEN_HOURS"] = 1020] = "SEVENTEEN_HOURS";
    BlockDuration[BlockDuration["EIGHTTEEN_HOURS"] = 1080] = "EIGHTTEEN_HOURS";
    BlockDuration[BlockDuration["NINETEEN_HOURS"] = 1140] = "NINETEEN_HOURS";
    BlockDuration[BlockDuration["TWENTY_HOURS"] = 1200] = "TWENTY_HOURS";
})(BlockDuration = exports.BlockDuration || (exports.BlockDuration = {}));
/**
 * @experimental
 */
var InstanceInterruptionBehavior;
(function (InstanceInterruptionBehavior) {
    InstanceInterruptionBehavior["HIBERNATE"] = "hibernate";
    InstanceInterruptionBehavior["STOP"] = "stop";
    InstanceInterruptionBehavior["TERMINATE"] = "terminate";
})(InstanceInterruptionBehavior = exports.InstanceInterruptionBehavior || (exports.InstanceInterruptionBehavior = {}));
/**
 * @experimental
 */
class GitlabContainerRunner extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        super(scope, id);
        const spotFleetId = id;
        const token = props.gitlabtoken;
        const tag1 = (_a = props.tag1) !== null && _a !== void 0 ? _a : 'gitlab';
        const tag2 = (_b = props.tag2) !== null && _b !== void 0 ? _b : 'awscdk';
        const tag3 = (_c = props.tag3) !== null && _c !== void 0 ? _c : 'runner';
        const gitlaburl = (_d = props.gitlaburl) !== null && _d !== void 0 ? _d : 'https://gitlab.com/';
        const ec2type = (_e = props.ec2type) !== null && _e !== void 0 ? _e : 't3.micro';
        const shell = aws_ec2_1.UserData.forLinux();
        shell.addCommands('yum update -y ', 'sleep 15 && yum install docker git -y && systemctl start docker && usermod -aG docker ec2-user && chmod 777 /var/run/docker.sock', 'systemctl restart docker && systemctl enable docker', 'docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner-register gitlab/gitlab-runner:alpine register --non-interactive --url ' +
            gitlaburl +
            ' --registration-token ' +
            token +
            ' --docker-pull-policy if-not-present --docker-volumes "/var/run/docker.sock:/var/run/docker.sock" --executor docker --docker-image "alpine:latest" --description "Docker Runner" --tag-list "' +
            tag1 +
            ',' +
            tag2 +
            ',' +
            tag3 +
            '" --docker-privileged', 'sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner gitlab/gitlab-runner:alpine', 'usermod -aG docker ssm-user');
        this.runnerRole = (_f = props.ec2iamrole) !== null && _f !== void 0 ? _f : new aws_iam_1.Role(this, 'runner-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
            description: 'For Gitlab EC2 Runner Role',
        });
        this.validUntil = props.validUntil;
        const instanceProfile = new aws_iam_1.CfnInstanceProfile(this, 'InstanceProfile', {
            roles: [this.runnerRole.roleName],
        });
        this.vpc = (_g = props.selfvpc) !== null && _g !== void 0 ? _g : new aws_ec2_1.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            maxAzs: 2,
            subnetConfiguration: [
                {
                    cidrMask: 26,
                    name: 'RunnerVPC',
                    subnetType: aws_ec2_1.SubnetType.PUBLIC,
                },
            ],
            natGateways: 0,
        });
        this.defaultRunnerSG = new aws_ec2_1.SecurityGroup(this, 'SpotFleetSg', {
            vpc: this.vpc,
        });
        this.defaultRunnerSG.connections.allowFromAnyIpv4(aws_ec2_1.Port.tcp(22));
        const spotOrOnDemand = (_h = props.spotFleet) !== null && _h !== void 0 ? _h : false;
        if (spotOrOnDemand) {
            //throw new Error('yes new spotfleet');
            const imageId = aws_ec2_1.MachineImage.latestAmazonLinux({
                generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
            }).getImage(this).imageId;
            const lt = new aws_ec2_1.CfnLaunchTemplate(this, 'LaunchTemplate', {
                launchTemplateData: {
                    imageId,
                    instanceType: ec2type,
                    blockDeviceMappings: [
                        {
                            deviceName: '/dev/xvda',
                            ebs: {
                                volumeSize: (_j = props.ebsSize) !== null && _j !== void 0 ? _j : 60,
                            },
                        },
                    ],
                    userData: core_1.Fn.base64(shell.render()),
                    keyName: props.keyName,
                    tagSpecifications: [
                        {
                            resourceType: 'instance',
                            tags: [
                                {
                                    key: 'Name',
                                    value: `${core_1.Stack.of(this).stackName}/spotFleetGitlabRunner/${spotFleetId}`,
                                },
                            ],
                        },
                    ],
                    instanceMarketOptions: {
                        marketType: 'spot',
                        spotOptions: {
                            blockDurationMinutes: (_k = props.blockDuration) !== null && _k !== void 0 ? _k : BlockDuration.ONE_HOUR,
                            instanceInterruptionBehavior: (_l = props.instanceInterruptionBehavior) !== null && _l !== void 0 ? _l : InstanceInterruptionBehavior.TERMINATE,
                        },
                    },
                    securityGroupIds: this.defaultRunnerSG.connections.securityGroups.map((m) => m.securityGroupId),
                    iamInstanceProfile: {
                        arn: instanceProfile.attrArn,
                    },
                },
            });
            const spotFleetRole = new aws_iam_1.Role(this, 'FleetRole', {
                assumedBy: new aws_iam_1.ServicePrincipal('spotfleet.amazonaws.com'),
                managedPolicies: [
                    aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonEC2SpotFleetTaggingRole'),
                ],
            });
            const vpcSubnetSelection = (_m = props.vpcSubnet) !== null && _m !== void 0 ? _m : {
                subnetType: aws_ec2_1.SubnetType.PUBLIC,
            };
            const subnetConfig = this.vpc
                .selectSubnets(vpcSubnetSelection)
                .subnets.map((s) => ({
                subnetId: s.subnetId,
            }));
            const cfnSpotFleet = new aws_ec2_1.CfnSpotFleet(this, id, {
                spotFleetRequestConfigData: {
                    launchTemplateConfigs: [
                        {
                            launchTemplateSpecification: {
                                launchTemplateId: lt.ref,
                                version: lt.attrLatestVersionNumber,
                            },
                            overrides: subnetConfig,
                        },
                    ],
                    iamFleetRole: spotFleetRole.roleArn,
                    targetCapacity: 1,
                    validUntil: core_1.Lazy.stringValue({ produce: () => this.validUntil }),
                    terminateInstancesWithExpiration: true,
                },
            });
            const onEvent = new lambda.Function(this, 'OnEvent', {
                code: lambda.Code.fromAsset(path.join(__dirname, '../getinstanceId')),
                handler: 'index.on_event',
                runtime: lambda.Runtime.PYTHON_3_8,
                timeout: core_1.Duration.seconds(60),
            });
            const isComplete = new lambda.Function(this, 'IsComplete', {
                code: lambda.Code.fromAsset(path.join(__dirname, '../getinstanceId')),
                handler: 'index.is_complete',
                runtime: lambda.Runtime.PYTHON_3_8,
                timeout: core_1.Duration.seconds(60),
                role: onEvent.role,
            });
            const myProvider = new cr.Provider(this, 'MyProvider', {
                onEventHandler: onEvent,
                isCompleteHandler: isComplete,
                logRetention: logs.RetentionDays.ONE_DAY,
            });
            onEvent.addToRolePolicy(new aws_iam_1.PolicyStatement({
                actions: ['ec2:DescribeSpotFleetInstances'],
                resources: ['*'],
            }));
            const fleetInstances = new core_1.CustomResource(this, 'GetInstanceId', {
                serviceToken: myProvider.serviceToken,
                properties: {
                    SpotFleetRequestId: cfnSpotFleet.ref,
                },
            });
            fleetInstances.node.addDependency(cfnSpotFleet);
            this.spotFleetInstanceId = core_1.Token.asString(fleetInstances.getAtt('InstanceId'));
            this.spotFleetRequestId = core_1.Token.asString(fleetInstances.getAtt('SpotInstanceRequestId'));
            new core_1.CfnOutput(this, 'InstanceId', { value: this.spotFleetInstanceId });
            new core_1.CfnOutput(this, 'SpotFleetId', { value: cfnSpotFleet.ref });
        }
        else {
            this.runnerEc2 = new aws_ec2_1.Instance(this, 'GitlabRunner', {
                instanceType: new aws_ec2_1.InstanceType(ec2type),
                instanceName: 'Gitlab-Runner',
                vpc: this.vpc,
                vpcSubnets: (_o = props.vpcSubnet) !== null && _o !== void 0 ? _o : {
                    subnetType: aws_ec2_1.SubnetType.PUBLIC,
                },
                machineImage: aws_ec2_1.MachineImage.latestAmazonLinux({
                    generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2,
                }),
                role: this.runnerRole,
                userData: shell,
                securityGroup: this.defaultRunnerSG,
                blockDevices: [
                    {
                        deviceName: '/dev/xvda',
                        volume: aws_ec2_1.BlockDeviceVolume.ebs((_p = props.ebsSize) !== null && _p !== void 0 ? _p : 60),
                    },
                ],
            });
            new core_1.CfnOutput(this, 'Runner-Instance-ID', {
                value: this.runnerEc2.instanceId,
            });
        }
        this.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new core_1.CfnOutput(this, 'Runner-Role-Arn', {
            value: this.runnerRole.roleArn,
        });
    }
    /**
     * @default - !!! only support spotfleet runner !!! .
     * @experimental
     */
    expireAfter(duration) {
        const date = new Date();
        date.setSeconds(date.getSeconds() + duration.toSeconds());
        this.validUntil = date.toISOString();
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
//# sourceMappingURL=data:application/json;base64,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