from __future__ import annotations

import abc
from typing import Any

class BaseQuantizer(metaclass=abc.ABCMeta):
    quant_bits: Any = ...
    abs_max_vals: Any = ...
    thresholds: Any = ...
    def __init__(self, quant_bits: int = ...) -> None: ...
    @abc.abstractmethod
    def sample_data(self, layer: Any, tensors: Any) -> Any: ...
    @abc.abstractmethod
    def cal_thresholds(self) -> Any: ...

class AbsmaxQuantizer(BaseQuantizer):
    def __init__(self, quant_bits: int = ...) -> None: ...
    abs_max_vals: Any = ...
    def sample_data(self, layer: Any, tensors: Any) -> None: ...
    thresholds: Any = ...
    def cal_thresholds(self) -> None: ...

class PerChannelAbsmaxQuantizer(BaseQuantizer):
    def __init__(self, quant_bits: int = ...) -> None: ...
    abs_max_vals: Any = ...
    def sample_data(self, layer: Any, tensors: Any) -> None: ...
    thresholds: Any = ...
    def cal_thresholds(self) -> None: ...

class BaseHistQuantizer(BaseQuantizer, metaclass=abc.ABCMeta):
    bins: Any = ...
    upsample_bins: Any = ...
    hists: Any = ...
    def __init__(self, quant_bits: int = ..., bins: int = ..., upsample_bins: int = ...) -> None: ...
    abs_max_vals: Any = ...
    def sample_data(self, layer: Any, tensors: Any) -> None: ...
    @abc.abstractmethod
    def cal_thresholds(self) -> Any: ...

class HistQuantizer(BaseHistQuantizer):
    hist_percent: Any = ...
    def __init__(
        self, quant_bits: int = ..., bins: int = ..., upsample_bins: int = ..., hist_percent: float = ...
    ) -> None: ...
    def cal_thresholds(self): ...

class KLQuantizer(BaseHistQuantizer):
    def __init__(self, quant_bits: int = ..., bins: int = ..., upsample_bins: int = ...) -> None: ...
    def cal_thresholds(self) -> None: ...

SUPPORT_ACT_QUANTIZERS: Any
SUPPORT_WT_QUANTIZERS: Any
