from flowui.scripts.load_operator import load_operator_class_from_path, load_operator_models_from_path
from pathlib import Path
import os
import ast
import json


def run_operator():
     # Import Operator from File System, already configured with metadata
    operator_name = os.getenv("FLOWUI_K8S_OPERATOR")

    operators_repository_copy_path = Path("flowui/operators_repository").resolve()
    operators_folder_path = operators_repository_copy_path / "operators"
    compiled_metadata_path = operators_repository_copy_path / ".flowui/compiled_metadata.json"
    
    with open(str(compiled_metadata_path), "r") as f:
        compiled_metadata = json.load(f)

    operator_class = load_operator_class_from_path(
        operators_folder_path=operators_folder_path,
        operator_name=operator_name,
        operator_metadata=compiled_metadata[operator_name]
    )

    operator_input_model_class, operator_output_model_class, operator_secrets_model_class = load_operator_models_from_path(
        operators_folder_path=operators_folder_path,
        operator_name=operator_name
    )

    # Instantiate Operator
    instantiate_op_dict = ast.literal_eval(os.getenv("FLOWUI_K8S_INSTANTIATE_OP_KWARGS"))
    operator_object = operator_class(**instantiate_op_dict)

    # Get relevant airflow context from ENV
    airflow_context = {
        "execution_datetime": os.getenv('AIRFLOW_CONTEXT_EXECUTION_DATETIME', "123456789"),
        "dag_run_id": os.getenv('AIRFLOW_CONTEXT_DAG_RUN_ID', "123456789"),
    }

    # Run Operator
    run_op_dict = ast.literal_eval(os.getenv("FLOWUI_K8S_RUN_OP_KWARGS"))
    operator_object.run_operator_function(
        airflow_context=airflow_context,
        op_kwargs=run_op_dict,        
        operator_input_model=operator_input_model_class, 
        operator_output_model=operator_output_model_class, 
        operator_secrets_model=operator_secrets_model_class,
    )

    return None