from flowui.scripts.load_operator import load_operator_class_from_path, load_operator_models_from_path
from pathlib import Path
import os
import ast
import json


def run_operator():
    # Import Operator from File System, already configured with metadata
    operator_dict = ast.literal_eval(os.getenv("FLOWUI_BASHOPERATOR_OPERATOR"))
    operator_name = operator_dict.get("name")

    operators_repository_copy_path = Path("opt/airflow/flowui/operators_repository")
    operators_folder_path = operators_repository_copy_path / "operators"
    compiled_metadata_path = operators_repository_copy_path / ".flowui/compiled_metadata.json"
    
    with open(str(compiled_metadata_path), "r") as f:
        compiled_metadata = json.load(f)

    operator_class = load_operator_class_from_path(
        operators_folder_path=operators_folder_path,
        operator_name=operator_name,
        operator_metadata=compiled_metadata[operator_name]
    )

    operator_input_model_class, operator_output_model_class, operator_secrets_model_class = load_operator_models_from_path(
        operators_folder_path=operators_folder_path,
        operator_name=operator_name
    )

    # Instantiate and run Operator
    instantiate_op_dict = ast.literal_eval(os.getenv("FLOWUI_BASHOPERATOR_INSTANTIATE_OP_KWARGS"))
    operator_object = operator_class(**instantiate_op_dict)

    run_op_dict = ast.literal_eval(os.getenv("FLOWUI_BASHOPERATOR_RUN_OP_KWARGS"))

    # Get relevant airflow context from ENV
    airflow_context = {
        "dag_owner": os.getenv('AIRFLOW_CONTEXT_DAG_OWNER'),
        "dag_id": os.getenv('AIRFLOW_CONTEXT_DAG_ID'),
        "task_id": os.getenv('AIRFLOW_CONTEXT_TASK_ID'),
        "execution_date": os.getenv('AIRFLOW_CONTEXT_EXECUTION_DATE'),
        "try_number": os.getenv('AIRFLOW_CONTEXT_TRY_NUMBER'),
        "dag_run_id": os.getenv('AIRFLOW_CONTEXT_DAG_RUN_ID'),
        "upstream_task_ids": os.getenv('AIRFLOW_CONTEXT_UPSTREAM_TASK_IDS')  # Added by FlowUI extended BashOperator
    }

    operator_object.run_operator_function(
        operator_input_model=operator_input_model_class, 
        operator_output_model=operator_output_model_class, 
        operator_secrets_model=operator_secrets_model_class,
        op_kwargs=run_op_dict,
        airflow_context=airflow_context
    )

    return None