class InvalidOperatorOutputError(Exception):
    """
    Raised when the Operator's output data is not an instance of the Operator's OutputModel
    """

    def __init__(self, operator_name: str):
        message = f"The output data for {operator_name} is not an instance of its OutputModel"
        super().__init__(message)


class MissingOperatorRepositoryFileError(Exception):
    """
    Raised when there's a missing required file from Operators repository
    """

    def __init__(self, missing_file: str, operators_repository: str):
        message = f"The file {missing_file} is not present in {operators_repository} operators repository"
        super().__init__(message)


class MissingEnvVarError(Exception):
    """
    Raised when there's a required ENV var missing on running environment
    """

    def __init__(self, missing_vars: list):
        message = "The required secrets are not present in running environment: " + '\n' + '\n'.join(missing_vars)
        super().__init__(message)


class NoMatchingDependencyForOperatorError(Exception):
    """
    Raised when there's no matching dependency for the given Operator in the dependencies_map.json file
    """

    def __init__(self, operator_name: str, repo_name: str):
        message = f"There's no matching dependency group for {operator_name} from repository {repo_name}. Please make sure to run 'flowui organize' in the target repository."
        super().__init__(message)