/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.FieldUtils;

public abstract class BaseDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = -2554245107589433218L;
    private final DurationFieldType iType;

    protected BaseDurationField(DurationFieldType durationFieldType) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = durationFieldType;
    }

    public final DurationFieldType getType() {
        return this.iType;
    }

    public final String getName() {
        return this.iType.getName();
    }

    public final boolean isSupported() {
        return true;
    }

    public int getValue(long l2) {
        return FieldUtils.safeToInt(this.getValueAsLong(l2));
    }

    public long getValueAsLong(long l2) {
        return l2 / this.getUnitMillis();
    }

    public int getValue(long l2, long l3) {
        return FieldUtils.safeToInt(this.getValueAsLong(l2, l3));
    }

    public long getMillis(int n2) {
        return (long)n2 * this.getUnitMillis();
    }

    public long getMillis(long l2) {
        return FieldUtils.safeMultiply(l2, this.getUnitMillis());
    }

    public int getDifference(long l2, long l3) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(l2, l3));
    }

    public int compareTo(DurationField durationField) {
        long l2 = durationField.getUnitMillis();
        long l3 = this.getUnitMillis();
        if (l3 == l2) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "DurationField[" + this.getName() + ']';
    }
}

