/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.ModelCategory;
import hex.genmodel.CategoricalEncoding;
import hex.genmodel.ConverterFactoryProvidingModel;
import hex.genmodel.GenModel;
import hex.genmodel.IClusteringModel;
import hex.genmodel.MojoModel;
import hex.genmodel.PredictContributions;
import hex.genmodel.PredictContributionsFactory;
import hex.genmodel.algos.deeplearning.DeeplearningMojoModel;
import hex.genmodel.algos.drf.DrfMojoModel;
import hex.genmodel.algos.glrm.GlrmMojoModel;
import hex.genmodel.algos.targetencoder.TargetEncoderMojoModel;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.algos.tree.TreeBackedMojoModel;
import hex.genmodel.algos.word2vec.WordEmbeddingModel;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.parameters.FeatureContribution;
import hex.genmodel.attributes.parameters.KeyValue;
import hex.genmodel.attributes.parameters.VariableImportancesHolder;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.RowToRawDataConverter;
import hex.genmodel.easy.error.VoidErrorConsumer;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.AbstractPrediction;
import hex.genmodel.easy.prediction.AnomalyDetectionPrediction;
import hex.genmodel.easy.prediction.AutoEncoderModelPrediction;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import hex.genmodel.easy.prediction.CoxPHModelPrediction;
import hex.genmodel.easy.prediction.DimReductionModelPrediction;
import hex.genmodel.easy.prediction.KLimeModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.OrdinalModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import hex.genmodel.easy.prediction.SortedClassProbability;
import hex.genmodel.easy.prediction.TargetEncoderPrediction;
import hex.genmodel.easy.prediction.Word2VecPrediction;
import hex.genmodel.utils.ArrayUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EasyPredictModelWrapper
implements Serializable {
    public final GenModel m;
    private final RowToRawDataConverter rowDataConverter;
    private final boolean useExtendedOutput;
    private final boolean enableLeafAssignment;
    private final boolean enableGLRMReconstruct;
    private final boolean enableStagedProbabilities;
    private final boolean enableContributions;
    private final int glrmIterNumber;
    private final PredictContributions predictContributions;

    public boolean getEnableLeafAssignment() {
        return this.enableLeafAssignment;
    }

    public boolean getEnableGLRMReconstruct() {
        return this.enableGLRMReconstruct;
    }

    public boolean getEnableStagedProbabilities() {
        return this.enableStagedProbabilities;
    }

    public boolean getEnableContributions() {
        return this.enableContributions;
    }

    public EasyPredictModelWrapper(Config config) {
        this.m = config.getModel();
        ErrorConsumer errorConsumer = config.getErrorConsumer() == null ? new VoidErrorConsumer() : config.getErrorConsumer();
        this.useExtendedOutput = config.getUseExtendedOutput();
        this.enableLeafAssignment = config.getEnableLeafAssignment();
        this.enableGLRMReconstruct = config.getEnableGLRMReconstrut();
        this.enableStagedProbabilities = config.getEnableStagedProbabilities();
        this.enableContributions = config.getEnableContributions();
        this.glrmIterNumber = config.getGLRMIterNumber();
        if (this.m instanceof GlrmMojoModel) {
            ((GlrmMojoModel)this.m)._iterNumber = this.glrmIterNumber;
        }
        if (this.enableContributions) {
            if (!(this.m instanceof PredictContributionsFactory)) {
                throw new IllegalStateException("Model " + this.m.getClass().getName() + " cannot be used to predict contributions.");
            }
            this.predictContributions = ((PredictContributionsFactory)((Object)this.m)).makeContributionsPredictor();
        } else {
            this.predictContributions = null;
        }
        CategoricalEncoding categoricalEncoding = config.getUseExternalEncoding() ? CategoricalEncoding.AUTO : this.m.getCategoricalEncoding();
        Map<String, Integer> columnMapping = categoricalEncoding.createColumnMapping(this.m);
        Map<Integer, CategoricalEncoder> domainMap = categoricalEncoding.createCategoricalEncoders(this.m, columnMapping);
        this.rowDataConverter = this.m instanceof ConverterFactoryProvidingModel ? ((ConverterFactoryProvidingModel)((Object)this.m)).makeConverterFactory(columnMapping, domainMap, errorConsumer, config) : new RowToRawDataConverter(this.m, columnMapping, domainMap, errorConsumer, config);
    }

    public EasyPredictModelWrapper(GenModel model) {
        this(new Config().setModel(model));
    }

    public AbstractPrediction predict(RowData data, ModelCategory mc) throws PredictException {
        switch (mc) {
            case AutoEncoder: {
                return this.predictAutoEncoder(data);
            }
            case Binomial: {
                return this.predictBinomial(data);
            }
            case Multinomial: {
                return this.predictMultinomial(data);
            }
            case Ordinal: {
                return this.predictOrdinal(data);
            }
            case Clustering: {
                return this.predictClustering(data);
            }
            case Regression: {
                return this.predictRegression(data);
            }
            case DimReduction: {
                return this.predictDimReduction(data);
            }
            case WordEmbedding: {
                return this.predictWord2Vec(data);
            }
            case TargetEncoder: {
                return this.predictTargetEncoding(data);
            }
            case AnomalyDetection: {
                return this.predictAnomalyDetection(data);
            }
            case KLime: {
                return this.predictKLime(data);
            }
            case CoxPH: {
                return this.predictCoxPH(data);
            }
            case Unknown: {
                throw new PredictException("Unknown model category");
            }
        }
        throw new PredictException("Unhandled model category (" + (Object)((Object)this.m.getModelCategory()) + ") in switch statement");
    }

    public double[] predictRaw(RowData data, double offset) throws PredictException {
        return this.preamble(this.m.getModelCategory(), data, offset);
    }

    public AbstractPrediction predict(RowData data) throws PredictException {
        return this.predict(data, this.m.getModelCategory());
    }

    ErrorConsumer getErrorConsumer() {
        return this.rowDataConverter.getErrorConsumer();
    }

    public String[] getContributionNames() {
        if (this.predictContributions == null) {
            throw new IllegalStateException("Contributions were not enabled using in EasyPredictModelWrapper (use setEnableContributions).");
        }
        return this.predictContributions.getContributionNames();
    }

    public AutoEncoderModelPrediction predictAutoEncoder(RowData data) throws PredictException {
        this.validateModelCategory(ModelCategory.AutoEncoder);
        int size = this.m.getPredsSize(ModelCategory.AutoEncoder);
        double[] output = new double[size];
        double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        output = this.m.score0(rawData, output);
        AutoEncoderModelPrediction p2 = new AutoEncoderModelPrediction();
        p2.original = this.expandRawData(rawData, output.length);
        p2.reconstructed = output;
        p2.reconstructedRowData = this.reconstructedToRowData(output);
        if (this.m instanceof DeeplearningMojoModel) {
            DeeplearningMojoModel mojoModel = (DeeplearningMojoModel)this.m;
            p2.mse = mojoModel.calculateReconstructionErrorPerRowData(p2.original, p2.reconstructed);
        }
        return p2;
    }

    private double[] expandRawData(double[] data, int size) {
        double[] expanded = new double[size];
        int pos = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (this.m._domains[i2] == null) {
                expanded[pos] = data[i2];
                ++pos;
                continue;
            }
            int idx = Double.isNaN(data[i2]) ? this.m._domains[i2].length : (int)data[i2];
            expanded[pos + idx] = 1.0;
            pos += this.m._domains[i2].length + 1;
        }
        return expanded;
    }

    private RowData reconstructedToRowData(double[] reconstructed) {
        RowData rd = new RowData();
        int pos = 0;
        for (int i2 = 0; i2 < this.m.nfeatures(); ++i2) {
            Object value;
            if (this.m._domains[i2] == null) {
                value = reconstructed[pos++];
            } else {
                value = EasyPredictModelWrapper.catValuesAsMap(this.m._domains[i2], reconstructed, pos);
                pos += this.m._domains[i2].length + 1;
            }
            rd.put(this.m._names[i2], value);
        }
        return rd;
    }

    private static Map<String, Double> catValuesAsMap(String[] cats, double[] reconstructed, int offset) {
        HashMap<String, Double> result = new HashMap<String, Double>(cats.length + 1);
        for (int i2 = 0; i2 < cats.length; ++i2) {
            result.put(cats[i2], reconstructed[i2 + offset]);
        }
        result.put(null, reconstructed[offset + cats.length]);
        return result;
    }

    public DimReductionModelPrediction predictDimReduction(RowData data) throws PredictException {
        double[] preds = this.preamble(ModelCategory.DimReduction, data);
        DimReductionModelPrediction p2 = new DimReductionModelPrediction();
        p2.dimensions = preds;
        if (this.m instanceof GlrmMojoModel && ((GlrmMojoModel)this.m)._archetypes_raw != null && this.enableGLRMReconstruct) {
            GlrmMojoModel cfr_ignored_0 = (GlrmMojoModel)this.m;
            p2.reconstructed = GlrmMojoModel.impute_data(preds, new double[this.m.nfeatures()], ((GlrmMojoModel)this.m)._nnums, ((GlrmMojoModel)this.m)._ncats, ((GlrmMojoModel)this.m)._permutation, ((GlrmMojoModel)this.m)._reverse_transform, ((GlrmMojoModel)this.m)._normMul, ((GlrmMojoModel)this.m)._normSub, ((GlrmMojoModel)this.m)._losses, ((GlrmMojoModel)this.m)._transposed, ((GlrmMojoModel)this.m)._archetypes_raw, ((GlrmMojoModel)this.m)._catOffsets, ((GlrmMojoModel)this.m)._numLevels);
        }
        return p2;
    }

    public float[] predictWord2Vec(String[] sentence) throws PredictException {
        WordEmbeddingModel weModel = this.asWordEmbeddingModel();
        int vecSize = weModel.getVecSize();
        float[] aggregated = new float[vecSize];
        float[] current = new float[vecSize];
        int embeddings = 0;
        for (String word : sentence) {
            float[] embedding = weModel.transform0(word, current);
            if (embedding == null) continue;
            ++embeddings;
            for (int i2 = 0; i2 < vecSize; ++i2) {
                int n2 = i2;
                aggregated[n2] = aggregated[n2] + embedding[i2];
            }
        }
        if (embeddings > 0) {
            int i3 = 0;
            while (i3 < vecSize) {
                int n3 = i3++;
                aggregated[n3] = aggregated[n3] / (float)embeddings;
            }
        } else {
            Arrays.fill(aggregated, Float.NaN);
        }
        return aggregated;
    }

    public Word2VecPrediction predictWord2Vec(RowData data) throws PredictException {
        WordEmbeddingModel weModel = this.asWordEmbeddingModel();
        int vecSize = weModel.getVecSize();
        HashMap<String, float[]> embeddings = new HashMap<String, float[]>(data.size());
        for (String wordKey : data.keySet()) {
            Object value = data.get(wordKey);
            if (!(value instanceof String)) continue;
            String word = (String)value;
            embeddings.put(wordKey, weModel.transform0(word, new float[vecSize]));
        }
        Word2VecPrediction p2 = new Word2VecPrediction();
        p2.wordEmbeddings = embeddings;
        return p2;
    }

    private WordEmbeddingModel asWordEmbeddingModel() throws PredictException {
        this.validateModelCategory(ModelCategory.WordEmbedding);
        if (!(this.m instanceof WordEmbeddingModel)) {
            throw new PredictException("Model is not of the expected type, class = " + this.m.getClass().getSimpleName());
        }
        return (WordEmbeddingModel)((Object)this.m);
    }

    public AnomalyDetectionPrediction predictAnomalyDetection(RowData data) throws PredictException {
        double[] preds = this.preamble(ModelCategory.AnomalyDetection, data, 0.0);
        AnomalyDetectionPrediction p2 = new AnomalyDetectionPrediction(preds);
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments assignments = this.leafNodeAssignmentExtended(data);
            p2.leafNodeAssignments = assignments._paths;
            p2.leafNodeAssignmentIds = assignments._nodeIds;
        }
        if (this.enableStagedProbabilities) {
            double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
            rawData = this.fillRawData(data, rawData);
            p2.stageProbabilities = ((SharedTreeMojoModel)this.m).scoreStagedPredictions(rawData, preds.length);
        }
        return p2;
    }

    public BinomialModelPrediction predictBinomial(RowData data) throws PredictException {
        return this.predictBinomial(data, 0.0);
    }

    public BinomialModelPrediction predictBinomial(RowData data, double offset) throws PredictException {
        double[] preds = this.preamble(ModelCategory.Binomial, data, offset);
        BinomialModelPrediction p2 = new BinomialModelPrediction();
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments assignments = this.leafNodeAssignmentExtended(data);
            p2.leafNodeAssignments = assignments._paths;
            p2.leafNodeAssignmentIds = assignments._nodeIds;
        }
        double d2 = preds[0];
        p2.labelIndex = (int)d2;
        String[] domainValues = this.m.getDomainValues(this.m.getResponseIdx());
        if (domainValues == null && this.m.getNumResponseClasses() == 2) {
            domainValues = new String[]{"0", "1"};
        }
        p2.label = domainValues[p2.labelIndex];
        p2.classProbabilities = new double[this.m.getNumResponseClasses()];
        System.arraycopy(preds, 1, p2.classProbabilities, 0, p2.classProbabilities.length);
        if (this.m.calibrateClassProbabilities(preds)) {
            p2.calibratedClassProbabilities = new double[this.m.getNumResponseClasses()];
            System.arraycopy(preds, 1, p2.calibratedClassProbabilities, 0, p2.calibratedClassProbabilities.length);
        }
        if (this.enableStagedProbabilities) {
            double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
            rawData = this.fillRawData(data, rawData);
            p2.stageProbabilities = ((SharedTreeMojoModel)this.m).scoreStagedPredictions(rawData, preds.length);
        }
        if (this.enableContributions) {
            p2.contributions = this.predictContributions(data);
        }
        return p2;
    }

    @Deprecated
    public TargetEncoderPrediction transformWithTargetEncoding(RowData data) throws PredictException {
        return this.predictTargetEncoding(data);
    }

    public TargetEncoderPrediction predictTargetEncoding(RowData data) throws PredictException {
        if (!(this.m instanceof TargetEncoderMojoModel)) {
            throw new PredictException("Model is not of the expected type, class = " + this.m.getClass().getSimpleName());
        }
        TargetEncoderMojoModel tem = (TargetEncoderMojoModel)this.m;
        double[] preds = new double[tem.getPredsSize()];
        TargetEncoderPrediction prediction = new TargetEncoderPrediction();
        prediction.transformations = this.predict(data, 0.0, preds);
        return prediction;
    }

    public String[] leafNodeAssignment(RowData data) throws PredictException {
        double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        return ((TreeBackedMojoModel)((Object)this.m)).getDecisionPath(rawData);
    }

    public SharedTreeMojoModel.LeafNodeAssignments leafNodeAssignmentExtended(RowData data) throws PredictException {
        double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        return ((TreeBackedMojoModel)((Object)this.m)).getLeafNodeAssignments(rawData);
    }

    public MultinomialModelPrediction predictMultinomial(RowData data) throws PredictException {
        return this.predictMultinomial(data, 0.0);
    }

    public MultinomialModelPrediction predictMultinomial(RowData data, double offset) throws PredictException {
        double[] preds = this.preamble(ModelCategory.Multinomial, data, offset);
        MultinomialModelPrediction p2 = new MultinomialModelPrediction();
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments assignments = this.leafNodeAssignmentExtended(data);
            p2.leafNodeAssignments = assignments._paths;
            p2.leafNodeAssignmentIds = assignments._nodeIds;
        }
        p2.classProbabilities = new double[this.m.getNumResponseClasses()];
        p2.labelIndex = (int)preds[0];
        String[] domainValues = this.m.getDomainValues(this.m.getResponseIdx());
        p2.label = domainValues[p2.labelIndex];
        System.arraycopy(preds, 1, p2.classProbabilities, 0, p2.classProbabilities.length);
        if (this.enableStagedProbabilities) {
            double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
            rawData = this.fillRawData(data, rawData);
            p2.stageProbabilities = ((SharedTreeMojoModel)this.m).scoreStagedPredictions(rawData, preds.length);
        }
        return p2;
    }

    public OrdinalModelPrediction predictOrdinal(RowData data) throws PredictException {
        return this.predictOrdinal(data, 0.0);
    }

    public OrdinalModelPrediction predictOrdinal(RowData data, double offset) throws PredictException {
        double[] preds = this.preamble(ModelCategory.Ordinal, data, offset);
        OrdinalModelPrediction p2 = new OrdinalModelPrediction();
        p2.classProbabilities = new double[this.m.getNumResponseClasses()];
        p2.labelIndex = (int)preds[0];
        String[] domainValues = this.m.getDomainValues(this.m.getResponseIdx());
        p2.label = domainValues[p2.labelIndex];
        System.arraycopy(preds, 1, p2.classProbabilities, 0, p2.classProbabilities.length);
        return p2;
    }

    private SortedClassProbability[] sortByDescendingClassProbability(String[] domainValues, double[] classProbabilities) {
        assert (classProbabilities.length == domainValues.length);
        SortedClassProbability[] arr = new SortedClassProbability[domainValues.length];
        for (int i2 = 0; i2 < domainValues.length; ++i2) {
            arr[i2] = new SortedClassProbability();
            arr[i2].name = domainValues[i2];
            arr[i2].probability = classProbabilities[i2];
        }
        Arrays.sort(arr, Collections.reverseOrder());
        return arr;
    }

    public SortedClassProbability[] sortByDescendingClassProbability(BinomialModelPrediction p2) {
        String[] domainValues = this.m.getDomainValues(this.m.getResponseIdx());
        double[] classProbabilities = p2.classProbabilities;
        return this.sortByDescendingClassProbability(domainValues, classProbabilities);
    }

    public ClusteringModelPrediction predictClustering(RowData data) throws PredictException {
        ClusteringModelPrediction p2 = new ClusteringModelPrediction();
        if (this.useExtendedOutput && this.m instanceof IClusteringModel) {
            IClusteringModel cm = (IClusteringModel)((Object)this.m);
            double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
            rawData = this.fillRawData(data, rawData);
            int k2 = cm.getNumClusters();
            p2.distances = new double[k2];
            p2.cluster = cm.distances(rawData, p2.distances);
        } else {
            double[] preds = this.preamble(ModelCategory.Clustering, data);
            p2.cluster = (int)preds[0];
        }
        return p2;
    }

    public RegressionModelPrediction predictRegression(RowData data) throws PredictException {
        return this.predictRegression(data, 0.0);
    }

    public RegressionModelPrediction predictRegression(RowData data, double offset) throws PredictException {
        double[] rawData;
        double[] preds = this.preamble(ModelCategory.Regression, data, offset);
        RegressionModelPrediction p2 = new RegressionModelPrediction();
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments assignments = this.leafNodeAssignmentExtended(data);
            p2.leafNodeAssignments = assignments._paths;
            p2.leafNodeAssignmentIds = assignments._nodeIds;
        }
        p2.value = preds[0];
        if (this.enableStagedProbabilities) {
            rawData = ArrayUtils.nanArray(this.m.nfeatures());
            rawData = this.fillRawData(data, rawData);
            p2.stageProbabilities = ((SharedTreeMojoModel)this.m).scoreStagedPredictions(rawData, preds.length);
        }
        if (this.enableContributions) {
            rawData = ArrayUtils.nanArray(this.m.nfeatures());
            rawData = this.fillRawData(data, rawData);
            p2.contributions = this.predictContributions.calculateContributions(rawData);
        }
        return p2;
    }

    public KLimeModelPrediction predictKLime(RowData data) throws PredictException {
        double[] preds = this.preamble(ModelCategory.KLime, data);
        KLimeModelPrediction p2 = new KLimeModelPrediction();
        p2.value = preds[0];
        p2.cluster = (int)preds[1];
        p2.reasonCodes = new double[preds.length - 2];
        System.arraycopy(preds, 2, p2.reasonCodes, 0, p2.reasonCodes.length);
        return p2;
    }

    public CoxPHModelPrediction predictCoxPH(RowData data, double offset) throws PredictException {
        double[] preds = this.preamble(ModelCategory.CoxPH, data, offset);
        CoxPHModelPrediction p2 = new CoxPHModelPrediction();
        p2.value = preds[0];
        return p2;
    }

    public CoxPHModelPrediction predictCoxPH(RowData data) throws PredictException {
        return this.predictCoxPH(data, 0.0);
    }

    public float[] predictContributions(RowData data) throws PredictException {
        double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        return this.predictContributions.calculateContributions(rawData);
    }

    public FeatureContribution[] predictContributions(RowData data, int topN, int bottomN, boolean compareAbs) throws PredictException {
        double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        return this.predictContributions.calculateContributions(rawData, topN, bottomN, compareAbs);
    }

    public KeyValue[] varimp() {
        return this.varimp(-1);
    }

    public KeyValue[] varimp(int n2) {
        if (this.m instanceof MojoModel) {
            ModelAttributes attributes = ((MojoModel)this.m)._modelAttributes;
            if (attributes == null) {
                throw new IllegalStateException("Model attributes are not available. Did you load metadata from model? MojoModel.load(\"model\", true)");
            }
            if (attributes instanceof VariableImportancesHolder) {
                return ((VariableImportancesHolder)((Object)attributes)).getVariableImportances().topN(n2);
            }
        }
        throw new IllegalStateException("Model does not support variable importance");
    }

    public GenModel getModel() {
        return this.m;
    }

    public ModelCategory getModelCategory() {
        return this.m.getModelCategory();
    }

    public String[] getResponseDomainValues() {
        return this.m.getDomainValues(this.m.getResponseIdx());
    }

    public String getHeader() {
        return this.m.getHeader();
    }

    private void validateModelCategory(ModelCategory c2) throws PredictException {
        if (!this.m.getModelCategories().contains((Object)c2)) {
            throw new PredictException((Object)((Object)c2) + " prediction type is not supported for this model.");
        }
    }

    protected double[] preamble(ModelCategory c2, RowData data) throws PredictException {
        return this.preamble(c2, data, 0.0);
    }

    protected double[] preamble(ModelCategory c2, RowData data, double offset) throws PredictException {
        this.validateModelCategory(c2);
        int predsSize = this.m.getPredsSize(c2);
        return this.predict(data, offset, new double[predsSize]);
    }

    protected double[] fillRawData(RowData data, double[] rawData) throws PredictException {
        return this.rowDataConverter.convert(data, rawData);
    }

    protected double[] predict(RowData data, double offset, double[] preds) throws PredictException {
        double[] rawData = ArrayUtils.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        preds = this.m.requiresOffset() || offset != 0.0 ? this.m.score0(rawData, offset, preds) : this.m.score0(rawData, preds);
        return preds;
    }

    public static class Config {
        private GenModel model;
        private boolean convertUnknownCategoricalLevelsToNa = false;
        private boolean convertInvalidNumbersToNa = false;
        private boolean useExtendedOutput = false;
        private ErrorConsumer errorConsumer;
        private boolean enableLeafAssignment = false;
        private boolean enableGLRMReconstrut = false;
        private boolean enableStagedProbabilities = false;
        private boolean enableContributions = false;
        private boolean useExternalEncoding = false;
        private int glrmIterNumber = 100;

        public Config setModel(GenModel value) {
            this.model = value;
            return this;
        }

        public GenModel getModel() {
            return this.model;
        }

        public Config setConvertUnknownCategoricalLevelsToNa(boolean value) {
            this.convertUnknownCategoricalLevelsToNa = value;
            return this;
        }

        public Config setEnableLeafAssignment(boolean val) throws IOException {
            if (val && this.model == null) {
                throw new IOException("enableLeafAssignment cannot be set with null model.  Call setModel() first.");
            }
            if (val && !(this.model instanceof TreeBackedMojoModel)) {
                throw new IOException("enableLeafAssignment can be set to true only with TreeBackedMojoModel, i.e. with GBM, DRF, Isolation forest or XGBoost.");
            }
            this.enableLeafAssignment = val;
            return this;
        }

        public Config setEnableGLRMReconstrut(boolean value) throws IOException {
            if (value && this.model == null) {
                throw new IOException("Cannot set enableGLRMReconstruct for a null model.  Call config.setModel() first.");
            }
            if (value && !(this.model instanceof GlrmMojoModel)) {
                throw new IOException("enableGLRMReconstruct shall only be used with GlrmMojoModels.");
            }
            this.enableGLRMReconstrut = value;
            return this;
        }

        public Config setGLRMIterNumber(int value) throws IOException {
            if (this.model == null) {
                throw new IOException("Cannot set glrmIterNumber for a null model.  Call config.setModel() first.");
            }
            if (!(this.model instanceof GlrmMojoModel)) {
                throw new IOException("glrmIterNumber  shall only be used with GlrmMojoModels.");
            }
            if (value <= 0) {
                throw new IllegalArgumentException("GLRMIterNumber must be positive.");
            }
            this.glrmIterNumber = value;
            return this;
        }

        public Config setEnableStagedProbabilities(boolean val) throws IOException {
            if (val && this.model == null) {
                throw new IOException("enableStagedProbabilities cannot be set with null model.  Call setModel() first.");
            }
            if (val && !(this.model instanceof SharedTreeMojoModel)) {
                throw new IOException("enableStagedProbabilities can be set to true only with SharedTreeMojoModel, i.e. with GBM or DRF.");
            }
            this.enableStagedProbabilities = val;
            return this;
        }

        public boolean getEnableGLRMReconstrut() {
            return this.enableGLRMReconstrut;
        }

        public Config setEnableContributions(boolean val) throws IOException {
            if (val && this.model == null) {
                throw new IOException("setEnableContributions cannot be set with null model.  Call setModel() first.");
            }
            if (val && !(this.model instanceof PredictContributionsFactory)) {
                throw new IOException("setEnableContributions can be set to true only with DRF, GBM, or XGBoost models.");
            }
            if (val && ModelCategory.Multinomial.equals((Object)this.model.getModelCategory())) {
                throw new IOException("setEnableContributions is not yet supported for multinomial classification models.");
            }
            if (val && this.model instanceof DrfMojoModel && ((DrfMojoModel)this.model).isBinomialDoubleTrees()) {
                throw new IOException("setEnableContributions is not yet supported for model with binomial_double_trees parameter set.");
            }
            this.enableContributions = val;
            return this;
        }

        public boolean getEnableContributions() {
            return this.enableContributions;
        }

        public Config setUseExternalEncoding(boolean val) {
            this.useExternalEncoding = val;
            return this;
        }

        public boolean getUseExternalEncoding() {
            return this.useExternalEncoding;
        }

        public boolean getConvertUnknownCategoricalLevelsToNa() {
            return this.convertUnknownCategoricalLevelsToNa;
        }

        public int getGLRMIterNumber() {
            return this.glrmIterNumber;
        }

        public Config setConvertInvalidNumbersToNa(boolean value) {
            this.convertInvalidNumbersToNa = value;
            return this;
        }

        public boolean getConvertInvalidNumbersToNa() {
            return this.convertInvalidNumbersToNa;
        }

        public Config setUseExtendedOutput(boolean value) {
            this.useExtendedOutput = value;
            return this;
        }

        public boolean getUseExtendedOutput() {
            return this.useExtendedOutput;
        }

        public boolean getEnableLeafAssignment() {
            return this.enableLeafAssignment;
        }

        public boolean getEnableStagedProbabilities() {
            return this.enableStagedProbabilities;
        }

        public ErrorConsumer getErrorConsumer() {
            return this.errorConsumer;
        }

        public Config setErrorConsumer(ErrorConsumer errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }
    }

    public static abstract class ErrorConsumer
    implements Serializable {
        public abstract void dataTransformError(String var1, Object var2, String var3);

        public abstract void unseenCategorical(String var1, Object var2, String var3);
    }
}

