# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['jellyfin_accounts']

package_data = \
{'': ['*'],
 'jellyfin_accounts': ['data/*', 'data/static/*', 'data/templates/*']}

install_requires = \
['configparser>=5.0.0,<6.0.0',
 'flask-httpauth>=3.3.0',
 'flask>=1.1.2,<2.0.0',
 'itsdangerous>=1.1.0,<2.0.0',
 'passlib>=1.7.2,<2.0.0',
 'pyopenssl>=19.1.0,<20.0.0',
 'python-dateutil>=2.8.1,<3.0.0',
 'pytz>=2020.1,<2021.0',
 'requests>=2.23.0,<3.0.0',
 'waitress>=1.4.3,<2.0.0',
 'watchdog>=0.10.2,<0.11.0']

entry_points = \
{'console_scripts': ['jf-accounts = jellyfin_accounts:main']}

setup_kwargs = {
    'name': 'jellyfin-accounts',
    'version': '0.2.1',
    'description': 'A simple account management system for Jellyfin',
    'long_description': '# ![jellyfin-accounts](https://raw.githubusercontent.com/hrfee/jellyfin-accounts/master/images/jellyfin-accounts-banner-wide.svg)\n\nA basic account management system for [Jellyfin](https://github.com/jellyfin/jellyfin).\n* Provides a web interface for creating invite codes, and a simple account creation form\n* Sends out emails when a user requests a password reset\n* Uses a basic python jellyfin API client for communication with the server. \n* Uses [Flask](https://github.com/pallets/flask), [HTTPAuth](https://github.com/miguelgrinberg/Flask-HTTPAuth), [itsdangerous](https://github.com/pallets/itsdangerous), and [Waitress](https://github.com/Pylons/waitress)\n* Frontend uses [Bootstrap](https://getbootstrap.com), [jQuery](https://jquery.com) and [jQuery-serialize-object](https://github.com/macek/jquery-serialize-object)\n* Password resets are handled using smtplib, requests, and [jinja](https://github.com/pallets/jinja)\n## Interface\n<p align="center">\n    <img src="https://raw.githubusercontent.com/hrfee/jellyfin-accounts/master/images/jfa.gif" width="100%"></img>\n</p>\n\n<p align="center">\n    <img src="https://raw.githubusercontent.com/hrfee/jellyfin-accounts/master/images/jfa.gif" width="48%" style="margin-right: 1.5%;" alt="Admin page"></img> \n    <img src="https://raw.githubusercontent.com/hrfee/jellyfin-accounts/master/images/create.png" width="48%" style="margin-left: 1.5%;" alt="Account creation page"></img>\n</p>\n\n\n\n## Get it\n### Requirements\n\n* This should work anywhere Python does, i\'ve tried to not use anything OS-specific. Drop an issue if there\'s a problem, of course.\n```\n* python >= 3.6\n* flask\n* flask_httpauth\n* jinja2\n* requests\n* itsdangerous\n* passlib\n* configparser\n* pyOpenSSL\n* waitress\n* pytz\n* python-dateutil\n* watchdog\n```\n### Install\n\nUsually as simple as:\n```\npip install jellyfin-accounts\n```\nIf not, or if you want to use docker, see [install](https://github.com/hrfee/jellyfin-accounts/wiki/Install).\n\n### Usage\n* Passing no arguments will run the server\n```\nusage: jf-accounts [-h] [-c CONFIG] [-d DATA] [--host HOST] [-p PORT] [-g]\n\njellyfin-accounts\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -c CONFIG, --config CONFIG\n                        specifies path to configuration file.\n  -d DATA, --data DATA  specifies directory to store data in. defaults to\n                        ~/.jf-accounts.\n  --host HOST           address to host web ui on.\n  -p PORT, --port PORT  port to host web ui on.\n  -g, --get_defaults    tool to grab a JF users policy (access, perms, etc.)\n                        and homescreen layout and output it as json to be used\n                        as a user template.\n```\n### Setup\n#### New user template\n* You may want to restrict a user from accessing certain libraries (e.g 4K Movies), display their account on the login screen by default, or set a default homecrseen layout. Jellyfin stores these settings in the user\'s policy, configuration and displayPreferences.\n* Make a temporary account and change its settings, then run `jf-accounts --get_defaults`. Choose your user, and this data will be stored at the location you set in `user_template`, `user_configuration` and `user_displayprefs` (or their default locations), and used for all subsequent new accounts.\n#### Emails/Password Resets\n* When someone initiates forget password on Jellyfin, a file named `passwordreset*.json` is created in its configuration directory. This directory is monitored and when created, the program reads the username, expiry time and PIN, puts it into a template and sends it to whatever address is specified in `emails.json`.\n* **The default forget password popup references the `passwordreset*.json` file created. This is confusing for users, so a quick fix is to edit the `MessageForgotPasswordFileCreated` string in Jellyfin\'s language folder.**\n* Currently, jellyfin-accounts supports generic SSL/TLS or STARTTLS secured SMTP, and the [mailgun](https://mailgun.com) REST API. \n* Email html is created using [mjml](https://mjml.io), and [jinja](https://github.com/pallets/jinja) templating is used. If you wish to create your own, ensure you use the same jinja expressions (`{{ pin }}`, etc.) as used in `data/email.mjml` or `invite-email.mjml`, and also create plain text versions for legacy email clients.\n\n#### Configuration\n* Note: Make sure to put this behind a reverse proxy with HTTPS.\n\nOn first run, access the setup wizard at `0.0.0.0:8056`. When finished, restart the program.\n\nThe configuration is stored at `~/.jf-accounts/config.ini`.\n\nFor detailed descriptions of each setting, see [setup](https://github.com/hrfee/jellyfin-accounts/wiki/Setup).\n\n\n```\n[jellyfin]\n; It is reccommended to create a limited admin account for this program.\nusername = username\npassword = password\n; Jellyfin server address. Can be public, or local for security purposes.\nserver = http://jellyfin.local:8096\n; Publicly accessible Jellyfin address, used on invite form.\n; Leave blank to use the same address as above.\npublic_server = https://jellyf.in:443\nclient = jf-accounts\nversion = 0.1\ndevice = jf-accounts\ndevice_id = jf-accounts-0.1\n\n[ui]\n; Set 0.0.0.0 to run localhost\nhost = 0.0.0.0\nport = 8056\n; Enable this to use Jellyfin users instead of the below username and pw.\njellyfin_login = true\n; Allows only admin users on Jellyfin to access admin page.\nadmin_only = true\n; Username to use on admin page... (leave blank if using jellyfin_login)\nusername = your username\n; ..and its corresponding password (leave blank if using jellyfin_login)\npassword = your password\n\ndebug = false\n\n; Displayed at the bottom of all pages except admin\ncontact_message = Need help? contact me.\n; Displayed at top of form page.\nhelp_message =  Enter your details to create an account.\n; Displayed when an account is created.\nsuccess_message = Your account has been created. Click below to continue to Jellyfin.\n\n[password_validation]\n; Enables password validation.\nenabled = true \n; Min. password length\nmin_length = 8\n; Min. number of uppercase characters\nupper = 1\n; Min. number of lowercase characters\nlower = 0\n; Min. number of numbers\nnumber = 1\n; Min. number of special characters\nspecial = 0\n\n[email]\n; Leave this whole section if you aren\'t using any email-related features.\nuse_24h = true\n; Date format follows datetime\'s strftime.\ndate_format = %d/%m/%y\n; Displayed at bottom of emails\nmessage = Need help? contact me.\n; Mail methods: mailgun, smtp\nmethod = smtp\n; Address to send from\naddress = jellyfin@jellyf.in\n; The name of the sender\nfrom = Jellyfin\n\n[password_resets]\n; Enable to store provided email addresses, monitor jellyfin directory for pw-resets, and send pin\nenabled = true\n; Directory to monitor for passwordReset*.json files. Usually the jellyfin config directory\nwatch_directory = /path/to/jellyfin\n; Path to custom email html. If blank, uses the internal template.\nemail_html =\n; Path to alternate plaintext email. If blank, uses the internal template.\nemail_text = \n; Subject of emails\nsubject = Password Reset - Jellyfin\n\n[invite_emails]\n; If enabled, allows one to send an invite directly to an email address.\nenabled = true\n; Path to custom email html. If blank, uses the internal template.\nemail_html =\n; Path to alternate plaintext email. If blank, uses the internal template.\nemail_text = \nsubject = Invite - Jellyfin\n; Base url for jf-accounts. This necessary because most will use a reverse proxy, so the program has no other way of knowing what URL to send.\nurl_base = http://accounts.jellyf.in:8056/invite\n\n[mailgun]\n\napi_url = https://api.mailgun.net...\napi_key = your api key\n\n[smtp]\n; Choose between ssl_tls and starttls. Your provider should tell you which to use, but generally SSL/TLS is 465, STARTTLS 587\nencryption = starttls\nserver = smtp.jellyf.in\n; Uses SMTP_SSL, so make sure the port is for this, not starttls.\nport = 587\npassword = smtp password\n\n[files]\n; When the below paths are left blank, files are stored in ~/.jf-accounts/.\n\n; Path to store valid invites.\ninvites = \n; Path to store emails addresses in JSON\nemails = \n; Path to the user policy template. Can be acquired with get-defaults (jf-accounts -g).\nuser_template =\n; Path to the user configuration template (part of homescreen layout). Can be acquired with get-defaults (jf-accounts -g).\nuser_configuration =\n; Path to the user display preferences template (part of homescreen layout). Can be acquired with get-defaults (jf-accounts -g).\nuser_displayprefs =\n; Path to custom bootstrap.css\ncustom_css = \n```\n\n\n',
    'author': 'Harvey Tindall',
    'author_email': 'harveyltindall@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/hrfee/jellyfin-accounts',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
