POLYNOMIALS={"colors_spt": {"subdwarfs": {"Gaia_GandLSST_G": {"x": "spt", "y": "Gaia_GandLSST_G", "fit": [1.2324054871792959e-05, -0.0018271673269642458, 0.1083966479362216, -3.2164223162723675, 47.62205936377559, -287.535125693462], "scatter": 0.22070027817237287, "method": "polynomial", "range": [25, 39], "x0": 0.0}, "SDSS_GandLSST_G": {"x": "spt", "y": "SDSS_GandLSST_G", "fit": [2.488840938176517e-05, -0.003787845191741443, 0.22742653101134427, -6.720794565677689, 97.51881456330098, -554.3343943437307], "scatter": 0.10003308763232047, "method": "polynomial", "range": [19, 39], "x0": 0.0}, "SDSS_RandLSST_G": {"x": "spt", "y": "SDSS_RandLSST_G", "fit": [-0.00034341567594013797, 0.05388072922414567, -3.357434166103655, 103.89817638939853, -1597.2128835920746, 9757.571026021424], "scatter": 0.3137649280712076, "method": "polynomial", "range": [25, 39], "x0": 0.0}, "SDSS_RandLSST_R": {"x": "spt", "y": "SDSS_RandLSST_R", "fit": [-2.3697035418223224e-06, 0.0002990876220729724, -0.01467686087789294, 0.3500810337695373, -4.02831122469002, 17.890749830189876], "scatter": 0.10663903897016488, "method": "polynomial", "range": [15, 39], "x0": 0.0}, "SDSS_IandLSST_I": {"x": "spt", "y": "SDSS_IandLSST_I", "fit": [-2.8509329373331904e-07, 3.926279967577217e-05, -0.0020583784985751764, 0.050939562056288704, -0.5926749084635597, 2.9741955106489573], "scatter": 0.10007740104469831, "method": "polynomial", "range": [15, 39], "x0": 0.0}, "SDSS_ZandLSST_Z": {"x": "spt", "y": "SDSS_ZandLSST_Z", "fit": [3.167403401799142e-06, -0.0004194783140346914, 0.021498807214632168, -0.5306543986135102, 6.248624603838674, -27.301351219994743], "scatter": 0.10717924366776604, "method": "polynomial", "range": [15, 39], "x0": 0.0}, "PANSTARRS_RandLSST_R": {"x": "spt", "y": "PANSTARRS_RandLSST_R", "fit": [-2.184929772896043e-07, 2.909256436593474e-05, -0.0014656170668683926, 0.03469625327479391, -0.3851412944684871, 1.7204551051490427], "scatter": 0.10007129733770231, "method": "polynomial", "range": [15, 39], "x0": 0.0}, "PANSTARRS_IandLSST_I": {"x": "spt", "y": "PANSTARRS_IandLSST_I", "fit": [1.2331348752607653e-07, -1.8332674399604368e-05, 0.001061502266526514, -0.029791228808445366, 0.40079759789342567, -1.7338062916776138], "scatter": 0.10003121325173432, "method": "polynomial", "range": [15, 39], "x0": 0.0}, "PANSTARRS_ZandLSST_Z": {"x": "spt", "y": "PANSTARRS_ZandLSST_Z", "fit": [-7.697184654991623e-08, 9.612056742934313e-06, -0.00046341514094729686, 0.010720231981558857, -0.11835173204970119, 0.996087864877184], "scatter": 0.10000489335282864, "method": "polynomial", "range": [15, 39], "x0": 0.0}, "PANSTARRS_YandLSST_Y": {"x": "spt", "y": "PANSTARRS_YandLSST_Y", "fit": [-5.074205463539692e-06, 0.0007168772321853589, -0.03994453207163281, 1.0967301094853132, -14.822447155076816, 79.2607414630186], "scatter": 0.10117518499253786, "method": "polynomial", "range": [15, 39], "x0": 0.0}, "LSST_GandLSST_R": {"x": "spt", "y": "LSST_GandLSST_R", "fit": [2.0673385079209283e-05, -0.002904069579902586, 0.15834569880744115, -4.204664489121918, 54.64997152590535, -276.74083905766304], "scatter": 0.3633028196964082, "method": "polynomial", "range": [17, 39], "x0": 0.0}, "LSST_RandLSST_Z": {"x": "spt", "y": "LSST_RandLSST_Z", "fit": [-9.98735836314863e-06, 0.0013202277592256856, -0.06644347737665264, 1.588966587356295, -17.879167556613574, 78.31827910757612], "scatter": 0.24718101449427904, "method": "polynomial", "range": [15, 39], "x0": 0.0}, "LSST_IandLSST_Z": {"x": "spt", "y": "LSST_IandLSST_Z", "fit": [-7.229039827893845e-06, 0.0009910663362999218, -0.052899148506811815, 1.375161534488187, -17.286167822406888, 84.66228437750271], "scatter": 0.15948486874130785, "method": "polynomial", "range": [15, 39], "x0": 0.0}}, "dwarfs": {"LSST_GandPANSTARRS_G": {"x": "spt", "y": "LSST_GandPANSTARRS_G", "fit": [-0.0002591165482083494, 0.009820900301056713, -0.12675877101161653, 0.2879275152831514], "scatter": 0.07647588918308122, "method": "spline", "range": [10.0, 18.0], "x0": 0.0}, "LSST_RandPANSTARRS_R": {"x": "spt", "y": "LSST_RandPANSTARRS_R", "fit": [8.734781342980187e-06, -0.0009290459972416479, 0.024332419183164814, -0.07069018196253507], "scatter": 0.04262462377853566, "method": "spline", "range": [10.0, 31.0], "x0": 0.0}, "LSST_IandPANSTARRS_I": {"x": "spt", "y": "LSST_IandPANSTARRS_I", "fit": [0.00011873438178698539, -0.00564452688804041, 0.08084974128979981, -0.027401133942057176], "scatter": 0.04949724167337082, "method": "spline", "range": [10.0, 25.0], "x0": 0.0}, "LSST_YandPANSTARRS_Y": {"x": "spt", "y": "LSST_YandPANSTARRS_Y", "fit": [4.6528820622417735e-05, -0.0031251005800534814, 0.07188359209167494, 0.020443322775547928], "scatter": 0.039107809581067604, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "LSST_ZandPANSTARRS_Z": {"x": "spt", "y": "LSST_ZandPANSTARRS_Z", "fit": [-2.427584246048443e-06, 0.0001722178660179202, -0.0038622617166725777, 0.5238621394319981], "scatter": 0.047800243494738964, "method": "spline", "range": [10.0, 36.0], "x0": 0.0}, "SDSS_GandPANSTARRS_G": {"x": "spt", "y": "SDSS_GandPANSTARRS_G", "fit": [-0.00020100232775490276, 0.006003051038781272, -0.06081200189201197, -0.027444982461180354], "scatter": 0.06828706174936013, "method": "spline", "range": [10.0, 18.0], "x0": 0.0}, "SDSS_RandPANSTARRS_R": {"x": "spt", "y": "SDSS_RandPANSTARRS_R", "fit": [-5.1526051427960436e-05, 0.0036546306791220206, -0.08261651995141163, 0.534477786035248], "scatter": 0.04140197783903025, "method": "spline", "range": [10.0, 31.0], "x0": 0.0}, "SDSS_IandPANSTARRS_I": {"x": "spt", "y": "SDSS_IandPANSTARRS_I", "fit": [0.0001161764358864966, -0.00512637964445646, 0.06632240490160213, -0.2856325501210895], "scatter": 0.0416920431922034, "method": "spline", "range": [10.0, 25.0], "x0": 0.0}, "SDSS_ZandPANSTARRS_Z": {"x": "spt", "y": "SDSS_ZandPANSTARRS_Z", "fit": [0.00010875707434282885, -0.007311891741904037, 0.1795632800307824, -1.242348234479665], "scatter": 0.042095882554346126, "method": "spline", "range": [10.0, 36.0], "x0": 0.0}, "VISTA_ZandPANSTARRS_Z": {"x": "spt", "y": "VISTA_ZandPANSTARRS_Z", "fit": [9.004246450366076e-06, -0.000517927564311095, 0.015815245911959486, 0.3982960769251776], "scatter": 0.04648468426743088, "method": "spline", "range": [10.0, 36.0], "x0": 0.0}, "VISTA_YandPANSTARRS_Y": {"x": "spt", "y": "VISTA_YandPANSTARRS_Y", "fit": [0.00019869407491675232, -0.012933887400785672, 0.28977264314227846, -1.3574840978008451], "scatter": 0.03514250299087071, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "VISTA_Jand2MASS J": {"x": "spt", "y": "VISTA_Jand2MASS J", "fit": [4.8432962741582365e-06, -0.00013328885898857075, 0.0023691632533059275, 0.018371724308582544], "scatter": 0.013330255329564717, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "VISTA_Hand2MASS H": {"x": "spt", "y": "VISTA_Hand2MASS H", "fit": [8.739332711652544e-06, -0.00047821323155825793, 0.005991083365280063, -0.03588510940478858], "scatter": 0.015368439684992862, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "VISTA_KSand2MASS K": {"x": "spt", "y": "VISTA_KSand2MASS K", "fit": [2.4087894532070977e-05, -0.0012025708241010739, 0.015253614502954664, -0.06661446237477897], "scatter": 0.01695719338741959, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "UKIDSS_YandPANSTARRS_Y": {"x": "spt", "y": "UKIDSS_YandPANSTARRS_Y", "fit": [0.00026894642420945695, -0.018331076201062935, 0.4280915827322837, -2.4508952710220977], "scatter": 0.03501080499437425, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "UKIDSS_ZandPANSTARRS_Z": {"x": "spt", "y": "UKIDSS_ZandPANSTARRS_Z", "fit": [2.412074749763542e-05, -0.001495311578883492, 0.03868483844043829, 0.2568465167923885], "scatter": 0.04512363034663807, "method": "spline", "range": [10.0, 36.0], "x0": 0.0}, "UKIDSS_Jand2MASS J": {"x": "spt", "y": "UKIDSS_Jand2MASS J", "fit": [7.829343732508459e-06, -0.0001655032683791908, 0.0007551764844445366, 0.044986672713673015], "scatter": 0.013039073661274221, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "UKIDSS_Hand2MASS H": {"x": "spt", "y": "UKIDSS_Hand2MASS H", "fit": [9.91753274971094e-06, -0.00047630141214325875, 0.003818664263406534, -0.02048256638065701], "scatter": 0.015862101702844925, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "UKIDSS_Kand2MASS K": {"x": "spt", "y": "UKIDSS_Kand2MASS K", "fit": [-2.6957172651811484e-05, 0.0014355668271533403, -0.023382456038931895, 0.12817653338519797], "scatter": 0.017962004847567627, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "NIRISS_F090WandPANSTARRS_R": {"x": "spt", "y": "NIRISS_F090WandPANSTARRS_R", "fit": [-0.00020480358325991848, -0.0009824280262262291, 0.09332838027791651, 3.991299512905759], "scatter": 0.0447467733836118, "method": "spline", "range": [10.0, 31.0], "x0": 0.0}, "NIRISS_F115Wand2MASS J": {"x": "spt", "y": "NIRISS_F115Wand2MASS J", "fit": [7.663694752384164e-06, 0.000620270260057994, -0.05149969917741428, -0.38227951682201894], "scatter": 0.015091020894643094, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "NIRISS_F150Wand2MASS J": {"x": "spt", "y": "NIRISS_F150Wand2MASS J", "fit": [0.0006938726844839089, -0.06697463420540684, 2.0253815323804907, -20.14439108751721], "scatter": 0.018210269618408104, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "NIRISS_F200Wand2MASS H": {"x": "spt", "y": "NIRISS_F200Wand2MASS H", "fit": [0.00019467453533509433, -0.019361910815710003, 0.5775690317939269, -6.803085643371137], "scatter": 0.019608887347527547, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "WFI_R062andPANSTARRS_Z": {"x": "spt", "y": "WFI_R062andPANSTARRS_Z", "fit": [0.004998653205602806, -0.2698049218959191, 4.29600998736586, -22.453104601759655], "scatter": 0.049858856416350794, "method": "spline", "range": [10.0, 31.0], "x0": 0.0}, "WFI_Z087andPANSTARRS_Z": {"x": "spt", "y": "WFI_Z087andPANSTARRS_Z", "fit": [4.897734558387354e-05, -0.0034593070483272923, 0.08960525599015931, -0.6867354562601502], "scatter": 0.044209988301174626, "method": "spline", "range": [10.0, 36.0], "x0": 0.0}, "WFI_Y106andPANSTARRS_Y": {"x": "spt", "y": "WFI_Y106andPANSTARRS_Y", "fit": [0.00033936646536384817, -0.027262574411457914, 0.7254179935890159, -5.809162898930913], "scatter": 0.03257758526252167, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "WFI_J129and2MASS J": {"x": "spt", "y": "WFI_J129and2MASS J", "fit": [4.23683884773684e-05, -0.004376105398118113, 0.12136503564665613, -1.935923834261555], "scatter": 0.01703013616188935, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "WFI_H158and2MASS H": {"x": "spt", "y": "WFI_H158and2MASS H", "fit": [-5.487417938900494e-06, 0.0006056585317904371, -0.03129607342926367, -1.089248442309321], "scatter": 0.016630439692899714, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "WFI_F184and2MASS H": {"x": "spt", "y": "WFI_F184and2MASS H", "fit": [-0.0001664502025736633, 0.009031740693866266, -0.15720116255631017, -0.6396999768784839], "scatter": 0.02206001188773756, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "WFI_Prismand2MASS J": {"x": "spt", "y": "WFI_Prismand2MASS J", "fit": [3.4171229933814415e-05, -0.005151209427894027, 0.1741706418750466, -2.8275558087708568], "scatter": 0.01914520771425298, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "WFI_Grismand2MASS H": {"x": "spt", "y": "WFI_Grismand2MASS H", "fit": [-0.0002343865643953181, 0.024210213869497208, -0.7801989980220592, 6.09903772285711], "scatter": 0.01786888004564286, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "EUCLID_YandPANSTARRS_Y": {"x": "spt", "y": "EUCLID_YandPANSTARRS_Y", "fit": [0.0003197363697347696, -0.025501177812860352, 0.6759443567040095, -5.245240347190846], "scatter": 0.03327615846549964, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "EUCLID_Jand2MASS J": {"x": "spt", "y": "EUCLID_Jand2MASS J", "fit": [8.50390240491186e-05, -0.008186259323310727, 0.22910486037528205, -2.8217145464897824], "scatter": 0.016792087051373188, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "EUCLID_Hand2MASS H": {"x": "spt", "y": "EUCLID_Hand2MASS H", "fit": [-8.530800091408146e-06, -0.0003214114206590677, 0.02198455013081396, -1.6982520787367736], "scatter": 0.020157563697238222, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "SUBARU_GandPANSTARRS_G": {"x": "spt", "y": "SUBARU_GandPANSTARRS_G", "fit": [0.0053704208727356545, -0.20297163738118207, 2.7368682067052275, -10.274130400701212], "scatter": 0.10793406576172841, "method": "spline", "range": [10.0, 18.0], "x0": 0.0}, "SUBARU_RandPANSTARRS_R": {"x": "spt", "y": "SUBARU_RandPANSTARRS_R", "fit": [-0.001095684158993483, -0.004271841153211738, 0.1793050301807932, 7.432110555143751], "scatter": 0.03547554596257583, "method": "spline", "range": [10.0, 18.0], "x0": 0.0}, "SUBARU_IandPANSTARRS_I": {"x": "spt", "y": "SUBARU_IandPANSTARRS_I", "fit": [-0.00019638358879568854, 0.009485358111858817, -0.12269485880939565, 0.8731234197321631], "scatter": 0.04348767551217911, "method": "spline", "range": [10.0, 25.0], "x0": 0.0}, "SUBARU_ZandPANSTARRS_Z": {"x": "spt", "y": "SUBARU_ZandPANSTARRS_Z", "fit": [-0.000135915768862262, 0.012988340590587762, -0.39943585020443456, 3.0684544755588163], "scatter": 0.044176833276436844, "method": "spline", "range": [10.0, 30.0], "x0": 0.0}, "DECAM_GandPANSTARRS_G": {"x": "spt", "y": "DECAM_GandPANSTARRS_G", "fit": [-0.00024334168739303128, 0.008901047939179795, -0.11309279686500091, 0.13716434742622066], "scatter": 0.06883125674956442, "method": "spline", "range": [10.0, 18.0], "x0": 0.0}, "DECAM_RandPANSTARRS_R": {"x": "spt", "y": "DECAM_RandPANSTARRS_R", "fit": [0.0014707542073966828, -0.09531383305601979, 1.9358393478657554, -12.036411306861813], "scatter": 0.04035319289740301, "method": "spline", "range": [10.0, 31.0], "x0": 0.0}, "DECAM_IandPANSTARRS_I": {"x": "spt", "y": "DECAM_IandPANSTARRS_I", "fit": [-0.00016579425352234085, 0.007508598625827096, -0.07022831670055225, 0.5824179778654168], "scatter": 0.04234492051214221, "method": "spline", "range": [10.0, 25.0], "x0": 0.0}, "DECAM_YandPANSTARRS_Y": {"x": "spt", "y": "DECAM_YandPANSTARRS_Y", "fit": [0.00013460321624035493, -0.008016867149169271, 0.1609469548603754, -0.29129842828003083], "scatter": 0.03496023708317043, "method": "spline", "range": [10.0, 38.0], "x0": 0.0}, "DECAM_ZandPANSTARRS_Z": {"x": "spt", "y": "DECAM_ZandPANSTARRS_Z", "fit": [0.0001527264649541111, -0.01072159245213122, 0.27197312821537833, -1.3040396859384285], "scatter": 0.04483151219731471, "method": "spline", "range": [10.0, 36.0], "x0": 0.0}, "WFC3_F110Wand2MASS J": {"x": "spt", "y": "WFC3_F110Wand2MASS J", "fit": [-1.7989502633746243e-05, 0.002058738360752383, -0.08284608268445107, 0.48487405820587676], "scatter": 0.017586946885304752, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "WFC3_F140Wand2MASS J": {"x": "spt", "y": "WFC3_F140Wand2MASS J", "fit": [0.00011463650860123882, -0.010289785910785023, 0.2801240514169048, -2.1379726989621184], "scatter": 0.017018621767547034, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}, "WFC3_F160Wand2MASS H": {"x": "spt", "y": "WFC3_F160Wand2MASS H", "fit": [2.3888110857834674e-05, -0.0002858787866308798, -0.04270291923967984, 0.44464715708868124], "scatter": 0.017541109410267788, "method": "spline", "range": [10.0, 41.0], "x0": 0.0}}}, "colors_teff": {"subdwarfs": {"Gaia_GandLSST_G": {"x": "teff", "y": "Gaia_GandLSST_G", "fit": [1.723563282458789e-14, -9.046928929975044e-11, 1.820534591283606e-07, -0.00017201528949803551, 0.07525679665071243, -19.973641408307774], "scatter": 0.22070027817237287, "method": "polynomial", "range": [500, 1550], "x0": 0.0}, "SDSS_GandLSST_G": {"x": "teff", "y": "SDSS_GandLSST_G", "fit": [-4.871523699883076e-16, 2.4780706875252494e-12, -3.827347698335282e-09, 1.754200648629816e-06, 0.0002603376950511216, -0.4192756284201611], "scatter": 0.10003308763232047, "method": "polynomial", "range": [500, 2600], "x0": 0.0}, "SDSS_RandLSST_G": {"x": "teff", "y": "SDSS_RandLSST_G", "fit": [3.570817081295418e-15, -4.723501753050171e-11, 1.6390606631214312e-07, -0.00023083218450701052, 0.13388984272002888, -25.377471234870164], "scatter": 0.3137649280712076, "method": "polynomial", "range": [500, 1550], "x0": 0.0}, "SDSS_RandLSST_R": {"x": "teff", "y": "SDSS_RandLSST_R", "fit": [3.4307433452890413e-16, -3.241530865015131e-12, 1.1591022136690441e-08, -1.9141999247582744e-05, 0.0137555375891732, -2.541865975315126], "scatter": 0.10663903897016488, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "SDSS_IandLSST_I": {"x": "teff", "y": "SDSS_IandLSST_I", "fit": [5.02867399746782e-17, -4.049488608642666e-13, 1.1591924598619529e-09, -1.406536942115116e-06, 0.0007065899171591946, 0.2179341583291481], "scatter": 0.10007740104469831, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "SDSS_ZandLSST_Z": {"x": "teff", "y": "SDSS_ZandLSST_Z", "fit": [-3.5336740603739443e-16, 3.0429888479652725e-12, -9.815009526837971e-09, 1.4569916168777752e-05, -0.009441127964231022, 2.021035129622021], "scatter": 0.10717924366776604, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "PANSTARRS_RandLSST_R": {"x": "teff", "y": "PANSTARRS_RandLSST_R", "fit": [3.151855145334353e-17, -2.658762393849548e-13, 8.013640763528337e-10, -1.008537185547608e-06, 0.0004611045755029511, 0.06348316064126736], "scatter": 0.10007129733770231, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "PANSTARRS_IandLSST_I": {"x": "teff", "y": "PANSTARRS_IandLSST_I", "fit": [-1.8804545854233824e-17, 1.515610571115792e-13, -4.534048611367085e-10, 6.196953731073958e-07, -0.0003544871090939366, 0.3359609523919096], "scatter": 0.10003121325173432, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "PANSTARRS_ZandLSST_Z": {"x": "teff", "y": "PANSTARRS_ZandLSST_Z", "fit": [7.587862056691807e-18, -6.874128349425475e-14, 2.358961233868976e-10, -3.804872251746239e-07, 0.0002888419829596479, 0.4151347580960371], "scatter": 0.10000489335282864, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "PANSTARRS_YandLSST_Y": {"x": "teff", "y": "PANSTARRS_YandLSST_Y", "fit": [-5.043344508021191e-16, 4.086494741933891e-12, -1.2159194145810583e-08, 1.6332380964674583e-05, -0.009801664304708142, 2.6694354729198118], "scatter": 0.10117518499253786, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "LSST_GandLSST_R": {"x": "teff", "y": "LSST_GandLSST_R", "fit": [-9.819326339829067e-16, 7.650091637325128e-12, -2.053670383323691e-08, 1.945413237481499e-05, 0.00137128181995143, -4.432286037982397], "scatter": 0.3633028196964082, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "LSST_RandLSST_Z": {"x": "teff", "y": "LSST_RandLSST_Z", "fit": [8.415734592353781e-16, -7.936412220022272e-12, 2.6920857703590943e-08, -3.829350028308912e-05, 0.01710354008096714, 7.815829350744316], "scatter": 0.24718101449427904, "method": "polynomial", "range": [500, 2900], "x0": 0.0}, "LSST_IandLSST_Z": {"x": "teff", "y": "LSST_IandLSST_Z", "fit": [8.917135393800796e-16, -8.024494705142146e-12, 2.7002615751215432e-08, -4.106796008056343e-05, 0.025122972330200992, -0.47301740227232614], "scatter": 0.15948486874130785, "method": "polynomial", "range": [500, 2900], "x0": 0.0}}, "dwarfs": {}}, "absmags_spt": {"subdwarfs": {"LSST_R": {"x": "spt", "y": "r", "fit": [0.0001383020930108926, -0.011039371786755509, 0.27945263311194096, -1.6827845094027616, 6.0650911946763095], "scatter": 0.31426183079731984, "method": "polynomial", "range": [10.0, 39.27272727272727], "x0": 0.0}, "LSST_I": {"x": "spt", "y": "i", "fit": [9.281110386604776e-05, -0.007842847121773104, 0.21657538175883623, -1.5793927633652545, 7.913681423787605], "scatter": 0.2618148554587376, "method": "polynomial", "range": [10.0, 39.27272727272727], "x0": 0.0}, "LSST_Z": {"x": "spt", "y": "z", "fit": [0.00010758991355577026, -0.009904660054948207, 0.31150870726546, -3.43779762921485, 19.290047261591656], "scatter": 0.24465234314904058, "method": "polynomial", "range": [10.0, 39.27272727272727], "x0": 0.0}}, "dwarfs": {"LSST_G": {"x": "spt", "y": "LSST_G", "fit": [-9.100167827452164e-06, 0.0013213421163587966, -0.07097617717049098, 1.7396199227350573, -18.260579402930627, 76.5577818017333], "scatter": 0.24799298947876397, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "LSST_R": {"x": "spt", "y": "LSST_R", "fit": [-1.7624402424709908e-05, 0.0022417252368265883, -0.1080404821043314, 2.4246408425102786, -24.146844108986425, 94.78887570855942], "scatter": 0.23690085505981193, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "LSST_I": {"x": "spt", "y": "LSST_I", "fit": [-1.572036951260401e-05, 0.00193422970394791, -0.09062883950768733, 1.9946485647962253, -19.656284051831218, 77.88761601772805], "scatter": 0.21867515561635947, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "LSST_Y": {"x": "spt", "y": "LSST_Y", "fit": [-6.649593536528823e-06, 0.0009112564916027903, -0.04675920716682469, 1.1005634416073653, -11.162424940300449, 47.40299021678589], "scatter": 0.21301230414048758, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "LSST_Z": {"x": "spt", "y": "LSST_Z", "fit": [-8.48169586813384e-06, 0.0011315781189112487, -0.05695847912066097, 1.3260682234134584, -13.471080214520589, 56.34009129061143], "scatter": 0.21287295743184292, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "SDSS_G": {"x": "spt", "y": "SDSS_G", "fit": [-8.31758637053051e-06, 0.0012555020085126623, -0.06881002314051003, 1.7036355133027479, -17.959723723571447, 75.58270080427496], "scatter": 0.24563393361712083, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "SDSS_R": {"x": "spt", "y": "SDSS_R", "fit": [-1.786234656222628e-05, 0.0022702383187740713, -0.10933929264175747, 2.4531048890813656, -24.463619299109173, 96.08156742235343], "scatter": 0.2367779404531905, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "SDSS_I": {"x": "spt", "y": "SDSS_I", "fit": [-1.578191857617511e-05, 0.0019401736833765594, -0.09086561230907408, 1.9997307775345692, -19.713724854817738, 77.78346629445132], "scatter": 0.21700950408056938, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "SDSS_Z": {"x": "spt", "y": "SDSS_Z", "fit": [-9.840980234716814e-06, 0.0012761743169666794, -0.06269404727002936, 1.4305837629776108, -14.305348233575835, 58.0947211120129], "scatter": 0.21200753343206677, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "VISTA_Z": {"x": "spt", "y": "VISTA_Z", "fit": [-9.265012103937234e-06, 0.0012143506173591166, -0.06027155766749666, 1.388648944392278, -14.022862101004273, 58.18083755434496], "scatter": 0.2127613980490063, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "VISTA_Y": {"x": "spt", "y": "VISTA_Y", "fit": [-7.74555019513362e-06, 0.0010239799643011111, -0.0509588653320379, 1.1693197326774931, -11.614057914858792, 48.19996135620045], "scatter": 0.21227155416258173, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "VISTA_J": {"x": "spt", "y": "VISTA_J", "fit": [-6.277387452721725e-06, 0.000841995937882098, -0.042461001701131484, 0.9846491589371074, -9.85138937369885, 40.65554992272734], "scatter": 0.21902750327810655, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "VISTA_H": {"x": "spt", "y": "VISTA_H", "fit": [-8.305122851177911e-06, 0.0010720766435728646, -0.05204766783087518, 1.1664905156681875, -11.434784273848784, 45.09298967243026], "scatter": 0.22153790023643966, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "VISTA_KS": {"x": "spt", "y": "VISTA_KS", "fit": [-1.041119241732215e-05, 0.0012909369772639324, -0.0605169748763722, 1.3194977874544522, -12.76219078175882, 49.388201587277386], "scatter": 0.2258528487463876, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "UKIDSS_Y": {"x": "spt", "y": "UKIDSS_Y", "fit": [-7.837768660134532e-06, 0.001032987459650032, -0.0512097435479788, 1.1690738205912425, -11.513239771065013, 47.2062941279045], "scatter": 0.21227352060352694, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "UKIDSS_Z": {"x": "spt", "y": "UKIDSS_Z", "fit": [-9.411629046249123e-06, 0.001229988297175874, -0.060893029233551034, 1.3999901593489967, -14.113154129820254, 58.434870356988476], "scatter": 0.21247565690020506, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "UKIDSS_J": {"x": "spt", "y": "UKIDSS_J", "fit": [-6.40965964210808e-06, 0.0008567290933254807, -0.043086066486554914, 0.9973369479928665, -9.974682989387267, 41.12212054165136], "scatter": 0.21886399389405828, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "UKIDSS_H": {"x": "spt", "y": "UKIDSS_H", "fit": [-8.338818232911797e-06, 0.00107573230475269, -0.05219728763608545, 1.1694368890562328, -11.464165940681308, 45.20385930313103], "scatter": 0.22152316022716947, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "UKIDSS_K": {"x": "spt", "y": "UKIDSS_K", "fit": [-1.1693675875213397e-05, 0.0014272929761956871, -0.06608620584892795, 1.4281261886007774, -13.767433899498155, 52.9401157132937], "scatter": 0.22524318250179015, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "NIRISS_F090W": {"x": "spt", "y": "NIRISS_F090W", "fit": [-1.9762060163227673e-05, 0.002489873774504865, -0.11838421904636003, 2.6134402400360472, -25.722021226991302, 104.27348774064575], "scatter": 0.23922658333142494, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "NIRISS_F115W": {"x": "spt", "y": "NIRISS_F115W", "fit": [-5.886569119581162e-06, 0.0008002059389235845, -0.04076110128185874, 0.9528104331551027, -9.608698428194701, 39.228133780549285], "scatter": 0.21932292300912212, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "NIRISS_F150W": {"x": "spt", "y": "NIRISS_F150W", "fit": [-6.000754575996292e-06, 0.0008149798890866913, -0.04079973127968214, 0.9017458797289747, -7.7034694709873, 20.11810399644905], "scatter": 0.21949595688624715, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "NIRISS_F200W": {"x": "spt", "y": "NIRISS_F200W", "fit": [-9.582636109539502e-06, 0.0012057389770780676, -0.057172149740492645, 1.2476590670024632, -11.759253621605206, 41.38836538779589], "scatter": 0.22113686530758958, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFI_R062": {"x": "spt", "y": "WFI_R062", "fit": [1.3297717775920555e-05, -0.0010794296128451974, 0.032005641325413704, -0.4294497920061416, 3.1933670939662453, -5.756222630592024], "scatter": 0.21137457971586368, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFI_Z087": {"x": "spt", "y": "WFI_Z087", "fit": [-9.330113288953046e-06, 0.0012219548408601236, -0.06055839905755937, 1.3921965645381535, -14.009303568250203, 57.307015273154875], "scatter": 0.21224383642427835, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFI_Y106": {"x": "spt", "y": "WFI_Y106", "fit": [-6.967070875162883e-06, 0.0009382824062700899, -0.04720529956487852, 1.0825263204969229, -10.490801540442444, 41.278471302522746], "scatter": 0.21222689105028272, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFI_J129": {"x": "spt", "y": "WFI_J129", "fit": [-5.559938105395802e-06, 0.0007643427181911256, -0.03923734687848073, 0.9187022063834719, -9.16731697294691, 36.73555050470229], "scatter": 0.21957224977213965, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFI_H158": {"x": "spt", "y": "WFI_H158", "fit": [-8.09750450206007e-06, 0.0010503231256438303, -0.05120717435264624, 1.1519115970879397, -11.336987309998275, 43.596784166875004], "scatter": 0.2217060967849717, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFI_F184": {"x": "spt", "y": "WFI_F184", "fit": [-1.0329006499490096e-05, 0.0012849508292072673, -0.060742071908468497, 1.3378958367464395, -13.060605930495694, 49.52912760385861], "scatter": 0.22091108637272983, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFI_Prism": {"x": "spt", "y": "WFI_Prism", "fit": [-5.265168932276143e-06, 0.000729227157320279, -0.03765308035312719, 0.8838941632193505, -8.774571869277993, 34.5726307598918], "scatter": 0.2202624832691609, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFI_Grism": {"x": "spt", "y": "WFI_Grism", "fit": [-8.221761165357741e-06, 0.001064250759963493, -0.05203277023178989, 1.1876612081914426, -12.203246643812841, 51.21622914066869], "scatter": 0.2215109068025518, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "EUCLID_Y": {"x": "spt", "y": "EUCLID_Y", "fit": [-6.941378378765369e-06, 0.0009336677769988751, -0.04694419069798225, 1.0768342677020062, -10.45396958200321, 41.48598331070464], "scatter": 0.21250601802081828, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "EUCLID_J": {"x": "spt", "y": "EUCLID_J", "fit": [-5.604562788224482e-06, 0.0007663557280004146, -0.0391463440442629, 0.9112418941338083, -9.002442893123627, 35.57756706693278], "scatter": 0.21983289191565808, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "EUCLID_H": {"x": "spt", "y": "EUCLID_H", "fit": [-7.785357055632057e-06, 0.0010153411603070516, -0.04971163499762603, 1.1204766202772336, -10.990431676961434, 41.922778393135204], "scatter": 0.22235049873257481, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "SUBARU_G": {"x": "spt", "y": "SUBARU_G", "fit": [-4.875160503397638e-06, 0.00089967425850689, -0.05597211381158297, 1.4918854121123404, -16.11071886119522, 71.06582316071733], "scatter": 0.26596935852895076, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "SUBARU_R": {"x": "spt", "y": "SUBARU_R", "fit": [-1.75457715142443e-05, 0.0021475304250195507, -0.09894547677569833, 2.125218847595419, -20.6745277227789, 89.4451985739626], "scatter": 0.22890648095023652, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "SUBARU_I": {"x": "spt", "y": "SUBARU_I", "fit": [-1.6014635390155607e-05, 0.001977187457706762, -0.09294187071395743, 2.0503003459829072, -20.234188525387893, 80.07872906698873], "scatter": 0.21755225980554835, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "SUBARU_Z": {"x": "spt", "y": "SUBARU_Z", "fit": [-8.047776684210506e-06, 0.001091858009487059, -0.05572717948888231, 1.316699501882746, -13.69482758634083, 58.37444618356181], "scatter": 0.21193850998232375, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "DECAM_G": {"x": "spt", "y": "DECAM_G", "fit": [-4.696090764296245e-06, 0.000900936791021877, -0.05573598609872315, 1.476727240068789, -16.092948171674706, 69.60047639163247], "scatter": 0.2445306998908947, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "DECAM_R": {"x": "spt", "y": "DECAM_R", "fit": [-1.646963785508164e-05, 0.002083052991640708, -0.09931379155993822, 2.1852231770498944, -20.921240514167344, 78.39004494267095], "scatter": 0.23522027048528618, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "DECAM_I": {"x": "spt", "y": "DECAM_I", "fit": [-1.5681234322678825e-05, 0.0019443977184215356, -0.09173552453984052, 2.028484433199883, -20.021710930149634, 79.2902661207861], "scatter": 0.21731760185184146, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "DECAM_Y": {"x": "spt", "y": "DECAM_Y", "fit": [-7.373182424928424e-06, 0.0009851347155976102, -0.04949244858686886, 1.145846657154346, -11.493506672253107, 48.430928388281274], "scatter": 0.21229902924867922, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "DECAM_Z": {"x": "spt", "y": "DECAM_Z", "fit": [-1.0148961829090454e-05, 0.0013066436982329178, -0.06377565241201949, 1.44654952822256, -14.369950903465124, 58.51712617990134], "scatter": 0.21260895732907795, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFC3_F110W": {"x": "spt", "y": "WFC3_F110W", "fit": [-5.688922767957466e-06, 0.0007781119776136373, -0.03985988633150251, 0.9360758414597722, -9.4726064550527, 39.51134815103], "scatter": 0.2196597318095225, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFC3_F140W": {"x": "spt", "y": "WFC3_F140W", "fit": [-5.5829003272438984e-06, 0.0007641593590608114, -0.03902920959767524, 0.907431887813022, -8.93542695931104, 36.20413331661779], "scatter": 0.2199178124622043, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}, "WFC3_F160W": {"x": "spt", "y": "WFC3_F160W", "fit": [-8.32352902168628e-06, 0.0010751215755816883, -0.052217872659056794, 1.1717452586994503, -11.543934721158331, 45.83023160548034], "scatter": 0.22151038568540057, "method": "spline", "range": [10.0, 39.455008228490975], "x0": 0.0}}}, "absmags_teff": {"subdwarfs": {}, "dwarfs": {"LSST_G": {"x": "teff", "y": "LSST_G", "fit": [-6.614502090434807e-17, 1.1369268812479925e-12, -6.6142568491760815e-09, 1.733659845065845e-05, -0.029042036339652366, 47.863249198271305], "scatter": 0.4132434510112974, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "LSST_R": {"x": "teff", "y": "LSST_R", "fit": [-1.6795511855909299e-16, 2.7605514018421106e-12, -1.6112409797263052e-08, 4.1673140950110916e-05, -0.05260014460805386, 48.39866510833716], "scatter": 0.40441911268205283, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "LSST_I": {"x": "teff", "y": "LSST_I", "fit": [-6.968654491833116e-17, 1.2114831433084774e-12, -7.168007281567016e-09, 1.8666589941578458e-05, -0.02695928970048641, 37.0004708407552], "scatter": 0.35565072558997324, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "LSST_Y": {"x": "teff", "y": "LSST_Y", "fit": [-5.7251763714538915e-18, 3.2619101930341774e-13, -2.5109765562953586e-09, 6.834665153606964e-06, -0.010820584591265269, 24.497980644730152], "scatter": 0.3255021353273035, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "LSST_Z": {"x": "teff", "y": "LSST_Z", "fit": [-8.481579081083003e-17, 1.3527469817138602e-12, -7.523453886658437e-09, 1.8243631061395226e-05, -0.02326221694793847, 30.904994415247042], "scatter": 0.33213286755448107, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "SDSS_G": {"x": "teff", "y": "SDSS_G", "fit": [-1.0719403254017594e-16, 1.7895390171610928e-12, -1.0674830455500097e-08, 2.9598691951581398e-05, -0.04678028140251554, 57.485433062410166], "scatter": 0.41135670931315554, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "SDSS_R": {"x": "teff", "y": "SDSS_R", "fit": [-1.2627782227531765e-16, 2.226673534133499e-12, -1.3554884686946482e-08, 3.612256529103892e-05, -0.04734167213084986, 46.437649027744484], "scatter": 0.39766273503198324, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "SDSS_I": {"x": "teff", "y": "SDSS_I", "fit": [-5.2254089990297167e-17, 9.740632430304129e-13, -5.9298938406503735e-09, 1.5636304464109666e-05, -0.02360257569858176, 35.39752717751045], "scatter": 0.3529119336886965, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "SDSS_Z": {"x": "teff", "y": "SDSS_Z", "fit": [-1.0198635235772902e-17, 3.982016519638382e-13, -2.932755159077348e-09, 8.065320513606796e-06, -0.013337298705675028, 27.642512481431904], "scatter": 0.3441724972672829, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "VISTA_Z": {"x": "teff", "y": "VISTA_Z", "fit": [-7.080551740195636e-17, 1.1719896905914544e-12, -6.642389663046134e-09, 1.625685670248952e-05, -0.02130287563372039, 30.40977338290604], "scatter": 0.3343916338472224, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "VISTA_Y": {"x": "teff", "y": "VISTA_Y", "fit": [3.591482121920544e-17, -1.790217388691139e-13, -2.9750820597523463e-10, 2.7103102089585227e-06, -0.008176162043644086, 24.908662556541593], "scatter": 0.3391834380097721, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "VISTA_J": {"x": "teff", "y": "VISTA_J", "fit": [4.170662702110088e-17, -2.770584390825028e-13, 3.425496227351539e-10, 6.279412962911524e-07, -0.00413465582051846, 18.743388551412792], "scatter": 0.3170540478589087, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "VISTA_H": {"x": "teff", "y": "VISTA_H", "fit": [4.9867650661975483e-17, -2.6524091983237185e-13, -4.992286263871723e-10, 5.022331974137746e-06, -0.012237097205769416, 22.636203930485447], "scatter": 0.3220132969328845, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "VISTA_KS": {"x": "teff", "y": "VISTA_KS", "fit": [8.332331364374874e-17, -6.665908742905328e-13, 1.217745402191119e-09, 2.0558313201630957e-06, -0.01074831914789438, 22.583740511659872], "scatter": 0.31981593348346243, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "UKIDSS_Y": {"x": "teff", "y": "UKIDSS_Y", "fit": [4.699179409351506e-17, -3.0731204375376674e-13, 2.284922676720065e-10, 1.796110502440093e-06, -0.007633647230684591, 25.011147007194854], "scatter": 0.3479061593752318, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "UKIDSS_Z": {"x": "teff", "y": "UKIDSS_Z", "fit": [-6.248116309020977e-17, 1.0667847052903456e-12, -6.145138393274295e-09, 1.5184088456725447e-05, -0.020309528508964943, 30.189953086840383], "scatter": 0.33564447405560266, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "UKIDSS_J": {"x": "teff", "y": "UKIDSS_J", "fit": [5.780849056378634e-17, -4.870518133364009e-13, 1.3832560021609471e-09, -1.7789954318432686e-06, -0.0016077472033370099, 17.826692588736], "scatter": 0.31615084840511914, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "UKIDSS_H": {"x": "teff", "y": "UKIDSS_H", "fit": [4.9652683265973377e-17, -2.618139347844832e-13, -5.204517206439159e-10, 5.08728878398425e-06, -0.012330664933519826, 22.667772245954595], "scatter": 0.32162202144603264, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "UKIDSS_K": {"x": "teff", "y": "UKIDSS_K", "fit": [8.295370596874281e-17, -6.790265691078083e-13, 1.407168286290984e-09, 1.1554845364386447e-06, -0.009006821176946206, 21.481216430730633], "scatter": 0.3201482487731264, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "NIRISS_F090W": {"x": "teff", "y": "NIRISS_F090W", "fit": [-2.8364071991121004e-16, 4.2303591925262625e-12, -2.313448470316351e-08, 5.6894739755941434e-05, -0.0660884665721233, 54.912551806096054], "scatter": 0.4011202916230254, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "NIRISS_F115W": {"x": "teff", "y": "NIRISS_F115W", "fit": [5.559890035016901e-17, -4.589841608937008e-13, 1.2479726320191815e-09, -1.460296964625416e-06, -0.0018470982810186597, 16.558722167982058], "scatter": 0.30831874003973847, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "NIRISS_F150W": {"x": "teff", "y": "NIRISS_F150W", "fit": [1.0623196696493594e-16, -1.0815064768430972e-12, 4.206177678723122e-09, -9.36322347077561e-06, 0.009511246593693358, 10.42356140411707], "scatter": 0.45041669457806677, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "NIRISS_F200W": {"x": "teff", "y": "NIRISS_F200W", "fit": [7.862451087336591e-17, -6.567096266077601e-13, 1.5829991409263899e-09, -6.883678338724167e-07, -0.004265390105888885, 16.803905045742876], "scatter": 0.3693100487563167, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFI_R062": {"x": "teff", "y": "WFI_R062", "fit": [1.3153942438127716e-16, -1.545063895088001e-12, 6.4994225237847446e-09, -1.0911911924094892e-05, 0.0003246958320370453, 23.82665498515063], "scatter": 0.3347956103957947, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFI_Z087": {"x": "teff", "y": "WFI_Z087", "fit": [-6.700097046019616e-17, 1.1355240713588668e-12, -6.553826092100857e-09, 1.6340112916621372e-05, -0.021854798919243853, 30.450140211382248], "scatter": 0.3391106215273225, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFI_Y106": {"x": "teff", "y": "WFI_Y106", "fit": [2.020976918049868e-17, 3.6862992344683954e-14, -1.4263916968735505e-09, 5.224629253936231e-06, -0.01031030102479415, 24.827317624826698], "scatter": 0.37443405887376324, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFI_J129": {"x": "teff", "y": "WFI_J129", "fit": [5.658763109371867e-17, -4.874377495315275e-13, 1.5146038111032018e-09, -2.6721713347054328e-06, 0.0006264598655523385, 14.945729415157276], "scatter": 0.3265832829979287, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFI_H158": {"x": "teff", "y": "WFI_H158", "fit": [5.434438904759515e-17, -3.382960501693571e-13, -3.4500166618370605e-11, 3.5982884254548742e-06, -0.010083386626663478, 19.854632403211383], "scatter": 0.3178416767616764, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFI_F184": {"x": "teff", "y": "WFI_F184", "fit": [3.861960784568209e-17, -1.9033955658544938e-13, -3.4590366481769276e-10, 2.807535126788469e-06, -0.00668810415180092, 16.94330116557419], "scatter": 0.31910728526428955, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFI_Prism": {"x": "teff", "y": "WFI_Prism", "fit": [7.058580768619878e-17, -6.831754991617228e-13, 2.5825126001333225e-09, -5.54083528346347e-06, 0.00436057624264768, 12.877435553174484], "scatter": 0.33470621567449055, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFI_Grism": {"x": "teff", "y": "WFI_Grism", "fit": [8.68955190766903e-17, -7.435310037316676e-13, 1.834884047801563e-09, 1.1658393613021666e-07, -0.00795365669315293, 19.74243304611034], "scatter": 0.2607109271546649, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "EUCLID_Y": {"x": "teff", "y": "EUCLID_Y", "fit": [2.870564375222851e-17, -7.545247851751697e-14, -8.719488162935844e-10, 4.005746854140715e-06, -0.00917985834326317, 24.60919026769673], "scatter": 0.37084559833529673, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "EUCLID_J": {"x": "teff", "y": "EUCLID_J", "fit": [6.600970480885993e-17, -6.070376615712738e-13, 2.0860242901812775e-09, -3.98513604382216e-06, 0.002072644166075317, 14.408920720267405], "scatter": 0.33464251801876405, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "EUCLID_H": {"x": "teff", "y": "EUCLID_H", "fit": [5.640873425787965e-17, -3.6890812973904826e-13, 1.5310345092224663e-10, 2.9765935593859044e-06, -0.00908322054164081, 19.335904633454614], "scatter": 0.3253373171063794, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "SUBARU_G": {"x": "teff", "y": "SUBARU_G", "fit": [-1.1938695029341138e-16, 1.889109188780082e-12, -1.0301771976427565e-08, 2.3624703983549192e-05, -0.02780173811231012, 42.6203504089693], "scatter": 0.46942258061647446, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "SUBARU_R": {"x": "teff", "y": "SUBARU_R", "fit": [-2.2220802333259094e-16, 3.4026148189089244e-12, -1.9454689077742098e-08, 5.160675452342668e-05, -0.06620543759090063, 56.61184689675686], "scatter": 0.3087795069539935, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "SUBARU_I": {"x": "teff", "y": "SUBARU_I", "fit": [-6.144142694342724e-17, 1.0997780345591777e-12, -6.5274765557702e-09, 1.671593476063492e-05, -0.0240181854565342, 35.670512179341664], "scatter": 0.3581012903929214, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "SUBARU_Z": {"x": "teff", "y": "SUBARU_Z", "fit": [-1.679497194799345e-16, 2.457327527217593e-12, -1.3126475079396384e-08, 3.179452250859802e-05, -0.03847241041605292, 35.64998384075358], "scatter": 0.2954649931686267, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "DECAM_G": {"x": "teff", "y": "DECAM_G", "fit": [-2.445132891713694e-16, 3.731598790194645e-12, -2.1320160006703825e-08, 5.7662365863075734e-05, -0.08198744066663716, 73.91961251217815], "scatter": 0.41216707634223815, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "DECAM_R": {"x": "teff", "y": "DECAM_R", "fit": [-3.8268003401786855e-17, 1.086221800367089e-12, -8.062515461146013e-09, 2.3637009374406654e-05, -0.033880283125036714, 41.78427664244535], "scatter": 0.451006498012234, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "DECAM_I": {"x": "teff", "y": "DECAM_I", "fit": [-8.060236760800066e-17, 1.3574426936970373e-12, -7.833481432022178e-09, 1.9721912757571893e-05, -0.0269666914794123, 36.67010108930802], "scatter": 0.3633678797417038, "method": "polynomial", "range": [500.0, 4176.42609281166], "x0": 0.0}, "DECAM_Y": {"x": "teff", "y": "DECAM_Y", "fit": [2.7730696263248134e-17, -8.277381644127116e-14, -7.00881259471245e-10, 3.4408727321097083e-06, -0.008625383135652798, 24.788793106238664], "scatter": 0.3277785790045751, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "DECAM_Z": {"x": "teff", "y": "DECAM_Z", "fit": [6.864320636620508e-18, 1.8549010448988717e-13, -1.942270681072973e-09, 5.940867730515935e-06, -0.011359545032074972, 27.87401323659671], "scatter": 0.35191885518013666, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFC3_F110W": {"x": "teff", "y": "WFC3_F110W", "fit": [5.2606996334172184e-17, -4.337855640381221e-13, 1.2239464435207433e-09, -1.7644488546044535e-06, -0.000865048300619632, 16.319530724892996], "scatter": 0.30643378354025763, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFC3_F140W": {"x": "teff", "y": "WFC3_F140W", "fit": [6.39525563084137e-17, -5.728728992675096e-13, 1.8617095243819574e-09, -3.282348580680575e-06, 0.0010148556216074036, 16.120485421486734], "scatter": 0.3386408493140105, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}, "WFC3_F160W": {"x": "teff", "y": "WFC3_F160W", "fit": [2.7244786846000448e-17, 3.9498672069407366e-14, -2.0832943542557552e-09, 8.988714934008392e-06, -0.01686406648213941, 24.24919232962919], "scatter": 0.31373852218841, "method": "polynomial", "range": [423.7692625124718, 4176.42609281166], "x0": 0.0}}}}