/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

import React from 'react';

const ChatIcon: React.FC<{
    fill?: string;
    height?: string;
    width?: string;
}> = ({
    height = '20',
    width = '19',
}) => (
        <svg
            data-testid="chat-icon"
            xmlns="http://www.w3.org/2000/svg"
            width={width}
            height={height}
            viewBox={`0 0 ${width} ${height}`}
        >
            <g fill="currentColor">
                <path d="M15.0626 4.8125C15.5466 4.8125 15.9376 5.20352 15.9376 5.6875C15.9376 6.17148 15.5466 6.5625 15.0626 6.5625C14.5787 6.5625 14.1876 6.17148 14.1876 5.6875C14.1876 5.20352 14.5787 4.8125 15.0626 4.8125ZM12.0001 4.8125C12.4841 4.8125 12.8751 5.20352 12.8751 5.6875C12.8751 6.17148 12.4841 6.5625 12.0001 6.5625C11.5162 6.5625 11.1251 6.17148 11.1251 5.6875C11.1251 5.20352 11.5162 4.8125 12.0001 4.8125ZM8.93764 4.8125C9.42162 4.8125 9.81264 5.20352 9.81264 5.6875C9.81264 6.17148 9.42162 6.5625 8.93764 6.5625C8.45365 6.5625 8.06264 6.17148 8.06264 5.6875C8.06264 5.20352 8.45365 4.8125 8.93764 4.8125ZM12.0001 0C15.8665 0 19.0001 2.5457 19.0001 5.6875C19.0001 6.98906 18.456 8.18125 17.5537 9.14102C17.9611 10.2184 18.8087 11.1316 18.8224 11.1426C19.0029 11.334 19.0521 11.6129 18.9482 11.8535C18.8443 12.0941 18.6064 12.25 18.3439 12.25C16.6622 12.25 15.3361 11.5473 14.5404 10.984C13.7501 11.2328 12.897 11.375 12.0001 11.375C8.13373 11.375 5.00014 8.8293 5.00014 5.6875C5.00014 2.5457 8.13373 0 12.0001 0ZM12.0001 10.0625C12.7302 10.0625 13.4521 9.95039 14.1439 9.73164L14.7646 9.53477L15.2978 9.91211C15.6888 10.1883 16.2247 10.4973 16.8701 10.7051C16.6705 10.3742 16.4763 10.0023 16.3259 9.60586L16.0361 8.8375L16.5994 8.24141C17.0943 7.71367 17.6876 6.84141 17.6876 5.6875C17.6876 3.27578 15.1365 1.3125 12.0001 1.3125C8.86381 1.3125 6.31264 3.27578 6.31264 5.6875C6.31264 8.09922 8.86381 10.0625 12.0001 10.0625Z" />
                <path d="M7 7C3.13359 7 0 9.5457 0 12.6875C0 14.0437 0.585156 15.2852 1.55859 16.2613C1.2168 17.6395 0.0738281 18.8672 0.0601563 18.8809C0 18.9438 -0.0164062 19.0367 0.0191406 19.1188C0.0546875 19.2008 0.13125 19.25 0.21875 19.25C2.03164 19.25 3.39063 18.3805 4.06328 17.8445C4.95742 18.1809 5.95 18.375 7 18.375C10.8664 18.375 14 15.8293 14 12.6875C14 9.5457 10.8664 7 7 7ZM3.5 13.5625C3.01602 13.5625 2.625 13.1715 2.625 12.6875C2.625 12.2035 3.01602 11.8125 3.5 11.8125C3.98398 11.8125 4.375 12.2035 4.375 12.6875C4.375 13.1715 3.98398 13.5625 3.5 13.5625ZM7 13.5625C6.51602 13.5625 6.125 13.1715 6.125 12.6875C6.125 12.2035 6.51602 11.8125 7 11.8125C7.48398 11.8125 7.875 12.2035 7.875 12.6875C7.875 13.1715 7.48398 13.5625 7 13.5625ZM10.5 13.5625C10.016 13.5625 9.625 13.1715 9.625 12.6875C9.625 12.2035 10.016 11.8125 10.5 11.8125C10.984 11.8125 11.375 12.2035 11.375 12.6875C11.375 13.1715 10.984 13.5625 10.5 13.5625Z" />
            </g>
        </svg>
    );

export default ChatIcon;