# Contributing to _Conversations_

Contributions are immensely appreciated and welcomed.


## Development Process

### Standards

To ensure effecient collaborative development, a variety of standards are utilised in this project.

- [Semantic Versioning](https://semver.org) is used.
    - [Python Semantic Releases](https://github.com/python-semantic-release/python-semantic-release) is used to automate change log generation and releases.
- [Conventional Commits](https://www.conventionalcommits.org/) are utilised and validated using the [wagoid/commitlint-github-action](https://github.com/wagoid/commitlint-github-action) github action, which itself uses [commitlint](https://github.com/conventional-changelog/commitlint)
    - Conventional Commmits are also utilised for pull request titles and enforced using [amannn/action-semantic-pull-request](https://github.com/amannn/action-semantic-pull-request).
- [Black](https://github.com/psf/black) code formatter is used.
    - [Actions Black](https://github.com/rickstaa/action-black) is used to format code in PRs.
- [Numpy style documentation strings](https://numpydoc.readthedocs.io/en/latest/format.html) are used.
    - [Pydocstyle](http://www.pydocstyle.org/en/stable/) is used to ensure documentation strings adhere to the standard.
- [Type hinting](https://docs.python.org/3/library/typing.html) is used.
    - And checked using [mypy](http://mypy-lang.org).
- Spelling is enforced using [codespell](https://github.com/codespell-project/codespell).

### Website

- The website and documentation is generated by [mkdocs](https://www.mkdocs.org) with the [mkdocsstrings](https://mkdocstrings.github.io) extension and [material](https://squidfunk.github.io/mkdocs-material/) theme.
