from io import StringIO

import pytest

from haplo.data_preparation import arbitrary_constantinos_kalapotharakos_file_contents_to_polars


def test_conversion_of_constantinos_kalapotharakos_format_file_handle_to_pandas_dataframe():
    file_contents_stub = b"""
  -0.137349282472716       4.651922986569446E-002 -0.126309026142708     
   2.57614122691645        3.94358482944553       0.303202923979724     
  0.132341360556433       0.304479697430865       0.758863131388038     
   3.84855473811096        2.77055893884855       -60707.7983495627     
   3304.07368074107        2885.49972405487        2585.23695232772     
   2435.75967557436        2414.95466459188        2558.18565865013     
   2828.53835520211        3201.38990408977        3639.30568490091     
   4108.50977290014        4598.79538425771        5066.55896544410     
   5478.35843853068        5819.24498291364        6093.33028957819     
   6269.82404801646        6358.58809938398        6378.18602155712     
   6323.47815226925        6211.05135135263        6071.94578487311     
   5939.45056697106        5819.35941605676        5754.30957355691     
   5800.07784946601        5925.96989016155        6194.92744193361     
   6596.51902146235        7173.10039158643        7881.00144080469     
   8722.80902255440        9708.91976575786        10810.6736478793     
   11886.8328370200        13003.3304911898        14068.7010232283     
   15060.2472776974        15999.7830008335        16802.8947014434     
   17492.6169028884        18002.9359362144        18348.3853069386     
   18610.5004887474        18655.6797507195        18534.4665953174     
   18242.2548976158        17809.2068920135        17282.8059905053     
   16614.3385258104        15834.6964442490        14933.7245082360     
   14030.3856913494        13081.9208137719        12069.2154503197     
   11087.3584605868        10130.2902279368        9190.96832873567     
   8277.63623378759        7389.06769335657        6559.04073164430     
   5805.71893764466        5094.57367609336        4463.47466681482     
   3856.13597951192     
 -4.043409993728597E-003 -0.128075018705045       0.224196155814766     
   1.21738848456914        5.00517716985642      -0.102001058482608     
 -0.372063036135099      -0.160829623774867        1.80830343946847     
   4.09294326775268        7.29742160149888       -65775.1946940988     
   2965.60917973073        2817.75059624910        2667.79154539088     
   2553.29774621568        2421.41614714647        2310.15583542935     
   2258.13993690502        2289.71347796575        2502.83551008805     
   2912.50617148077        3575.13440225266        4502.37526948587     
   5680.93070840227        7034.14535891384        8568.92320582812     
   10189.4150625844        11841.8627674754        13488.5704975548     
   14999.3757004603        16390.3900383063        17604.9171259886     
   18501.1092637771        19140.8981156140        19487.6178919886     
   19537.5779560356        19266.1171897656        18733.0956973584     
   17980.0181865558        17022.9612533786        15927.8298866168     
   14722.7900169746        13470.5437443183        12210.0762834222     
   10988.4125211004        9824.87139050356        8788.06374634578     
   7867.61692894692        7109.72208859924        6525.86103074197     
   6110.86872917927        5824.32396808876        5742.08251212740     
   5764.56175753815        5947.46766664592        6187.84031336860     
   6456.45937145367        6712.41302651271        6885.23006564379     
   6973.56493444504        6981.19279667291        6887.65158476772     
   6698.72628246103        6526.44157120265        6230.24201346512     
   5913.56973890497        5532.82439919757        5188.26639767070     
   4834.58426833610        4469.91318462395        4168.39007926779     
   3858.44869583521        3582.59549752075        3355.65062746198     
   3153.37600771749  
    """
    data_frame = arbitrary_constantinos_kalapotharakos_file_contents_to_polars(
        file_contents_stub, columns_per_row=11 + 1 + 64)
    assert data_frame.row(0)[0] == pytest.approx(-0.137349282472716)
    assert data_frame.row(0)[10] == pytest.approx(2.77055893884855)
    assert data_frame.row(0)[11 + 1 + 2] == pytest.approx(2585.23695232772)
    assert data_frame.row(0)[11 + 1 + 60] == pytest.approx(5805.71893764466)
    assert data_frame.row(1)[11 + 1 + 0] == pytest.approx(2965.60917973073)
