#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 4.0.0-a53ec6ee1b on 2019-05-07.
#  2019, SMART Health IT.


import os
import io
import unittest
import json
from . import testscript
from .fhirdate import FHIRDate


class TestScriptTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("TestScript", js["resourceType"])
        return testscript.TestScript(js)
    
    def testTestScript1(self):
        inst = self.instantiate_from("testscript-example-multisystem.json")
        self.assertIsNotNone(inst, "Must have instantiated a TestScript instance")
        self.implTestScript1(inst)
        
        js = inst.as_json()
        self.assertEqual("TestScript", js["resourceType"])
        inst2 = testscript.TestScript(js)
        self.implTestScript1(inst2)
    
    def implTestScript1(self, inst):
        self.assertEqual(inst.contact[0].name, "Support")
        self.assertEqual(inst.contact[0].telecom[0].system, "email")
        self.assertEqual(inst.contact[0].telecom[0].use, "work")
        self.assertEqual(inst.contact[0].telecom[0].value, "support@HL7.org")
        self.assertEqual(inst.copyright, "© HL7.org 2011+")
        self.assertEqual(inst.date.date, FHIRDate("2017-01-18").date)
        self.assertEqual(inst.date.as_json(), "2017-01-18")
        self.assertEqual(inst.destination[0].index, 1)
        self.assertEqual(inst.destination[0].profile.code, "FHIR-Server")
        self.assertEqual(inst.destination[1].index, 2)
        self.assertEqual(inst.destination[1].profile.code, "FHIR-Server")
        self.assertTrue(inst.experimental)
        self.assertEqual(inst.id, "testscript-example-multisystem")
        self.assertEqual(inst.identifier.system, "urn:ietf:rfc:3986")
        self.assertEqual(inst.identifier.value, "urn:oid:1.3.6.1.4.1.21367.2005.3.7.9878")
        self.assertEqual(inst.jurisdiction[0].coding[0].code, "US")
        self.assertEqual(inst.jurisdiction[0].coding[0].display, "United States of America (the)")
        self.assertEqual(inst.jurisdiction[0].coding[0].system, "urn:iso:std:iso:3166")
        self.assertEqual(inst.metadata.capability[0].capabilities, "CapabilityStatement/example")
        self.assertEqual(inst.metadata.capability[0].description, "Patient Read Operation")
        self.assertEqual(inst.metadata.capability[0].destination, 1)
        self.assertEqual(inst.metadata.capability[0].link[0], "http://hl7.org/fhir/http.html#read")
        self.assertEqual(inst.metadata.capability[0].origin[0], 1)
        self.assertTrue(inst.metadata.capability[0].required)
        self.assertFalse(inst.metadata.capability[0].validated)
        self.assertEqual(inst.metadata.capability[1].capabilities, "CapabilityStatement/example")
        self.assertEqual(inst.metadata.capability[1].description, "Patient Read Operation")
        self.assertEqual(inst.metadata.capability[1].destination, 2)
        self.assertEqual(inst.metadata.capability[1].link[0], "http://hl7.org/fhir/http.html#read")
        self.assertEqual(inst.metadata.capability[1].origin[0], 1)
        self.assertTrue(inst.metadata.capability[1].required)
        self.assertFalse(inst.metadata.capability[1].validated)
        self.assertEqual(inst.metadata.link[0].description, "Demographics and other administrative information about an individual or animal receiving care or other health-related services.")
        self.assertEqual(inst.metadata.link[0].url, "http://hl7.org/fhir/patient.html")
        self.assertEqual(inst.name, "testscript-example-multisystem")
        self.assertEqual(inst.origin[0].index, 1)
        self.assertEqual(inst.origin[0].profile.code, "FHIR-Client")
        self.assertEqual(inst.publisher, "HL7")
        self.assertEqual(inst.purpose, "Patient Read Operation")
        self.assertEqual(inst.status, "draft")
        self.assertEqual(inst.test[0].action[0].operation.accept, "xml")
        self.assertEqual(inst.test[0].action[0].operation.contentType, "xml")
        self.assertEqual(inst.test[0].action[0].operation.description, "Read a Patient from the first destination test system and perform basic validation.")
        self.assertEqual(inst.test[0].action[0].operation.destination, 1)
        self.assertTrue(inst.test[0].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[0].action[0].operation.origin, 1)
        self.assertEqual(inst.test[0].action[0].operation.params, "/${Dest1PatientResourceId}")
        self.assertEqual(inst.test[0].action[0].operation.requestId, "request-read-patient-01")
        self.assertEqual(inst.test[0].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[0].action[0].operation.type.code, "read")
        self.assertEqual(inst.test[0].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[0].action[1].assert_fhir.description, "Confirm that the request method GET was sent by the client system under test.")
        self.assertEqual(inst.test[0].action[1].assert_fhir.requestMethod, "get")
        self.assertFalse(inst.test[0].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[2].assert_fhir.description, "Confirm that the client requested an Accept of xml.")
        self.assertEqual(inst.test[0].action[2].assert_fhir.direction, "request")
        self.assertEqual(inst.test[0].action[2].assert_fhir.headerField, "Accept")
        self.assertEqual(inst.test[0].action[2].assert_fhir.operator, "contains")
        self.assertEqual(inst.test[0].action[2].assert_fhir.value, "xml")
        self.assertFalse(inst.test[0].action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[3].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.test[0].action[3].assert_fhir.direction, "response")
        self.assertEqual(inst.test[0].action[3].assert_fhir.response, "okay")
        self.assertFalse(inst.test[0].action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[4].assert_fhir.contentType, "xml")
        self.assertEqual(inst.test[0].action[4].assert_fhir.description, "Confirm that the returned format is XML.")
        self.assertEqual(inst.test[0].action[4].assert_fhir.direction, "response")
        self.assertFalse(inst.test[0].action[4].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[5].assert_fhir.description, "Confirm that the returned resource type is Patient.")
        self.assertEqual(inst.test[0].action[5].assert_fhir.direction, "response")
        self.assertEqual(inst.test[0].action[5].assert_fhir.resource, "Patient")
        self.assertFalse(inst.test[0].action[5].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].description, "Read a Patient from the first destination test system using the user defined dynamic variable ${Dest1PatientResourceId}. Perform basic validation.")
        self.assertEqual(inst.test[0].id, "01-ReadPatient-Destination1")
        self.assertEqual(inst.test[0].name, "ReadPatient-Destination1")
        self.assertEqual(inst.test[1].action[0].operation.accept, "xml")
        self.assertEqual(inst.test[1].action[0].operation.contentType, "xml")
        self.assertEqual(inst.test[1].action[0].operation.description, "Read a Patient from the second destination test system and perform basic validation.")
        self.assertEqual(inst.test[1].action[0].operation.destination, 2)
        self.assertTrue(inst.test[1].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[1].action[0].operation.origin, 1)
        self.assertEqual(inst.test[1].action[0].operation.params, "/${Dest2PatientResourceId}")
        self.assertEqual(inst.test[1].action[0].operation.requestHeader[0].field, "Accept-Charset")
        self.assertEqual(inst.test[1].action[0].operation.requestHeader[0].value, "utf-8")
        self.assertEqual(inst.test[1].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[1].action[0].operation.type.code, "read")
        self.assertEqual(inst.test[1].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[1].action[1].assert_fhir.description, "Confirm that the client requested an Accept of xml.")
        self.assertEqual(inst.test[1].action[1].assert_fhir.direction, "request")
        self.assertEqual(inst.test[1].action[1].assert_fhir.headerField, "Accept")
        self.assertEqual(inst.test[1].action[1].assert_fhir.operator, "contains")
        self.assertEqual(inst.test[1].action[1].assert_fhir.value, "xml")
        self.assertFalse(inst.test[1].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].action[2].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.test[1].action[2].assert_fhir.direction, "response")
        self.assertEqual(inst.test[1].action[2].assert_fhir.response, "okay")
        self.assertFalse(inst.test[1].action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].action[3].assert_fhir.contentType, "xml")
        self.assertEqual(inst.test[1].action[3].assert_fhir.description, "Confirm that the returned format is XML.")
        self.assertEqual(inst.test[1].action[3].assert_fhir.direction, "response")
        self.assertFalse(inst.test[1].action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].action[4].assert_fhir.description, "Confirm that the returned resource type is Patient.")
        self.assertEqual(inst.test[1].action[4].assert_fhir.direction, "response")
        self.assertEqual(inst.test[1].action[4].assert_fhir.resource, "Patient")
        self.assertFalse(inst.test[1].action[4].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].description, "Read a Patient from the second destination test system using the user defined dynamic variable ${Dest2PatientResourceId}. Perform basic validation.")
        self.assertEqual(inst.test[1].id, "02-ReadPatient-Destination2")
        self.assertEqual(inst.test[1].name, "ReadPatient-Destination2")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.title, "Multisystem Test Script")
        self.assertEqual(inst.url, "http://hl7.org/fhir/TestScript/testscript-example-multisystem")
        self.assertEqual(inst.variable[0].defaultValue, "example")
        self.assertEqual(inst.variable[0].name, "Dest1PatientResourceId")
        self.assertEqual(inst.variable[1].defaultValue, "example")
        self.assertEqual(inst.variable[1].name, "Dest2PatientResourceId")
        self.assertEqual(inst.version, "1.0")
    
    def testTestScript2(self):
        inst = self.instantiate_from("testscript-example-history.json")
        self.assertIsNotNone(inst, "Must have instantiated a TestScript instance")
        self.implTestScript2(inst)
        
        js = inst.as_json()
        self.assertEqual("TestScript", js["resourceType"])
        inst2 = testscript.TestScript(js)
        self.implTestScript2(inst2)
    
    def implTestScript2(self, inst):
        self.assertEqual(inst.contact[0].name, "Support")
        self.assertEqual(inst.contact[0].telecom[0].system, "email")
        self.assertEqual(inst.contact[0].telecom[0].use, "work")
        self.assertEqual(inst.contact[0].telecom[0].value, "support@HL7.org")
        self.assertEqual(inst.copyright, "© HL7.org 2011+")
        self.assertEqual(inst.date.date, FHIRDate("2017-01-18").date)
        self.assertEqual(inst.date.as_json(), "2017-01-18")
        self.assertTrue(inst.experimental)
        self.assertFalse(inst.fixture[0].autocreate)
        self.assertFalse(inst.fixture[0].autodelete)
        self.assertEqual(inst.fixture[0].id, "fixture-patient-create")
        self.assertFalse(inst.fixture[1].autocreate)
        self.assertFalse(inst.fixture[1].autodelete)
        self.assertEqual(inst.fixture[1].id, "fixture-patient-update")
        self.assertEqual(inst.id, "testscript-example-history")
        self.assertEqual(inst.identifier.system, "urn:ietf:rfc:3986")
        self.assertEqual(inst.identifier.value, "urn:oid:1.3.6.1.4.1.21367.2005.3.7.9877")
        self.assertEqual(inst.jurisdiction[0].coding[0].code, "US")
        self.assertEqual(inst.jurisdiction[0].coding[0].display, "United States of America (the)")
        self.assertEqual(inst.jurisdiction[0].coding[0].system, "urn:iso:std:iso:3166")
        self.assertEqual(inst.metadata.capability[0].capabilities, "CapabilityStatement/example")
        self.assertEqual(inst.metadata.capability[0].description, "Patient Update, Delete and History (Instance) Operations")
        self.assertEqual(inst.metadata.capability[0].link[0], "http://hl7.org/fhir/http.html#update")
        self.assertEqual(inst.metadata.capability[0].link[1], "http://hl7.org/fhir/http.html#delete")
        self.assertEqual(inst.metadata.capability[0].link[2], "http://hl7.org/fhir/http.html#history")
        self.assertTrue(inst.metadata.capability[0].required)
        self.assertFalse(inst.metadata.capability[0].validated)
        self.assertEqual(inst.metadata.link[0].description, "Demographics and other administrative information about an individual or animal receiving care or other health-related services.")
        self.assertEqual(inst.metadata.link[0].url, "http://hl7.org/fhir/patient.html")
        self.assertEqual(inst.name, "TestScript Example History")
        self.assertEqual(inst.publisher, "HL7")
        self.assertEqual(inst.purpose, "Patient (Conditional) Create, Update, Delete and History (Instance) Operations")
        self.assertEqual(inst.setup.action[0].operation.accept, "json")
        self.assertEqual(inst.setup.action[0].operation.description, "Execute a delete operation to insure the patient does not exist on the server.")
        self.assertTrue(inst.setup.action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[0].operation.label, "SetupDeletePatient")
        self.assertEqual(inst.setup.action[0].operation.params, "/${createResourceId}")
        self.assertEqual(inst.setup.action[0].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[0].operation.type.code, "delete")
        self.assertEqual(inst.setup.action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[1].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK) or 204(No Content).")
        self.assertEqual(inst.setup.action[1].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[1].assert_fhir.operator, "in")
        self.assertEqual(inst.setup.action[1].assert_fhir.responseCode, "200,204")
        self.assertFalse(inst.setup.action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[2].operation.accept, "json")
        self.assertEqual(inst.setup.action[2].operation.contentType, "json")
        self.assertEqual(inst.setup.action[2].operation.description, "Create patient resource on test server using the contents of fixture-patient-create")
        self.assertTrue(inst.setup.action[2].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[2].operation.label, "SetupCreatePatient")
        self.assertEqual(inst.setup.action[2].operation.params, "/${createResourceId}")
        self.assertEqual(inst.setup.action[2].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[2].operation.sourceId, "fixture-patient-create")
        self.assertEqual(inst.setup.action[2].operation.type.code, "update")
        self.assertEqual(inst.setup.action[2].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[3].assert_fhir.description, "Confirm that the returned HTTP status is 201(Created).")
        self.assertEqual(inst.setup.action[3].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[3].assert_fhir.responseCode, "201")
        self.assertFalse(inst.setup.action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[4].operation.accept, "json")
        self.assertEqual(inst.setup.action[4].operation.contentType, "json")
        self.assertEqual(inst.setup.action[4].operation.description, "Update patient resource on test server using the contents of fixture-patient-update")
        self.assertTrue(inst.setup.action[4].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[4].operation.label, "SetupUpdatePatient")
        self.assertEqual(inst.setup.action[4].operation.params, "/${createResourceId}")
        self.assertEqual(inst.setup.action[4].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[4].operation.sourceId, "fixture-patient-update")
        self.assertEqual(inst.setup.action[4].operation.type.code, "update")
        self.assertEqual(inst.setup.action[4].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[5].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.setup.action[5].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[5].assert_fhir.responseCode, "200")
        self.assertFalse(inst.setup.action[5].assert_fhir.warningOnly)
        self.assertEqual(inst.status, "draft")
        self.assertEqual(inst.test[0].action[0].operation.accept, "json")
        self.assertEqual(inst.test[0].action[0].operation.contentType, "json")
        self.assertEqual(inst.test[0].action[0].operation.description, "Get the Patient history on the test server using the id from fixture-patient-create.")
        self.assertTrue(inst.test[0].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[0].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[0].action[0].operation.targetId, "fixture-patient-create")
        self.assertEqual(inst.test[0].action[0].operation.type.code, "history")
        self.assertEqual(inst.test[0].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[0].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.test[0].action[1].assert_fhir.direction, "response")
        self.assertEqual(inst.test[0].action[1].assert_fhir.response, "okay")
        self.assertFalse(inst.test[0].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[2].assert_fhir.description, "Confirm that the returned resource type is Bundle.")
        self.assertEqual(inst.test[0].action[2].assert_fhir.resource, "Bundle")
        self.assertFalse(inst.test[0].action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[3].assert_fhir.description, "Confirm that the returned Bundle conforms to the base FHIR specification.")
        self.assertEqual(inst.test[0].action[3].assert_fhir.validateProfileId, "bundle-profile")
        self.assertFalse(inst.test[0].action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[4].assert_fhir.description, "Confirm that the returned Bundle type equals 'history'.")
        self.assertEqual(inst.test[0].action[4].assert_fhir.operator, "equals")
        self.assertEqual(inst.test[0].action[4].assert_fhir.path, "fhir:Bundle/fhir:type/@value")
        self.assertEqual(inst.test[0].action[4].assert_fhir.value, "history")
        self.assertFalse(inst.test[0].action[4].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].description, "Get the history for a known Patient and validate response.")
        self.assertEqual(inst.test[0].id, "01-HistoryPatient")
        self.assertEqual(inst.test[0].name, "History Patient")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.url, "http://hl7.org/fhir/TestScript/testscript-example-history")
        self.assertEqual(inst.variable[0].name, "createResourceId")
        self.assertEqual(inst.variable[0].path, "Patient/id")
        self.assertEqual(inst.variable[0].sourceId, "fixture-patient-create")
        self.assertEqual(inst.version, "1.0")
    
    def testTestScript3(self):
        inst = self.instantiate_from("testscript-example-update.json")
        self.assertIsNotNone(inst, "Must have instantiated a TestScript instance")
        self.implTestScript3(inst)
        
        js = inst.as_json()
        self.assertEqual("TestScript", js["resourceType"])
        inst2 = testscript.TestScript(js)
        self.implTestScript3(inst2)
    
    def implTestScript3(self, inst):
        self.assertEqual(inst.contact[0].name, "Support")
        self.assertEqual(inst.contact[0].telecom[0].system, "email")
        self.assertEqual(inst.contact[0].telecom[0].use, "work")
        self.assertEqual(inst.contact[0].telecom[0].value, "support@HL7.org")
        self.assertEqual(inst.copyright, "© HL7.org 2011+")
        self.assertEqual(inst.date.date, FHIRDate("2017-01-18").date)
        self.assertEqual(inst.date.as_json(), "2017-01-18")
        self.assertEqual(inst.description, "TestScript example resource with setup to delete if present and create a new instance of a Patient; and single test definition to update that Patient with various asserts.")
        self.assertTrue(inst.experimental)
        self.assertFalse(inst.fixture[0].autocreate)
        self.assertFalse(inst.fixture[0].autodelete)
        self.assertEqual(inst.fixture[0].id, "fixture-patient-create")
        self.assertFalse(inst.fixture[1].autocreate)
        self.assertFalse(inst.fixture[1].autodelete)
        self.assertEqual(inst.fixture[1].id, "fixture-patient-update")
        self.assertEqual(inst.id, "testscript-example-update")
        self.assertEqual(inst.identifier.system, "urn:ietf:rfc:3986")
        self.assertEqual(inst.identifier.value, "urn:oid:1.3.6.1.4.1.21367.2005.3.7.9882")
        self.assertEqual(inst.jurisdiction[0].coding[0].code, "US")
        self.assertEqual(inst.jurisdiction[0].coding[0].display, "United States of America (the)")
        self.assertEqual(inst.jurisdiction[0].coding[0].system, "urn:iso:std:iso:3166")
        self.assertEqual(inst.metadata.capability[0].capabilities, "CapabilityStatement/example")
        self.assertEqual(inst.metadata.capability[0].description, "Patient Update and Delete Operations")
        self.assertEqual(inst.metadata.capability[0].link[0], "http://hl7.org/fhir/http.html#update")
        self.assertEqual(inst.metadata.capability[0].link[1], "http://hl7.org/fhir/http.html#delete")
        self.assertTrue(inst.metadata.capability[0].required)
        self.assertFalse(inst.metadata.capability[0].validated)
        self.assertEqual(inst.metadata.link[0].description, "Demographics and other administrative information about an individual or animal receiving care or other health-related services.")
        self.assertEqual(inst.metadata.link[0].url, "http://hl7.org/fhir/patient.html")
        self.assertEqual(inst.name, "TestScript Example Update")
        self.assertEqual(inst.publisher, "HL7")
        self.assertEqual(inst.purpose, "Patient (Conditional) Create, Update, Delete Operations")
        self.assertEqual(inst.setup.action[0].operation.accept, "xml")
        self.assertEqual(inst.setup.action[0].operation.description, "Execute a delete operation to insure the patient does not exist on the server.")
        self.assertTrue(inst.setup.action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[0].operation.label, "SetupDeletePatient")
        self.assertEqual(inst.setup.action[0].operation.params, "/${createResourceId}")
        self.assertEqual(inst.setup.action[0].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[0].operation.type.code, "delete")
        self.assertEqual(inst.setup.action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[1].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK) or 204(No Content).")
        self.assertEqual(inst.setup.action[1].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[1].assert_fhir.operator, "in")
        self.assertEqual(inst.setup.action[1].assert_fhir.responseCode, "200,204")
        self.assertFalse(inst.setup.action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[2].operation.accept, "xml")
        self.assertEqual(inst.setup.action[2].operation.contentType, "xml")
        self.assertEqual(inst.setup.action[2].operation.description, "Create patient resource on test server using the contents of fixture-patient-create")
        self.assertTrue(inst.setup.action[2].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[2].operation.label, "SetupCreatePatient")
        self.assertEqual(inst.setup.action[2].operation.params, "/${createResourceId}")
        self.assertEqual(inst.setup.action[2].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[2].operation.sourceId, "fixture-patient-create")
        self.assertEqual(inst.setup.action[2].operation.type.code, "update")
        self.assertEqual(inst.setup.action[2].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[3].assert_fhir.description, "Confirm that the returned HTTP status is 201(Created).")
        self.assertEqual(inst.setup.action[3].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[3].assert_fhir.responseCode, "201")
        self.assertFalse(inst.setup.action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.status, "draft")
        self.assertEqual(inst.test[0].action[0].operation.accept, "xml")
        self.assertEqual(inst.test[0].action[0].operation.contentType, "xml")
        self.assertEqual(inst.test[0].action[0].operation.description, "Update patient resource on test server using the contents of fixture-patient-update")
        self.assertTrue(inst.test[0].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[0].action[0].operation.label, "SetupUpdatePatient")
        self.assertEqual(inst.test[0].action[0].operation.params, "/${createResourceId}")
        self.assertEqual(inst.test[0].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[0].action[0].operation.sourceId, "fixture-patient-update")
        self.assertEqual(inst.test[0].action[0].operation.type.code, "update")
        self.assertEqual(inst.test[0].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[0].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.test[0].action[1].assert_fhir.response, "okay")
        self.assertFalse(inst.test[0].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[2].assert_fhir.contentType, "xml")
        self.assertEqual(inst.test[0].action[2].assert_fhir.description, "Confirm that the returned format is XML.")
        self.assertFalse(inst.test[0].action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[3].assert_fhir.description, "Confirm that the returned HTTP Header Last-Modified is present. Warning only as the server might not support versioning.")
        self.assertEqual(inst.test[0].action[3].assert_fhir.headerField, "Last-Modified")
        self.assertEqual(inst.test[0].action[3].assert_fhir.operator, "notEmpty")
        self.assertTrue(inst.test[0].action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].description, "Update a Patient and validate response.")
        self.assertEqual(inst.test[0].id, "01-UpdatePatient")
        self.assertEqual(inst.test[0].name, "Update Patient")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.url, "http://hl7.org/fhir/TestScript/testscript-example-update")
        self.assertEqual(inst.variable[0].name, "createResourceId")
        self.assertEqual(inst.variable[0].path, "Patient/id")
        self.assertEqual(inst.variable[0].sourceId, "fixture-patient-create")
        self.assertEqual(inst.version, "1.0")
    
    def testTestScript4(self):
        inst = self.instantiate_from("testscript-example-search.json")
        self.assertIsNotNone(inst, "Must have instantiated a TestScript instance")
        self.implTestScript4(inst)
        
        js = inst.as_json()
        self.assertEqual("TestScript", js["resourceType"])
        inst2 = testscript.TestScript(js)
        self.implTestScript4(inst2)
    
    def implTestScript4(self, inst):
        self.assertEqual(inst.contact[0].name, "Support")
        self.assertEqual(inst.contact[0].telecom[0].system, "email")
        self.assertEqual(inst.contact[0].telecom[0].use, "work")
        self.assertEqual(inst.contact[0].telecom[0].value, "support@HL7.org")
        self.assertEqual(inst.copyright, "© HL7.org 2011+")
        self.assertEqual(inst.date.date, FHIRDate("2017-01-18").date)
        self.assertEqual(inst.date.as_json(), "2017-01-18")
        self.assertEqual(inst.description, "TestScript example resource with simple Patient search test. The read tests will utilize user defined dynamic variables that will hold the Patient search parameter values.")
        self.assertTrue(inst.experimental)
        self.assertFalse(inst.fixture[0].autocreate)
        self.assertFalse(inst.fixture[0].autodelete)
        self.assertEqual(inst.fixture[0].id, "fixture-patient-create")
        self.assertEqual(inst.id, "testscript-example-search")
        self.assertEqual(inst.identifier.system, "urn:ietf:rfc:3986")
        self.assertEqual(inst.identifier.value, "urn:oid:1.3.6.1.4.1.21367.2005.3.7.9881")
        self.assertEqual(inst.jurisdiction[0].coding[0].code, "US")
        self.assertEqual(inst.jurisdiction[0].coding[0].display, "United States of America (the)")
        self.assertEqual(inst.jurisdiction[0].coding[0].system, "urn:iso:std:iso:3166")
        self.assertEqual(inst.metadata.capability[0].capabilities, "CapabilityStatement/example")
        self.assertEqual(inst.metadata.capability[0].description, "Patient Search Operation")
        self.assertEqual(inst.metadata.capability[0].link[0], "http://hl7.org/fhir/http.html#search")
        self.assertTrue(inst.metadata.capability[0].required)
        self.assertFalse(inst.metadata.capability[0].validated)
        self.assertEqual(inst.metadata.link[0].description, "Demographics and other administrative information about an individual or animal receiving care or other health-related services.")
        self.assertEqual(inst.metadata.link[0].url, "http://hl7.org/fhir/patient.html")
        self.assertEqual(inst.name, "TestScript Example Search")
        self.assertEqual(inst.publisher, "HL7")
        self.assertEqual(inst.purpose, "Patient Search Operation")
        self.assertEqual(inst.setup.action[0].operation.accept, "xml")
        self.assertEqual(inst.setup.action[0].operation.description, "Test simple search to verify server support.")
        self.assertTrue(inst.setup.action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[0].operation.params, "?family=DONTEXPECTAMATCH&given=DONTEXPECTAMATCH")
        self.assertEqual(inst.setup.action[0].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[0].operation.type.code, "search")
        self.assertEqual(inst.setup.action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[1].assert_fhir.description, "Confirm that the request url contains the family search parameter.")
        self.assertEqual(inst.setup.action[1].assert_fhir.direction, "request")
        self.assertEqual(inst.setup.action[1].assert_fhir.operator, "contains")
        self.assertEqual(inst.setup.action[1].assert_fhir.requestURL, "family")
        self.assertFalse(inst.setup.action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[2].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.setup.action[2].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[2].assert_fhir.responseCode, "200")
        self.assertFalse(inst.setup.action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[3].assert_fhir.description, "Confirm that the returned resource type is Bundle.")
        self.assertEqual(inst.setup.action[3].assert_fhir.resource, "Bundle")
        self.assertFalse(inst.setup.action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[4].assert_fhir.description, "Confirm that the returned Bundle correctly defines the navigation links.")
        self.assertTrue(inst.setup.action[4].assert_fhir.navigationLinks)
        self.assertFalse(inst.setup.action[4].assert_fhir.warningOnly)
        self.assertEqual(inst.status, "draft")
        self.assertEqual(inst.test[0].action[0].operation.accept, "xml")
        self.assertEqual(inst.test[0].action[0].operation.contentType, "xml")
        self.assertEqual(inst.test[0].action[0].operation.description, "Create a Patient resource and capture the returned HTTP Header Location.")
        self.assertTrue(inst.test[0].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[0].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[0].action[0].operation.responseId, "PatientCreateResponse")
        self.assertEqual(inst.test[0].action[0].operation.sourceId, "fixture-patient-create")
        self.assertEqual(inst.test[0].action[0].operation.type.code, "create")
        self.assertEqual(inst.test[0].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[0].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 201(Created).")
        self.assertEqual(inst.test[0].action[1].assert_fhir.response, "created")
        self.assertFalse(inst.test[0].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[2].assert_fhir.description, "Confirm that the returned HTTP Header Location is present.")
        self.assertEqual(inst.test[0].action[2].assert_fhir.direction, "response")
        self.assertEqual(inst.test[0].action[2].assert_fhir.headerField, "Location")
        self.assertEqual(inst.test[0].action[2].assert_fhir.operator, "notEmpty")
        self.assertFalse(inst.test[0].action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[3].operation.accept, "xml")
        self.assertEqual(inst.test[0].action[3].operation.description, "Read the created Patient using the captured Location URL value.")
        self.assertTrue(inst.test[0].action[3].operation.encodeRequestUrl)
        self.assertEqual(inst.test[0].action[3].operation.type.code, "read")
        self.assertEqual(inst.test[0].action[3].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[0].action[3].operation.url, "${PatientCreateLocation}")
        self.assertEqual(inst.test[0].action[4].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.test[0].action[4].assert_fhir.response, "okay")
        self.assertFalse(inst.test[0].action[4].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[5].assert_fhir.description, "Confirm that the returned resource type is Patient.")
        self.assertEqual(inst.test[0].action[5].assert_fhir.resource, "Patient")
        self.assertFalse(inst.test[0].action[5].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].description, "Create a Patient resource and capture the returned HTTP Header Location. Then search for (read) that Patient using the Location URL value and validate the response.")
        self.assertEqual(inst.test[0].id, "01-PatientCreateSearch")
        self.assertEqual(inst.test[0].name, "Patient Create Search")
        self.assertEqual(inst.test[1].action[0].operation.accept, "xml")
        self.assertEqual(inst.test[1].action[0].operation.description, "Search for Patient resources on the destination test system.")
        self.assertTrue(inst.test[1].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[1].action[0].operation.params, "?family=${PatientSearchFamilyName}&given=${PatientSearchGivenName}")
        self.assertEqual(inst.test[1].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[1].action[0].operation.type.code, "search")
        self.assertEqual(inst.test[1].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[1].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.test[1].action[1].assert_fhir.response, "okay")
        self.assertFalse(inst.test[1].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].action[2].assert_fhir.contentType, "xml")
        self.assertEqual(inst.test[1].action[2].assert_fhir.description, "Confirm that the returned format is XML.")
        self.assertFalse(inst.test[1].action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].action[3].assert_fhir.description, "Confirm that the returned resource type is Bundle.")
        self.assertEqual(inst.test[1].action[3].assert_fhir.resource, "Bundle")
        self.assertFalse(inst.test[1].action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].action[4].assert_fhir.description, "Confirm that the returned Bundle conforms to the base FHIR specification.")
        self.assertEqual(inst.test[1].action[4].assert_fhir.validateProfileId, "bundle-profile")
        self.assertFalse(inst.test[1].action[4].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].action[5].assert_fhir.description, "Confirm that the returned Bundle type equals 'searchset'.")
        self.assertEqual(inst.test[1].action[5].assert_fhir.operator, "equals")
        self.assertEqual(inst.test[1].action[5].assert_fhir.path, "fhir:Bundle/fhir:type/@value")
        self.assertEqual(inst.test[1].action[5].assert_fhir.value, "searchset")
        self.assertFalse(inst.test[1].action[5].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].action[6].assert_fhir.description, "Confirm that the returned Bundle total is greater than or equal to the number of returned entries.")
        self.assertEqual(inst.test[1].action[6].assert_fhir.expression, "Bundle.total.toInteger() >= entry.count()")
        self.assertFalse(inst.test[1].action[6].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].description, "Search for Patient resources using the user defined dynamic variables ${PatientSearchFamilyName} and ${PatientSearchGivenName} and validate response.")
        self.assertEqual(inst.test[1].id, "02-PatientSearchDynamic")
        self.assertEqual(inst.test[1].name, "Patient Search Dynamic")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.url, "http://hl7.org/fhir/TestScript/testscript-example-search")
        self.assertEqual(inst.variable[0].headerField, "Location")
        self.assertEqual(inst.variable[0].name, "PatientCreateLocation")
        self.assertEqual(inst.variable[0].sourceId, "PatientCreateResponse")
        self.assertEqual(inst.variable[1].description, "Enter patient search criteria for a known family name on the target system")
        self.assertEqual(inst.variable[1].hint, "[Family name]")
        self.assertEqual(inst.variable[1].name, "PatientSearchFamilyName")
        self.assertEqual(inst.variable[2].description, "Enter patient search criteria for a known given name on the target system")
        self.assertEqual(inst.variable[2].hint, "[Given name]")
        self.assertEqual(inst.variable[2].name, "PatientSearchGivenName")
        self.assertEqual(inst.variable[3].description, "Evaluate the returned Patient searchset Bundle.total value")
        self.assertEqual(inst.variable[3].expression, "Bundle.total.toInteger()")
        self.assertEqual(inst.variable[3].name, "PatientSearchBundleTotal")
        self.assertEqual(inst.version, "1.0")
    
    def testTestScript5(self):
        inst = self.instantiate_from("testscript-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a TestScript instance")
        self.implTestScript5(inst)
        
        js = inst.as_json()
        self.assertEqual("TestScript", js["resourceType"])
        inst2 = testscript.TestScript(js)
        self.implTestScript5(inst2)
    
    def implTestScript5(self, inst):
        self.assertEqual(inst.contact[0].name, "Support")
        self.assertEqual(inst.contact[0].telecom[0].system, "email")
        self.assertEqual(inst.contact[0].telecom[0].use, "work")
        self.assertEqual(inst.contact[0].telecom[0].value, "support@HL7.org")
        self.assertEqual(inst.copyright, "© HL7.org 2011+")
        self.assertEqual(inst.date.date, FHIRDate("2017-01-18").date)
        self.assertEqual(inst.date.as_json(), "2017-01-18")
        self.assertEqual(inst.description, "TestScript example resource with setup to delete if present and create a new instance of a Patient; and single test definition to read the created Patient with various asserts.")
        self.assertTrue(inst.experimental)
        self.assertFalse(inst.fixture[0].autocreate)
        self.assertFalse(inst.fixture[0].autodelete)
        self.assertEqual(inst.fixture[0].id, "fixture-patient-create")
        self.assertFalse(inst.fixture[1].autocreate)
        self.assertFalse(inst.fixture[1].autodelete)
        self.assertEqual(inst.fixture[1].id, "fixture-patient-minimum")
        self.assertEqual(inst.id, "testscript-example")
        self.assertEqual(inst.identifier.system, "urn:ietf:rfc:3986")
        self.assertEqual(inst.identifier.value, "urn:oid:1.3.6.1.4.1.21367.2005.3.7.9876")
        self.assertEqual(inst.jurisdiction[0].coding[0].code, "US")
        self.assertEqual(inst.jurisdiction[0].coding[0].display, "United States of America (the)")
        self.assertEqual(inst.jurisdiction[0].coding[0].system, "urn:iso:std:iso:3166")
        self.assertEqual(inst.metadata.capability[0].capabilities, "CapabilityStatement/example")
        self.assertEqual(inst.metadata.capability[0].description, "Patient Update, Read and Delete Operations")
        self.assertEqual(inst.metadata.capability[0].link[0], "http://hl7.org/fhir/http.html#delete")
        self.assertEqual(inst.metadata.capability[0].link[1], "http://hl7.org/fhir/http.html#read")
        self.assertEqual(inst.metadata.capability[0].link[2], "http://hl7.org/fhir/http.html#update")
        self.assertTrue(inst.metadata.capability[0].required)
        self.assertFalse(inst.metadata.capability[0].validated)
        self.assertEqual(inst.metadata.link[0].description, "Demographics and other administrative information about an individual or animal receiving care or other health-related services.")
        self.assertEqual(inst.metadata.link[0].url, "http://hl7.org/fhir/patient.html")
        self.assertEqual(inst.name, "TestScript Example")
        self.assertEqual(inst.publisher, "HL7")
        self.assertEqual(inst.purpose, "Patient Conditional Create (Update), Read and Delete Operations")
        self.assertEqual(inst.setup.action[0].operation.accept, "json")
        self.assertEqual(inst.setup.action[0].operation.description, "Execute a delete operation to insure the patient does not exist on the server.")
        self.assertTrue(inst.setup.action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[0].operation.label, "SetupDeletePatient")
        self.assertEqual(inst.setup.action[0].operation.params, "/${createResourceId}")
        self.assertEqual(inst.setup.action[0].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[0].operation.type.code, "delete")
        self.assertEqual(inst.setup.action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[1].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK) or 204(No Content).")
        self.assertEqual(inst.setup.action[1].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[1].assert_fhir.operator, "in")
        self.assertEqual(inst.setup.action[1].assert_fhir.responseCode, "200,204")
        self.assertFalse(inst.setup.action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[2].operation.accept, "json")
        self.assertEqual(inst.setup.action[2].operation.contentType, "json")
        self.assertEqual(inst.setup.action[2].operation.description, "Create patient resource on test server using the contents of fixture-patient-create")
        self.assertTrue(inst.setup.action[2].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[2].operation.label, "SetupCreatePatient")
        self.assertEqual(inst.setup.action[2].operation.params, "/${createResourceId}")
        self.assertEqual(inst.setup.action[2].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[2].operation.sourceId, "fixture-patient-create")
        self.assertEqual(inst.setup.action[2].operation.type.code, "update")
        self.assertEqual(inst.setup.action[2].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[3].assert_fhir.description, "Confirm that the returned HTTP status is 201(Created).")
        self.assertEqual(inst.setup.action[3].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[3].assert_fhir.responseCode, "201")
        self.assertFalse(inst.setup.action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[4].operation.description, "Read the created patient resource on the test server using the id from fixture-patient-create. Verify contents.")
        self.assertTrue(inst.setup.action[4].operation.encodeRequestUrl)
        self.assertEqual(inst.setup.action[4].operation.resource, "Patient")
        self.assertEqual(inst.setup.action[4].operation.targetId, "fixture-patient-create")
        self.assertEqual(inst.setup.action[4].operation.type.code, "read")
        self.assertEqual(inst.setup.action[4].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.setup.action[5].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.setup.action[5].assert_fhir.direction, "response")
        self.assertEqual(inst.setup.action[5].assert_fhir.response, "okay")
        self.assertFalse(inst.setup.action[5].assert_fhir.warningOnly)
        self.assertEqual(inst.setup.action[6].assert_fhir.compareToSourceExpression, "Patient.name.first().family")
        self.assertEqual(inst.setup.action[6].assert_fhir.compareToSourceId, "fixture-patient-create")
        self.assertEqual(inst.setup.action[6].assert_fhir.description, "Confirm that the returned Patient contains the expected family name 'Chalmers'. Uses explicit compareToSourceId reference to fixture-patient-create used to create the Patient.")
        self.assertEqual(inst.setup.action[6].assert_fhir.operator, "equals")
        self.assertFalse(inst.setup.action[6].assert_fhir.warningOnly)
        self.assertEqual(inst.status, "draft")
        self.assertEqual(inst.teardown.action[0].operation.description, "Delete the patient resource on the test server using the id from fixture-patient-create.")
        self.assertTrue(inst.teardown.action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.teardown.action[0].operation.resource, "Patient")
        self.assertEqual(inst.teardown.action[0].operation.targetId, "fixture-patient-create")
        self.assertEqual(inst.teardown.action[0].operation.type.code, "delete")
        self.assertEqual(inst.teardown.action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[0].action[0].operation.description, "Read the patient resource on the test server using the id from fixture-patient-create. Prevent URL encoding of the request.")
        self.assertFalse(inst.test[0].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[0].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[0].action[0].operation.responseId, "fixture-patient-read")
        self.assertEqual(inst.test[0].action[0].operation.targetId, "fixture-patient-create")
        self.assertEqual(inst.test[0].action[0].operation.type.code, "read")
        self.assertEqual(inst.test[0].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[0].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.test[0].action[1].assert_fhir.direction, "response")
        self.assertEqual(inst.test[0].action[1].assert_fhir.label, "01-ReadPatientOK")
        self.assertEqual(inst.test[0].action[1].assert_fhir.response, "okay")
        self.assertFalse(inst.test[0].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[2].assert_fhir.description, "Confirm that the returned HTTP Header Last-Modified is present. Warning only as the server might not support versioning.")
        self.assertEqual(inst.test[0].action[2].assert_fhir.direction, "response")
        self.assertEqual(inst.test[0].action[2].assert_fhir.headerField, "Last-Modified")
        self.assertEqual(inst.test[0].action[2].assert_fhir.operator, "notEmpty")
        self.assertTrue(inst.test[0].action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[3].assert_fhir.description, "Confirm that the returned resource type is Patient.")
        self.assertEqual(inst.test[0].action[3].assert_fhir.resource, "Patient")
        self.assertFalse(inst.test[0].action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[4].assert_fhir.description, "Confirm that the returned Patient conforms to the base FHIR specification.")
        self.assertEqual(inst.test[0].action[4].assert_fhir.validateProfileId, "patient-profile")
        self.assertFalse(inst.test[0].action[4].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[5].assert_fhir.description, "Confirm that the returned Patient contains the expected family name 'Chalmers'. Uses explicit sourceId reference to read responseId fixture.")
        self.assertEqual(inst.test[0].action[5].assert_fhir.operator, "equals")
        self.assertEqual(inst.test[0].action[5].assert_fhir.path, "fhir:Patient/fhir:name/fhir:family/@value")
        self.assertEqual(inst.test[0].action[5].assert_fhir.sourceId, "fixture-patient-read")
        self.assertEqual(inst.test[0].action[5].assert_fhir.value, "Chalmers")
        self.assertFalse(inst.test[0].action[5].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[6].assert_fhir.description, "Confirm that the returned Patient contains the expected given name 'Peter'. Uses explicit sourceId reference to read responseId fixture.")
        self.assertEqual(inst.test[0].action[6].assert_fhir.operator, "equals")
        self.assertEqual(inst.test[0].action[6].assert_fhir.path, "fhir:Patient/fhir:name/fhir:given/@value")
        self.assertEqual(inst.test[0].action[6].assert_fhir.sourceId, "fixture-patient-read")
        self.assertEqual(inst.test[0].action[6].assert_fhir.value, "Peter")
        self.assertFalse(inst.test[0].action[6].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[7].assert_fhir.compareToSourceId, "fixture-patient-create")
        self.assertEqual(inst.test[0].action[7].assert_fhir.compareToSourcePath, "fhir:Patient/fhir:name/fhir:family/@value")
        self.assertEqual(inst.test[0].action[7].assert_fhir.operator, "equals")
        self.assertEqual(inst.test[0].action[7].assert_fhir.path, "fhir:Patient/fhir:name/fhir:family/@value")
        self.assertFalse(inst.test[0].action[7].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[8].assert_fhir.compareToSourceId, "fixture-patient-create")
        self.assertEqual(inst.test[0].action[8].assert_fhir.compareToSourcePath, "fhir:Patient/fhir:name/fhir:given/@value")
        self.assertEqual(inst.test[0].action[8].assert_fhir.path, "fhir:Patient/fhir:name/fhir:given/@value")
        self.assertEqual(inst.test[0].action[8].assert_fhir.sourceId, "fixture-patient-read")
        self.assertFalse(inst.test[0].action[8].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[9].assert_fhir.description, "Confirm that the returned resource contains the expected retained elements and values. Warning only to provide users with reviewable results.")
        self.assertEqual(inst.test[0].action[9].assert_fhir.minimumId, "fixture-patient-minimum")
        self.assertTrue(inst.test[0].action[9].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].description, "Read a Patient and validate response.")
        self.assertEqual(inst.test[0].id, "01-ReadPatient")
        self.assertEqual(inst.test[0].name, "Read Patient")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.url, "http://hl7.org/fhir/TestScript/testscript-example")
        self.assertEqual(inst.useContext[0].code.code, "focus")
        self.assertEqual(inst.useContext[0].code.system, "http://terminology.hl7.org/CodeSystem/usage-context-type")
        self.assertEqual(inst.useContext[0].valueCodeableConcept.coding[0].code, "positive")
        self.assertEqual(inst.useContext[0].valueCodeableConcept.coding[0].system, "http://terminology.hl7.org/CodeSystem/variant-state")
        self.assertEqual(inst.variable[0].name, "createResourceId")
        self.assertEqual(inst.variable[0].path, "Patient/id")
        self.assertEqual(inst.variable[0].sourceId, "fixture-patient-create")
        self.assertEqual(inst.version, "1.0")
    
    def testTestScript6(self):
        inst = self.instantiate_from("testscript-example-readtest.json")
        self.assertIsNotNone(inst, "Must have instantiated a TestScript instance")
        self.implTestScript6(inst)
        
        js = inst.as_json()
        self.assertEqual("TestScript", js["resourceType"])
        inst2 = testscript.TestScript(js)
        self.implTestScript6(inst2)
    
    def implTestScript6(self, inst):
        self.assertEqual(inst.contact[0].name, "Support")
        self.assertEqual(inst.contact[0].telecom[0].system, "email")
        self.assertEqual(inst.contact[0].telecom[0].use, "work")
        self.assertEqual(inst.contact[0].telecom[0].value, "support@HL7.org")
        self.assertEqual(inst.copyright, "© HL7.org 2011+")
        self.assertEqual(inst.date.date, FHIRDate("2017-01-18").date)
        self.assertEqual(inst.date.as_json(), "2017-01-18")
        self.assertEqual(inst.description, "TestScript example resource with ported Sprinkler basic read tests R001, R002, R003, R004. The read tests will utilize user defined dynamic variables that will hold the Patient resource id values.")
        self.assertTrue(inst.experimental)
        self.assertEqual(inst.id, "testscript-example-readtest")
        self.assertEqual(inst.identifier.system, "urn:ietf:rfc:3986")
        self.assertEqual(inst.identifier.value, "urn:oid:1.3.6.1.4.1.21367.2005.3.7.9879")
        self.assertEqual(inst.jurisdiction[0].coding[0].code, "US")
        self.assertEqual(inst.jurisdiction[0].coding[0].display, "United States of America (the)")
        self.assertEqual(inst.jurisdiction[0].coding[0].system, "urn:iso:std:iso:3166")
        self.assertEqual(inst.metadata.capability[0].capabilities, "CapabilityStatement/example")
        self.assertEqual(inst.metadata.capability[0].description, "Patient Read Operation")
        self.assertEqual(inst.metadata.capability[0].link[0], "http://hl7.org/fhir/http.html#read")
        self.assertTrue(inst.metadata.capability[0].required)
        self.assertFalse(inst.metadata.capability[0].validated)
        self.assertEqual(inst.metadata.link[0].description, "Demographics and other administrative information about an individual or animal receiving care or other health-related services.")
        self.assertEqual(inst.metadata.link[0].url, "http://hl7.org/fhir/patient.html")
        self.assertEqual(inst.name, "TestScript Example Read Test")
        self.assertEqual(inst.publisher, "HL7")
        self.assertEqual(inst.purpose, "Patient Read Operation")
        self.assertEqual(inst.status, "draft")
        self.assertEqual(inst.test[0].action[0].operation.accept, "xml")
        self.assertEqual(inst.test[0].action[0].operation.description, "Read the known Patient resource on the destination test system using the user defined dynamic variable ${KnownPatientResourceId}.")
        self.assertTrue(inst.test[0].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[0].action[0].operation.params, "/${KnownPatientResourceId}")
        self.assertEqual(inst.test[0].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[0].action[0].operation.type.code, "read")
        self.assertEqual(inst.test[0].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[0].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 200(OK).")
        self.assertEqual(inst.test[0].action[1].assert_fhir.response, "okay")
        self.assertFalse(inst.test[0].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[2].assert_fhir.contentType, "xml")
        self.assertEqual(inst.test[0].action[2].assert_fhir.description, "Confirm that the returned format is XML.")
        self.assertFalse(inst.test[0].action[2].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[3].assert_fhir.description, "Confirm that the returned HTTP Header Last-Modified is present. Warning only as the server might not support versioning.")
        self.assertEqual(inst.test[0].action[3].assert_fhir.headerField, "Last-Modified")
        self.assertEqual(inst.test[0].action[3].assert_fhir.operator, "notEmpty")
        self.assertTrue(inst.test[0].action[3].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[4].assert_fhir.description, "Confirm that the returned resource type is Patient.")
        self.assertEqual(inst.test[0].action[4].assert_fhir.resource, "Patient")
        self.assertFalse(inst.test[0].action[4].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].action[5].assert_fhir.description, "Confirm that the returned Patient conforms to the base FHIR specification.")
        self.assertEqual(inst.test[0].action[5].assert_fhir.validateProfileId, "patient-profile")
        self.assertFalse(inst.test[0].action[5].assert_fhir.warningOnly)
        self.assertEqual(inst.test[0].description, "Read a known Patient and validate response.")
        self.assertEqual(inst.test[0].id, "R001")
        self.assertEqual(inst.test[0].name, "Sprinkler Read Test R001")
        self.assertEqual(inst.test[1].action[0].operation.accept, "xml")
        self.assertTrue(inst.test[1].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[1].action[0].operation.params, "/1")
        self.assertEqual(inst.test[1].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[1].action[0].operation.type.code, "read")
        self.assertEqual(inst.test[1].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[1].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 404(Not Found).")
        self.assertEqual(inst.test[1].action[1].assert_fhir.response, "notFound")
        self.assertFalse(inst.test[1].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[1].description, "Read an unknown Resource Type and validate response.")
        self.assertEqual(inst.test[1].id, "R002")
        self.assertEqual(inst.test[1].name, "Sprinkler Read Test R002")
        self.assertEqual(inst.test[2].action[0].operation.accept, "xml")
        self.assertEqual(inst.test[2].action[0].operation.description, "Attempt to read the non-existing Patient resource on the destination test system using the user defined dynamic variable ${NonExistsPatientResourceId}.")
        self.assertTrue(inst.test[2].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[2].action[0].operation.params, "/${NonExistsPatientResourceId}")
        self.assertEqual(inst.test[2].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[2].action[0].operation.type.code, "read")
        self.assertEqual(inst.test[2].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[2].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 404(Not Found).")
        self.assertEqual(inst.test[2].action[1].assert_fhir.response, "notFound")
        self.assertFalse(inst.test[2].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[2].description, "Read a known, non-existing Patient and validate response.")
        self.assertEqual(inst.test[2].id, "R003")
        self.assertEqual(inst.test[2].name, "Sprinkler Read Test R003")
        self.assertEqual(inst.test[3].action[0].operation.accept, "xml")
        self.assertEqual(inst.test[3].action[0].operation.description, "Attempt to read a Patient resource on the destination test system using known bad formatted resource id.")
        self.assertTrue(inst.test[3].action[0].operation.encodeRequestUrl)
        self.assertEqual(inst.test[3].action[0].operation.params, "/ID-may-not-contain-CAPITALS")
        self.assertEqual(inst.test[3].action[0].operation.resource, "Patient")
        self.assertEqual(inst.test[3].action[0].operation.type.code, "read")
        self.assertEqual(inst.test[3].action[0].operation.type.system, "http://terminology.hl7.org/CodeSystem/testscript-operation-codes")
        self.assertEqual(inst.test[3].action[1].assert_fhir.description, "Confirm that the returned HTTP status is 400(Bad Request).")
        self.assertEqual(inst.test[3].action[1].assert_fhir.response, "bad")
        self.assertFalse(inst.test[3].action[1].assert_fhir.warningOnly)
        self.assertEqual(inst.test[3].description, "Read a Patient using a known bad formatted resource id and validate response.")
        self.assertEqual(inst.test[3].id, "R004")
        self.assertEqual(inst.test[3].name, "Sprinkler Read Test R004")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.url, "http://hl7.org/fhir/TestScript/testscript-example-readtest")
        self.assertEqual(inst.variable[0].defaultValue, "example")
        self.assertEqual(inst.variable[0].name, "KnownPatientResourceId")
        self.assertEqual(inst.variable[1].defaultValue, "does-not-exist")
        self.assertEqual(inst.variable[1].name, "NonExistsPatientResourceId")
        self.assertEqual(inst.version, "1.0")

