#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 4.0.0-a53ec6ee1b on 2019-05-07.
#  2019, SMART Health IT.


import os
import io
import unittest
import json
from . import questionnaireresponse
from .fhirdate import FHIRDate


class QuestionnaireResponseTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("QuestionnaireResponse", js["resourceType"])
        return questionnaireresponse.QuestionnaireResponse(js)
    
    def testQuestionnaireResponse1(self):
        inst = self.instantiate_from("questionnaireresponse-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse1(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse1(inst2)
    
    def implQuestionnaireResponse1(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2013-02-19T14:15:00-05:00").date)
        self.assertEqual(inst.authored.as_json(), "2013-02-19T14:15:00-05:00")
        self.assertEqual(inst.contained[0].id, "patsub")
        self.assertEqual(inst.contained[1].id, "order")
        self.assertEqual(inst.contained[2].id, "questauth")
        self.assertEqual(inst.id, "3141")
        self.assertEqual(inst.identifier.system, "http://example.org/fhir/NamingSystem/questionnaire-ids")
        self.assertEqual(inst.identifier.value, "Q12349876")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[0].answer[0].valueCoding.code, "1")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[0].answer[0].valueCoding.system, "http://cancer.questionnaire.org/system/code/yesno")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[0].linkId, "1.1.1.1")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[1].answer[0].valueCoding.code, "1")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[1].answer[0].valueCoding.system, "http://cancer.questionnaire.org/system/code/yesno")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[1].linkId, "1.1.1.2")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[2].answer[0].valueCoding.code, "0")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[2].answer[0].valueCoding.system, "http://cancer.questionnaire.org/system/code/yesno")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].item[2].linkId, "1.1.1.3")
        self.assertEqual(inst.item[0].item[0].answer[0].item[0].linkId, "1.1.1")
        self.assertEqual(inst.item[0].item[0].answer[0].valueCoding.code, "1")
        self.assertEqual(inst.item[0].item[0].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[0].item[0].answer[0].valueCoding.system, "http://cancer.questionnaire.org/system/code/yesno")
        self.assertEqual(inst.item[0].item[0].linkId, "1.1")
        self.assertEqual(inst.item[0].linkId, "1")
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.status, "generated")
    
    def testQuestionnaireResponse2(self):
        inst = self.instantiate_from("questionnaireresponse-example-ussg-fht-answers.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse2(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse2(inst2)
    
    def implQuestionnaireResponse2(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2008-01-17").date)
        self.assertEqual(inst.authored.as_json(), "2008-01-17")
        self.assertEqual(inst.id, "ussg-fht-answers")
        self.assertEqual(inst.item[0].item[0].answer[0].valueDate.date, FHIRDate("2008-01-17").date)
        self.assertEqual(inst.item[0].item[0].answer[0].valueDate.as_json(), "2008-01-17")
        self.assertEqual(inst.item[0].item[0].linkId, "0.1")
        self.assertEqual(inst.item[0].item[0].text, "Date Done")
        self.assertEqual(inst.item[0].linkId, "0")
        self.assertEqual(inst.item[1].definition, "http://loinc.org/fhir/DataElement/54126-8")
        self.assertEqual(inst.item[1].item[0].item[0].answer[0].valueString, "Annie Proband")
        self.assertEqual(inst.item[1].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54125-0")
        self.assertEqual(inst.item[1].item[0].item[0].linkId, "1.1.1")
        self.assertEqual(inst.item[1].item[0].item[0].text, "Name")
        self.assertEqual(inst.item[1].item[0].item[1].answer[0].valueCoding.code, "LA3-6")
        self.assertEqual(inst.item[1].item[0].item[1].answer[0].valueCoding.display, "Female")
        self.assertEqual(inst.item[1].item[0].item[1].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[1].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54131-8")
        self.assertEqual(inst.item[1].item[0].item[1].linkId, "1.1.2")
        self.assertEqual(inst.item[1].item[0].item[1].text, "Gender")
        self.assertEqual(inst.item[1].item[0].item[2].answer[0].valueDate.date, FHIRDate("1966-04-04").date)
        self.assertEqual(inst.item[1].item[0].item[2].answer[0].valueDate.as_json(), "1966-04-04")
        self.assertEqual(inst.item[1].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/21112-8")
        self.assertEqual(inst.item[1].item[0].item[2].linkId, "1.1.3")
        self.assertEqual(inst.item[1].item[0].item[2].text, "Date of Birth")
        self.assertEqual(inst.item[1].item[0].item[3].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[1].item[0].item[3].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[1].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[1].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54132-6")
        self.assertEqual(inst.item[1].item[0].item[3].linkId, "1.1.4")
        self.assertEqual(inst.item[1].item[0].item[3].text, "Were you born a twin?")
        self.assertEqual(inst.item[1].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[1].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[1].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[1].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54128-4")
        self.assertEqual(inst.item[1].item[0].item[4].linkId, "1.1.5")
        self.assertEqual(inst.item[1].item[0].item[4].text, "Were you adopted?")
        self.assertEqual(inst.item[1].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[1].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[1].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[1].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54135-9")
        self.assertEqual(inst.item[1].item[0].item[5].linkId, "1.1.6")
        self.assertEqual(inst.item[1].item[0].item[5].text, "Are your parents related to each other in any way other than marriage?")
        self.assertEqual(inst.item[1].item[0].item[6].answer[0].item[0].item[0].answer[0].valueCoding.code, "[in_i]")
        self.assertEqual(inst.item[1].item[0].item[6].answer[0].item[0].item[0].answer[0].valueCoding.display, "inches")
        self.assertEqual(inst.item[1].item[0].item[6].answer[0].item[0].item[0].answer[0].valueCoding.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.item[1].item[0].item[6].answer[0].item[0].item[0].linkId, "1.1.7.1.1")
        self.assertEqual(inst.item[1].item[0].item[6].answer[0].item[0].item[0].text, "Units")
        self.assertEqual(inst.item[1].item[0].item[6].answer[0].item[0].linkId, "1.1.7.1")
        self.assertEqual(inst.item[1].item[0].item[6].answer[0].valueDecimal, 63)
        self.assertEqual(inst.item[1].item[0].item[6].definition, "http://loinc.org/fhir/DataElement/8302-2")
        self.assertEqual(inst.item[1].item[0].item[6].linkId, "1.1.7")
        self.assertEqual(inst.item[1].item[0].item[6].text, "Height")
        self.assertEqual(inst.item[1].item[0].item[7].answer[0].item[0].item[0].answer[0].valueCoding.code, "[lb_av]")
        self.assertEqual(inst.item[1].item[0].item[7].answer[0].item[0].item[0].answer[0].valueCoding.display, "pounds")
        self.assertEqual(inst.item[1].item[0].item[7].answer[0].item[0].item[0].answer[0].valueCoding.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.item[1].item[0].item[7].answer[0].item[0].item[0].linkId, "1.1.8.1.1")
        self.assertEqual(inst.item[1].item[0].item[7].answer[0].item[0].item[0].text, "Units")
        self.assertEqual(inst.item[1].item[0].item[7].answer[0].item[0].linkId, "1.1.8.1")
        self.assertEqual(inst.item[1].item[0].item[7].answer[0].valueDecimal, 127)
        self.assertEqual(inst.item[1].item[0].item[7].definition, "http://loinc.org/fhir/DataElement/29463-7")
        self.assertEqual(inst.item[1].item[0].item[7].linkId, "1.1.8")
        self.assertEqual(inst.item[1].item[0].item[7].text, "Weight")
        self.assertEqual(inst.item[1].item[0].item[8].answer[0].valueDecimal, 22.5)
        self.assertEqual(inst.item[1].item[0].item[8].definition, "http://loinc.org/fhir/DataElement/39156-5")
        self.assertEqual(inst.item[1].item[0].item[8].linkId, "1.1.9")
        self.assertEqual(inst.item[1].item[0].item[8].text, "Body mass index (BMI) [Ratio]")
        self.assertEqual(inst.item[1].item[0].item[9].answer[0].valueCoding.code, "LA4457-3")
        self.assertEqual(inst.item[1].item[0].item[9].answer[0].valueCoding.display, "White")
        self.assertEqual(inst.item[1].item[0].item[9].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[1].item[0].item[9].definition, "http://loinc.org/fhir/DataElement/54134-2")
        self.assertEqual(inst.item[1].item[0].item[9].linkId, "1.1.10")
        self.assertEqual(inst.item[1].item[0].item[9].text, "Race")
        self.assertEqual(inst.item[1].item[0].linkId, "1.1")
        self.assertEqual(inst.item[1].linkId, "1")
        self.assertEqual(inst.item[1].text, "Your health information")
        self.assertEqual(inst.item[2].definition, "http://loinc.org/fhir/DataElement/54114-4")
        self.assertEqual(inst.item[2].item[0].item[0].answer[0].valueCoding.code, "LA10405-1")
        self.assertEqual(inst.item[2].item[0].item[0].answer[0].valueCoding.display, "Daughter")
        self.assertEqual(inst.item[2].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[0].item[1].answer[0].valueString, "Susan")
        self.assertEqual(inst.item[2].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[0].item[2].answer[0].valueCoding.code, "LA3-6")
        self.assertEqual(inst.item[2].item[0].item[2].answer[0].valueCoding.display, "Female")
        self.assertEqual(inst.item[2].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 17)
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54141-7")
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.2.2")
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].item[0].item[0].text, "Age")
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.2")
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].valueCoding.code, "LA33-6")
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[2].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[0].linkId, "2.1")
        self.assertEqual(inst.item[2].item[1].item[0].item[0].answer[0].valueCoding.code, "LA10415-0")
        self.assertEqual(inst.item[2].item[1].item[0].item[0].answer[0].valueCoding.display, "Brother")
        self.assertEqual(inst.item[2].item[1].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[1].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[1].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[1].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[1].item[0].item[1].answer[0].valueString, "Brian")
        self.assertEqual(inst.item[2].item[1].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[1].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[1].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[1].item[0].item[2].answer[0].valueCoding.code, "LA2-8")
        self.assertEqual(inst.item[2].item[1].item[0].item[2].answer[0].valueCoding.display, "Male")
        self.assertEqual(inst.item[2].item[1].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[1].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[1].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[1].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 32)
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54141-7")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.2.2")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].item[0].item[0].text, "Age")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.2")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].valueCoding.code, "LA33-6")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[1].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[1].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[1].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[1].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[1].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[1].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[1].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[1].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[1].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[1].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[1].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[1].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[1].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[1].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[1].item[1].item[0].answer[0].valueCoding.code, "LA10550-4")
        self.assertEqual(inst.item[2].item[1].item[1].item[0].answer[0].valueCoding.display, "-- Other Cancer")
        self.assertEqual(inst.item[2].item[1].item[1].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[1].item[1].item[0].linkId, "2.1.2.1")
        self.assertEqual(inst.item[2].item[1].item[1].item[0].text, "Disease or Condition")
        self.assertEqual(inst.item[2].item[1].item[1].item[1].answer[0].valueCoding.code, "LA10397-0")
        self.assertEqual(inst.item[2].item[1].item[1].item[1].answer[0].valueCoding.display, "30-39")
        self.assertEqual(inst.item[2].item[1].item[1].item[1].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[1].item[1].item[1].linkId, "2.1.2.2")
        self.assertEqual(inst.item[2].item[1].item[1].item[1].text, "Age at Diagnosis")
        self.assertEqual(inst.item[2].item[1].item[1].linkId, "2.1.2")
        self.assertEqual(inst.item[2].item[1].item[1].text, "This family member's history of disease")
        self.assertEqual(inst.item[2].item[1].linkId, "2.1")
        self.assertEqual(inst.item[2].item[2].item[0].item[0].answer[0].valueCoding.code, "LA10418-4")
        self.assertEqual(inst.item[2].item[2].item[0].item[0].answer[0].valueCoding.display, "Sister")
        self.assertEqual(inst.item[2].item[2].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[2].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[2].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[2].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[2].item[0].item[1].answer[0].valueString, "Janet")
        self.assertEqual(inst.item[2].item[2].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[2].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[2].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[2].item[0].item[2].answer[0].valueCoding.code, "LA3-6")
        self.assertEqual(inst.item[2].item[2].item[0].item[2].answer[0].valueCoding.display, "Female")
        self.assertEqual(inst.item[2].item[2].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[2].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[2].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[2].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 36)
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54141-7")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.2.2")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].item[0].item[0].text, "Age")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.2")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].valueCoding.code, "LA33-6")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[2].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[2].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[2].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[2].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[2].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[2].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[2].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[2].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[2].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[2].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[2].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[2].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[2].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[2].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[2].item[1].item[0].answer[0].valueCoding.code, "LA10536-3")
        self.assertEqual(inst.item[2].item[2].item[1].item[0].answer[0].valueCoding.display, "-- Breast Cancer")
        self.assertEqual(inst.item[2].item[2].item[1].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[2].item[1].item[0].linkId, "2.1.2.1")
        self.assertEqual(inst.item[2].item[2].item[1].item[0].text, "Disease or Condition")
        self.assertEqual(inst.item[2].item[2].item[1].item[1].answer[0].valueCoding.code, "LA10397-0")
        self.assertEqual(inst.item[2].item[2].item[1].item[1].answer[0].valueCoding.display, "30-39")
        self.assertEqual(inst.item[2].item[2].item[1].item[1].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[2].item[1].item[1].linkId, "2.1.2.2")
        self.assertEqual(inst.item[2].item[2].item[1].item[1].text, "Age at Diagnosis")
        self.assertEqual(inst.item[2].item[2].item[1].linkId, "2.1.2")
        self.assertEqual(inst.item[2].item[2].item[1].text, "This family member's history of disease")
        self.assertEqual(inst.item[2].item[2].linkId, "2.1")
        self.assertEqual(inst.item[2].item[3].item[0].item[0].answer[0].valueCoding.code, "LA10419-2")
        self.assertEqual(inst.item[2].item[3].item[0].item[0].answer[0].valueCoding.display, "Nephew")
        self.assertEqual(inst.item[2].item[3].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[3].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[3].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[3].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[3].item[0].item[1].answer[0].valueString, "Ian")
        self.assertEqual(inst.item[2].item[3].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[3].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[3].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[3].item[0].item[2].answer[0].valueCoding.code, "LA2-8")
        self.assertEqual(inst.item[2].item[3].item[0].item[2].answer[0].valueCoding.display, "Male")
        self.assertEqual(inst.item[2].item[3].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[3].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[3].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[3].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 16)
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54141-7")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.2.2")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].item[0].item[0].text, "Age")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.2")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].valueCoding.code, "LA33-6")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[3].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[3].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[3].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[3].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[3].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[3].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[3].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[3].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[3].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[3].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[3].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[3].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[3].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[3].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[3].linkId, "2.1")
        self.assertEqual(inst.item[2].item[4].item[0].item[0].answer[0].valueCoding.code, "LA10420-0")
        self.assertEqual(inst.item[2].item[4].item[0].item[0].answer[0].valueCoding.display, "Niece")
        self.assertEqual(inst.item[2].item[4].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[4].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[4].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[4].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[4].item[0].item[1].answer[0].valueString, "Helen")
        self.assertEqual(inst.item[2].item[4].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[4].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[4].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[4].item[0].item[2].answer[0].valueCoding.code, "LA3-6")
        self.assertEqual(inst.item[2].item[4].item[0].item[2].answer[0].valueCoding.display, "Female")
        self.assertEqual(inst.item[2].item[4].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[4].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[4].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[4].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 15)
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54141-7")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.2.2")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].item[0].item[0].text, "Age")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.2")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].valueCoding.code, "LA33-6")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[4].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[4].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[4].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[4].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[4].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[4].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[4].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[4].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[4].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[4].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[4].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[4].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[4].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[4].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[4].linkId, "2.1")
        self.assertEqual(inst.item[2].item[5].item[0].item[0].answer[0].valueCoding.code, "LA10416-8")
        self.assertEqual(inst.item[2].item[5].item[0].item[0].answer[0].valueCoding.display, "Father")
        self.assertEqual(inst.item[2].item[5].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[5].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[5].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[5].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[5].item[0].item[1].answer[0].valueString, "Donald")
        self.assertEqual(inst.item[2].item[5].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[5].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[5].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[5].item[0].item[2].answer[0].valueCoding.code, "LA2-8")
        self.assertEqual(inst.item[2].item[5].item[0].item[2].answer[0].valueCoding.display, "Male")
        self.assertEqual(inst.item[2].item[5].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[5].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[5].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[5].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 52)
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54141-7")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.2.2")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].item[0].item[0].text, "Age")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.2")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].valueCoding.code, "LA33-6")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[5].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[5].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[5].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[5].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[5].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[5].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[5].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[5].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[5].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[5].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[5].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[5].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[5].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[5].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[5].linkId, "2.1")
        self.assertEqual(inst.item[2].item[6].item[0].item[0].answer[0].valueCoding.code, "LA10425-9")
        self.assertEqual(inst.item[2].item[6].item[0].item[0].answer[0].valueCoding.display, "Paternal Uncle")
        self.assertEqual(inst.item[2].item[6].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[6].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[6].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[6].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[6].item[0].item[1].answer[0].valueString, "Eric")
        self.assertEqual(inst.item[2].item[6].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[6].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[6].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[6].item[0].item[2].answer[0].valueCoding.code, "LA2-8")
        self.assertEqual(inst.item[2].item[6].item[0].item[2].answer[0].valueCoding.display, "Male")
        self.assertEqual(inst.item[2].item[6].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[6].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[6].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[6].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 56)
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54141-7")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.2.2")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].item[0].item[0].text, "Age")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.2")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].valueCoding.code, "LA33-6")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[6].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[6].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[6].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[6].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[6].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[6].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[6].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[6].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[6].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[6].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[6].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[6].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[6].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[6].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[6].linkId, "2.1")
        self.assertEqual(inst.item[2].item[7].item[0].item[0].answer[0].valueCoding.code, "LA10421-8")
        self.assertEqual(inst.item[2].item[7].item[0].item[0].answer[0].valueCoding.display, "Paternal Aunt")
        self.assertEqual(inst.item[2].item[7].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[7].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[7].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[7].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[7].item[0].item[1].answer[0].valueString, "Fiona")
        self.assertEqual(inst.item[2].item[7].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[7].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[7].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[7].item[0].item[2].answer[0].valueCoding.code, "LA3-6")
        self.assertEqual(inst.item[2].item[7].item[0].item[2].answer[0].valueCoding.display, "Female")
        self.assertEqual(inst.item[2].item[7].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[7].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[7].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[7].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].item[0].item[0].answer[0].valueDecimal, 57)
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54141-7")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.2.2")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].item[0].item[0].text, "Age")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.2")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].valueCoding.code, "LA33-6")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].valueCoding.display, "Yes")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[7].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[7].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[7].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[7].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[7].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[7].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[7].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[7].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[7].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[7].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[7].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[7].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[7].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[7].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[7].item[1].item[0].answer[0].valueCoding.code, "LA10543-9")
        self.assertEqual(inst.item[2].item[7].item[1].item[0].answer[0].valueCoding.display, "-- Skin Cancer")
        self.assertEqual(inst.item[2].item[7].item[1].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[7].item[1].item[0].linkId, "2.1.2.1")
        self.assertEqual(inst.item[2].item[7].item[1].item[0].text, "Disease or Condition")
        self.assertEqual(inst.item[2].item[7].item[1].linkId, "2.1.2")
        self.assertEqual(inst.item[2].item[7].item[1].text, "This family member's history of disease")
        self.assertEqual(inst.item[2].item[7].linkId, "2.1")
        self.assertEqual(inst.item[2].item[8].item[0].item[0].answer[0].valueCoding.code, "LA10423-4")
        self.assertEqual(inst.item[2].item[8].item[0].item[0].answer[0].valueCoding.display, "Paternal Grandfather")
        self.assertEqual(inst.item[2].item[8].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[8].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[8].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[8].item[0].item[1].answer[0].valueString, "Bob")
        self.assertEqual(inst.item[2].item[8].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[8].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[8].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[8].item[0].item[2].answer[0].valueCoding.code, "LA2-8")
        self.assertEqual(inst.item[2].item[8].item[0].item[2].answer[0].valueCoding.display, "Male")
        self.assertEqual(inst.item[2].item[8].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[8].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[8].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.code, "LA10537-1")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.display, "-- Colon Cancer")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54112-8")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.1.1")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[0].text, "Cause of Death")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.code, "LA10400-2")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.display, "OVER 60")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54113-6")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].linkId, "2.1.1.4.1.2")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].item[1].text, "Age at Death")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.1")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[8].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[8].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[8].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[8].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[8].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[8].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[8].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[8].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[8].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[8].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[8].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[8].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[8].item[1].item[0].answer[0].valueCoding.code, "LA10537-1")
        self.assertEqual(inst.item[2].item[8].item[1].item[0].answer[0].valueCoding.display, "-- Colon Cancer")
        self.assertEqual(inst.item[2].item[8].item[1].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[1].item[0].linkId, "2.1.2.1")
        self.assertEqual(inst.item[2].item[8].item[1].item[0].text, "Disease or Condition")
        self.assertEqual(inst.item[2].item[8].item[1].item[1].answer[0].valueCoding.code, "LA10400-2")
        self.assertEqual(inst.item[2].item[8].item[1].item[1].answer[0].valueCoding.display, "OVER 60")
        self.assertEqual(inst.item[2].item[8].item[1].item[1].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[8].item[1].item[1].linkId, "2.1.2.2")
        self.assertEqual(inst.item[2].item[8].item[1].item[1].text, "Age at Diagnosis")
        self.assertEqual(inst.item[2].item[8].item[1].linkId, "2.1.2")
        self.assertEqual(inst.item[2].item[8].item[1].text, "This family member's history of disease")
        self.assertEqual(inst.item[2].item[8].linkId, "2.1")
        self.assertEqual(inst.item[2].item[9].item[0].item[0].answer[0].valueCoding.code, "LA10424-2")
        self.assertEqual(inst.item[2].item[9].item[0].item[0].answer[0].valueCoding.display, "Paternal Grandmother")
        self.assertEqual(inst.item[2].item[9].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[9].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54136-7")
        self.assertEqual(inst.item[2].item[9].item[0].item[0].linkId, "2.1.1.1")
        self.assertEqual(inst.item[2].item[9].item[0].item[0].text, "Relationship to you")
        self.assertEqual(inst.item[2].item[9].item[0].item[1].answer[0].valueString, "Claire")
        self.assertEqual(inst.item[2].item[9].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54138-3")
        self.assertEqual(inst.item[2].item[9].item[0].item[1].linkId, "2.1.1.2")
        self.assertEqual(inst.item[2].item[9].item[0].item[1].text, "Name")
        self.assertEqual(inst.item[2].item[9].item[0].item[2].answer[0].valueCoding.code, "LA3-6")
        self.assertEqual(inst.item[2].item[9].item[0].item[2].answer[0].valueCoding.display, "Female")
        self.assertEqual(inst.item[2].item[9].item[0].item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[9].item[0].item[2].definition, "http://loinc.org/fhir/DataElement/54123-5")
        self.assertEqual(inst.item[2].item[9].item[0].item[2].linkId, "2.1.1.3")
        self.assertEqual(inst.item[2].item[9].item[0].item[2].text, "Gender")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].item[0].answer[0].valueString, "Lou Gehrigs")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].item[0].linkId, "2.1.1.4.1.1.1")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].item[0].text, "Please specify")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.code, "LA10589-2")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.display, "-- Other/Unexpected")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].definition, "http://loinc.org/fhir/DataElement/54112-8")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].linkId, "2.1.1.4.1.1")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[0].text, "Cause of Death")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.code, "LA10400-2")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.display, "OVER 60")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].definition, "http://loinc.org/fhir/DataElement/54113-6")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].linkId, "2.1.1.4.1.2")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].item[1].text, "Age at Death")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].item[0].linkId, "2.1.1.4.1")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].definition, "http://loinc.org/fhir/DataElement/54139-1")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].linkId, "2.1.1.4")
        self.assertEqual(inst.item[2].item[9].item[0].item[3].text, "Living?")
        self.assertEqual(inst.item[2].item[9].item[0].item[4].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[9].item[0].item[4].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[9].item[0].item[4].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[9].item[0].item[4].definition, "http://loinc.org/fhir/DataElement/54121-9")
        self.assertEqual(inst.item[2].item[9].item[0].item[4].linkId, "2.1.1.5")
        self.assertEqual(inst.item[2].item[9].item[0].item[4].text, "Was this person born a twin?")
        self.assertEqual(inst.item[2].item[9].item[0].item[5].answer[0].valueCoding.code, "LA32-8")
        self.assertEqual(inst.item[2].item[9].item[0].item[5].answer[0].valueCoding.display, "No")
        self.assertEqual(inst.item[2].item[9].item[0].item[5].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].item[9].item[0].item[5].definition, "http://loinc.org/fhir/DataElement/54122-7")
        self.assertEqual(inst.item[2].item[9].item[0].item[5].linkId, "2.1.1.6")
        self.assertEqual(inst.item[2].item[9].item[0].item[5].text, "Was this person adopted?")
        self.assertEqual(inst.item[2].item[9].item[0].linkId, "2.1.1")
        self.assertEqual(inst.item[2].item[9].linkId, "2.1")
        self.assertEqual(inst.item[2].linkId, "2")
        self.assertEqual(inst.item[2].text, "Family member health information")
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.questionnaire, "Questionnaire/ussg-fht")
        self.assertEqual(inst.status, "in-progress")
        self.assertEqual(inst.text.status, "generated")
    
    def testQuestionnaireResponse3(self):
        inst = self.instantiate_from("questionnaireresponse-example-f201-lifelines.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse3(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse3(inst2)
    
    def implQuestionnaireResponse3(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2013-06-18T00:00:00+01:00").date)
        self.assertEqual(inst.authored.as_json(), "2013-06-18T00:00:00+01:00")
        self.assertEqual(inst.id, "f201")
        self.assertEqual(inst.item[0].item[0].answer[0].valueString, "I am allergic to house dust")
        self.assertEqual(inst.item[0].item[0].linkId, "1.1")
        self.assertEqual(inst.item[0].item[0].text, "Do you have allergies?")
        self.assertEqual(inst.item[0].linkId, "1")
        self.assertEqual(inst.item[1].item[0].answer[0].valueString, "Male")
        self.assertEqual(inst.item[1].item[0].linkId, "2.1")
        self.assertEqual(inst.item[1].item[0].text, "What is your gender?")
        self.assertEqual(inst.item[1].item[1].answer[0].valueDate.date, FHIRDate("1960-03-13").date)
        self.assertEqual(inst.item[1].item[1].answer[0].valueDate.as_json(), "1960-03-13")
        self.assertEqual(inst.item[1].item[1].linkId, "2.2")
        self.assertEqual(inst.item[1].item[1].text, "What is your date of birth?")
        self.assertEqual(inst.item[1].item[2].answer[0].valueString, "The Netherlands")
        self.assertEqual(inst.item[1].item[2].linkId, "2.3")
        self.assertEqual(inst.item[1].item[2].text, "What is your country of birth?")
        self.assertEqual(inst.item[1].item[3].answer[0].valueString, "married")
        self.assertEqual(inst.item[1].item[3].linkId, "2.4")
        self.assertEqual(inst.item[1].item[3].text, "What is your marital status?")
        self.assertEqual(inst.item[1].linkId, "2")
        self.assertEqual(inst.item[1].text, "General questions")
        self.assertEqual(inst.item[2].item[0].answer[0].valueString, "No")
        self.assertEqual(inst.item[2].item[0].linkId, "3.1")
        self.assertEqual(inst.item[2].item[0].text, "Do you smoke?")
        self.assertEqual(inst.item[2].item[1].answer[0].valueString, "No, but I used to drink")
        self.assertEqual(inst.item[2].item[1].linkId, "3.2")
        self.assertEqual(inst.item[2].item[1].text, "Do you drink alchohol?")
        self.assertEqual(inst.item[2].linkId, "3")
        self.assertEqual(inst.item[2].text, "Intoxications")
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.status, "generated")
    
    def testQuestionnaireResponse4(self):
        inst = self.instantiate_from("questionnaireresponse-example-bluebook.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse4(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse4(inst2)
    
    def implQuestionnaireResponse4(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2013-02-19T14:15:00+10:00").date)
        self.assertEqual(inst.authored.as_json(), "2013-02-19T14:15:00+10:00")
        self.assertEqual(inst.id, "bb")
        self.assertEqual(inst.item[0].item[0].item[0].answer[0].valueString, "Cathy Jones")
        self.assertEqual(inst.item[0].item[0].item[0].linkId, "nameOfChild")
        self.assertEqual(inst.item[0].item[0].item[0].text, "Name of child")
        self.assertEqual(inst.item[0].item[0].item[1].answer[0].valueCoding.code, "f")
        self.assertEqual(inst.item[0].item[0].item[1].linkId, "sex")
        self.assertEqual(inst.item[0].item[0].item[1].text, "Sex")
        self.assertEqual(inst.item[0].item[0].linkId, "group")
        self.assertEqual(inst.item[0].item[1].item[0].answer[0].valueDecimal, 3.25)
        self.assertEqual(inst.item[0].item[1].item[0].linkId, "birthWeight")
        self.assertEqual(inst.item[0].item[1].item[0].text, "Birth weight (kg)")
        self.assertEqual(inst.item[0].item[1].item[1].answer[0].valueDecimal, 44.3)
        self.assertEqual(inst.item[0].item[1].item[1].linkId, "birthLength")
        self.assertEqual(inst.item[0].item[1].item[1].text, "Birth length (cm)")
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[0].answer[0].valueDate.date, FHIRDate("1972-11-30").date)
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[0].answer[0].valueDate.as_json(), "1972-11-30")
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[0].linkId, "vitaminKDose1")
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[0].text, "1st dose")
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[1].answer[0].valueDate.date, FHIRDate("1972-12-11").date)
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[1].answer[0].valueDate.as_json(), "1972-12-11")
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[1].linkId, "vitaminKDose2")
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].item[1].text, "2nd dose")
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].item[0].linkId, "vitaminKgivenDoses")
        self.assertEqual(inst.item[0].item[1].item[2].answer[0].valueCoding.code, "INJECTION")
        self.assertEqual(inst.item[0].item[1].item[2].linkId, "vitaminKgiven")
        self.assertEqual(inst.item[0].item[1].item[2].text, "Vitamin K given")
        self.assertEqual(inst.item[0].item[1].item[3].answer[0].item[0].answer[0].valueDate.date, FHIRDate("1972-12-04").date)
        self.assertEqual(inst.item[0].item[1].item[3].answer[0].item[0].answer[0].valueDate.as_json(), "1972-12-04")
        self.assertEqual(inst.item[0].item[1].item[3].answer[0].item[0].linkId, "hepBgivenDate")
        self.assertEqual(inst.item[0].item[1].item[3].answer[0].item[0].text, "Date given")
        self.assertTrue(inst.item[0].item[1].item[3].answer[0].valueBoolean)
        self.assertEqual(inst.item[0].item[1].item[3].linkId, "hepBgiven")
        self.assertEqual(inst.item[0].item[1].item[3].text, "Hep B given y / n")
        self.assertEqual(inst.item[0].item[1].item[4].answer[0].valueString, "Already able to speak Chinese")
        self.assertEqual(inst.item[0].item[1].item[4].linkId, "abnormalitiesAtBirth")
        self.assertEqual(inst.item[0].item[1].item[4].text, "Abnormalities noted at birth")
        self.assertEqual(inst.item[0].item[1].linkId, "neonatalInformation")
        self.assertEqual(inst.item[0].item[1].text, "Neonatal Information")
        self.assertEqual(inst.item[0].linkId, "birthDetails")
        self.assertEqual(inst.item[0].text, "Birth details - To be completed by health professional")
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.status, "generated")
    
    def testQuestionnaireResponse5(self):
        inst = self.instantiate_from("questionnaireresponse-example-gcs.json")
        self.assertIsNotNone(inst, "Must have instantiated a QuestionnaireResponse instance")
        self.implQuestionnaireResponse5(inst)
        
        js = inst.as_json()
        self.assertEqual("QuestionnaireResponse", js["resourceType"])
        inst2 = questionnaireresponse.QuestionnaireResponse(js)
        self.implQuestionnaireResponse5(inst2)
    
    def implQuestionnaireResponse5(self, inst):
        self.assertEqual(inst.authored.date, FHIRDate("2014-12-11T04:44:16Z").date)
        self.assertEqual(inst.authored.as_json(), "2014-12-11T04:44:16Z")
        self.assertEqual(inst.id, "gcs")
        self.assertEqual(inst.item[0].answer[0].valueCoding.code, "LA6560-2")
        self.assertEqual(inst.item[0].answer[0].valueCoding.display, "Confused")
        self.assertEqual(inst.item[0].answer[0].valueCoding.extension[0].url, "http://hl7.org/fhir/StructureDefinition/ordinalValue")
        self.assertEqual(inst.item[0].answer[0].valueCoding.extension[0].valueDecimal, 4)
        self.assertEqual(inst.item[0].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[0].linkId, "1.1")
        self.assertEqual(inst.item[1].answer[0].valueCoding.code, "LA6566-9")
        self.assertEqual(inst.item[1].answer[0].valueCoding.display, "Localizing pain")
        self.assertEqual(inst.item[1].answer[0].valueCoding.extension[0].url, "http://hl7.org/fhir/StructureDefinition/ordinalValue")
        self.assertEqual(inst.item[1].answer[0].valueCoding.extension[0].valueDecimal, 5)
        self.assertEqual(inst.item[1].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[1].linkId, "1.2")
        self.assertEqual(inst.item[2].answer[0].valueCoding.code, "LA6556-0")
        self.assertEqual(inst.item[2].answer[0].valueCoding.display, "Eyes open spontaneously")
        self.assertEqual(inst.item[2].answer[0].valueCoding.extension[0].url, "http://hl7.org/fhir/StructureDefinition/ordinalValue")
        self.assertEqual(inst.item[2].answer[0].valueCoding.extension[0].valueDecimal, 4)
        self.assertEqual(inst.item[2].answer[0].valueCoding.system, "http://loinc.org")
        self.assertEqual(inst.item[2].linkId, "1.3")
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.questionnaire, "Questionnaire/gcs")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.status, "generated")

