#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 4.0.0-a53ec6ee1b on 2019-05-07.
#  2019, SMART Health IT.


import os
import io
import unittest
import json
from . import claim
from .fhirdate import FHIRDate


class ClaimTests(unittest.TestCase):
    def instantiate_from(self, filename):
        datadir = os.environ.get('FHIR_UNITTEST_DATADIR') or ''
        with io.open(os.path.join(datadir, filename), 'r', encoding='utf-8') as handle:
            js = json.load(handle)
            self.assertEqual("Claim", js["resourceType"])
        return claim.Claim(js)
    
    def testClaim1(self):
        inst = self.instantiate_from("claim-example-institutional-rich.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim1(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim1(inst2)
    
    def implClaim1(self, inst):
        self.assertEqual(inst.accident.date.date, FHIRDate("2014-07-09").date)
        self.assertEqual(inst.accident.date.as_json(), "2014-07-09")
        self.assertEqual(inst.accident.locationAddress.text, "Grouse Mountain Ski Hill")
        self.assertEqual(inst.accident.type.coding[0].code, "SPT")
        self.assertEqual(inst.accident.type.coding[0].display, "Sporting Accident")
        self.assertEqual(inst.accident.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActIncidentCode")
        self.assertEqual(inst.billablePeriod.end.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.billablePeriod.end.as_json(), "2014-08-16")
        self.assertEqual(inst.billablePeriod.start.date, FHIRDate("2014-08-15").date)
        self.assertEqual(inst.billablePeriod.start.as_json(), "2014-08-15")
        self.assertEqual(inst.careTeam[0].qualification.coding[0].code, "physician")
        self.assertEqual(inst.careTeam[0].qualification.coding[0].system, "http://example.org/fhir/CodeSystem/provider-qualification")
        self.assertTrue(inst.careTeam[0].responsible)
        self.assertEqual(inst.careTeam[0].role.coding[0].code, "primary")
        self.assertEqual(inst.careTeam[0].role.coding[0].system, "http://example.org/fhir/CodeSystem/claim-careteamrole")
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.created.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.created.as_json(), "2014-08-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "654456")
        self.assertEqual(inst.diagnosis[0].packageCode.coding[0].code, "400")
        self.assertEqual(inst.diagnosis[0].packageCode.coding[0].display, "Head trauma - concussion")
        self.assertEqual(inst.diagnosis[0].packageCode.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.diagnosis[0].type[0].coding[0].code, "admitting")
        self.assertEqual(inst.diagnosis[0].type[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-diagnosistype")
        self.assertEqual(inst.id, "960151")
        self.assertEqual(inst.identifier[0].system, "http://happyhospital.com/claim")
        self.assertEqual(inst.identifier[0].value, "96123451")
        self.assertEqual(inst.insurance[0].businessArrangement, "BA987123")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].preAuthRef[0], "PA2014G56473")
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 125.0)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "exam")
        self.assertEqual(inst.item[0].productOrService.coding[0].system, "http://hl7.org/fhir/ex-serviceproduct")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 125.0)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.supportingInfo[0].category.coding[0].code, "employmentimpacted")
        self.assertEqual(inst.supportingInfo[0].category.coding[0].system, "http://terminology.hl7.org/CodeSystem/claiminformationcategory")
        self.assertEqual(inst.supportingInfo[0].sequence, 1)
        self.assertEqual(inst.supportingInfo[0].timingPeriod.end.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.supportingInfo[0].timingPeriod.end.as_json(), "2014-08-16")
        self.assertEqual(inst.supportingInfo[0].timingPeriod.start.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.supportingInfo[0].timingPeriod.start.as_json(), "2014-08-16")
        self.assertEqual(inst.supportingInfo[1].category.coding[0].code, "hospitalized")
        self.assertEqual(inst.supportingInfo[1].category.coding[0].system, "http://terminology.hl7.org/CodeSystem/claiminformationcategory")
        self.assertEqual(inst.supportingInfo[1].sequence, 2)
        self.assertEqual(inst.supportingInfo[1].timingPeriod.end.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.supportingInfo[1].timingPeriod.end.as_json(), "2014-08-16")
        self.assertEqual(inst.supportingInfo[1].timingPeriod.start.date, FHIRDate("2014-08-15").date)
        self.assertEqual(inst.supportingInfo[1].timingPeriod.start.as_json(), "2014-08-15")
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.total.currency, "USD")
        self.assertEqual(inst.total.value, 125.0)
        self.assertEqual(inst.type.coding[0].code, "institutional")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")
    
    def testClaim2(self):
        inst = self.instantiate_from("claim-example-professional.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim2(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim2(inst2)
    
    def implClaim2(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.created.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.created.as_json(), "2014-08-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "654456")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.id, "860150")
        self.assertEqual(inst.identifier[0].system, "http://happypdocs.com/claim")
        self.assertEqual(inst.identifier[0].value, "8612345")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 75.0)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "exam")
        self.assertEqual(inst.item[0].productOrService.coding[0].system, "http://hl7.org/fhir/ex-serviceproduct")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 75.0)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "professional")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")
    
    def testClaim3(self):
        inst = self.instantiate_from("claim-example.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim3(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim3(inst2)
    
    def implClaim3(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.created.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.created.as_json(), "2014-08-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "123456")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.id, "100150")
        self.assertEqual(inst.identifier[0].system, "http://happyvalley.com/claim")
        self.assertEqual(inst.identifier[0].value, "12345")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].identifier.system, "http://happyvalley.com/claim")
        self.assertEqual(inst.insurance[0].identifier.value, "12345")
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 135.57)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "1200")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 135.57)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Oral Health Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "oral")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")
    
    def testClaim4(self):
        inst = self.instantiate_from("claim-example-vision.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim4(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim4(inst2)
    
    def implClaim4(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.created.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.created.as_json(), "2014-08-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "654321")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.id, "660150")
        self.assertEqual(inst.identifier[0].system, "http://happysight.com/claim")
        self.assertEqual(inst.identifier[0].value, "6612345")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 80.0)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "exam")
        self.assertEqual(inst.item[0].productOrService.coding[0].system, "http://example.org/fhir/CodeSystem/ex-visionservice")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 80.0)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Vision Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "vision")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")
    
    def testClaim5(self):
        inst = self.instantiate_from("claim-example-vision-glasses-3tier.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim5(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim5(inst2)
    
    def implClaim5(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.contained[0].id, "device-frame")
        self.assertEqual(inst.contained[1].id, "device-lens")
        self.assertEqual(inst.created.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.created.as_json(), "2014-08-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "654321")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.id, "660152")
        self.assertEqual(inst.identifier[0].system, "http://happysight.com/claim")
        self.assertEqual(inst.identifier[0].value, "6612347")
        self.assertFalse(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].preAuthRef[0], "PR7652387237")
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertTrue(inst.insurance[1].focal)
        self.assertEqual(inst.insurance[1].preAuthRef[0], "AB543GTD7567")
        self.assertEqual(inst.insurance[1].sequence, 2)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].category.coding[0].code, "F6")
        self.assertEqual(inst.item[0].category.coding[0].display, "Vision Coverage")
        self.assertEqual(inst.item[0].category.coding[0].system, "http://example.org/fhir/CodeSystem/benefit-subcategory")
        self.assertEqual(inst.item[0].detail[0].category.coding[0].code, "F6")
        self.assertEqual(inst.item[0].detail[0].category.coding[0].display, "Vision Coverage")
        self.assertEqual(inst.item[0].detail[0].category.coding[0].system, "http://example.org/fhir/CodeSystem/benefit-subcategory")
        self.assertEqual(inst.item[0].detail[0].factor, 1.1)
        self.assertEqual(inst.item[0].detail[0].modifier[0].coding[0].code, "rooh")
        self.assertEqual(inst.item[0].detail[0].modifier[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/modifiers")
        self.assertEqual(inst.item[0].detail[0].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[0].net.value, 110.0)
        self.assertEqual(inst.item[0].detail[0].productOrService.coding[0].code, "frame")
        self.assertEqual(inst.item[0].detail[0].productOrService.coding[0].system, "http://example.org/fhir/CodeSystem/ex-visionservice")
        self.assertEqual(inst.item[0].detail[0].revenue.coding[0].code, "0010")
        self.assertEqual(inst.item[0].detail[0].revenue.coding[0].display, "Vision Clinic")
        self.assertEqual(inst.item[0].detail[0].revenue.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-revenue-center")
        self.assertEqual(inst.item[0].detail[0].sequence, 1)
        self.assertEqual(inst.item[0].detail[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[0].unitPrice.value, 100.0)
        self.assertEqual(inst.item[0].detail[1].category.coding[0].code, "F6")
        self.assertEqual(inst.item[0].detail[1].category.coding[0].display, "Vision Coverage")
        self.assertEqual(inst.item[0].detail[1].category.coding[0].system, "http://example.org/fhir/CodeSystem/benefit-subcategory")
        self.assertEqual(inst.item[0].detail[1].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].net.value, 110.0)
        self.assertEqual(inst.item[0].detail[1].productOrService.coding[0].code, "lens")
        self.assertEqual(inst.item[0].detail[1].productOrService.coding[0].system, "http://example.org/fhir/CodeSystem/ex-visionservice")
        self.assertEqual(inst.item[0].detail[1].programCode[0].coding[0].code, "none")
        self.assertEqual(inst.item[0].detail[1].programCode[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-programcode")
        self.assertEqual(inst.item[0].detail[1].quantity.value, 2)
        self.assertEqual(inst.item[0].detail[1].revenue.coding[0].code, "0010")
        self.assertEqual(inst.item[0].detail[1].revenue.coding[0].display, "Vision Clinic")
        self.assertEqual(inst.item[0].detail[1].revenue.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-revenue-center")
        self.assertEqual(inst.item[0].detail[1].sequence, 2)
        self.assertEqual(inst.item[0].detail[1].subDetail[0].category.coding[0].code, "F6")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].category.coding[0].display, "Vision Coverage")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].category.coding[0].system, "http://example.org/fhir/CodeSystem/benefit-subcategory")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].factor, 1.1)
        self.assertEqual(inst.item[0].detail[1].subDetail[0].modifier[0].coding[0].code, "rooh")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].modifier[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/modifiers")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].net.value, 66.0)
        self.assertEqual(inst.item[0].detail[1].subDetail[0].productOrService.coding[0].code, "lens")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].productOrService.coding[0].system, "http://example.org/fhir/CodeSystem/ex-visionservice")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].programCode[0].coding[0].code, "none")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].programCode[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-programcode")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].quantity.value, 2)
        self.assertEqual(inst.item[0].detail[1].subDetail[0].revenue.coding[0].code, "0010")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].revenue.coding[0].display, "Vision Clinic")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].revenue.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-revenue-center")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].sequence, 1)
        self.assertEqual(inst.item[0].detail[1].subDetail[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].subDetail[0].unitPrice.value, 30.0)
        self.assertEqual(inst.item[0].detail[1].subDetail[1].category.coding[0].code, "F6")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].category.coding[0].display, "Vision Coverage")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].category.coding[0].system, "http://example.org/fhir/CodeSystem/benefit-subcategory")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].factor, 1.1)
        self.assertEqual(inst.item[0].detail[1].subDetail[1].modifier[0].coding[0].code, "rooh")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].modifier[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/modifiers")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].net.value, 33.0)
        self.assertEqual(inst.item[0].detail[1].subDetail[1].productOrService.coding[0].code, "hardening")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].productOrService.coding[0].system, "http://example.org/fhir/CodeSystem/ex-visionservice")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].quantity.value, 2)
        self.assertEqual(inst.item[0].detail[1].subDetail[1].revenue.coding[0].code, "0010")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].revenue.coding[0].display, "Vision Clinic")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].revenue.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-revenue-center")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].sequence, 2)
        self.assertEqual(inst.item[0].detail[1].subDetail[1].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].subDetail[1].unitPrice.value, 15.0)
        self.assertEqual(inst.item[0].detail[1].subDetail[2].category.coding[0].code, "F6")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].category.coding[0].display, "Vision Coverage")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].category.coding[0].system, "http://example.org/fhir/CodeSystem/benefit-subcategory")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].factor, 1.1)
        self.assertEqual(inst.item[0].detail[1].subDetail[2].modifier[0].coding[0].code, "rooh")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].modifier[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/modifiers")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].net.value, 11.0)
        self.assertEqual(inst.item[0].detail[1].subDetail[2].productOrService.coding[0].code, "UV coating")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].productOrService.coding[0].system, "http://example.org/fhir/CodeSystem/ex-visionservice")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].quantity.value, 2)
        self.assertEqual(inst.item[0].detail[1].subDetail[2].revenue.coding[0].code, "0010")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].revenue.coding[0].display, "Vision Clinic")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].revenue.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-revenue-center")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].sequence, 3)
        self.assertEqual(inst.item[0].detail[1].subDetail[2].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].subDetail[2].unitPrice.value, 5.0)
        self.assertEqual(inst.item[0].detail[1].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].unitPrice.value, 55.0)
        self.assertEqual(inst.item[0].detail[2].category.coding[0].code, "F6")
        self.assertEqual(inst.item[0].detail[2].category.coding[0].display, "Vision Coverage")
        self.assertEqual(inst.item[0].detail[2].category.coding[0].system, "http://example.org/fhir/CodeSystem/benefit-subcategory")
        self.assertEqual(inst.item[0].detail[2].factor, 0.07)
        self.assertEqual(inst.item[0].detail[2].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[2].net.value, 15.4)
        self.assertEqual(inst.item[0].detail[2].productOrService.coding[0].code, "fst")
        self.assertEqual(inst.item[0].detail[2].productOrService.coding[0].system, "http://example.org/fhir/CodeSystem/ex-visionservice")
        self.assertEqual(inst.item[0].detail[2].revenue.coding[0].code, "0010")
        self.assertEqual(inst.item[0].detail[2].revenue.coding[0].display, "Vision Clinic")
        self.assertEqual(inst.item[0].detail[2].revenue.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-revenue-center")
        self.assertEqual(inst.item[0].detail[2].sequence, 3)
        self.assertEqual(inst.item[0].detail[2].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[2].unitPrice.value, 220.0)
        self.assertEqual(inst.item[0].modifier[0].coding[0].code, "rooh")
        self.assertEqual(inst.item[0].modifier[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/modifiers")
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 235.4)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "glasses")
        self.assertEqual(inst.item[0].productOrService.coding[0].system, "http://example.org/fhir/CodeSystem/ex-visionservice")
        self.assertEqual(inst.item[0].programCode[0].coding[0].code, "none")
        self.assertEqual(inst.item[0].programCode[0].coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-programcode")
        self.assertEqual(inst.item[0].revenue.coding[0].code, "0010")
        self.assertEqual(inst.item[0].revenue.coding[0].display, "Vision Clinic")
        self.assertEqual(inst.item[0].revenue.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-revenue-center")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 235.4)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Vision Claim for Glasses</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "vision")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")
    
    def testClaim6(self):
        inst = self.instantiate_from("claim-example-institutional.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim6(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim6(inst2)
    
    def implClaim6(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.created.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.created.as_json(), "2014-08-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "654456")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.id, "960150")
        self.assertEqual(inst.identifier[0].system, "http://happyhospital.com/claim")
        self.assertEqual(inst.identifier[0].value, "9612345")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 125.0)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "exam")
        self.assertEqual(inst.item[0].productOrService.coding[0].system, "http://hl7.org/fhir/ex-serviceproduct")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 125.0)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.procedure[0].date.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.procedure[0].date.as_json(), "2014-08-16")
        self.assertEqual(inst.procedure[0].procedureCodeableConcept.coding[0].code, "SDI9901")
        self.assertEqual(inst.procedure[0].procedureCodeableConcept.text, "Subcutaneous diagnostic implant")
        self.assertEqual(inst.procedure[0].sequence, 1)
        self.assertEqual(inst.procedure[0].type[0].coding[0].code, "primary")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.subType.coding[0].code, "emergency")
        self.assertEqual(inst.subType.coding[0].system, "http://terminology.hl7.org/CodeSystem/ex-claimsubtype")
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.total.currency, "USD")
        self.assertEqual(inst.total.value, 125.0)
        self.assertEqual(inst.type.coding[0].code, "institutional")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")
    
    def testClaim7(self):
        inst = self.instantiate_from("claim-example-oral-contained.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim7(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim7(inst2)
    
    def implClaim7(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.contained[0].id, "org-insurer")
        self.assertEqual(inst.contained[1].id, "org-org")
        self.assertEqual(inst.contained[2].id, "provider-1")
        self.assertEqual(inst.contained[3].id, "patient-1")
        self.assertEqual(inst.contained[4].id, "coverage-1")
        self.assertEqual(inst.created.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.created.as_json(), "2014-08-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "123456")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.id, "100152")
        self.assertEqual(inst.identifier[0].system, "http://happyvalley.com/claim")
        self.assertEqual(inst.identifier[0].value, "12347")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 135.57)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "1200")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 135.57)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Oral Health Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "oral")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")
    
    def testClaim8(self):
        inst = self.instantiate_from("claim-example-pharmacy-medication.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim8(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim8(inst2)
    
    def implClaim8(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.created.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.created.as_json(), "2014-08-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "654456")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.id, "760151")
        self.assertEqual(inst.identifier[0].system, "http://happypharma.com/claim")
        self.assertEqual(inst.identifier[0].value, "7612345")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].detail[0].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[0].net.value, 45.0)
        self.assertEqual(inst.item[0].detail[0].productOrService.coding[0].code, "drugcost")
        self.assertEqual(inst.item[0].detail[0].productOrService.coding[0].system, "http://hl7.org/fhir/ex-pharmaservice")
        self.assertEqual(inst.item[0].detail[0].sequence, 1)
        self.assertEqual(inst.item[0].detail[1].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].net.value, 9.0)
        self.assertEqual(inst.item[0].detail[1].productOrService.coding[0].code, "markup")
        self.assertEqual(inst.item[0].detail[1].productOrService.coding[0].system, "http://hl7.org/fhir/ex-pharmaservice")
        self.assertEqual(inst.item[0].detail[1].sequence, 2)
        self.assertEqual(inst.item[0].detail[2].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[2].net.value, 36.0)
        self.assertEqual(inst.item[0].detail[2].productOrService.coding[0].code, "dispensefee")
        self.assertEqual(inst.item[0].detail[2].productOrService.coding[0].system, "http://hl7.org/fhir/ex-pharmaservice")
        self.assertEqual(inst.item[0].detail[2].sequence, 3)
        self.assertEqual(inst.item[0].informationSequence[0], 1)
        self.assertEqual(inst.item[0].informationSequence[1], 2)
        self.assertEqual(inst.item[0].informationSequence[2], 3)
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 90.0)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "562721")
        self.assertEqual(inst.item[0].productOrService.coding[0].display, "Alprazolam 0.25mg (Xanax)")
        self.assertEqual(inst.item[0].productOrService.coding[0].system, "http://www.nlm.nih.gov/research/umls/rxnorm")
        self.assertEqual(inst.item[0].quantity.code, "TAB")
        self.assertEqual(inst.item[0].quantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.item[0].quantity.unit, "TAB")
        self.assertEqual(inst.item[0].quantity.value, 90)
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "stat")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.supportingInfo[0].category.coding[0].code, "pharmacyrefill")
        self.assertEqual(inst.supportingInfo[0].code.coding[0].code, "new")
        self.assertEqual(inst.supportingInfo[0].code.coding[0].system, "http://example.org/fhir/CodeSystem/pharmacy-refill")
        self.assertEqual(inst.supportingInfo[0].sequence, 1)
        self.assertEqual(inst.supportingInfo[1].category.coding[0].code, "pharmacyinformation")
        self.assertEqual(inst.supportingInfo[1].code.coding[0].code, "refillsremaining")
        self.assertEqual(inst.supportingInfo[1].code.coding[0].system, "http://example.org/fhir/CodeSystem/pharmacy-information")
        self.assertEqual(inst.supportingInfo[1].sequence, 2)
        self.assertEqual(inst.supportingInfo[1].valueQuantity.value, 2)
        self.assertEqual(inst.supportingInfo[2].category.coding[0].code, "pharmacyinformation")
        self.assertEqual(inst.supportingInfo[2].code.coding[0].code, "dayssupply")
        self.assertEqual(inst.supportingInfo[2].code.coding[0].system, "http://example.org/fhir/CodeSystem/pharmacy-information")
        self.assertEqual(inst.supportingInfo[2].sequence, 3)
        self.assertEqual(inst.supportingInfo[2].valueQuantity.value, 90)
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Pharmacy Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.total.currency, "USD")
        self.assertEqual(inst.total.value, 90.0)
        self.assertEqual(inst.type.coding[0].code, "pharmacy")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")
    
    def testClaim9(self):
        inst = self.instantiate_from("claim-example-oral-orthoplan.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim9(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim9(inst2)
    
    def implClaim9(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.created.date, FHIRDate("2015-03-16").date)
        self.assertEqual(inst.created.as_json(), "2015-03-16")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "123457")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].system, "http://hl7.org/fhir/sid/icd-10")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.fundsReserve.coding[0].code, "provider")
        self.assertEqual(inst.id, "100153")
        self.assertEqual(inst.identifier[0].system, "http://happyvalley.com/claim")
        self.assertEqual(inst.identifier[0].value, "12355")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].detail[0].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[0].net.value, 1000.0)
        self.assertEqual(inst.item[0].detail[0].productOrService.coding[0].code, "ORTHOEXAM")
        self.assertEqual(inst.item[0].detail[0].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[0].detail[0].sequence, 1)
        self.assertEqual(inst.item[0].detail[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[0].unitPrice.value, 1000.0)
        self.assertEqual(inst.item[0].detail[1].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].net.value, 1500.0)
        self.assertEqual(inst.item[0].detail[1].productOrService.coding[0].code, "ORTHODIAG")
        self.assertEqual(inst.item[0].detail[1].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[0].detail[1].sequence, 2)
        self.assertEqual(inst.item[0].detail[1].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[1].unitPrice.value, 1500.0)
        self.assertEqual(inst.item[0].detail[2].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[2].net.value, 500.0)
        self.assertEqual(inst.item[0].detail[2].productOrService.coding[0].code, "ORTHOINITIAL")
        self.assertEqual(inst.item[0].detail[2].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[0].detail[2].sequence, 3)
        self.assertEqual(inst.item[0].detail[2].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[2].unitPrice.value, 500.0)
        self.assertEqual(inst.item[0].detail[3].productOrService.coding[0].code, "ORTHOMONTHS")
        self.assertEqual(inst.item[0].detail[3].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[0].detail[3].quantity.value, 24)
        self.assertEqual(inst.item[0].detail[3].sequence, 4)
        self.assertEqual(inst.item[0].detail[4].net.currency, "USD")
        self.assertEqual(inst.item[0].detail[4].net.value, 250.0)
        self.assertEqual(inst.item[0].detail[4].productOrService.coding[0].code, "ORTHOPERIODIC")
        self.assertEqual(inst.item[0].detail[4].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[0].detail[4].quantity.value, 24)
        self.assertEqual(inst.item[0].detail[4].sequence, 5)
        self.assertEqual(inst.item[0].detail[4].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].detail[4].unitPrice.value, 250.0)
        self.assertEqual(inst.item[0].diagnosisSequence[0], 1)
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 9000.0)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "ORTHPLAN")
        self.assertEqual(inst.item[0].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2015-05-16").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2015-05-16")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 9000.0)
        self.assertEqual(inst.item[1].bodySite.coding[0].code, "21")
        self.assertEqual(inst.item[1].bodySite.coding[0].system, "http://fdi.org/fhir/oraltoothcodes")
        self.assertEqual(inst.item[1].careTeamSequence[0], 1)
        self.assertEqual(inst.item[1].net.currency, "USD")
        self.assertEqual(inst.item[1].net.value, 105.0)
        self.assertEqual(inst.item[1].productOrService.coding[0].code, "21211")
        self.assertEqual(inst.item[1].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[1].sequence, 2)
        self.assertEqual(inst.item[1].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[1].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[1].subSite[0].coding[0].code, "L")
        self.assertEqual(inst.item[1].subSite[0].coding[0].system, "http://fdi.org/fhir/oralsurfacecodes")
        self.assertEqual(inst.item[1].unitPrice.currency, "USD")
        self.assertEqual(inst.item[1].unitPrice.value, 105.0)
        self.assertEqual(inst.item[2].bodySite.coding[0].code, "36")
        self.assertEqual(inst.item[2].bodySite.coding[0].system, "http://fdi.org/fhir/oraltoothcodes")
        self.assertEqual(inst.item[2].careTeamSequence[0], 1)
        self.assertEqual(inst.item[2].detail[0].net.currency, "USD")
        self.assertEqual(inst.item[2].detail[0].net.value, 750.0)
        self.assertEqual(inst.item[2].detail[0].productOrService.coding[0].code, "27211")
        self.assertEqual(inst.item[2].detail[0].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[2].detail[0].sequence, 1)
        self.assertEqual(inst.item[2].detail[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[2].detail[0].unitPrice.value, 750.0)
        self.assertEqual(inst.item[2].detail[1].net.currency, "USD")
        self.assertEqual(inst.item[2].detail[1].net.value, 350.0)
        self.assertEqual(inst.item[2].detail[1].productOrService.coding[0].code, "lab")
        self.assertEqual(inst.item[2].detail[1].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[2].detail[1].sequence, 2)
        self.assertEqual(inst.item[2].detail[1].unitPrice.currency, "USD")
        self.assertEqual(inst.item[2].detail[1].unitPrice.value, 350.0)
        self.assertEqual(inst.item[2].net.currency, "USD")
        self.assertEqual(inst.item[2].net.value, 1100.0)
        self.assertEqual(inst.item[2].productOrService.coding[0].code, "27211")
        self.assertEqual(inst.item[2].productOrService.coding[0].system, "http://example.org/fhir/oralservicecodes")
        self.assertEqual(inst.item[2].sequence, 3)
        self.assertEqual(inst.item[2].servicedDate.date, FHIRDate("2014-08-16").date)
        self.assertEqual(inst.item[2].servicedDate.as_json(), "2014-08-16")
        self.assertEqual(inst.item[2].unitPrice.currency, "USD")
        self.assertEqual(inst.item[2].unitPrice.value, 1100.0)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of the Oral Health Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "oral")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "preauthorization")
    
    def testClaim10(self):
        inst = self.instantiate_from("claim-example-cms1500-medical.json")
        self.assertIsNotNone(inst, "Must have instantiated a Claim instance")
        self.implClaim10(inst)
        
        js = inst.as_json()
        self.assertEqual("Claim", js["resourceType"])
        inst2 = claim.Claim(js)
        self.implClaim10(inst2)
    
    def implClaim10(self, inst):
        self.assertEqual(inst.careTeam[0].sequence, 1)
        self.assertEqual(inst.contained[0].id, "patient-1")
        self.assertEqual(inst.contained[1].id, "coverage-1")
        self.assertEqual(inst.created.date, FHIRDate("2015-10-16T00:00:00-07:00").date)
        self.assertEqual(inst.created.as_json(), "2015-10-16T00:00:00-07:00")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].code, "M96.1")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].display, "Postlaminectomy syndrome")
        self.assertEqual(inst.diagnosis[0].diagnosisCodeableConcept.coding[0].system, "http://hl7.org/fhir/sid/icd-10")
        self.assertEqual(inst.diagnosis[0].sequence, 1)
        self.assertEqual(inst.diagnosis[1].diagnosisCodeableConcept.coding[0].code, "G89.4")
        self.assertEqual(inst.diagnosis[1].diagnosisCodeableConcept.coding[0].display, "Chronic pain syndrome")
        self.assertEqual(inst.diagnosis[1].diagnosisCodeableConcept.coding[0].system, "http://hl7.org/fhir/sid/icd-10")
        self.assertEqual(inst.diagnosis[1].sequence, 2)
        self.assertEqual(inst.diagnosis[2].diagnosisCodeableConcept.coding[0].code, "M53.88")
        self.assertEqual(inst.diagnosis[2].diagnosisCodeableConcept.coding[0].display, "Other specified dorsopathies, sacral and sacrococcygeal region")
        self.assertEqual(inst.diagnosis[2].diagnosisCodeableConcept.coding[0].system, "http://hl7.org/fhir/sid/icd-10")
        self.assertEqual(inst.diagnosis[2].sequence, 3)
        self.assertEqual(inst.diagnosis[3].diagnosisCodeableConcept.coding[0].code, "M47.816")
        self.assertEqual(inst.diagnosis[3].diagnosisCodeableConcept.coding[0].display, "Spondylosis without myelopathy or radiculopathy, lumbar region")
        self.assertEqual(inst.diagnosis[3].diagnosisCodeableConcept.coding[0].system, "http://hl7.org/fhir/sid/icd-10")
        self.assertEqual(inst.diagnosis[3].sequence, 4)
        self.assertEqual(inst.id, "MED-00050")
        self.assertEqual(inst.identifier[0].system, "http://CedarArmsMedicalCenter.com/claim")
        self.assertEqual(inst.identifier[0].value, "MED-00050")
        self.assertTrue(inst.insurance[0].focal)
        self.assertEqual(inst.insurance[0].identifier.system, "http://CedarArmsMedicalCenter.com/claim")
        self.assertEqual(inst.insurance[0].identifier.value, "MED-00050")
        self.assertEqual(inst.insurance[0].sequence, 1)
        self.assertEqual(inst.item[0].careTeamSequence[0], 1)
        self.assertEqual(inst.item[0].diagnosisSequence[0], 2)
        self.assertEqual(inst.item[0].diagnosisSequence[1], 4)
        self.assertEqual(inst.item[0].informationSequence[0], 1)
        self.assertEqual(inst.item[0].locationCodeableConcept.coding[0].code, "24")
        self.assertEqual(inst.item[0].locationCodeableConcept.coding[0].display, "Ambulatory Surgical Center")
        self.assertEqual(inst.item[0].locationCodeableConcept.coding[0].system, "https://www.cms.gov/medicare/coding/place-of-service-codes/place_of_service_code_set.html")
        self.assertEqual(inst.item[0].net.currency, "USD")
        self.assertEqual(inst.item[0].net.value, 12500.0)
        self.assertEqual(inst.item[0].productOrService.coding[0].code, "62264")
        self.assertEqual(inst.item[0].productOrService.coding[0].display, "Surgical Procedures on the Spine and Spinal Cord")
        self.assertEqual(inst.item[0].productOrService.coding[0].system, "http://www.ama-assn.org/go/cpt")
        self.assertEqual(inst.item[0].sequence, 1)
        self.assertEqual(inst.item[0].servicedDate.date, FHIRDate("2015-10-13").date)
        self.assertEqual(inst.item[0].servicedDate.as_json(), "2015-10-13")
        self.assertEqual(inst.item[0].unitPrice.currency, "USD")
        self.assertEqual(inst.item[0].unitPrice.value, 12500.0)
        self.assertEqual(inst.meta.tag[0].code, "HTEST")
        self.assertEqual(inst.meta.tag[0].display, "test health data")
        self.assertEqual(inst.meta.tag[0].system, "http://terminology.hl7.org/CodeSystem/v3-ActReason")
        self.assertEqual(inst.payee.type.coding[0].code, "provider")
        self.assertEqual(inst.payee.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/payeetype")
        self.assertEqual(inst.priority.coding[0].code, "normal")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.subType.coding[0].code, "831")
        self.assertEqual(inst.subType.coding[0].system, "https://www.cms.gov/codes/billtype")
        self.assertEqual(inst.supportingInfo[0].category.coding[0].code, "hospitalized")
        self.assertEqual(inst.supportingInfo[0].category.coding[0].system, "http://terminology.hl7.org/CodeSystem/claiminformationcategory")
        self.assertEqual(inst.supportingInfo[0].sequence, 1)
        self.assertEqual(inst.supportingInfo[0].timingPeriod.end.date, FHIRDate("2015-10-05T00:00:00-07:00").date)
        self.assertEqual(inst.supportingInfo[0].timingPeriod.end.as_json(), "2015-10-05T00:00:00-07:00")
        self.assertEqual(inst.supportingInfo[0].timingPeriod.start.date, FHIRDate("2015-10-01T00:00:00-07:00").date)
        self.assertEqual(inst.supportingInfo[0].timingPeriod.start.as_json(), "2015-10-01T00:00:00-07:00")
        self.assertEqual(inst.supportingInfo[1].category.coding[0].code, "discharge")
        self.assertEqual(inst.supportingInfo[1].category.coding[0].system, "http://terminology.hl7.org/CodeSystem/claiminformationcategory")
        self.assertEqual(inst.supportingInfo[1].code.coding[0].code, "01")
        self.assertEqual(inst.supportingInfo[1].code.coding[0].display, "Discharge to Home or Self Care")
        self.assertEqual(inst.supportingInfo[1].code.coding[0].system, "https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/SE0801.pdf")
        self.assertEqual(inst.supportingInfo[1].sequence, 2)
        self.assertEqual(inst.text.div, "<div xmlns=\"http://www.w3.org/1999/xhtml\">A human-readable rendering of a CMS 1500 Claim</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.total.currency, "USD")
        self.assertEqual(inst.total.value, 12500.0)
        self.assertEqual(inst.type.coding[0].code, "institutional")
        self.assertEqual(inst.type.coding[0].system, "http://terminology.hl7.org/CodeSystem/claim-type")
        self.assertEqual(inst.use, "claim")

