"""
    Veeroute.LSS Routing

    Veeroute.LSS Routing API  # noqa: E501

    The version of the OpenAPI document: 3.7.167066
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_routing.api_client import ApiClient, Endpoint as _Endpoint
from vrt_lss_routing.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrt_lss_routing.model.inline_response400 import InlineResponse400
from vrt_lss_routing.model.inline_response401 import InlineResponse401
from vrt_lss_routing.model.inline_response404 import InlineResponse404
from vrt_lss_routing.model.inline_response406 import InlineResponse406
from vrt_lss_routing.model.inline_response415 import InlineResponse415
from vrt_lss_routing.model.inline_response429 import InlineResponse429
from vrt_lss_routing.model.inline_response500 import InlineResponse500
from vrt_lss_routing.model.inline_response501 import InlineResponse501
from vrt_lss_routing.model.inline_response502 import InlineResponse502
from vrt_lss_routing.model.inline_response503 import InlineResponse503
from vrt_lss_routing.model.inline_response504 import InlineResponse504
from vrt_lss_routing.model.inline_response_default import InlineResponseDefault
from vrt_lss_routing.model.matrix_result import MatrixResult
from vrt_lss_routing.model.matrix_task import MatrixTask


class MatrixApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __build_matrix(
            self,
            matrix_task,
            **kwargs
        ):
            """Creating a time-distance matrix.  # noqa: E501

            Creating time-distance matrices between each pair of locations.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.build_matrix(matrix_task, async_req=True)
            >>> result = thread.get()

            Args:
                matrix_task (MatrixTask): New request for matrix calculation.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MatrixResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['matrix_task'] = \
                matrix_task
            return self.call_with_http_info(**kwargs)

        self.build_matrix = _Endpoint(
            settings={
                'response_type': (MatrixResult,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/routing/matrix',
                'operation_id': 'build_matrix',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'matrix_task',
                ],
                'required': [
                    'matrix_task',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'matrix_task':
                        (MatrixTask,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'matrix_task': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__build_matrix
        )
