"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DummyTaskDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
class DummyTaskDefinition extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        this.executionRole = new aws_iam_1.Role(this, 'ExecutionRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('ecs-tasks.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonECSTaskExecutionRolePolicy')],
        });
        this.family = (_b = props.family) !== null && _b !== void 0 ? _b : this.node.addr;
        this.containerName = (_c = props.containerName) !== null && _c !== void 0 ? _c : 'sample-website';
        this.containerPort = (_d = props.containerPort) !== null && _d !== void 0 ? _d : 80;
        const registerTaskDefinition = {
            service: 'ECS',
            action: 'registerTaskDefinition',
            parameters: {
                requiresCompatibilities: ['FARGATE'],
                family: this.family,
                executionRoleArn: this.executionRole.roleArn,
                networkMode: aws_ecs_1.NetworkMode.AWS_VPC,
                cpu: '256',
                memory: '512',
                containerDefinitions: [
                    {
                        name: this.containerName,
                        image: props.image,
                        portMappings: [
                            {
                                hostPort: this.containerPort,
                                protocol: 'tcp',
                                containerPort: this.containerPort,
                            },
                        ],
                    },
                ],
            },
            physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse('taskDefinition.taskDefinitionArn'),
        };
        const deregisterTaskDefinition = {
            service: 'ECS',
            action: 'deregisterTaskDefinition',
            parameters: {
                taskDefinition: new custom_resources_1.PhysicalResourceIdReference(),
            },
        };
        const taskDefinition = new custom_resources_1.AwsCustomResource(this, 'DummyTaskDefinition', {
            resourceType: 'Custom::DummyTaskDefinition',
            onCreate: registerTaskDefinition,
            onUpdate: registerTaskDefinition,
            onDelete: deregisterTaskDefinition,
            policy: custom_resources_1.AwsCustomResourcePolicy.fromStatements([
                new aws_iam_1.PolicyStatement({
                    effect: aws_iam_1.Effect.ALLOW,
                    actions: ['ecs:RegisterTaskDefinition', 'ecs:DeregisterTaskDefinition'],
                    resources: ['*'],
                }),
                new aws_iam_1.PolicyStatement({
                    effect: aws_iam_1.Effect.ALLOW,
                    actions: ['iam:PassRole'],
                    resources: [this.executionRole.roleArn],
                }),
            ]),
        });
        this.taskDefinitionArn = taskDefinition.getResponseField('taskDefinition.taskDefinitionArn');
    }
    /**
     * Adds a policy statement to the task execution IAM role.
     */
    addToExecutionRolePolicy(statement) {
        this.executionRole.addToPrincipalPolicy(statement);
    }
}
exports.DummyTaskDefinition = DummyTaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
DummyTaskDefinition[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.DummyTaskDefinition", version: "1.47.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHVtbXktdGFzay1kZWZpbml0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2R1bW15LXRhc2stZGVmaW5pdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDhDQUErQztBQUMvQyw4Q0FBeUc7QUFDekcsd0NBQTBDO0FBQzFDLGdFQUFvSjtBQTJCcEosTUFBYSxtQkFBb0IsU0FBUSxnQkFBUztJQVdoRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQStCOztRQUN2RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxjQUFJLENBQUMsSUFBSSxFQUFFLGVBQWUsRUFBRTtZQUNuRCxTQUFTLEVBQUUsSUFBSSwwQkFBZ0IsQ0FBQyx5QkFBeUIsQ0FBQztZQUMxRCxlQUFlLEVBQUUsQ0FBQyx1QkFBYSxDQUFDLHdCQUF3QixDQUFDLCtDQUErQyxDQUFDLENBQUM7U0FDM0csQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLE1BQU0sU0FBRyxLQUFLLENBQUMsTUFBTSxtQ0FBSSxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztRQUM3QyxJQUFJLENBQUMsYUFBYSxTQUFHLEtBQUssQ0FBQyxhQUFhLG1DQUFJLGdCQUFnQixDQUFDO1FBQzdELElBQUksQ0FBQyxhQUFhLFNBQUcsS0FBSyxDQUFDLGFBQWEsbUNBQUksRUFBRSxDQUFDO1FBRS9DLE1BQU0sc0JBQXNCLEdBQWU7WUFDekMsT0FBTyxFQUFFLEtBQUs7WUFDZCxNQUFNLEVBQUUsd0JBQXdCO1lBQ2hDLFVBQVUsRUFBRTtnQkFDVix1QkFBdUIsRUFBRSxDQUFDLFNBQVMsQ0FBQztnQkFDcEMsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2dCQUNuQixnQkFBZ0IsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU87Z0JBQzVDLFdBQVcsRUFBRSxxQkFBVyxDQUFDLE9BQU87Z0JBQ2hDLEdBQUcsRUFBRSxLQUFLO2dCQUNWLE1BQU0sRUFBRSxLQUFLO2dCQUNiLG9CQUFvQixFQUFFO29CQUNwQjt3QkFDRSxJQUFJLEVBQUUsSUFBSSxDQUFDLGFBQWE7d0JBQ3hCLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSzt3QkFDbEIsWUFBWSxFQUFFOzRCQUNaO2dDQUNFLFFBQVEsRUFBRSxJQUFJLENBQUMsYUFBYTtnQ0FDNUIsUUFBUSxFQUFFLEtBQUs7Z0NBQ2YsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhOzZCQUNsQzt5QkFDRjtxQkFDRjtpQkFDRjthQUNGO1lBQ0Qsa0JBQWtCLEVBQUUscUNBQWtCLENBQUMsWUFBWSxDQUFDLGtDQUFrQyxDQUFDO1NBQ3hGLENBQUM7UUFFRixNQUFNLHdCQUF3QixHQUFlO1lBQzNDLE9BQU8sRUFBRSxLQUFLO1lBQ2QsTUFBTSxFQUFFLDBCQUEwQjtZQUNsQyxVQUFVLEVBQUU7Z0JBQ1YsY0FBYyxFQUFFLElBQUksOENBQTJCLEVBQUU7YUFDbEQ7U0FDRixDQUFDO1FBRUYsTUFBTSxjQUFjLEdBQUcsSUFBSSxvQ0FBaUIsQ0FBQyxJQUFJLEVBQUUscUJBQXFCLEVBQUU7WUFDeEUsWUFBWSxFQUFFLDZCQUE2QjtZQUMzQyxRQUFRLEVBQUUsc0JBQXNCO1lBQ2hDLFFBQVEsRUFBRSxzQkFBc0I7WUFDaEMsUUFBUSxFQUFFLHdCQUF3QjtZQUNsQyxNQUFNLEVBQUUsMENBQXVCLENBQUMsY0FBYyxDQUFDO2dCQUM3QyxJQUFJLHlCQUFlLENBQUM7b0JBQ2xCLE1BQU0sRUFBRSxnQkFBTSxDQUFDLEtBQUs7b0JBQ3BCLE9BQU8sRUFBRSxDQUFDLDRCQUE0QixFQUFFLDhCQUE4QixDQUFDO29CQUN2RSxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7aUJBQ2pCLENBQUM7Z0JBQ0YsSUFBSSx5QkFBZSxDQUFDO29CQUNsQixNQUFNLEVBQUUsZ0JBQU0sQ0FBQyxLQUFLO29CQUNwQixPQUFPLEVBQUUsQ0FBQyxjQUFjLENBQUM7b0JBQ3pCLFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDO2lCQUN4QyxDQUFDO2FBQ0gsQ0FBQztTQUNILENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxpQkFBaUIsR0FBRyxjQUFjLENBQUMsZ0JBQWdCLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUMvRixDQUFDOzs7O0lBR00sd0JBQXdCLENBQUMsU0FBMEI7UUFDeEQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyRCxDQUFDOztBQW5GSCxrREFvRkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBOZXR3b3JrTW9kZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1lY3MnO1xuaW1wb3J0IHsgUm9sZSwgU2VydmljZVByaW5jaXBhbCwgTWFuYWdlZFBvbGljeSwgUG9saWN5U3RhdGVtZW50LCBFZmZlY3QsIElSb2xlIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEF3c0N1c3RvbVJlc291cmNlLCBBd3NDdXN0b21SZXNvdXJjZVBvbGljeSwgQXdzU2RrQ2FsbCwgUGh5c2ljYWxSZXNvdXJjZUlkLCBQaHlzaWNhbFJlc291cmNlSWRSZWZlcmVuY2UgfSBmcm9tICdAYXdzLWNkay9jdXN0b20tcmVzb3VyY2VzJztcblxuZXhwb3J0IGludGVyZmFjZSBJRHVtbXlUYXNrRGVmaW5pdGlvbiB7XG4gIHJlYWRvbmx5IGV4ZWN1dGlvblJvbGU6IElSb2xlO1xuXG4gIHJlYWRvbmx5IGZhbWlseTogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IHRhc2tEZWZpbml0aW9uQXJuOiBzdHJpbmc7XG5cbiAgcmVhZG9ubHkgY29udGFpbmVyTmFtZTogc3RyaW5nO1xuXG4gIHJlYWRvbmx5IGNvbnRhaW5lclBvcnQ6IG51bWJlcjtcbn1cbmV4cG9ydCBpbnRlcmZhY2UgRHVtbXlUYXNrRGVmaW5pdGlvblByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGZhbWlseT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaW1hZ2U6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb250YWluZXJOYW1lPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvbnRhaW5lclBvcnQ/OiBudW1iZXI7XG59XG5cbmV4cG9ydCBjbGFzcyBEdW1teVRhc2tEZWZpbml0aW9uIGV4dGVuZHMgQ29uc3RydWN0IGltcGxlbWVudHMgSUR1bW15VGFza0RlZmluaXRpb24ge1xuICBwdWJsaWMgcmVhZG9ubHkgZXhlY3V0aW9uUm9sZTogSVJvbGU7XG5cbiAgcHVibGljIHJlYWRvbmx5IGZhbWlseTogc3RyaW5nO1xuXG4gIHB1YmxpYyByZWFkb25seSB0YXNrRGVmaW5pdGlvbkFybjogc3RyaW5nO1xuXG4gIHB1YmxpYyByZWFkb25seSBjb250YWluZXJOYW1lOiBzdHJpbmc7XG5cbiAgcHVibGljIHJlYWRvbmx5IGNvbnRhaW5lclBvcnQ6IG51bWJlcjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRHVtbXlUYXNrRGVmaW5pdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuZXhlY3V0aW9uUm9sZSA9IG5ldyBSb2xlKHRoaXMsICdFeGVjdXRpb25Sb2xlJywge1xuICAgICAgYXNzdW1lZEJ5OiBuZXcgU2VydmljZVByaW5jaXBhbCgnZWNzLXRhc2tzLmFtYXpvbmF3cy5jb20nKSxcbiAgICAgIG1hbmFnZWRQb2xpY2llczogW01hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKCdzZXJ2aWNlLXJvbGUvQW1hem9uRUNTVGFza0V4ZWN1dGlvblJvbGVQb2xpY3knKV0sXG4gICAgfSk7XG5cbiAgICB0aGlzLmZhbWlseSA9IHByb3BzLmZhbWlseSA/PyB0aGlzLm5vZGUuYWRkcjtcbiAgICB0aGlzLmNvbnRhaW5lck5hbWUgPSBwcm9wcy5jb250YWluZXJOYW1lID8/ICdzYW1wbGUtd2Vic2l0ZSc7XG4gICAgdGhpcy5jb250YWluZXJQb3J0ID0gcHJvcHMuY29udGFpbmVyUG9ydCA/PyA4MDtcblxuICAgIGNvbnN0IHJlZ2lzdGVyVGFza0RlZmluaXRpb246IEF3c1Nka0NhbGwgPSB7XG4gICAgICBzZXJ2aWNlOiAnRUNTJyxcbiAgICAgIGFjdGlvbjogJ3JlZ2lzdGVyVGFza0RlZmluaXRpb24nLFxuICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICByZXF1aXJlc0NvbXBhdGliaWxpdGllczogWydGQVJHQVRFJ10sXG4gICAgICAgIGZhbWlseTogdGhpcy5mYW1pbHksXG4gICAgICAgIGV4ZWN1dGlvblJvbGVBcm46IHRoaXMuZXhlY3V0aW9uUm9sZS5yb2xlQXJuLFxuICAgICAgICBuZXR3b3JrTW9kZTogTmV0d29ya01vZGUuQVdTX1ZQQyxcbiAgICAgICAgY3B1OiAnMjU2JyxcbiAgICAgICAgbWVtb3J5OiAnNTEyJyxcbiAgICAgICAgY29udGFpbmVyRGVmaW5pdGlvbnM6IFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICBuYW1lOiB0aGlzLmNvbnRhaW5lck5hbWUsXG4gICAgICAgICAgICBpbWFnZTogcHJvcHMuaW1hZ2UsXG4gICAgICAgICAgICBwb3J0TWFwcGluZ3M6IFtcbiAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIGhvc3RQb3J0OiB0aGlzLmNvbnRhaW5lclBvcnQsXG4gICAgICAgICAgICAgICAgcHJvdG9jb2w6ICd0Y3AnLFxuICAgICAgICAgICAgICAgIGNvbnRhaW5lclBvcnQ6IHRoaXMuY29udGFpbmVyUG9ydCxcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIF0sXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgICBwaHlzaWNhbFJlc291cmNlSWQ6IFBoeXNpY2FsUmVzb3VyY2VJZC5mcm9tUmVzcG9uc2UoJ3Rhc2tEZWZpbml0aW9uLnRhc2tEZWZpbml0aW9uQXJuJyksXG4gICAgfTtcblxuICAgIGNvbnN0IGRlcmVnaXN0ZXJUYXNrRGVmaW5pdGlvbjogQXdzU2RrQ2FsbCA9IHtcbiAgICAgIHNlcnZpY2U6ICdFQ1MnLFxuICAgICAgYWN0aW9uOiAnZGVyZWdpc3RlclRhc2tEZWZpbml0aW9uJyxcbiAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgdGFza0RlZmluaXRpb246IG5ldyBQaHlzaWNhbFJlc291cmNlSWRSZWZlcmVuY2UoKSxcbiAgICAgIH0sXG4gICAgfTtcblxuICAgIGNvbnN0IHRhc2tEZWZpbml0aW9uID0gbmV3IEF3c0N1c3RvbVJlc291cmNlKHRoaXMsICdEdW1teVRhc2tEZWZpbml0aW9uJywge1xuICAgICAgcmVzb3VyY2VUeXBlOiAnQ3VzdG9tOjpEdW1teVRhc2tEZWZpbml0aW9uJyxcbiAgICAgIG9uQ3JlYXRlOiByZWdpc3RlclRhc2tEZWZpbml0aW9uLFxuICAgICAgb25VcGRhdGU6IHJlZ2lzdGVyVGFza0RlZmluaXRpb24sXG4gICAgICBvbkRlbGV0ZTogZGVyZWdpc3RlclRhc2tEZWZpbml0aW9uLFxuICAgICAgcG9saWN5OiBBd3NDdXN0b21SZXNvdXJjZVBvbGljeS5mcm9tU3RhdGVtZW50cyhbXG4gICAgICAgIG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgIGVmZmVjdDogRWZmZWN0LkFMTE9XLFxuICAgICAgICAgIGFjdGlvbnM6IFsnZWNzOlJlZ2lzdGVyVGFza0RlZmluaXRpb24nLCAnZWNzOkRlcmVnaXN0ZXJUYXNrRGVmaW5pdGlvbiddLFxuICAgICAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICAgIH0pLFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgICBhY3Rpb25zOiBbJ2lhbTpQYXNzUm9sZSddLFxuICAgICAgICAgIHJlc291cmNlczogW3RoaXMuZXhlY3V0aW9uUm9sZS5yb2xlQXJuXSxcbiAgICAgICAgfSksXG4gICAgICBdKSxcbiAgICB9KTtcblxuICAgIHRoaXMudGFza0RlZmluaXRpb25Bcm4gPSB0YXNrRGVmaW5pdGlvbi5nZXRSZXNwb25zZUZpZWxkKCd0YXNrRGVmaW5pdGlvbi50YXNrRGVmaW5pdGlvbkFybicpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkVG9FeGVjdXRpb25Sb2xlUG9saWN5KHN0YXRlbWVudDogUG9saWN5U3RhdGVtZW50KTogdm9pZCB7XG4gICAgdGhpcy5leGVjdXRpb25Sb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KHN0YXRlbWVudCk7XG4gIH1cbn1cbiJdfQ==