# coding: utf-8

"""
    Datový konektor Domino pro eSMLOUVY

    Toto je datový konektor umožňující datovou výměnu mezi obchodní logikou aplikace eSMLOUVY a datovým serverem HCL Domino.  Ovládá se pomocí REST API   # noqa: E501

    OpenAPI spec version: 1.1.1
    Contact: info@sysnet.cz
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class DocumentAttachmentEntry(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'title': 'str',
        'creator': 'str',
        'date_uploaded': 'datetime',
        'attachment_type': 'str',
        'attachment_subtype': 'str',
        'mime_type': 'str',
        'size': 'int',
        'container_id': 'str',
        'document_id': 'str',
        'identifier': 'str',
        'system_authors': 'list[str]',
        'system_readers': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'title': 'title',
        'creator': 'creator',
        'date_uploaded': 'date_uploaded',
        'attachment_type': 'attachment_type',
        'attachment_subtype': 'attachment_subtype',
        'mime_type': 'mime_type',
        'size': 'size',
        'container_id': 'container_id',
        'document_id': 'document_id',
        'identifier': 'identifier',
        'system_authors': 'system_authors',
        'system_readers': 'system_readers'
    }

    def __init__(self, name=None, title=None, creator=None, date_uploaded=None, attachment_type=None, attachment_subtype=None, mime_type=None, size=None, container_id=None, document_id=None, identifier=None, system_authors=None, system_readers=None):  # noqa: E501
        """DocumentAttachmentEntry - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._title = None
        self._creator = None
        self._date_uploaded = None
        self._attachment_type = None
        self._attachment_subtype = None
        self._mime_type = None
        self._size = None
        self._container_id = None
        self._document_id = None
        self._identifier = None
        self._system_authors = None
        self._system_readers = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if title is not None:
            self.title = title
        if creator is not None:
            self.creator = creator
        if date_uploaded is not None:
            self.date_uploaded = date_uploaded
        if attachment_type is not None:
            self.attachment_type = attachment_type
        if attachment_subtype is not None:
            self.attachment_subtype = attachment_subtype
        if mime_type is not None:
            self.mime_type = mime_type
        if size is not None:
            self.size = size
        if container_id is not None:
            self.container_id = container_id
        if document_id is not None:
            self.document_id = document_id
        if identifier is not None:
            self.identifier = identifier
        if system_authors is not None:
            self.system_authors = system_authors
        if system_readers is not None:
            self.system_readers = system_readers

    @property
    def name(self):
        """Gets the name of this DocumentAttachmentEntry.  # noqa: E501

        Attachment name for display  # noqa: E501

        :return: The name of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DocumentAttachmentEntry.

        Attachment name for display  # noqa: E501

        :param name: The name of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def title(self):
        """Gets the title of this DocumentAttachmentEntry.  # noqa: E501

        Attachment title for display  # noqa: E501

        :return: The title of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this DocumentAttachmentEntry.

        Attachment title for display  # noqa: E501

        :param title: The title of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def creator(self):
        """Gets the creator of this DocumentAttachmentEntry.  # noqa: E501

        Osoba, která uploadovala přílohu  # noqa: E501

        :return: The creator of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this DocumentAttachmentEntry.

        Osoba, která uploadovala přílohu  # noqa: E501

        :param creator: The creator of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._creator = creator

    @property
    def date_uploaded(self):
        """Gets the date_uploaded of this DocumentAttachmentEntry.  # noqa: E501

        Datum uploadu přílohy  # noqa: E501

        :return: The date_uploaded of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: datetime
        """
        return self._date_uploaded

    @date_uploaded.setter
    def date_uploaded(self, date_uploaded):
        """Sets the date_uploaded of this DocumentAttachmentEntry.

        Datum uploadu přílohy  # noqa: E501

        :param date_uploaded: The date_uploaded of this DocumentAttachmentEntry.  # noqa: E501
        :type: datetime
        """

        self._date_uploaded = date_uploaded

    @property
    def attachment_type(self):
        """Gets the attachment_type of this DocumentAttachmentEntry.  # noqa: E501

        Typ přílohy - z číselníku typů  # noqa: E501

        :return: The attachment_type of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._attachment_type

    @attachment_type.setter
    def attachment_type(self, attachment_type):
        """Sets the attachment_type of this DocumentAttachmentEntry.

        Typ přílohy - z číselníku typů  # noqa: E501

        :param attachment_type: The attachment_type of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._attachment_type = attachment_type

    @property
    def attachment_subtype(self):
        """Gets the attachment_subtype of this DocumentAttachmentEntry.  # noqa: E501

        Typ přílohy - z číselníku typů  # noqa: E501

        :return: The attachment_subtype of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._attachment_subtype

    @attachment_subtype.setter
    def attachment_subtype(self, attachment_subtype):
        """Sets the attachment_subtype of this DocumentAttachmentEntry.

        Typ přílohy - z číselníku typů  # noqa: E501

        :param attachment_subtype: The attachment_subtype of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._attachment_subtype = attachment_subtype

    @property
    def mime_type(self):
        """Gets the mime_type of this DocumentAttachmentEntry.  # noqa: E501

        Attachment mime type  # noqa: E501

        :return: The mime_type of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """Sets the mime_type of this DocumentAttachmentEntry.

        Attachment mime type  # noqa: E501

        :param mime_type: The mime_type of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._mime_type = mime_type

    @property
    def size(self):
        """Gets the size of this DocumentAttachmentEntry.  # noqa: E501

        File size  # noqa: E501

        :return: The size of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this DocumentAttachmentEntry.

        File size  # noqa: E501

        :param size: The size of this DocumentAttachmentEntry.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def container_id(self):
        """Gets the container_id of this DocumentAttachmentEntry.  # noqa: E501

        Container unique identifier  # noqa: E501

        :return: The container_id of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this DocumentAttachmentEntry.

        Container unique identifier  # noqa: E501

        :param container_id: The container_id of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._container_id = container_id

    @property
    def document_id(self):
        """Gets the document_id of this DocumentAttachmentEntry.  # noqa: E501

        Source document unique identifier  # noqa: E501

        :return: The document_id of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """Sets the document_id of this DocumentAttachmentEntry.

        Source document unique identifier  # noqa: E501

        :param document_id: The document_id of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._document_id = document_id

    @property
    def identifier(self):
        """Gets the identifier of this DocumentAttachmentEntry.  # noqa: E501

        Attachment unique identifier  # noqa: E501

        :return: The identifier of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this DocumentAttachmentEntry.

        Attachment unique identifier  # noqa: E501

        :param identifier: The identifier of this DocumentAttachmentEntry.  # noqa: E501
        :type: str
        """

        self._identifier = identifier

    @property
    def system_authors(self):
        """Gets the system_authors of this DocumentAttachmentEntry.  # noqa: E501

        SystemAuthors  - seznam osob a útvarů oprávněných zapisovat do dokumentu  # noqa: E501

        :return: The system_authors of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: list[str]
        """
        return self._system_authors

    @system_authors.setter
    def system_authors(self, system_authors):
        """Sets the system_authors of this DocumentAttachmentEntry.

        SystemAuthors  - seznam osob a útvarů oprávněných zapisovat do dokumentu  # noqa: E501

        :param system_authors: The system_authors of this DocumentAttachmentEntry.  # noqa: E501
        :type: list[str]
        """

        self._system_authors = system_authors

    @property
    def system_readers(self):
        """Gets the system_readers of this DocumentAttachmentEntry.  # noqa: E501

        SystemReaders - seznam osob a útvarů číst dokument  # noqa: E501

        :return: The system_readers of this DocumentAttachmentEntry.  # noqa: E501
        :rtype: list[str]
        """
        return self._system_readers

    @system_readers.setter
    def system_readers(self, system_readers):
        """Sets the system_readers of this DocumentAttachmentEntry.

        SystemReaders - seznam osob a útvarů číst dokument  # noqa: E501

        :param system_readers: The system_readers of this DocumentAttachmentEntry.  # noqa: E501
        :type: list[str]
        """

        self._system_readers = system_readers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DocumentAttachmentEntry, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DocumentAttachmentEntry):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
