"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
test('BillingAlarm is created', () => {
    // GIVEN
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'TestStack');
    // WHEN
    new lib_1.BillingAlarm(stack, 'MyBillingAlarmConstruct', {
        monthlyThreshold: 50,
        email: 'admin@example.com',
    });
    // THEN
    assert_1.expect(stack).to(assert_1.countResources('AWS::SNS::Topic', 1));
    assert_1.expect(stack).to(assert_1.haveResource('AWS::SNS::Topic', {
        TopicName: 'BillingAlarmNotificationTopic',
    }));
    assert_1.expect(stack).to(assert_1.countResources('AWS::SNS::Subscription', 1));
    assert_1.expect(stack).to(assert_1.haveResource('AWS::SNS::Subscription', {
        Protocol: 'email-json',
        TopicArn: {
            Ref: 'MyBillingAlarmConstructBillingAlarmNotificationTopicEFAE92EB',
        },
        Endpoint: 'admin@example.com',
    }));
    assert_1.expect(stack).to(assert_1.countResources('AWS::CloudWatch::Alarm', 1));
    assert_1.expect(stack).to(assert_1.haveResource('AWS::CloudWatch::Alarm', {
        ComparisonOperator: 'GreaterThanOrEqualToThreshold',
        EvaluationPeriods: 1,
        AlarmActions: [
            {
                Ref: 'MyBillingAlarmConstructBillingAlarmNotificationTopicEFAE92EB',
            },
        ],
        AlarmDescription: 'Upper monthly billing cost limit',
        MetricName: 'EstimatedCharges',
        Namespace: 'AWS/Billing',
        Period: 32400,
        Statistic: 'Maximum',
        Threshold: 50,
    }));
});
test('BillingAlarm is created with non-round threshold', () => {
    // GIVEN
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'TestStack');
    // WHEN
    new lib_1.BillingAlarm(stack, 'MyBillingAlarmConstruct', {
        monthlyThreshold: 50.50,
        email: 'admin@example.com',
    });
    // THEN
    assert_1.expect(stack).to(assert_1.countResources('AWS::SNS::Topic', 1));
    assert_1.expect(stack).to(assert_1.countResources('AWS::SNS::Subscription', 1));
    assert_1.expect(stack).to(assert_1.countResources('AWS::CloudWatch::Alarm', 1));
    assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CloudWatch::Alarm', {
        Threshold: 50.5,
    }));
});
test('BillingAlarm construct holds a metric that has USD currency as dimension', () => {
    // GIVEN
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'TestStack');
    // WHEN
    new lib_1.BillingAlarm(stack, 'MyBillingAlarmConstruct', {
        monthlyThreshold: 50,
        email: 'admin@example.com',
    });
    // THEN
    assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CloudWatch::Alarm', {
        Dimensions: [
            {
                Name: 'Currency',
                Value: 'USD',
            },
        ],
    }));
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmlsbGluZy1hbGFybS50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYmlsbGluZy1hbGFybS50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNENBRXlCO0FBQ3pCLHFDQUFxQztBQUNyQyxnQ0FBc0M7QUFFdEMsSUFBSSxDQUFDLHlCQUF5QixFQUFFLEdBQUcsRUFBRTtJQUNuQyxRQUFRO0lBQ1IsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7SUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxXQUFXLENBQUMsQ0FBQztJQUU5QyxPQUFPO0lBQ1AsSUFBSSxrQkFBWSxDQUFDLEtBQUssRUFBRSx5QkFBeUIsRUFBRTtRQUNqRCxnQkFBZ0IsRUFBRSxFQUFFO1FBQ3BCLEtBQUssRUFBRSxtQkFBbUI7S0FDM0IsQ0FBQyxDQUFDO0lBRUgsT0FBTztJQUNQLGVBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsdUJBQWMsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzFELGVBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMscUJBQVksQ0FBQyxpQkFBaUIsRUFBRTtRQUNsRCxTQUFTLEVBQUUsK0JBQStCO0tBQzNDLENBQUMsQ0FBQyxDQUFDO0lBRUosZUFBUyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyx1QkFBYyxDQUFDLHdCQUF3QixFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDakUsZUFBUyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxxQkFBWSxDQUFDLHdCQUF3QixFQUFFO1FBQ3pELFFBQVEsRUFBRSxZQUFZO1FBQ3RCLFFBQVEsRUFBRTtZQUNSLEdBQUcsRUFBRSw4REFBOEQ7U0FDcEU7UUFDRCxRQUFRLEVBQUUsbUJBQW1CO0tBQzlCLENBQUMsQ0FBQyxDQUFDO0lBRUosZUFBUyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyx1QkFBYyxDQUFDLHdCQUF3QixFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDakUsZUFBUyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxxQkFBWSxDQUFDLHdCQUF3QixFQUFFO1FBQ3pELGtCQUFrQixFQUFFLCtCQUErQjtRQUNuRCxpQkFBaUIsRUFBRSxDQUFDO1FBQ3BCLFlBQVksRUFBRTtZQUNaO2dCQUNFLEdBQUcsRUFBRSw4REFBOEQ7YUFDcEU7U0FDRjtRQUNELGdCQUFnQixFQUFFLGtDQUFrQztRQUNwRCxVQUFVLEVBQUUsa0JBQWtCO1FBQzlCLFNBQVMsRUFBRSxhQUFhO1FBQ3hCLE1BQU0sRUFBRSxLQUFLO1FBQ2IsU0FBUyxFQUFFLFNBQVM7UUFDcEIsU0FBUyxFQUFFLEVBQUU7S0FDZCxDQUFDLENBQUMsQ0FBQztBQUNOLENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLGtEQUFrRCxFQUFFLEdBQUcsRUFBRTtJQUM1RCxRQUFRO0lBQ1IsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7SUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxXQUFXLENBQUMsQ0FBQztJQUU5QyxPQUFPO0lBQ1AsSUFBSSxrQkFBWSxDQUFDLEtBQUssRUFBRSx5QkFBeUIsRUFBRTtRQUNqRCxnQkFBZ0IsRUFBRSxLQUFLO1FBQ3ZCLEtBQUssRUFBRSxtQkFBbUI7S0FDM0IsQ0FBQyxDQUFDO0lBRUgsT0FBTztJQUNQLGVBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsdUJBQWMsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzFELGVBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsdUJBQWMsQ0FBQyx3QkFBd0IsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2pFLGVBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsdUJBQWMsQ0FBQyx3QkFBd0IsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2pFLGVBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMseUJBQWdCLENBQUMsd0JBQXdCLEVBQUU7UUFDN0QsU0FBUyxFQUFFLElBQUk7S0FDaEIsQ0FBQyxDQUFDLENBQUM7QUFDTixDQUFDLENBQUMsQ0FBQztBQUVILElBQUksQ0FBQywwRUFBMEUsRUFBRSxHQUFHLEVBQUU7SUFDcEYsUUFBUTtJQUNSLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0lBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsV0FBVyxDQUFDLENBQUM7SUFFOUMsT0FBTztJQUNQLElBQUksa0JBQVksQ0FBQyxLQUFLLEVBQUUseUJBQXlCLEVBQUU7UUFDakQsZ0JBQWdCLEVBQUUsRUFBRTtRQUNwQixLQUFLLEVBQUUsbUJBQW1CO0tBQzNCLENBQUMsQ0FBQztJQUVILE9BQU87SUFDUCxlQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHlCQUFnQixDQUFDLHdCQUF3QixFQUFFO1FBQzdELFVBQVUsRUFBRTtZQUNWO2dCQUNFLElBQUksRUFBRSxVQUFVO2dCQUNoQixLQUFLLEVBQUUsS0FBSzthQUNiO1NBQ0Y7S0FDRixDQUFDLENBQUMsQ0FBQztBQUNOLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgZXhwZWN0IGFzIGV4cGVjdENESywgY291bnRSZXNvdXJjZXMsIGhhdmVSZXNvdXJjZSwgaGF2ZVJlc291cmNlTGlrZSxcbn0gZnJvbSAnQGF3cy1jZGsvYXNzZXJ0JztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEJpbGxpbmdBbGFybSB9IGZyb20gJy4uL2xpYic7XG5cbnRlc3QoJ0JpbGxpbmdBbGFybSBpcyBjcmVhdGVkJywgKCkgPT4ge1xuICAvLyBHSVZFTlxuICBjb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnVGVzdFN0YWNrJyk7XG5cbiAgLy8gV0hFTlxuICBuZXcgQmlsbGluZ0FsYXJtKHN0YWNrLCAnTXlCaWxsaW5nQWxhcm1Db25zdHJ1Y3QnLCB7XG4gICAgbW9udGhseVRocmVzaG9sZDogNTAsXG4gICAgZW1haWw6ICdhZG1pbkBleGFtcGxlLmNvbScsXG4gIH0pO1xuXG4gIC8vIFRIRU5cbiAgZXhwZWN0Q0RLKHN0YWNrKS50byhjb3VudFJlc291cmNlcygnQVdTOjpTTlM6OlRvcGljJywgMSkpO1xuICBleHBlY3RDREsoc3RhY2spLnRvKGhhdmVSZXNvdXJjZSgnQVdTOjpTTlM6OlRvcGljJywge1xuICAgIFRvcGljTmFtZTogJ0JpbGxpbmdBbGFybU5vdGlmaWNhdGlvblRvcGljJyxcbiAgfSkpO1xuXG4gIGV4cGVjdENESyhzdGFjaykudG8oY291bnRSZXNvdXJjZXMoJ0FXUzo6U05TOjpTdWJzY3JpcHRpb24nLCAxKSk7XG4gIGV4cGVjdENESyhzdGFjaykudG8oaGF2ZVJlc291cmNlKCdBV1M6OlNOUzo6U3Vic2NyaXB0aW9uJywge1xuICAgIFByb3RvY29sOiAnZW1haWwtanNvbicsXG4gICAgVG9waWNBcm46IHtcbiAgICAgIFJlZjogJ015QmlsbGluZ0FsYXJtQ29uc3RydWN0QmlsbGluZ0FsYXJtTm90aWZpY2F0aW9uVG9waWNFRkFFOTJFQicsXG4gICAgfSxcbiAgICBFbmRwb2ludDogJ2FkbWluQGV4YW1wbGUuY29tJyxcbiAgfSkpO1xuXG4gIGV4cGVjdENESyhzdGFjaykudG8oY291bnRSZXNvdXJjZXMoJ0FXUzo6Q2xvdWRXYXRjaDo6QWxhcm0nLCAxKSk7XG4gIGV4cGVjdENESyhzdGFjaykudG8oaGF2ZVJlc291cmNlKCdBV1M6OkNsb3VkV2F0Y2g6OkFsYXJtJywge1xuICAgIENvbXBhcmlzb25PcGVyYXRvcjogJ0dyZWF0ZXJUaGFuT3JFcXVhbFRvVGhyZXNob2xkJyxcbiAgICBFdmFsdWF0aW9uUGVyaW9kczogMSxcbiAgICBBbGFybUFjdGlvbnM6IFtcbiAgICAgIHtcbiAgICAgICAgUmVmOiAnTXlCaWxsaW5nQWxhcm1Db25zdHJ1Y3RCaWxsaW5nQWxhcm1Ob3RpZmljYXRpb25Ub3BpY0VGQUU5MkVCJyxcbiAgICAgIH0sXG4gICAgXSxcbiAgICBBbGFybURlc2NyaXB0aW9uOiAnVXBwZXIgbW9udGhseSBiaWxsaW5nIGNvc3QgbGltaXQnLFxuICAgIE1ldHJpY05hbWU6ICdFc3RpbWF0ZWRDaGFyZ2VzJyxcbiAgICBOYW1lc3BhY2U6ICdBV1MvQmlsbGluZycsXG4gICAgUGVyaW9kOiAzMjQwMCxcbiAgICBTdGF0aXN0aWM6ICdNYXhpbXVtJyxcbiAgICBUaHJlc2hvbGQ6IDUwLFxuICB9KSk7XG59KTtcblxudGVzdCgnQmlsbGluZ0FsYXJtIGlzIGNyZWF0ZWQgd2l0aCBub24tcm91bmQgdGhyZXNob2xkJywgKCkgPT4ge1xuICAvLyBHSVZFTlxuICBjb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnVGVzdFN0YWNrJyk7XG5cbiAgLy8gV0hFTlxuICBuZXcgQmlsbGluZ0FsYXJtKHN0YWNrLCAnTXlCaWxsaW5nQWxhcm1Db25zdHJ1Y3QnLCB7XG4gICAgbW9udGhseVRocmVzaG9sZDogNTAuNTAsXG4gICAgZW1haWw6ICdhZG1pbkBleGFtcGxlLmNvbScsXG4gIH0pO1xuXG4gIC8vIFRIRU5cbiAgZXhwZWN0Q0RLKHN0YWNrKS50byhjb3VudFJlc291cmNlcygnQVdTOjpTTlM6OlRvcGljJywgMSkpO1xuICBleHBlY3RDREsoc3RhY2spLnRvKGNvdW50UmVzb3VyY2VzKCdBV1M6OlNOUzo6U3Vic2NyaXB0aW9uJywgMSkpO1xuICBleHBlY3RDREsoc3RhY2spLnRvKGNvdW50UmVzb3VyY2VzKCdBV1M6OkNsb3VkV2F0Y2g6OkFsYXJtJywgMSkpO1xuICBleHBlY3RDREsoc3RhY2spLnRvKGhhdmVSZXNvdXJjZUxpa2UoJ0FXUzo6Q2xvdWRXYXRjaDo6QWxhcm0nLCB7XG4gICAgVGhyZXNob2xkOiA1MC41LFxuICB9KSk7XG59KTtcblxudGVzdCgnQmlsbGluZ0FsYXJtIGNvbnN0cnVjdCBob2xkcyBhIG1ldHJpYyB0aGF0IGhhcyBVU0QgY3VycmVuY3kgYXMgZGltZW5zaW9uJywgKCkgPT4ge1xuICAvLyBHSVZFTlxuICBjb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnVGVzdFN0YWNrJyk7XG5cbiAgLy8gV0hFTlxuICBuZXcgQmlsbGluZ0FsYXJtKHN0YWNrLCAnTXlCaWxsaW5nQWxhcm1Db25zdHJ1Y3QnLCB7XG4gICAgbW9udGhseVRocmVzaG9sZDogNTAsXG4gICAgZW1haWw6ICdhZG1pbkBleGFtcGxlLmNvbScsXG4gIH0pO1xuXG4gIC8vIFRIRU5cbiAgZXhwZWN0Q0RLKHN0YWNrKS50byhoYXZlUmVzb3VyY2VMaWtlKCdBV1M6OkNsb3VkV2F0Y2g6OkFsYXJtJywge1xuICAgIERpbWVuc2lvbnM6IFtcbiAgICAgIHtcbiAgICAgICAgTmFtZTogJ0N1cnJlbmN5JyxcbiAgICAgICAgVmFsdWU6ICdVU0QnLFxuICAgICAgfSxcbiAgICBdLFxuICB9KSk7XG59KTtcbiJdfQ==