import * as cdk from '@aws-cdk/core';
/**
 * Properties for a BillingAlarm.
 *
 * @stability stable
 */
export interface BillingAlarmProps {
    /**
     * Monetary amount threshold in USD that represents the maximum exclusive limit before which the alarm is triggered and the notification sent.
     *
     * @stability stable
     */
    readonly monthlyThreshold: number;
    /**
     * The email to which the alarm-triggered notification will be sent.
     *
     * @stability stable
     */
    readonly email: string;
}
/**
 * A CDK construct that sets up email notification for when you exceed a given AWS estimated charges amount.
 *
 * Note: The email address used as SNS Topic endpoint must be manually confirmed
 * once the stack is deployed.
 *
 * @stability stable
 */
export declare class BillingAlarm extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: BillingAlarmProps);
}
