import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "aws-cdk-billing-alarm",
    "version": "1.0.0.b1",
    "description": "aws-cdk-billing-alarm",
    "license": "MIT",
    "url": "https://github.com/alvyn279/aws-cdk-billing-alarm.git",
    "long_description_content_type": "text/markdown",
    "author": "Alvyn Le<alvyn279@gmail.com>",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/alvyn279/aws-cdk-billing-alarm.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws-cdk-billing-alarm.core",
        "aws-cdk-billing-alarm.core._jsii"
    ],
    "package_data": {
        "aws-cdk-billing-alarm.core._jsii": [
            "aws-cdk-billing-alarm@1.0.0-beta.1.jsii.tgz"
        ],
        "aws-cdk-billing-alarm.core": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "aws-cdk.aws-cloudwatch-actions>=1.78.0, <2.0.0",
        "aws-cdk.aws-cloudwatch>=1.78.0, <2.0.0",
        "aws-cdk.aws-sns-subscriptions>=1.78.0, <2.0.0",
        "aws-cdk.aws-sns>=1.78.0, <2.0.0",
        "aws-cdk.core>=1.78.0, <2.0.0",
        "jsii>=1.16.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Typing :: Typed",
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved"
    ]
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
