# Generated by Django 3.0.3 on 2020-03-02 02:35

import ckeditor.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import warehouse.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Model',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='模型名称')),
                ('slug', models.CharField(help_text="英文无空格，用以生产模型最后的URL, URL的生产规则为f'AI_{project_slug}_{model_slug}_{version}.{suffix}'", max_length=255, unique=True, verbose_name='slug')),
                ('note', ckeditor.fields.RichTextField(blank=True, verbose_name='模型备注')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('create_user', models.ForeignKey(blank=True, help_text='默认为当前登录用户', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_model_files', to=settings.AUTH_USER_MODEL, verbose_name='添加人')),
            ],
            options={
                'verbose_name': '模型',
                'verbose_name_plural': '模型',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='项目名称')),
                ('slug', models.CharField(help_text="英文无空格，用以生产模型最后的URL, URL的生产规则为f'AI_{project_slug}_{model_slug}_{version}.{suffix}'", max_length=255, unique=True, verbose_name='slug')),
                ('note', ckeditor.fields.RichTextField(blank=True, verbose_name='项目备注')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('create_user', models.ForeignKey(blank=True, help_text='默认为当前登录用户', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_projects', to=settings.AUTH_USER_MODEL, verbose_name='添加人')),
                ('update_user', models.ForeignKey(blank=True, help_text='默认为当前登录用户', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='updated_projects', to=settings.AUTH_USER_MODEL, verbose_name='更新人')),
            ],
            options={
                'verbose_name': '项目',
                'verbose_name_plural': '项目',
            },
        ),
        migrations.CreateModel(
            name='ModelFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=255, verbose_name='模型版本')),
                ('note', ckeditor.fields.RichTextField(blank=True, verbose_name='模型备注')),
                ('suffix', models.CharField(default='model', help_text='最后生成模型名称的后缀，如果遇到特殊框架需指定文件名后缀的可用。', max_length=255, verbose_name='模型后缀')),
                ('file', models.FileField(help_text="URL的生产规则为f'AI_{project_slug}_{model_slug}_{version}.{suffix}'", upload_to=warehouse.utils.model_upload_to, verbose_name='文件选择')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('create_user', models.ForeignKey(blank=True, help_text='默认为当前登录用户', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_model_versions', to=settings.AUTH_USER_MODEL, verbose_name='添加人')),
                ('model_file', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='warehouse.Model', verbose_name='对应模型文件')),
                ('update_user', models.ForeignKey(blank=True, help_text='默认为当前登录用户', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='updated_model_versions', to=settings.AUTH_USER_MODEL, verbose_name='更新人')),
            ],
            options={
                'verbose_name': '模型文件',
                'verbose_name_plural': '模型文件',
            },
        ),
        migrations.AddField(
            model_name='model',
            name='project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='warehouse.Project', verbose_name='对应项目'),
        ),
        migrations.AddField(
            model_name='model',
            name='update_user',
            field=models.ForeignKey(blank=True, help_text='默认为当前登录用户', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='updated_model_files', to=settings.AUTH_USER_MODEL, verbose_name='更新人'),
        ),
    ]
