"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackWithDynamicSource = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * If you are using a dynamic location for assets and pass those as a variable
 * in your top stack, this allows you to continue passing those down
 */
class StackWithDynamicSource extends aws_cdk_lib_1.NestedStack {
    static updateBaseParams(scope, props) {
        if (props.assetsBucketsParameterName !== undefined) {
            let currentNode = scope;
            while (currentNode !== undefined && !(currentNode instanceof aws_cdk_lib_1.Stack)) {
                currentNode = currentNode.node.scope;
            }
            if (currentNode !== undefined) {
                let assetsBucket = currentNode.node.tryFindChild(props.assetsBucketsParameterName);
                if (assetsBucket !== undefined &&
                    assetsBucket instanceof aws_cdk_lib_1.CfnParameter) {
                    if (props.parameters === undefined) {
                        let tmp = {
                            parameters: {},
                            timeout: props.timeout,
                            notificationArns: props.notificationArns,
                            removalPolicy: props.removalPolicy,
                            description: props.description,
                        };
                        if (tmp.parameters !== undefined) {
                            tmp.parameters[props.assetsBucketsParameterName] =
                                assetsBucket.valueAsString;
                            if (props.assetsBucketPrefixParameterName !== undefined) {
                                let assetsBucketPrefix = currentNode.node.tryFindChild(props.assetsBucketPrefixParameterName);
                                if (assetsBucketPrefix !== undefined &&
                                    assetsBucketPrefix instanceof aws_cdk_lib_1.CfnParameter) {
                                    tmp.parameters[props.assetsBucketPrefixParameterName] =
                                        assetsBucketPrefix.valueAsString;
                                }
                            }
                        }
                        return tmp;
                    }
                    else {
                        props.parameters[props.assetsBucketsParameterName] =
                            assetsBucket.valueAsString;
                        if (props.assetsBucketPrefixParameterName !== undefined) {
                            let assetsBucketPrefix = currentNode.node.tryFindChild(props.assetsBucketPrefixParameterName);
                            if (assetsBucketPrefix !== undefined &&
                                assetsBucketPrefix instanceof aws_cdk_lib_1.CfnParameter) {
                                props.parameters[props.assetsBucketPrefixParameterName] =
                                    assetsBucketPrefix.valueAsString;
                            }
                        }
                    }
                }
            }
        }
        return props;
    }
    constructor(scope, id, props) {
        super(scope, id, StackWithDynamicSource.updateBaseParams(scope, props));
        let currentNode = this;
        while (currentNode !== undefined && !(currentNode instanceof aws_cdk_lib_1.Stack)) {
            currentNode = currentNode.node.scope;
        }
        if (currentNode !== undefined) {
            if (props.assetsBucketsParameterName !== undefined) {
                new aws_cdk_lib_1.CfnParameter(currentNode, props.assetsBucketsParameterName, {
                    type: "String",
                });
            }
            if (props.assetsBucketPrefixParameterName !== undefined) {
                new aws_cdk_lib_1.CfnParameter(currentNode, props.assetsBucketPrefixParameterName, {
                    type: "String",
                });
            }
        }
    }
}
exports.StackWithDynamicSource = StackWithDynamicSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RhY2tXaXRoRHluYW1pY1NvdXJjZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsaXRpZXMvU3RhY2tXaXRoRHluYW1pY1NvdXJjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2Q0FLcUI7QUFRckI7OztHQUdHO0FBQ0gsTUFBYSxzQkFBdUIsU0FBUSx5QkFBVztJQUM3QyxNQUFNLENBQUMsZ0JBQWdCLENBQzdCLEtBQWlCLEVBQ2pCLEtBQXdDO1FBRXhDLElBQUksS0FBSyxDQUFDLDBCQUEwQixLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQ25ELElBQUksV0FBVyxHQUEyQixLQUFLLENBQUM7WUFFaEQsT0FBTyxXQUFXLEtBQUssU0FBUyxJQUFJLENBQUMsQ0FBQyxXQUFXLFlBQVksbUJBQUssQ0FBQyxFQUFFLENBQUM7Z0JBQ3BFLFdBQVcsR0FBRyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUN2QyxDQUFDO1lBRUQsSUFBSSxXQUFXLEtBQUssU0FBUyxFQUFFLENBQUM7Z0JBQzlCLElBQUksWUFBWSxHQUNkLFdBQ0QsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO2dCQUV0RCxJQUNFLFlBQVksS0FBSyxTQUFTO29CQUMxQixZQUFZLFlBQVksMEJBQVksRUFDcEMsQ0FBQztvQkFDRCxJQUFJLEtBQUssQ0FBQyxVQUFVLEtBQUssU0FBUyxFQUFFLENBQUM7d0JBQ25DLElBQUksR0FBRyxHQUFxQjs0QkFDMUIsVUFBVSxFQUFFLEVBQUU7NEJBQ2QsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPOzRCQUN0QixnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCOzRCQUN4QyxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7NEJBQ2xDLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVzt5QkFDL0IsQ0FBQzt3QkFFRixJQUFJLEdBQUcsQ0FBQyxVQUFVLEtBQUssU0FBUyxFQUFFLENBQUM7NEJBQ2pDLEdBQUcsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLDBCQUEwQixDQUFDO2dDQUM5QyxZQUFZLENBQUMsYUFBYSxDQUFDOzRCQUU3QixJQUFJLEtBQUssQ0FBQywrQkFBK0IsS0FBSyxTQUFTLEVBQUUsQ0FBQztnQ0FDeEQsSUFBSSxrQkFBa0IsR0FDcEIsV0FDRCxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLCtCQUErQixDQUFDLENBQUM7Z0NBQzNELElBQ0Usa0JBQWtCLEtBQUssU0FBUztvQ0FDaEMsa0JBQWtCLFlBQVksMEJBQVksRUFDMUMsQ0FBQztvQ0FDRCxHQUFHLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQywrQkFBK0IsQ0FBQzt3Q0FDbkQsa0JBQWtCLENBQUMsYUFBYSxDQUFDO2dDQUNyQyxDQUFDOzRCQUNILENBQUM7d0JBQ0gsQ0FBQzt3QkFFRCxPQUFPLEdBQUcsQ0FBQztvQkFDYixDQUFDO3lCQUFNLENBQUM7d0JBQ04sS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsMEJBQTBCLENBQUM7NEJBQ2hELFlBQVksQ0FBQyxhQUFhLENBQUM7d0JBRTdCLElBQUksS0FBSyxDQUFDLCtCQUErQixLQUFLLFNBQVMsRUFBRSxDQUFDOzRCQUN4RCxJQUFJLGtCQUFrQixHQUNwQixXQUNELENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsK0JBQStCLENBQUMsQ0FBQzs0QkFFM0QsSUFDRSxrQkFBa0IsS0FBSyxTQUFTO2dDQUNoQyxrQkFBa0IsWUFBWSwwQkFBWSxFQUMxQyxDQUFDO2dDQUNELEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLCtCQUErQixDQUFDO29DQUNyRCxrQkFBa0IsQ0FBQyxhQUFhLENBQUM7NEJBQ3JDLENBQUM7d0JBQ0gsQ0FBQztvQkFDSCxDQUFDO2dCQUNILENBQUM7WUFDSCxDQUFDO1FBQ0gsQ0FBQztRQUVELE9BQU8sS0FBeUIsQ0FBQztJQUNuQyxDQUFDO0lBRUQsWUFDRSxLQUFnQixFQUNoQixFQUFVLEVBQ1YsS0FBd0M7UUFFeEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsc0JBQXNCLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFFeEUsSUFBSSxXQUFXLEdBQTJCLElBQUksQ0FBQztRQUUvQyxPQUFPLFdBQVcsS0FBSyxTQUFTLElBQUksQ0FBQyxDQUFDLFdBQVcsWUFBWSxtQkFBSyxDQUFDLEVBQUUsQ0FBQztZQUNwRSxXQUFXLEdBQUcsV0FBVyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7UUFDdkMsQ0FBQztRQUVELElBQUksV0FBVyxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQzlCLElBQUksS0FBSyxDQUFDLDBCQUEwQixLQUFLLFNBQVMsRUFBRSxDQUFDO2dCQUNuRCxJQUFJLDBCQUFZLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQywwQkFBMEIsRUFBRTtvQkFDOUQsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztZQUVELElBQUksS0FBSyxDQUFDLCtCQUErQixLQUFLLFNBQVMsRUFBRSxDQUFDO2dCQUN4RCxJQUFJLDBCQUFZLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQywrQkFBK0IsRUFBRTtvQkFDbkUsSUFBSSxFQUFFLFFBQVE7aUJBQ2YsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztRQUNILENBQUM7SUFDSCxDQUFDO0NBQ0Y7QUFyR0Qsd0RBcUdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgQ2ZuUGFyYW1ldGVyLFxuICBOZXN0ZWRTdGFjayxcbiAgTmVzdGVkU3RhY2tQcm9wcyxcbiAgU3RhY2ssXG59IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBJQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcblxuZXhwb3J0IGludGVyZmFjZSBOZXN0ZWRTdGFja1dpdGhEeW5hbWljU291cmNlUHJvcHMgZXh0ZW5kcyBOZXN0ZWRTdGFja1Byb3BzIHtcbiAgYXNzZXRzQnVja2V0c1BhcmFtZXRlck5hbWU/OiBzdHJpbmc7XG4gIGFzc2V0c0J1Y2tldFByZWZpeFBhcmFtZXRlck5hbWU/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogSWYgeW91IGFyZSB1c2luZyBhIGR5bmFtaWMgbG9jYXRpb24gZm9yIGFzc2V0cyBhbmQgcGFzcyB0aG9zZSBhcyBhIHZhcmlhYmxlXG4gKiBpbiB5b3VyIHRvcCBzdGFjaywgdGhpcyBhbGxvd3MgeW91IHRvIGNvbnRpbnVlIHBhc3NpbmcgdGhvc2UgZG93blxuICovXG5leHBvcnQgY2xhc3MgU3RhY2tXaXRoRHluYW1pY1NvdXJjZSBleHRlbmRzIE5lc3RlZFN0YWNrIHtcbiAgcHJpdmF0ZSBzdGF0aWMgdXBkYXRlQmFzZVBhcmFtcyhcbiAgICBzY29wZTogSUNvbnN0cnVjdCxcbiAgICBwcm9wczogTmVzdGVkU3RhY2tXaXRoRHluYW1pY1NvdXJjZVByb3BzLFxuICApOiBOZXN0ZWRTdGFja1Byb3BzIHtcbiAgICBpZiAocHJvcHMuYXNzZXRzQnVja2V0c1BhcmFtZXRlck5hbWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgbGV0IGN1cnJlbnROb2RlOiBJQ29uc3RydWN0IHwgdW5kZWZpbmVkID0gc2NvcGU7XG5cbiAgICAgIHdoaWxlIChjdXJyZW50Tm9kZSAhPT0gdW5kZWZpbmVkICYmICEoY3VycmVudE5vZGUgaW5zdGFuY2VvZiBTdGFjaykpIHtcbiAgICAgICAgY3VycmVudE5vZGUgPSBjdXJyZW50Tm9kZS5ub2RlLnNjb3BlO1xuICAgICAgfVxuXG4gICAgICBpZiAoY3VycmVudE5vZGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgICBsZXQgYXNzZXRzQnVja2V0OiBJQ29uc3RydWN0IHwgdW5kZWZpbmVkID0gKFxuICAgICAgICAgIGN1cnJlbnROb2RlIGFzIFN0YWNrXG4gICAgICAgICkubm9kZS50cnlGaW5kQ2hpbGQocHJvcHMuYXNzZXRzQnVja2V0c1BhcmFtZXRlck5hbWUpO1xuXG4gICAgICAgIGlmIChcbiAgICAgICAgICBhc3NldHNCdWNrZXQgIT09IHVuZGVmaW5lZCAmJlxuICAgICAgICAgIGFzc2V0c0J1Y2tldCBpbnN0YW5jZW9mIENmblBhcmFtZXRlclxuICAgICAgICApIHtcbiAgICAgICAgICBpZiAocHJvcHMucGFyYW1ldGVycyA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICBsZXQgdG1wOiBOZXN0ZWRTdGFja1Byb3BzID0ge1xuICAgICAgICAgICAgICBwYXJhbWV0ZXJzOiB7fSxcbiAgICAgICAgICAgICAgdGltZW91dDogcHJvcHMudGltZW91dCxcbiAgICAgICAgICAgICAgbm90aWZpY2F0aW9uQXJuczogcHJvcHMubm90aWZpY2F0aW9uQXJucyxcbiAgICAgICAgICAgICAgcmVtb3ZhbFBvbGljeTogcHJvcHMucmVtb3ZhbFBvbGljeSxcbiAgICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgICAgICAgfTtcblxuICAgICAgICAgICAgaWYgKHRtcC5wYXJhbWV0ZXJzICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgdG1wLnBhcmFtZXRlcnNbcHJvcHMuYXNzZXRzQnVja2V0c1BhcmFtZXRlck5hbWVdID1cbiAgICAgICAgICAgICAgICBhc3NldHNCdWNrZXQudmFsdWVBc1N0cmluZztcblxuICAgICAgICAgICAgICBpZiAocHJvcHMuYXNzZXRzQnVja2V0UHJlZml4UGFyYW1ldGVyTmFtZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgICAgbGV0IGFzc2V0c0J1Y2tldFByZWZpeDogSUNvbnN0cnVjdCB8IHVuZGVmaW5lZCA9IChcbiAgICAgICAgICAgICAgICAgIGN1cnJlbnROb2RlIGFzIFN0YWNrXG4gICAgICAgICAgICAgICAgKS5ub2RlLnRyeUZpbmRDaGlsZChwcm9wcy5hc3NldHNCdWNrZXRQcmVmaXhQYXJhbWV0ZXJOYW1lKTtcbiAgICAgICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgICBhc3NldHNCdWNrZXRQcmVmaXggIT09IHVuZGVmaW5lZCAmJlxuICAgICAgICAgICAgICAgICAgYXNzZXRzQnVja2V0UHJlZml4IGluc3RhbmNlb2YgQ2ZuUGFyYW1ldGVyXG4gICAgICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgICB0bXAucGFyYW1ldGVyc1twcm9wcy5hc3NldHNCdWNrZXRQcmVmaXhQYXJhbWV0ZXJOYW1lXSA9XG4gICAgICAgICAgICAgICAgICAgIGFzc2V0c0J1Y2tldFByZWZpeC52YWx1ZUFzU3RyaW5nO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICByZXR1cm4gdG1wO1xuICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBwcm9wcy5wYXJhbWV0ZXJzW3Byb3BzLmFzc2V0c0J1Y2tldHNQYXJhbWV0ZXJOYW1lXSA9XG4gICAgICAgICAgICAgIGFzc2V0c0J1Y2tldC52YWx1ZUFzU3RyaW5nO1xuXG4gICAgICAgICAgICBpZiAocHJvcHMuYXNzZXRzQnVja2V0UHJlZml4UGFyYW1ldGVyTmFtZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICAgIGxldCBhc3NldHNCdWNrZXRQcmVmaXg6IElDb25zdHJ1Y3QgfCB1bmRlZmluZWQgPSAoXG4gICAgICAgICAgICAgICAgY3VycmVudE5vZGUgYXMgU3RhY2tcbiAgICAgICAgICAgICAgKS5ub2RlLnRyeUZpbmRDaGlsZChwcm9wcy5hc3NldHNCdWNrZXRQcmVmaXhQYXJhbWV0ZXJOYW1lKTtcblxuICAgICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgYXNzZXRzQnVja2V0UHJlZml4ICE9PSB1bmRlZmluZWQgJiZcbiAgICAgICAgICAgICAgICBhc3NldHNCdWNrZXRQcmVmaXggaW5zdGFuY2VvZiBDZm5QYXJhbWV0ZXJcbiAgICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgcHJvcHMucGFyYW1ldGVyc1twcm9wcy5hc3NldHNCdWNrZXRQcmVmaXhQYXJhbWV0ZXJOYW1lXSA9XG4gICAgICAgICAgICAgICAgICBhc3NldHNCdWNrZXRQcmVmaXgudmFsdWVBc1N0cmluZztcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiBwcm9wcyBhcyBOZXN0ZWRTdGFja1Byb3BzO1xuICB9XG5cbiAgY29uc3RydWN0b3IoXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBpZDogc3RyaW5nLFxuICAgIHByb3BzOiBOZXN0ZWRTdGFja1dpdGhEeW5hbWljU291cmNlUHJvcHMsXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgU3RhY2tXaXRoRHluYW1pY1NvdXJjZS51cGRhdGVCYXNlUGFyYW1zKHNjb3BlLCBwcm9wcykpO1xuXG4gICAgbGV0IGN1cnJlbnROb2RlOiBJQ29uc3RydWN0IHwgdW5kZWZpbmVkID0gdGhpcztcblxuICAgIHdoaWxlIChjdXJyZW50Tm9kZSAhPT0gdW5kZWZpbmVkICYmICEoY3VycmVudE5vZGUgaW5zdGFuY2VvZiBTdGFjaykpIHtcbiAgICAgIGN1cnJlbnROb2RlID0gY3VycmVudE5vZGUubm9kZS5zY29wZTtcbiAgICB9XG5cbiAgICBpZiAoY3VycmVudE5vZGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaWYgKHByb3BzLmFzc2V0c0J1Y2tldHNQYXJhbWV0ZXJOYW1lICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgbmV3IENmblBhcmFtZXRlcihjdXJyZW50Tm9kZSwgcHJvcHMuYXNzZXRzQnVja2V0c1BhcmFtZXRlck5hbWUsIHtcbiAgICAgICAgICB0eXBlOiBcIlN0cmluZ1wiLFxuICAgICAgICB9KTtcbiAgICAgIH1cblxuICAgICAgaWYgKHByb3BzLmFzc2V0c0J1Y2tldFByZWZpeFBhcmFtZXRlck5hbWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgICBuZXcgQ2ZuUGFyYW1ldGVyKGN1cnJlbnROb2RlLCBwcm9wcy5hc3NldHNCdWNrZXRQcmVmaXhQYXJhbWV0ZXJOYW1lLCB7XG4gICAgICAgICAgdHlwZTogXCJTdHJpbmdcIixcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfVxuICB9XG59XG4iXX0=