"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutlierDetectionAlgorithm = void 0;
/**
 * Available algorithms for performing outlier detection
 */
var OutlierDetectionAlgorithm;
(function (OutlierDetectionAlgorithm) {
    /**
     * Defines using a static value to compare skew in faults or
     * high latency responses.
     *
     * A good default threshold for this is .7 meaning one AZ
     * is responsible for 70% of the total errors or high latency responses
     */
    OutlierDetectionAlgorithm["STATIC"] = "STATIC";
    /**
     * Uses the chi squared statistic to determine if there is a statistically
     * significant skew in fault rate or high latency distribution
     *
     * A normal default threshold for this is 0.05, which means there is a 5% or
     * less chance of the skew in errors or high latency responses occuring
     */
    OutlierDetectionAlgorithm["CHI_SQUARED"] = "CHI_SQUARED";
    /**
     * Uses z-score to determine if the skew in faults or high latency respones
     * exceeds a defined number of standard devations
     *
     * A good default threshold value for this is 2, meaning the outlier value is outside
     * 95% of the normal distribution. Using 3 means the outlier is outside 99.7% of
     * the normal distribution.
     */
    OutlierDetectionAlgorithm["Z_SCORE"] = "Z_SCORE";
    /**
     * Uses Interquartile Range Method to determine an outlier for faults or latency
     *
     * No threshold is required for this method and will be ignored
     */
    OutlierDetectionAlgorithm["IQR"] = "IQR";
    /**
     * Median Absolute Deviation (MAD) to determine an outlier for faults or latency
     *
     * A common default value threshold 3
     */
    OutlierDetectionAlgorithm["MAD"] = "MAD";
})(OutlierDetectionAlgorithm || (exports.OutlierDetectionAlgorithm = OutlierDetectionAlgorithm = {}));
//# sourceMappingURL=data:application/json;base64,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