"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvailabilityMetricType = void 0;
/**
 * Different availability metric types
 */
var AvailabilityMetricType;
(function (AvailabilityMetricType) {
    /**
     * The success rate, i.e. (successful responses) / (successful + fault responses) * 100
     */
    AvailabilityMetricType["SUCCESS_RATE"] = "Success_Rate";
    /**
     * The number of success responses as an absolute value
     */
    AvailabilityMetricType["SUCCESS_COUNT"] = "Success_Count";
    /**
     * The fault rate, i.e. (fault responses) / (successful + fault responses) * 100
     */
    AvailabilityMetricType["FAULT_RATE"] = "Fault_Rate";
    /**
     * The number of fault responses as an absolute value
     */
    AvailabilityMetricType["FAULT_COUNT"] = "Fault_Count";
    /**
     * The number of requests received that resulted in either a fault or success. This
     * does not include "error" responses that would be equivalent to 4xx responses.
     */
    AvailabilityMetricType["REQUEST_COUNT"] = "Request_Count";
})(AvailabilityMetricType || (exports.AvailabilityMetricType = AvailabilityMetricType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXZhaWxhYmlsaXR5TWV0cmljVHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsaXRpZXMvQXZhaWxhYmlsaXR5TWV0cmljVHlwZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTs7R0FFRztBQUNILElBQVksc0JBMEJYO0FBMUJELFdBQVksc0JBQXNCO0lBQ2hDOztPQUVHO0lBQ0gsdURBQTZCLENBQUE7SUFFN0I7O09BRUc7SUFDSCx5REFBK0IsQ0FBQTtJQUUvQjs7T0FFRztJQUNILG1EQUF5QixDQUFBO0lBRXpCOztPQUVHO0lBQ0gscURBQTJCLENBQUE7SUFFM0I7OztPQUdHO0lBQ0gseURBQStCLENBQUE7QUFDakMsQ0FBQyxFQTFCVyxzQkFBc0Isc0NBQXRCLHNCQUFzQixRQTBCakMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIERpZmZlcmVudCBhdmFpbGFiaWxpdHkgbWV0cmljIHR5cGVzXG4gKi9cbmV4cG9ydCBlbnVtIEF2YWlsYWJpbGl0eU1ldHJpY1R5cGUge1xuICAvKipcbiAgICogVGhlIHN1Y2Nlc3MgcmF0ZSwgaS5lLiAoc3VjY2Vzc2Z1bCByZXNwb25zZXMpIC8gKHN1Y2Nlc3NmdWwgKyBmYXVsdCByZXNwb25zZXMpICogMTAwXG4gICAqL1xuICBTVUNDRVNTX1JBVEUgPSBcIlN1Y2Nlc3NfUmF0ZVwiLFxuXG4gIC8qKlxuICAgKiBUaGUgbnVtYmVyIG9mIHN1Y2Nlc3MgcmVzcG9uc2VzIGFzIGFuIGFic29sdXRlIHZhbHVlXG4gICAqL1xuICBTVUNDRVNTX0NPVU5UID0gXCJTdWNjZXNzX0NvdW50XCIsXG5cbiAgLyoqXG4gICAqIFRoZSBmYXVsdCByYXRlLCBpLmUuIChmYXVsdCByZXNwb25zZXMpIC8gKHN1Y2Nlc3NmdWwgKyBmYXVsdCByZXNwb25zZXMpICogMTAwXG4gICAqL1xuICBGQVVMVF9SQVRFID0gXCJGYXVsdF9SYXRlXCIsXG5cbiAgLyoqXG4gICAqIFRoZSBudW1iZXIgb2YgZmF1bHQgcmVzcG9uc2VzIGFzIGFuIGFic29sdXRlIHZhbHVlXG4gICAqL1xuICBGQVVMVF9DT1VOVCA9IFwiRmF1bHRfQ291bnRcIixcblxuICAvKipcbiAgICogVGhlIG51bWJlciBvZiByZXF1ZXN0cyByZWNlaXZlZCB0aGF0IHJlc3VsdGVkIGluIGVpdGhlciBhIGZhdWx0IG9yIHN1Y2Nlc3MuIFRoaXNcbiAgICogZG9lcyBub3QgaW5jbHVkZSBcImVycm9yXCIgcmVzcG9uc2VzIHRoYXQgd291bGQgYmUgZXF1aXZhbGVudCB0byA0eHggcmVzcG9uc2VzLlxuICAgKi9cbiAgUkVRVUVTVF9DT1VOVCA9IFwiUmVxdWVzdF9Db3VudFwiLFxufVxuIl19