"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricDimensions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Provides the ability to get operation specific metric dimensions
 * for metrics at the regional level as well as Availability Zone level
 */
class MetricDimensions {
    constructor(staticDimensions, availabilityZoneIdKey, regionKey) {
        this.staticDimensions = staticDimensions;
        this.availabilityZoneIdKey = availabilityZoneIdKey;
        this.regionKey = regionKey;
    }
    /**
     * Gets the zonal dimensions for these metrics by combining the static
     * metric dimensions with the keys provided for Availability Zone and
     * optional Region, expected to return something like
     * {
     *   "Region": "us-east-1",
     *   "AZ-ID": "use1-az1",
     *   "Operation": "ride",
     *   "Service": "WildRydes"
     * }
     * @param availabilityZoneId
     * @param region
     */
    zonalDimensions(availabilityZoneId, region) {
        let tmp = {};
        Object.assign(tmp, this.staticDimensions);
        tmp[this.availabilityZoneIdKey] = availabilityZoneId;
        if (this.regionKey !== undefined) {
            tmp[this.regionKey] = region;
        }
        return tmp;
    }
    /**
     * Gets the regional dimensions for these metrics by combining the static
     * metric dimensions with the keys provided the optional Region key,
     * expected to return something like
     * {
     *   "Region": "us-east-1",
     *   "Operation": "ride",
     *   "Service": "WildRydes"
     * }
     * @param region
     */
    regionalDimensions(region) {
        let tmp = {};
        Object.assign(tmp, this.staticDimensions);
        if (this.regionKey !== undefined) {
            tmp[this.regionKey] = region;
        }
        return tmp;
    }
}
exports.MetricDimensions = MetricDimensions;
_a = JSII_RTTI_SYMBOL_1;
MetricDimensions[_a] = { fqn: "multi-az-observability.MetricDimensions", version: "0.0.1-alpha.10" };
//# sourceMappingURL=data:application/json;base64,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