"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstrumentedServiceMultiAZObservability = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const CanaryMetrics_1 = require("./CanaryMetrics");
const Operation_1 = require("./Operation");
const OperationMetricDetails_1 = require("./OperationMetricDetails");
const MetricDimensions_1 = require("./props/MetricDimensions");
const OperationAlarmsAndRules_1 = require("../alarmsandrules/OperationAlarmsAndRules");
const ServiceAlarmsAndRules_1 = require("../alarmsandrules/ServiceAlarmsAndRules");
const AvailabilityZoneMapper_1 = require("../azmapper/AvailabilityZoneMapper");
const CanaryFunction_1 = require("../canaries/CanaryFunction");
const CanaryTest_1 = require("../canaries/CanaryTest");
const OperationAvailabilityAndLatencyDashboard_1 = require("../dashboards/OperationAvailabilityAndLatencyDashboard");
const ServiceAvailabilityAndLatencyDashboard_1 = require("../dashboards/ServiceAvailabilityAndLatencyDashboard");
const OutlierDetectionFunction_1 = require("../outlier-detection/OutlierDetectionFunction");
const OutlierDetectionAlgorithm_1 = require("../utilities/OutlierDetectionAlgorithm");
const StackWithDynamicSource_1 = require("../utilities/StackWithDynamicSource");
/**
 * An service that implements its own instrumentation to record
 * availability and latency metrics that can be used to create
 * alarms, rules, and dashboards from
 */
class InstrumentedServiceMultiAZObservability extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let outlierThreshold;
        if (!props.outlierThreshold) {
            switch (props.outlierDetectionAlgorithm) {
                case OutlierDetectionAlgorithm_1.OutlierDetectionAlgorithm.CHI_SQUARED:
                    outlierThreshold = 0.05;
                    break;
                case OutlierDetectionAlgorithm_1.OutlierDetectionAlgorithm.IQR:
                    outlierThreshold = 1.5;
                    break;
                case OutlierDetectionAlgorithm_1.OutlierDetectionAlgorithm.MAD:
                    outlierThreshold = 3;
                    break;
                case OutlierDetectionAlgorithm_1.OutlierDetectionAlgorithm.STATIC:
                    outlierThreshold = 0.7;
                    break;
                case OutlierDetectionAlgorithm_1.OutlierDetectionAlgorithm.Z_SCORE:
                    outlierThreshold = 2;
                    break;
            }
        }
        else {
            outlierThreshold = props.outlierThreshold;
        }
        this.azMapper = new AvailabilityZoneMapper_1.AvailabilityZoneMapper(this, "AZMapper", {
            availabilityZoneNames: props.service.availabilityZoneNames,
        });
        if (props.service.canaryTestProps !== undefined) {
            let canaryStack = new StackWithDynamicSource_1.StackWithDynamicSource(this, "Canary", {
                assetsBucketsParameterName: props.assetsBucketParameterName,
                assetsBucketPrefixParameterName: props.assetsBucketPrefixParameterName,
            });
            let canary = new CanaryFunction_1.CanaryFunction(canaryStack, "CanaryFunction", {
                vpc: props.service.canaryTestProps.networkConfiguration?.vpc,
                subnetSelection: props.service.canaryTestProps.networkConfiguration?.subnetSelection,
                httpTimeout: props.service.canaryTestProps.timeout
                    ? props.service.canaryTestProps.timeout
                    : aws_cdk_lib_1.Duration.seconds(2),
                ignoreTlsErrors: props.service.canaryTestProps.ignoreTlsErrors
                    ? props.service.canaryTestProps.ignoreTlsErrors
                    : false,
            });
            this.canaryLogGroup = canary.logGroup;
            for (let i = 0; i < props.service.operations.length; i++) {
                let operation = props.service.operations[i];
                if (operation.optOutOfServiceCreatedCanary != true) {
                    let testProps = operation.canaryTestProps
                        ? operation.canaryTestProps
                        : props.service.canaryTestProps;
                    let nestedStack = new aws_cdk_lib_1.NestedStack(this, operation.operationName + "CanaryTest", {});
                    let test = new CanaryTest_1.CanaryTest(nestedStack, operation.operationName, {
                        function: canary.function,
                        requestCount: testProps.requestCount,
                        regionalRequestCount: testProps.regionalRequestCount
                            ? testProps.regionalRequestCount
                            : testProps.requestCount,
                        schedule: testProps.schedule,
                        operation: operation,
                        loadBalancer: testProps.loadBalancer,
                        headers: testProps.headers,
                        postData: testProps.postData,
                        azMapper: this.azMapper,
                    });
                    let defaultAvailabilityMetricDetails;
                    let defaultLatencyMetricDetails;
                    if (operation.canaryMetricDetails?.canaryAvailabilityMetricDetails) {
                        defaultAvailabilityMetricDetails = new OperationMetricDetails_1.OperationMetricDetails({
                            operationName: operation.operationName,
                            metricDimensions: new MetricDimensions_1.MetricDimensions({ Operation: operation.operationName }, "AZ-ID", "Region"),
                            alarmStatistic: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .alarmStatistic,
                            datapointsToAlarm: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .datapointsToAlarm,
                            evaluationPeriods: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .evaluationPeriods,
                            faultAlarmThreshold: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .faultAlarmThreshold,
                            faultMetricNames: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .faultMetricNames,
                            graphedFaultStatistics: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .graphedFaultStatistics,
                            graphedSuccessStatistics: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .graphedSuccessStatistics,
                            metricNamespace: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .metricNamespace,
                            period: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .period,
                            successAlarmThreshold: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .successAlarmThreshold,
                            successMetricNames: operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                                .successMetricNames,
                            unit: operation.canaryMetricDetails
                                .canaryAvailabilityMetricDetails.unit,
                        }, operation.service.defaultAvailabilityMetricDetails);
                    }
                    else if (operation.canaryTestAvailabilityMetricsOverride) {
                        defaultAvailabilityMetricDetails = new OperationMetricDetails_1.OperationMetricDetails({
                            operationName: operation.operationName,
                            metricNamespace: test.metricNamespace,
                            successMetricNames: ["Success"],
                            faultMetricNames: ["Fault", "Failure"],
                            metricDimensions: new MetricDimensions_1.MetricDimensions({ Operation: operation.operationName }, "AZ-ID", "Region"),
                            alarmStatistic: operation.canaryTestAvailabilityMetricsOverride
                                .alarmStatistic,
                            datapointsToAlarm: operation.canaryTestAvailabilityMetricsOverride
                                .datapointsToAlarm,
                            evaluationPeriods: operation.canaryTestAvailabilityMetricsOverride
                                .evaluationPeriods,
                            faultAlarmThreshold: operation.canaryTestAvailabilityMetricsOverride
                                .faultAlarmThreshold,
                            period: operation.canaryTestAvailabilityMetricsOverride.period,
                            successAlarmThreshold: operation.canaryTestAvailabilityMetricsOverride
                                .successAlarmThreshold,
                        }, props.service.defaultAvailabilityMetricDetails);
                    }
                    else {
                        defaultAvailabilityMetricDetails = new OperationMetricDetails_1.OperationMetricDetails({
                            operationName: operation.operationName,
                            metricNamespace: test.metricNamespace,
                            successMetricNames: ["Success"],
                            faultMetricNames: ["Fault", "Failure"],
                            metricDimensions: new MetricDimensions_1.MetricDimensions({ Operation: operation.operationName }, "AZ-ID", "Region"),
                        }, props.service.defaultAvailabilityMetricDetails);
                    }
                    if (operation.canaryMetricDetails?.canaryLatencyMetricDetails) {
                        defaultLatencyMetricDetails = new OperationMetricDetails_1.OperationMetricDetails({
                            operationName: operation.operationName,
                            metricDimensions: new MetricDimensions_1.MetricDimensions({ Operation: operation.operationName }, "AZ-ID", "Region"),
                            alarmStatistic: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .alarmStatistic,
                            datapointsToAlarm: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .datapointsToAlarm,
                            evaluationPeriods: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .evaluationPeriods,
                            faultAlarmThreshold: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .faultAlarmThreshold,
                            faultMetricNames: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .faultMetricNames,
                            graphedFaultStatistics: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .graphedFaultStatistics,
                            graphedSuccessStatistics: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .graphedSuccessStatistics,
                            metricNamespace: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .metricNamespace,
                            period: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .period,
                            successAlarmThreshold: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .successAlarmThreshold,
                            successMetricNames: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .successMetricNames,
                            unit: operation.canaryMetricDetails.canaryLatencyMetricDetails
                                .unit,
                        }, operation.service.defaultLatencyMetricDetails);
                    }
                    else if (operation.canaryTestLatencyMetricsOverride) {
                        defaultLatencyMetricDetails = new OperationMetricDetails_1.OperationMetricDetails({
                            operationName: operation.operationName,
                            metricNamespace: test.metricNamespace,
                            successMetricNames: ["SuccessLatency"],
                            faultMetricNames: ["FaultLatency"],
                            metricDimensions: new MetricDimensions_1.MetricDimensions({ Operation: operation.operationName }, "AZ-ID", "Region"),
                            alarmStatistic: operation.canaryTestLatencyMetricsOverride.alarmStatistic,
                            datapointsToAlarm: operation.canaryTestLatencyMetricsOverride.datapointsToAlarm,
                            evaluationPeriods: operation.canaryTestLatencyMetricsOverride.evaluationPeriods,
                            faultAlarmThreshold: operation.canaryTestLatencyMetricsOverride
                                .faultAlarmThreshold,
                            period: operation.canaryTestLatencyMetricsOverride.period,
                            successAlarmThreshold: operation.canaryTestLatencyMetricsOverride
                                .successAlarmThreshold,
                        }, props.service.defaultLatencyMetricDetails);
                    }
                    else {
                        defaultLatencyMetricDetails = new OperationMetricDetails_1.OperationMetricDetails({
                            operationName: operation.operationName,
                            metricNamespace: test.metricNamespace,
                            successMetricNames: ["SuccessLatency"],
                            faultMetricNames: ["FaultLatency"],
                            metricDimensions: new MetricDimensions_1.MetricDimensions({ Operation: operation.operationName }, "AZ-ID", "Region"),
                        }, props.service.defaultLatencyMetricDetails);
                    }
                    let newOperation = new Operation_1.Operation({
                        serverSideAvailabilityMetricDetails: operation.serverSideAvailabilityMetricDetails,
                        serverSideLatencyMetricDetails: operation.serverSideLatencyMetricDetails,
                        serverSideContributorInsightRuleDetails: operation.serverSideContributorInsightRuleDetails,
                        service: operation.service,
                        operationName: operation.operationName,
                        path: operation.path,
                        critical: operation.critical,
                        httpMethods: operation.httpMethods,
                        canaryMetricDetails: new CanaryMetrics_1.CanaryMetrics({
                            canaryAvailabilityMetricDetails: defaultAvailabilityMetricDetails,
                            canaryLatencyMetricDetails: defaultLatencyMetricDetails,
                        }),
                    });
                    props.service.operations[i] = newOperation;
                }
            }
        }
        if (props.outlierDetectionAlgorithm != OutlierDetectionAlgorithm_1.OutlierDetectionAlgorithm.STATIC) {
            let outlierDetectionStack = new StackWithDynamicSource_1.StackWithDynamicSource(this, "OutlierDetectionStack", {
                assetsBucketsParameterName: props.assetsBucketParameterName,
                assetsBucketPrefixParameterName: props.assetsBucketPrefixParameterName,
            });
            this.outlierDetectionFunction = new OutlierDetectionFunction_1.OutlierDetectionFunction(outlierDetectionStack, "OutlierDetectionFunction", {}).function;
        }
        this.perOperationAlarmsAndRules = Object.fromEntries(props.service.operations.map((operation) => {
            let nestedStack = new aws_cdk_lib_1.NestedStack(this, operation.operationName + "OperationAlarmsAndRulesNestedStack");
            return [
                operation.operationName,
                new OperationAlarmsAndRules_1.OperationAlarmsAndRules(nestedStack, operation.operationName, {
                    operation: operation,
                    outlierDetectionAlgorithm: props.outlierDetectionAlgorithm,
                    outlierThreshold: outlierThreshold,
                    loadBalancer: props.service.loadBalancer,
                    azMapper: this.azMapper,
                    outlierDetectionFunction: this.outlierDetectionFunction,
                }),
            ];
        }));
        this.perOperationZonalImpactAlarms = Object.fromEntries(Object.entries(this.perOperationAlarmsAndRules).map(([key, value]) => {
            return [key, value.aggregateZonalAlarmsMap];
        }));
        let serviceAlarmsStack = new aws_cdk_lib_1.NestedStack(this, "ServiceAlarmsNestedStack");
        this.serviceAlarms = new ServiceAlarmsAndRules_1.ServiceAlarmsAndRules(serviceAlarmsStack, props.service.serviceName, {
            perOperationAlarmsAndRules: this.perOperationAlarmsAndRules,
            service: props.service,
            azMapper: this.azMapper,
        });
        if (props.createDashboards) {
            this.operationDashboards = [];
            props.service.operations.forEach((x) => {
                let dashboardStack = new aws_cdk_lib_1.NestedStack(this, x.operationName + "Dashboard", {});
                if (this.operationDashboards) {
                    this.operationDashboards.push(new OperationAvailabilityAndLatencyDashboard_1.OperationAvailabilityAndLatencyDashboard(dashboardStack, x.operationName, {
                        operation: x,
                        azMapper: this.azMapper,
                        interval: props.interval
                            ? props.interval
                            : aws_cdk_lib_1.Duration.minutes(60),
                        loadBalancer: props.service.loadBalancer,
                        regionalEndpointCanaryAvailabilityAlarm: this.perOperationAlarmsAndRules[x.operationName]
                            .canaryRegionalAlarmsAndRules?.availabilityAlarm,
                        regionalEndpointCanaryLatencyAlarm: this.perOperationAlarmsAndRules[x.operationName]
                            .canaryRegionalAlarmsAndRules?.latencyAlarm,
                        regionalEndpointServerAvailabilityAlarm: this.perOperationAlarmsAndRules[x.operationName]
                            .serverSideRegionalAlarmsAndRules.availabilityAlarm,
                        regionalEndpointServerLatencyAlarm: this.perOperationAlarmsAndRules[x.operationName]
                            .serverSideRegionalAlarmsAndRules.latencyAlarm,
                        zonalEndpointCanaryAvailabilityAlarms: this.perOperationAlarmsAndRules[x.operationName].canaryZonalAlarmsAndRules?.map((a) => a.availabilityAlarm),
                        zonalEndpointCanaryLatencyAlarms: this.perOperationAlarmsAndRules[x.operationName].canaryZonalAlarmsAndRules?.map((a) => a.latencyAlarm),
                        zonalEndpointServerAvailabilityAlarms: this.perOperationAlarmsAndRules[x.operationName].serverSideZonalAlarmsAndRules.map((a) => a.availabilityAlarm),
                        zonalEndpointServerLatencyAlarms: this.perOperationAlarmsAndRules[x.operationName].serverSideZonalAlarmsAndRules.map((a) => a.latencyAlarm),
                        isolatedAZImpactAlarms: this.perOperationAlarmsAndRules[x.operationName]
                            .aggregateZonalAlarms,
                        regionalImpactAlarm: this.perOperationAlarmsAndRules[x.operationName]
                            .aggregateRegionalAlarm,
                        instanceContributorsToFaults: this.perOperationAlarmsAndRules[x.operationName]
                            .serverSideRegionalAlarmsAndRules
                            .instanceContributorsToRegionalFaults,
                        instanceContributorsToHighLatency: this.perOperationAlarmsAndRules[x.operationName]
                            .serverSideRegionalAlarmsAndRules
                            .instanceContributorsToRegionalHighLatency,
                    }).dashboard);
                }
            });
            let dashboardStack = new aws_cdk_lib_1.NestedStack(this, "ServiceDashboard", {});
            this.serviceDashboard = new ServiceAvailabilityAndLatencyDashboard_1.ServiceAvailabilityAndLatencyDashboard(dashboardStack, props.service.serviceName.toLowerCase(), {
                interval: props.interval ? props.interval : aws_cdk_lib_1.Duration.minutes(60),
                service: props.service,
                aggregateRegionalAlarm: this.serviceAlarms.regionalFaultCountServerSideAlarm,
                zonalAggregateAlarms: this.serviceAlarms.zonalAggregateIsolatedImpactAlarms,
                azMapper: this.azMapper,
            }).dashboard;
        }
    }
}
exports.InstrumentedServiceMultiAZObservability = InstrumentedServiceMultiAZObservability;
_a = JSII_RTTI_SYMBOL_1;
InstrumentedServiceMultiAZObservability[_a] = { fqn: "multi-az-observability.InstrumentedServiceMultiAZObservability", version: "0.0.1-alpha.10" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSW5zdHJ1bWVudGVkU2VydmljZU11bHRpQVpPYnNlcnZhYmlsaXR5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3NlcnZpY2VzL0luc3RydW1lbnRlZFNlcnZpY2VNdWx0aUFaT2JzZXJ2YWJpbGl0eS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFvRDtBQUlwRCwyQ0FBdUM7QUFDdkMsbURBQWdEO0FBSWhELDJDQUF3QztBQUN4QyxxRUFBa0U7QUFFbEUsK0RBQTREO0FBRzVELHVGQUFvRjtBQUNwRixtRkFBZ0Y7QUFDaEYsK0VBQTRFO0FBQzVFLCtEQUE0RDtBQUM1RCx1REFBb0Q7QUFFcEQscUhBQWtIO0FBQ2xILGlIQUE4RztBQUM5Ryw0RkFBeUY7QUFDekYsc0ZBQW1GO0FBQ25GLGdGQUE2RTtBQUU3RTs7OztHQUlHO0FBQ0gsTUFBYSx1Q0FDWCxTQUFRLHNCQUFTO0lBb0RqQixZQUNFLEtBQWdCLEVBQ2hCLEVBQVUsRUFDVixLQUFtRDtRQUVuRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksZ0JBQXdCLENBQUM7UUFFN0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQzVCLFFBQVEsS0FBSyxDQUFDLHlCQUF5QixFQUFFLENBQUM7Z0JBQ3hDLEtBQUsscURBQXlCLENBQUMsV0FBVztvQkFDeEMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDO29CQUN4QixNQUFNO2dCQUNSLEtBQUsscURBQXlCLENBQUMsR0FBRztvQkFDaEMsZ0JBQWdCLEdBQUcsR0FBRyxDQUFDO29CQUN2QixNQUFNO2dCQUNSLEtBQUsscURBQXlCLENBQUMsR0FBRztvQkFDaEMsZ0JBQWdCLEdBQUcsQ0FBQyxDQUFDO29CQUNyQixNQUFNO2dCQUNSLEtBQUsscURBQXlCLENBQUMsTUFBTTtvQkFDbkMsZ0JBQWdCLEdBQUcsR0FBRyxDQUFDO29CQUN2QixNQUFNO2dCQUNSLEtBQUsscURBQXlCLENBQUMsT0FBTztvQkFDcEMsZ0JBQWdCLEdBQUcsQ0FBQyxDQUFDO29CQUNyQixNQUFNO1lBQ1YsQ0FBQztRQUNILENBQUM7YUFBTSxDQUFDO1lBQ04sZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQzVDLENBQUM7UUFFRCxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksK0NBQXNCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUMzRCxxQkFBcUIsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLHFCQUFxQjtTQUMzRCxDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsZUFBZSxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQ2hELElBQUksV0FBVyxHQUEyQixJQUFJLCtDQUFzQixDQUNsRSxJQUFJLEVBQ0osUUFBUSxFQUNSO2dCQUNFLDBCQUEwQixFQUFFLEtBQUssQ0FBQyx5QkFBeUI7Z0JBQzNELCtCQUErQixFQUM3QixLQUFLLENBQUMsK0JBQStCO2FBQ3hDLENBQ0YsQ0FBQztZQUVGLElBQUksTUFBTSxHQUFHLElBQUksK0JBQWMsQ0FBQyxXQUFXLEVBQUUsZ0JBQWdCLEVBQUU7Z0JBQzdELEdBQUcsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHO2dCQUM1RCxlQUFlLEVBQ2IsS0FBSyxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsb0JBQW9CLEVBQUUsZUFBZTtnQkFDckUsV0FBVyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLE9BQU87b0JBQ2hELENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxPQUFPO29CQUN2QyxDQUFDLENBQUMsc0JBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO2dCQUN2QixlQUFlLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsZUFBZTtvQkFDNUQsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLGVBQWU7b0JBQy9DLENBQUMsQ0FBQyxLQUFLO2FBQ1YsQ0FBQyxDQUFDO1lBRUgsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1lBRXRDLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQztnQkFDekQsSUFBSSxTQUFTLEdBQWUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7Z0JBRXhELElBQUksU0FBUyxDQUFDLDRCQUE0QixJQUFJLElBQUksRUFBRSxDQUFDO29CQUNuRCxJQUFJLFNBQVMsR0FBdUIsU0FBUyxDQUFDLGVBQWU7d0JBQzNELENBQUMsQ0FBQyxTQUFTLENBQUMsZUFBZTt3QkFDM0IsQ0FBQyxDQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsZUFBc0MsQ0FBQztvQkFFMUQsSUFBSSxXQUFXLEdBQWdCLElBQUkseUJBQVcsQ0FDNUMsSUFBSSxFQUNKLFNBQVMsQ0FBQyxhQUFhLEdBQUcsWUFBWSxFQUN0QyxFQUFFLENBQ0gsQ0FBQztvQkFFRixJQUFJLElBQUksR0FBRyxJQUFJLHVCQUFVLENBQUMsV0FBVyxFQUFFLFNBQVMsQ0FBQyxhQUFhLEVBQUU7d0JBQzlELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTt3QkFDekIsWUFBWSxFQUFFLFNBQVMsQ0FBQyxZQUFZO3dCQUNwQyxvQkFBb0IsRUFBRSxTQUFTLENBQUMsb0JBQW9COzRCQUNsRCxDQUFDLENBQUMsU0FBUyxDQUFDLG9CQUFvQjs0QkFDaEMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxZQUFZO3dCQUMxQixRQUFRLEVBQUUsU0FBUyxDQUFDLFFBQVE7d0JBQzVCLFNBQVMsRUFBRSxTQUFTO3dCQUNwQixZQUFZLEVBQUUsU0FBUyxDQUFDLFlBQVk7d0JBQ3BDLE9BQU8sRUFBRSxTQUFTLENBQUMsT0FBTzt3QkFDMUIsUUFBUSxFQUFFLFNBQVMsQ0FBQyxRQUFRO3dCQUM1QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7cUJBQ3hCLENBQUMsQ0FBQztvQkFFSCxJQUFJLGdDQUF5RCxDQUFDO29CQUM5RCxJQUFJLDJCQUFvRCxDQUFDO29CQUV6RCxJQUFJLFNBQVMsQ0FBQyxtQkFBbUIsRUFBRSwrQkFBK0IsRUFBRSxDQUFDO3dCQUNuRSxnQ0FBZ0MsR0FBRyxJQUFJLCtDQUFzQixDQUMzRDs0QkFDRSxhQUFhLEVBQUUsU0FBUyxDQUFDLGFBQWE7NEJBQ3RDLGdCQUFnQixFQUFFLElBQUksbUNBQWdCLENBQ3BDLEVBQUUsU0FBUyxFQUFFLFNBQVMsQ0FBQyxhQUFhLEVBQUUsRUFDdEMsT0FBTyxFQUNQLFFBQVEsQ0FDVDs0QkFDRCxjQUFjLEVBQ1osU0FBUyxDQUFDLG1CQUFtQixDQUFDLCtCQUErQjtpQ0FDMUQsY0FBYzs0QkFDbkIsaUJBQWlCLEVBQ2YsU0FBUyxDQUFDLG1CQUFtQixDQUFDLCtCQUErQjtpQ0FDMUQsaUJBQWlCOzRCQUN0QixpQkFBaUIsRUFDZixTQUFTLENBQUMsbUJBQW1CLENBQUMsK0JBQStCO2lDQUMxRCxpQkFBaUI7NEJBQ3RCLG1CQUFtQixFQUNqQixTQUFTLENBQUMsbUJBQW1CLENBQUMsK0JBQStCO2lDQUMxRCxtQkFBbUI7NEJBQ3hCLGdCQUFnQixFQUNkLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQywrQkFBK0I7aUNBQzFELGdCQUFnQjs0QkFDckIsc0JBQXNCLEVBQ3BCLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQywrQkFBK0I7aUNBQzFELHNCQUFzQjs0QkFDM0Isd0JBQXdCLEVBQ3RCLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQywrQkFBK0I7aUNBQzFELHdCQUF3Qjs0QkFDN0IsZUFBZSxFQUNiLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQywrQkFBK0I7aUNBQzFELGVBQWU7NEJBQ3BCLE1BQU0sRUFDSixTQUFTLENBQUMsbUJBQW1CLENBQUMsK0JBQStCO2lDQUMxRCxNQUFNOzRCQUNYLHFCQUFxQixFQUNuQixTQUFTLENBQUMsbUJBQW1CLENBQUMsK0JBQStCO2lDQUMxRCxxQkFBcUI7NEJBQzFCLGtCQUFrQixFQUNoQixTQUFTLENBQUMsbUJBQW1CLENBQUMsK0JBQStCO2lDQUMxRCxrQkFBa0I7NEJBQ3ZCLElBQUksRUFBRSxTQUFTLENBQUMsbUJBQW1CO2lDQUNoQywrQkFBK0IsQ0FBQyxJQUFJO3lCQUN4QyxFQUNELFNBQVMsQ0FBQyxPQUFPLENBQUMsZ0NBQWdDLENBQ25ELENBQUM7b0JBQ0osQ0FBQzt5QkFBTSxJQUFJLFNBQVMsQ0FBQyxxQ0FBcUMsRUFBRSxDQUFDO3dCQUMzRCxnQ0FBZ0MsR0FBRyxJQUFJLCtDQUFzQixDQUMzRDs0QkFDRSxhQUFhLEVBQUUsU0FBUyxDQUFDLGFBQWE7NEJBQ3RDLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTs0QkFDckMsa0JBQWtCLEVBQUUsQ0FBQyxTQUFTLENBQUM7NEJBQy9CLGdCQUFnQixFQUFFLENBQUMsT0FBTyxFQUFFLFNBQVMsQ0FBQzs0QkFDdEMsZ0JBQWdCLEVBQUUsSUFBSSxtQ0FBZ0IsQ0FDcEMsRUFBRSxTQUFTLEVBQUUsU0FBUyxDQUFDLGFBQWEsRUFBRSxFQUN0QyxPQUFPLEVBQ1AsUUFBUSxDQUNUOzRCQUVELGNBQWMsRUFDWixTQUFTLENBQUMscUNBQXFDO2lDQUM1QyxjQUFjOzRCQUNuQixpQkFBaUIsRUFDZixTQUFTLENBQUMscUNBQXFDO2lDQUM1QyxpQkFBaUI7NEJBQ3RCLGlCQUFpQixFQUNmLFNBQVMsQ0FBQyxxQ0FBcUM7aUNBQzVDLGlCQUFpQjs0QkFDdEIsbUJBQW1CLEVBQ2pCLFNBQVMsQ0FBQyxxQ0FBcUM7aUNBQzVDLG1CQUFtQjs0QkFDeEIsTUFBTSxFQUFFLFNBQVMsQ0FBQyxxQ0FBcUMsQ0FBQyxNQUFNOzRCQUM5RCxxQkFBcUIsRUFDbkIsU0FBUyxDQUFDLHFDQUFxQztpQ0FDNUMscUJBQXFCO3lCQUMzQixFQUNELEtBQUssQ0FBQyxPQUFPLENBQUMsZ0NBQWdDLENBQy9DLENBQUM7b0JBQ0osQ0FBQzt5QkFBTSxDQUFDO3dCQUNOLGdDQUFnQyxHQUFHLElBQUksK0NBQXNCLENBQzNEOzRCQUNFLGFBQWEsRUFBRSxTQUFTLENBQUMsYUFBYTs0QkFDdEMsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlOzRCQUNyQyxrQkFBa0IsRUFBRSxDQUFDLFNBQVMsQ0FBQzs0QkFDL0IsZ0JBQWdCLEVBQUUsQ0FBQyxPQUFPLEVBQUUsU0FBUyxDQUFDOzRCQUN0QyxnQkFBZ0IsRUFBRSxJQUFJLG1DQUFnQixDQUNwQyxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsYUFBYSxFQUFFLEVBQ3RDLE9BQU8sRUFDUCxRQUFRLENBQ1Q7eUJBQ0YsRUFDRCxLQUFLLENBQUMsT0FBTyxDQUFDLGdDQUFnQyxDQUMvQyxDQUFDO29CQUNKLENBQUM7b0JBRUQsSUFBSSxTQUFTLENBQUMsbUJBQW1CLEVBQUUsMEJBQTBCLEVBQUUsQ0FBQzt3QkFDOUQsMkJBQTJCLEdBQUcsSUFBSSwrQ0FBc0IsQ0FDdEQ7NEJBQ0UsYUFBYSxFQUFFLFNBQVMsQ0FBQyxhQUFhOzRCQUN0QyxnQkFBZ0IsRUFBRSxJQUFJLG1DQUFnQixDQUNwQyxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsYUFBYSxFQUFFLEVBQ3RDLE9BQU8sRUFDUCxRQUFRLENBQ1Q7NEJBQ0QsY0FBYyxFQUNaLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQywwQkFBMEI7aUNBQ3JELGNBQWM7NEJBQ25CLGlCQUFpQixFQUNmLFNBQVMsQ0FBQyxtQkFBbUIsQ0FBQywwQkFBMEI7aUNBQ3JELGlCQUFpQjs0QkFDdEIsaUJBQWlCLEVBQ2YsU0FBUyxDQUFDLG1CQUFtQixDQUFDLDBCQUEwQjtpQ0FDckQsaUJBQWlCOzRCQUN0QixtQkFBbUIsRUFDakIsU0FBUyxDQUFDLG1CQUFtQixDQUFDLDBCQUEwQjtpQ0FDckQsbUJBQW1COzRCQUN4QixnQkFBZ0IsRUFDZCxTQUFTLENBQUMsbUJBQW1CLENBQUMsMEJBQTBCO2lDQUNyRCxnQkFBZ0I7NEJBQ3JCLHNCQUFzQixFQUNwQixTQUFTLENBQUMsbUJBQW1CLENBQUMsMEJBQTBCO2lDQUNyRCxzQkFBc0I7NEJBQzNCLHdCQUF3QixFQUN0QixTQUFTLENBQUMsbUJBQW1CLENBQUMsMEJBQTBCO2lDQUNyRCx3QkFBd0I7NEJBQzdCLGVBQWUsRUFDYixTQUFTLENBQUMsbUJBQW1CLENBQUMsMEJBQTBCO2lDQUNyRCxlQUFlOzRCQUNwQixNQUFNLEVBQ0osU0FBUyxDQUFDLG1CQUFtQixDQUFDLDBCQUEwQjtpQ0FDckQsTUFBTTs0QkFDWCxxQkFBcUIsRUFDbkIsU0FBUyxDQUFDLG1CQUFtQixDQUFDLDBCQUEwQjtpQ0FDckQscUJBQXFCOzRCQUMxQixrQkFBa0IsRUFDaEIsU0FBUyxDQUFDLG1CQUFtQixDQUFDLDBCQUEwQjtpQ0FDckQsa0JBQWtCOzRCQUN2QixJQUFJLEVBQUUsU0FBUyxDQUFDLG1CQUFtQixDQUFDLDBCQUEwQjtpQ0FDM0QsSUFBSTt5QkFDUixFQUNELFNBQVMsQ0FBQyxPQUFPLENBQUMsMkJBQTJCLENBQzlDLENBQUM7b0JBQ0osQ0FBQzt5QkFBTSxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBRSxDQUFDO3dCQUN0RCwyQkFBMkIsR0FBRyxJQUFJLCtDQUFzQixDQUN0RDs0QkFDRSxhQUFhLEVBQUUsU0FBUyxDQUFDLGFBQWE7NEJBQ3RDLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTs0QkFDckMsa0JBQWtCLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQzs0QkFDdEMsZ0JBQWdCLEVBQUUsQ0FBQyxjQUFjLENBQUM7NEJBQ2xDLGdCQUFnQixFQUFFLElBQUksbUNBQWdCLENBQ3BDLEVBQUUsU0FBUyxFQUFFLFNBQVMsQ0FBQyxhQUFhLEVBQUUsRUFDdEMsT0FBTyxFQUNQLFFBQVEsQ0FDVDs0QkFFRCxjQUFjLEVBQ1osU0FBUyxDQUFDLGdDQUFnQyxDQUFDLGNBQWM7NEJBQzNELGlCQUFpQixFQUNmLFNBQVMsQ0FBQyxnQ0FBZ0MsQ0FBQyxpQkFBaUI7NEJBQzlELGlCQUFpQixFQUNmLFNBQVMsQ0FBQyxnQ0FBZ0MsQ0FBQyxpQkFBaUI7NEJBQzlELG1CQUFtQixFQUNqQixTQUFTLENBQUMsZ0NBQWdDO2lDQUN2QyxtQkFBbUI7NEJBQ3hCLE1BQU0sRUFBRSxTQUFTLENBQUMsZ0NBQWdDLENBQUMsTUFBTTs0QkFDekQscUJBQXFCLEVBQ25CLFNBQVMsQ0FBQyxnQ0FBZ0M7aUNBQ3ZDLHFCQUFxQjt5QkFDM0IsRUFDRCxLQUFLLENBQUMsT0FBTyxDQUFDLDJCQUEyQixDQUMxQyxDQUFDO29CQUNKLENBQUM7eUJBQU0sQ0FBQzt3QkFDTiwyQkFBMkIsR0FBRyxJQUFJLCtDQUFzQixDQUN0RDs0QkFDRSxhQUFhLEVBQUUsU0FBUyxDQUFDLGFBQWE7NEJBQ3RDLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTs0QkFDckMsa0JBQWtCLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQzs0QkFDdEMsZ0JBQWdCLEVBQUUsQ0FBQyxjQUFjLENBQUM7NEJBQ2xDLGdCQUFnQixFQUFFLElBQUksbUNBQWdCLENBQ3BDLEVBQUUsU0FBUyxFQUFFLFNBQVMsQ0FBQyxhQUFhLEVBQUUsRUFDdEMsT0FBTyxFQUNQLFFBQVEsQ0FDVDt5QkFDRixFQUNELEtBQUssQ0FBQyxPQUFPLENBQUMsMkJBQTJCLENBQzFDLENBQUM7b0JBQ0osQ0FBQztvQkFFRCxJQUFJLFlBQVksR0FBRyxJQUFJLHFCQUFTLENBQUM7d0JBQy9CLG1DQUFtQyxFQUNqQyxTQUFTLENBQUMsbUNBQW1DO3dCQUMvQyw4QkFBOEIsRUFDNUIsU0FBUyxDQUFDLDhCQUE4Qjt3QkFDMUMsdUNBQXVDLEVBQ3JDLFNBQVMsQ0FBQyx1Q0FBdUM7d0JBQ25ELE9BQU8sRUFBRSxTQUFTLENBQUMsT0FBTzt3QkFDMUIsYUFBYSxFQUFFLFNBQVMsQ0FBQyxhQUFhO3dCQUN0QyxJQUFJLEVBQUUsU0FBUyxDQUFDLElBQUk7d0JBQ3BCLFFBQVEsRUFBRSxTQUFTLENBQUMsUUFBUTt3QkFDNUIsV0FBVyxFQUFFLFNBQVMsQ0FBQyxXQUFXO3dCQUNsQyxtQkFBbUIsRUFBRSxJQUFJLDZCQUFhLENBQUM7NEJBQ3JDLCtCQUErQixFQUFFLGdDQUFnQzs0QkFDakUsMEJBQTBCLEVBQUUsMkJBQTJCO3lCQUN4RCxDQUFDO3FCQUNILENBQUMsQ0FBQztvQkFFSCxLQUFLLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsR0FBRyxZQUFZLENBQUM7Z0JBQzdDLENBQUM7WUFDSCxDQUFDO1FBQ0gsQ0FBQztRQUVELElBQUksS0FBSyxDQUFDLHlCQUF5QixJQUFJLHFEQUF5QixDQUFDLE1BQU0sRUFBRSxDQUFDO1lBQ3hFLElBQUkscUJBQXFCLEdBQ3ZCLElBQUksK0NBQXNCLENBQUMsSUFBSSxFQUFFLHVCQUF1QixFQUFFO2dCQUN4RCwwQkFBMEIsRUFBRSxLQUFLLENBQUMseUJBQXlCO2dCQUMzRCwrQkFBK0IsRUFDN0IsS0FBSyxDQUFDLCtCQUErQjthQUN4QyxDQUFDLENBQUM7WUFFTCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsSUFBSSxtREFBd0IsQ0FDMUQscUJBQXFCLEVBQ3JCLDBCQUEwQixFQUMxQixFQUFFLENBQ0gsQ0FBQyxRQUFRLENBQUM7UUFDYixDQUFDO1FBRUQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQ2xELEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFNBQXFCLEVBQUUsRUFBRTtZQUNyRCxJQUFJLFdBQVcsR0FBZ0IsSUFBSSx5QkFBVyxDQUM1QyxJQUFJLEVBQ0osU0FBUyxDQUFDLGFBQWEsR0FBRyxvQ0FBb0MsQ0FDL0QsQ0FBQztZQUVGLE9BQU87Z0JBQ0wsU0FBUyxDQUFDLGFBQWE7Z0JBQ3ZCLElBQUksaURBQXVCLENBQUMsV0FBVyxFQUFFLFNBQVMsQ0FBQyxhQUFhLEVBQUU7b0JBQ2hFLFNBQVMsRUFBRSxTQUFTO29CQUNwQix5QkFBeUIsRUFBRSxLQUFLLENBQUMseUJBQXlCO29CQUMxRCxnQkFBZ0IsRUFBRSxnQkFBZ0I7b0JBQ2xDLFlBQVksRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFlBQVk7b0JBQ3hDLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtvQkFDdkIsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLHdCQUF3QjtpQkFDeEQsQ0FBQzthQUNILENBQUM7UUFDSixDQUFDLENBQUMsQ0FDSCxDQUFDO1FBRUYsSUFBSSxDQUFDLDZCQUE2QixHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQ3JELE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLDBCQUEwQixDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLEVBQUUsRUFBRTtZQUNuRSxPQUFPLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQzlDLENBQUMsQ0FBQyxDQUNILENBQUM7UUFFRixJQUFJLGtCQUFrQixHQUFnQixJQUFJLHlCQUFXLENBQ25ELElBQUksRUFDSiwwQkFBMEIsQ0FDM0IsQ0FBQztRQUVGLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSw2Q0FBcUIsQ0FDNUMsa0JBQWtCLEVBQ2xCLEtBQUssQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUN6QjtZQUNFLDBCQUEwQixFQUFFLElBQUksQ0FBQywwQkFBMEI7WUFDM0QsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtTQUN4QixDQUNGLENBQUM7UUFFRixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1lBQzNCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxFQUFFLENBQUM7WUFFOUIsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUU7Z0JBQ3JDLElBQUksY0FBYyxHQUFnQixJQUFJLHlCQUFXLENBQy9DLElBQUksRUFDSixDQUFDLENBQUMsYUFBYSxHQUFHLFdBQVcsRUFDN0IsRUFBRSxDQUNILENBQUM7Z0JBRUYsSUFBSSxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztvQkFDN0IsSUFBSSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FDM0IsSUFBSSxtRkFBd0MsQ0FDMUMsY0FBYyxFQUNkLENBQUMsQ0FBQyxhQUFhLEVBQ2Y7d0JBQ0UsU0FBUyxFQUFFLENBQUM7d0JBQ1osUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO3dCQUN2QixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7NEJBQ3RCLENBQUMsQ0FBQyxLQUFLLENBQUMsUUFBUTs0QkFDaEIsQ0FBQyxDQUFDLHNCQUFRLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQzt3QkFDeEIsWUFBWSxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsWUFBWTt3QkFFeEMsdUNBQXVDLEVBQ3JDLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUMsYUFBYSxDQUFDOzZCQUM3Qyw0QkFBNEIsRUFBRSxpQkFBaUI7d0JBRXBELGtDQUFrQyxFQUNoQyxJQUFJLENBQUMsMEJBQTBCLENBQUMsQ0FBQyxDQUFDLGFBQWEsQ0FBQzs2QkFDN0MsNEJBQTRCLEVBQUUsWUFBWTt3QkFFL0MsdUNBQXVDLEVBQ3JDLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUMsYUFBYSxDQUFDOzZCQUM3QyxnQ0FBZ0MsQ0FBQyxpQkFBaUI7d0JBRXZELGtDQUFrQyxFQUNoQyxJQUFJLENBQUMsMEJBQTBCLENBQUMsQ0FBQyxDQUFDLGFBQWEsQ0FBQzs2QkFDN0MsZ0NBQWdDLENBQUMsWUFBWTt3QkFFbEQscUNBQXFDLEVBQ25DLElBQUksQ0FBQywwQkFBMEIsQ0FDN0IsQ0FBQyxDQUFDLGFBQWEsQ0FDaEIsQ0FBQyx5QkFBeUIsRUFBRSxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxpQkFBaUIsQ0FBQzt3QkFFOUQsZ0NBQWdDLEVBQzlCLElBQUksQ0FBQywwQkFBMEIsQ0FDN0IsQ0FBQyxDQUFDLGFBQWEsQ0FDaEIsQ0FBQyx5QkFBeUIsRUFBRSxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxZQUFZLENBQUM7d0JBRXpELHFDQUFxQyxFQUNuQyxJQUFJLENBQUMsMEJBQTBCLENBQzdCLENBQUMsQ0FBQyxhQUFhLENBQ2hCLENBQUMsNkJBQTZCLENBQUMsR0FBRyxDQUNqQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLGlCQUFpQixDQUMzQjt3QkFFSCxnQ0FBZ0MsRUFDOUIsSUFBSSxDQUFDLDBCQUEwQixDQUM3QixDQUFDLENBQUMsYUFBYSxDQUNoQixDQUFDLDZCQUE2QixDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQzt3QkFFNUQsc0JBQXNCLEVBQ3BCLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxDQUFDLENBQUMsYUFBYSxDQUFDOzZCQUM3QyxvQkFBb0I7d0JBRXpCLG1CQUFtQixFQUNqQixJQUFJLENBQUMsMEJBQTBCLENBQUMsQ0FBQyxDQUFDLGFBQWEsQ0FBQzs2QkFDN0Msc0JBQXNCO3dCQUUzQiw0QkFBNEIsRUFDMUIsSUFBSSxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQyxhQUFhLENBQUM7NkJBQzdDLGdDQUFnQzs2QkFDaEMsb0NBQW9DO3dCQUV6QyxpQ0FBaUMsRUFDL0IsSUFBSSxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQyxhQUFhLENBQUM7NkJBQzdDLGdDQUFnQzs2QkFDaEMseUNBQXlDO3FCQUMvQyxDQUNGLENBQUMsU0FBUyxDQUNaLENBQUM7Z0JBQ0osQ0FBQztZQUNILENBQUMsQ0FBQyxDQUFDO1lBRUgsSUFBSSxjQUFjLEdBQWdCLElBQUkseUJBQVcsQ0FDL0MsSUFBSSxFQUNKLGtCQUFrQixFQUNsQixFQUFFLENBQ0gsQ0FBQztZQUVGLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLCtFQUFzQyxDQUNoRSxjQUFjLEVBQ2QsS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsV0FBVyxFQUFFLEVBQ3ZDO2dCQUNFLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxzQkFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7Z0JBQ2hFLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztnQkFDdEIsc0JBQXNCLEVBQ3BCLElBQUksQ0FBQyxhQUFhLENBQUMsaUNBQWlDO2dCQUN0RCxvQkFBb0IsRUFDbEIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxrQ0FBa0M7Z0JBQ3ZELFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTthQUN4QixDQUNGLENBQUMsU0FBUyxDQUFDO1FBQ2QsQ0FBQztJQUNILENBQUM7O0FBcmdCSCwwRkFzZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRHVyYXRpb24sIE5lc3RlZFN0YWNrIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgeyBEYXNoYm9hcmQsIElBbGFybSB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaFwiO1xuaW1wb3J0IHsgSUZ1bmN0aW9uIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1sYW1iZGFcIjtcbmltcG9ydCB7IElMb2dHcm91cCB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtbG9nc1wiO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IENhbmFyeU1ldHJpY3MgfSBmcm9tIFwiLi9DYW5hcnlNZXRyaWNzXCI7XG5pbXBvcnQgeyBJSW5zdHJ1bWVudGVkU2VydmljZU11bHRpQVpPYnNlcnZhYmlsaXR5IH0gZnJvbSBcIi4vSUluc3RydW1lbnRlZFNlcnZpY2VNdWx0aUFaT2JzZXJ2YWJpbGl0eVwiO1xuaW1wb3J0IHsgSU9wZXJhdGlvbiB9IGZyb20gXCIuL0lPcGVyYXRpb25cIjtcbmltcG9ydCB7IElPcGVyYXRpb25NZXRyaWNEZXRhaWxzIH0gZnJvbSBcIi4vSU9wZXJhdGlvbk1ldHJpY0RldGFpbHNcIjtcbmltcG9ydCB7IE9wZXJhdGlvbiB9IGZyb20gXCIuL09wZXJhdGlvblwiO1xuaW1wb3J0IHsgT3BlcmF0aW9uTWV0cmljRGV0YWlscyB9IGZyb20gXCIuL09wZXJhdGlvbk1ldHJpY0RldGFpbHNcIjtcbmltcG9ydCB7IEluc3RydW1lbnRlZFNlcnZpY2VNdWx0aUFaT2JzZXJ2YWJpbGl0eVByb3BzIH0gZnJvbSBcIi4vcHJvcHMvSW5zdHJ1bWVudGVkU2VydmljZU11bHRpQVpPYnNlcnZhYmlsaXR5UHJvcHNcIjtcbmltcG9ydCB7IE1ldHJpY0RpbWVuc2lvbnMgfSBmcm9tIFwiLi9wcm9wcy9NZXRyaWNEaW1lbnNpb25zXCI7XG5pbXBvcnQgeyBJT3BlcmF0aW9uQWxhcm1zQW5kUnVsZXMgfSBmcm9tIFwiLi4vYWxhcm1zYW5kcnVsZXMvSU9wZXJhdGlvbkFsYXJtc0FuZFJ1bGVzXCI7XG5pbXBvcnQgeyBJU2VydmljZUFsYXJtc0FuZFJ1bGVzIH0gZnJvbSBcIi4uL2FsYXJtc2FuZHJ1bGVzL0lTZXJ2aWNlQWxhcm1zQW5kUnVsZXNcIjtcbmltcG9ydCB7IE9wZXJhdGlvbkFsYXJtc0FuZFJ1bGVzIH0gZnJvbSBcIi4uL2FsYXJtc2FuZHJ1bGVzL09wZXJhdGlvbkFsYXJtc0FuZFJ1bGVzXCI7XG5pbXBvcnQgeyBTZXJ2aWNlQWxhcm1zQW5kUnVsZXMgfSBmcm9tIFwiLi4vYWxhcm1zYW5kcnVsZXMvU2VydmljZUFsYXJtc0FuZFJ1bGVzXCI7XG5pbXBvcnQgeyBBdmFpbGFiaWxpdHlab25lTWFwcGVyIH0gZnJvbSBcIi4uL2F6bWFwcGVyL0F2YWlsYWJpbGl0eVpvbmVNYXBwZXJcIjtcbmltcG9ydCB7IENhbmFyeUZ1bmN0aW9uIH0gZnJvbSBcIi4uL2NhbmFyaWVzL0NhbmFyeUZ1bmN0aW9uXCI7XG5pbXBvcnQgeyBDYW5hcnlUZXN0IH0gZnJvbSBcIi4uL2NhbmFyaWVzL0NhbmFyeVRlc3RcIjtcbmltcG9ydCB7IEFkZENhbmFyeVRlc3RQcm9wcyB9IGZyb20gXCIuLi9jYW5hcmllcy9wcm9wcy9BZGRDYW5hcnlUZXN0UHJvcHNcIjtcbmltcG9ydCB7IE9wZXJhdGlvbkF2YWlsYWJpbGl0eUFuZExhdGVuY3lEYXNoYm9hcmQgfSBmcm9tIFwiLi4vZGFzaGJvYXJkcy9PcGVyYXRpb25BdmFpbGFiaWxpdHlBbmRMYXRlbmN5RGFzaGJvYXJkXCI7XG5pbXBvcnQgeyBTZXJ2aWNlQXZhaWxhYmlsaXR5QW5kTGF0ZW5jeURhc2hib2FyZCB9IGZyb20gXCIuLi9kYXNoYm9hcmRzL1NlcnZpY2VBdmFpbGFiaWxpdHlBbmRMYXRlbmN5RGFzaGJvYXJkXCI7XG5pbXBvcnQgeyBPdXRsaWVyRGV0ZWN0aW9uRnVuY3Rpb24gfSBmcm9tIFwiLi4vb3V0bGllci1kZXRlY3Rpb24vT3V0bGllckRldGVjdGlvbkZ1bmN0aW9uXCI7XG5pbXBvcnQgeyBPdXRsaWVyRGV0ZWN0aW9uQWxnb3JpdGhtIH0gZnJvbSBcIi4uL3V0aWxpdGllcy9PdXRsaWVyRGV0ZWN0aW9uQWxnb3JpdGhtXCI7XG5pbXBvcnQgeyBTdGFja1dpdGhEeW5hbWljU291cmNlIH0gZnJvbSBcIi4uL3V0aWxpdGllcy9TdGFja1dpdGhEeW5hbWljU291cmNlXCI7XG5cbi8qKlxuICogQW4gc2VydmljZSB0aGF0IGltcGxlbWVudHMgaXRzIG93biBpbnN0cnVtZW50YXRpb24gdG8gcmVjb3JkXG4gKiBhdmFpbGFiaWxpdHkgYW5kIGxhdGVuY3kgbWV0cmljcyB0aGF0IGNhbiBiZSB1c2VkIHRvIGNyZWF0ZVxuICogYWxhcm1zLCBydWxlcywgYW5kIGRhc2hib2FyZHMgZnJvbVxuICovXG5leHBvcnQgY2xhc3MgSW5zdHJ1bWVudGVkU2VydmljZU11bHRpQVpPYnNlcnZhYmlsaXR5XG4gIGV4dGVuZHMgQ29uc3RydWN0XG4gIGltcGxlbWVudHMgSUluc3RydW1lbnRlZFNlcnZpY2VNdWx0aUFaT2JzZXJ2YWJpbGl0eVxue1xuICAvKipcbiAgICogS2V5IHJlcHJlc2VudHMgdGhlIG9wZXJhdGlvbiBuYW1lIGFuZCB0aGUgdmFsdWUgaXMgdGhlIHNldFxuICAgKiBvZiB6b25hbCBhbGFybXMgYW5kIHJ1bGVzIGZvciB0aGF0IG9wZXJhdGlvbi4gVGhlIHZhbHVlcyB0aGVtc2VsdmVzXG4gICAqIGFyZSBkaWN0aW9uYXJpZXMgdGhhdCBoYXZlIGEga2V5IGZvciBlYWNoIEFaIElELlxuICAgKi9cbiAgcHJpdmF0ZSByZWFkb25seSBwZXJPcGVyYXRpb25BbGFybXNBbmRSdWxlczoge1xuICAgIFtrZXk6IHN0cmluZ106IElPcGVyYXRpb25BbGFybXNBbmRSdWxlcztcbiAgfTtcblxuICAvKipcbiAgICogSW5kZXggaW50byB0aGUgZGljdGlvbmFyeSBieSBvcGVyYXRpb24gbmFtZSwgdGhlbiBieSBBdmFpbGFiaWxpdHkgWm9uZSBJZFxuICAgKiB0byBnZXQgdGhlIGFsYXJtcyB0aGF0IGluZGljYXRlIGFuIEFaIHNob3dzIGlzb2xhdGVkIGltcGFjdCBmcm9tIGF2YWlsYWJpbGl0eVxuICAgKiBvciBsYXRlbmN5IGFzIHNlZW4gYnkgZWl0aGVyIHRoZSBzZXJ2ZXItc2lkZSBvciBjYW5hcnkuIFRoZXNlIGFyZSB0aGUgYWxhcm1zXG4gICAqIHlvdSB3b3VsZCB3YW50IHRvIHVzZSB0byB0cmlnZ2VyIGF1dG9tYXRpb24gdG8gZXZhY3VhdGUgYW4gQVouXG4gICAqL1xuICByZWFkb25seSBwZXJPcGVyYXRpb25ab25hbEltcGFjdEFsYXJtczoge1xuICAgIFtrZXk6IHN0cmluZ106IHsgW2tleTogc3RyaW5nXTogSUFsYXJtIH07XG4gIH07XG5cbiAgLyoqXG4gICAqIFRoZSBhbGFybXMgYW5kIHJ1bGVzIGZvciB0aGUgb3ZlcmFsbCBzZXJ2aWNlXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlQWxhcm1zOiBJU2VydmljZUFsYXJtc0FuZFJ1bGVzO1xuXG4gIC8qKlxuICAgKiBUaGUgZGFzaGJvYXJkcyBmb3IgZWFjaCBvcGVyYXRpb25cbiAgICovXG4gIHJlYWRvbmx5IG9wZXJhdGlvbkRhc2hib2FyZHM/OiBEYXNoYm9hcmRbXTtcblxuICAvKipcbiAgICogVGhlIHNlcnZpY2UgbGV2ZWwgZGFzaGJvYXJkXG4gICAqL1xuICByZWFkb25seSBzZXJ2aWNlRGFzaGJvYXJkPzogRGFzaGJvYXJkO1xuXG4gIC8qKlxuICAgKiBUaGUgQVogbWFwcGVyIGN1c3RvbSByZXNvdXJjZSB1c2VkIHRvIG1hcCBBWiBJZHMgdG8gTmFtZXMgYW5kIHZpY2UgYSB2ZXJzYVxuICAgKi9cbiAgcHJpdmF0ZSByZWFkb25seSBhek1hcHBlcjogQXZhaWxhYmlsaXR5Wm9uZU1hcHBlcjtcblxuICAvKipcbiAgICogSWYgdGhlIHNlcnZpY2UgaXMgY29uZmlndXJlZCB0byBoYXZlIGNhbmFyeSB0ZXN0cyBjcmVhdGVkLCB0aGlzIHdpbGxcbiAgICogYmUgdGhlIGxvZyBncm91cCB3aGVyZSB0aGUgY2FuYXJ5J3MgbG9ncyBhcmUgc3RvcmVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGxvZyBncm91cCBpcyBjcmVhdGVkIGlmIHRoZSBjYW5hcnkgaXMgbm90IHJlcXVlc3RlZC5cbiAgICovXG4gIHJlYWRvbmx5IGNhbmFyeUxvZ0dyb3VwPzogSUxvZ0dyb3VwO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgb3V0bGllckRldGVjdGlvbkZ1bmN0aW9uPzogSUZ1bmN0aW9uO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICBwcm9wczogSW5zdHJ1bWVudGVkU2VydmljZU11bHRpQVpPYnNlcnZhYmlsaXR5UHJvcHMsXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBsZXQgb3V0bGllclRocmVzaG9sZDogbnVtYmVyO1xuXG4gICAgaWYgKCFwcm9wcy5vdXRsaWVyVGhyZXNob2xkKSB7XG4gICAgICBzd2l0Y2ggKHByb3BzLm91dGxpZXJEZXRlY3Rpb25BbGdvcml0aG0pIHtcbiAgICAgICAgY2FzZSBPdXRsaWVyRGV0ZWN0aW9uQWxnb3JpdGhtLkNISV9TUVVBUkVEOlxuICAgICAgICAgIG91dGxpZXJUaHJlc2hvbGQgPSAwLjA1O1xuICAgICAgICAgIGJyZWFrO1xuICAgICAgICBjYXNlIE91dGxpZXJEZXRlY3Rpb25BbGdvcml0aG0uSVFSOlxuICAgICAgICAgIG91dGxpZXJUaHJlc2hvbGQgPSAxLjU7XG4gICAgICAgICAgYnJlYWs7XG4gICAgICAgIGNhc2UgT3V0bGllckRldGVjdGlvbkFsZ29yaXRobS5NQUQ6XG4gICAgICAgICAgb3V0bGllclRocmVzaG9sZCA9IDM7XG4gICAgICAgICAgYnJlYWs7XG4gICAgICAgIGNhc2UgT3V0bGllckRldGVjdGlvbkFsZ29yaXRobS5TVEFUSUM6XG4gICAgICAgICAgb3V0bGllclRocmVzaG9sZCA9IDAuNztcbiAgICAgICAgICBicmVhaztcbiAgICAgICAgY2FzZSBPdXRsaWVyRGV0ZWN0aW9uQWxnb3JpdGhtLlpfU0NPUkU6XG4gICAgICAgICAgb3V0bGllclRocmVzaG9sZCA9IDI7XG4gICAgICAgICAgYnJlYWs7XG4gICAgICB9XG4gICAgfSBlbHNlIHtcbiAgICAgIG91dGxpZXJUaHJlc2hvbGQgPSBwcm9wcy5vdXRsaWVyVGhyZXNob2xkO1xuICAgIH1cblxuICAgIHRoaXMuYXpNYXBwZXIgPSBuZXcgQXZhaWxhYmlsaXR5Wm9uZU1hcHBlcih0aGlzLCBcIkFaTWFwcGVyXCIsIHtcbiAgICAgIGF2YWlsYWJpbGl0eVpvbmVOYW1lczogcHJvcHMuc2VydmljZS5hdmFpbGFiaWxpdHlab25lTmFtZXMsXG4gICAgfSk7XG5cbiAgICBpZiAocHJvcHMuc2VydmljZS5jYW5hcnlUZXN0UHJvcHMgIT09IHVuZGVmaW5lZCkge1xuICAgICAgbGV0IGNhbmFyeVN0YWNrOiBTdGFja1dpdGhEeW5hbWljU291cmNlID0gbmV3IFN0YWNrV2l0aER5bmFtaWNTb3VyY2UoXG4gICAgICAgIHRoaXMsXG4gICAgICAgIFwiQ2FuYXJ5XCIsXG4gICAgICAgIHtcbiAgICAgICAgICBhc3NldHNCdWNrZXRzUGFyYW1ldGVyTmFtZTogcHJvcHMuYXNzZXRzQnVja2V0UGFyYW1ldGVyTmFtZSxcbiAgICAgICAgICBhc3NldHNCdWNrZXRQcmVmaXhQYXJhbWV0ZXJOYW1lOlxuICAgICAgICAgICAgcHJvcHMuYXNzZXRzQnVja2V0UHJlZml4UGFyYW1ldGVyTmFtZSxcbiAgICAgICAgfSxcbiAgICAgICk7XG5cbiAgICAgIGxldCBjYW5hcnkgPSBuZXcgQ2FuYXJ5RnVuY3Rpb24oY2FuYXJ5U3RhY2ssIFwiQ2FuYXJ5RnVuY3Rpb25cIiwge1xuICAgICAgICB2cGM6IHByb3BzLnNlcnZpY2UuY2FuYXJ5VGVzdFByb3BzLm5ldHdvcmtDb25maWd1cmF0aW9uPy52cGMsXG4gICAgICAgIHN1Ym5ldFNlbGVjdGlvbjpcbiAgICAgICAgICBwcm9wcy5zZXJ2aWNlLmNhbmFyeVRlc3RQcm9wcy5uZXR3b3JrQ29uZmlndXJhdGlvbj8uc3VibmV0U2VsZWN0aW9uLFxuICAgICAgICBodHRwVGltZW91dDogcHJvcHMuc2VydmljZS5jYW5hcnlUZXN0UHJvcHMudGltZW91dFxuICAgICAgICAgID8gcHJvcHMuc2VydmljZS5jYW5hcnlUZXN0UHJvcHMudGltZW91dFxuICAgICAgICAgIDogRHVyYXRpb24uc2Vjb25kcygyKSxcbiAgICAgICAgaWdub3JlVGxzRXJyb3JzOiBwcm9wcy5zZXJ2aWNlLmNhbmFyeVRlc3RQcm9wcy5pZ25vcmVUbHNFcnJvcnNcbiAgICAgICAgICA/IHByb3BzLnNlcnZpY2UuY2FuYXJ5VGVzdFByb3BzLmlnbm9yZVRsc0Vycm9yc1xuICAgICAgICAgIDogZmFsc2UsXG4gICAgICB9KTtcblxuICAgICAgdGhpcy5jYW5hcnlMb2dHcm91cCA9IGNhbmFyeS5sb2dHcm91cDtcblxuICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCBwcm9wcy5zZXJ2aWNlLm9wZXJhdGlvbnMubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgbGV0IG9wZXJhdGlvbjogSU9wZXJhdGlvbiA9IHByb3BzLnNlcnZpY2Uub3BlcmF0aW9uc1tpXTtcblxuICAgICAgICBpZiAob3BlcmF0aW9uLm9wdE91dE9mU2VydmljZUNyZWF0ZWRDYW5hcnkgIT0gdHJ1ZSkge1xuICAgICAgICAgIGxldCB0ZXN0UHJvcHM6IEFkZENhbmFyeVRlc3RQcm9wcyA9IG9wZXJhdGlvbi5jYW5hcnlUZXN0UHJvcHNcbiAgICAgICAgICAgID8gb3BlcmF0aW9uLmNhbmFyeVRlc3RQcm9wc1xuICAgICAgICAgICAgOiAocHJvcHMuc2VydmljZS5jYW5hcnlUZXN0UHJvcHMgYXMgQWRkQ2FuYXJ5VGVzdFByb3BzKTtcblxuICAgICAgICAgIGxldCBuZXN0ZWRTdGFjazogTmVzdGVkU3RhY2sgPSBuZXcgTmVzdGVkU3RhY2soXG4gICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUgKyBcIkNhbmFyeVRlc3RcIixcbiAgICAgICAgICAgIHt9LFxuICAgICAgICAgICk7XG5cbiAgICAgICAgICBsZXQgdGVzdCA9IG5ldyBDYW5hcnlUZXN0KG5lc3RlZFN0YWNrLCBvcGVyYXRpb24ub3BlcmF0aW9uTmFtZSwge1xuICAgICAgICAgICAgZnVuY3Rpb246IGNhbmFyeS5mdW5jdGlvbixcbiAgICAgICAgICAgIHJlcXVlc3RDb3VudDogdGVzdFByb3BzLnJlcXVlc3RDb3VudCxcbiAgICAgICAgICAgIHJlZ2lvbmFsUmVxdWVzdENvdW50OiB0ZXN0UHJvcHMucmVnaW9uYWxSZXF1ZXN0Q291bnRcbiAgICAgICAgICAgICAgPyB0ZXN0UHJvcHMucmVnaW9uYWxSZXF1ZXN0Q291bnRcbiAgICAgICAgICAgICAgOiB0ZXN0UHJvcHMucmVxdWVzdENvdW50LFxuICAgICAgICAgICAgc2NoZWR1bGU6IHRlc3RQcm9wcy5zY2hlZHVsZSxcbiAgICAgICAgICAgIG9wZXJhdGlvbjogb3BlcmF0aW9uLFxuICAgICAgICAgICAgbG9hZEJhbGFuY2VyOiB0ZXN0UHJvcHMubG9hZEJhbGFuY2VyLFxuICAgICAgICAgICAgaGVhZGVyczogdGVzdFByb3BzLmhlYWRlcnMsXG4gICAgICAgICAgICBwb3N0RGF0YTogdGVzdFByb3BzLnBvc3REYXRhLFxuICAgICAgICAgICAgYXpNYXBwZXI6IHRoaXMuYXpNYXBwZXIsXG4gICAgICAgICAgfSk7XG5cbiAgICAgICAgICBsZXQgZGVmYXVsdEF2YWlsYWJpbGl0eU1ldHJpY0RldGFpbHM6IElPcGVyYXRpb25NZXRyaWNEZXRhaWxzO1xuICAgICAgICAgIGxldCBkZWZhdWx0TGF0ZW5jeU1ldHJpY0RldGFpbHM6IElPcGVyYXRpb25NZXRyaWNEZXRhaWxzO1xuXG4gICAgICAgICAgaWYgKG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzPy5jYW5hcnlBdmFpbGFiaWxpdHlNZXRyaWNEZXRhaWxzKSB7XG4gICAgICAgICAgICBkZWZhdWx0QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlscyA9IG5ldyBPcGVyYXRpb25NZXRyaWNEZXRhaWxzKFxuICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgb3BlcmF0aW9uTmFtZTogb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUsXG4gICAgICAgICAgICAgICAgbWV0cmljRGltZW5zaW9uczogbmV3IE1ldHJpY0RpbWVuc2lvbnMoXG4gICAgICAgICAgICAgICAgICB7IE9wZXJhdGlvbjogb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUgfSxcbiAgICAgICAgICAgICAgICAgIFwiQVotSURcIixcbiAgICAgICAgICAgICAgICAgIFwiUmVnaW9uXCIsXG4gICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICBhbGFybVN0YXRpc3RpYzpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzLmNhbmFyeUF2YWlsYWJpbGl0eU1ldHJpY0RldGFpbHNcbiAgICAgICAgICAgICAgICAgICAgLmFsYXJtU3RhdGlzdGljLFxuICAgICAgICAgICAgICAgIGRhdGFwb2ludHNUb0FsYXJtOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAuZGF0YXBvaW50c1RvQWxhcm0sXG4gICAgICAgICAgICAgICAgZXZhbHVhdGlvblBlcmlvZHM6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5TWV0cmljRGV0YWlscy5jYW5hcnlBdmFpbGFiaWxpdHlNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5ldmFsdWF0aW9uUGVyaW9kcyxcbiAgICAgICAgICAgICAgICBmYXVsdEFsYXJtVGhyZXNob2xkOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAuZmF1bHRBbGFybVRocmVzaG9sZCxcbiAgICAgICAgICAgICAgICBmYXVsdE1ldHJpY05hbWVzOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAuZmF1bHRNZXRyaWNOYW1lcyxcbiAgICAgICAgICAgICAgICBncmFwaGVkRmF1bHRTdGF0aXN0aWNzOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAuZ3JhcGhlZEZhdWx0U3RhdGlzdGljcyxcbiAgICAgICAgICAgICAgICBncmFwaGVkU3VjY2Vzc1N0YXRpc3RpY3M6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5TWV0cmljRGV0YWlscy5jYW5hcnlBdmFpbGFiaWxpdHlNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5ncmFwaGVkU3VjY2Vzc1N0YXRpc3RpY3MsXG4gICAgICAgICAgICAgICAgbWV0cmljTmFtZXNwYWNlOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAubWV0cmljTmFtZXNwYWNlLFxuICAgICAgICAgICAgICAgIHBlcmlvZDpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzLmNhbmFyeUF2YWlsYWJpbGl0eU1ldHJpY0RldGFpbHNcbiAgICAgICAgICAgICAgICAgICAgLnBlcmlvZCxcbiAgICAgICAgICAgICAgICBzdWNjZXNzQWxhcm1UaHJlc2hvbGQ6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5TWV0cmljRGV0YWlscy5jYW5hcnlBdmFpbGFiaWxpdHlNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5zdWNjZXNzQWxhcm1UaHJlc2hvbGQsXG4gICAgICAgICAgICAgICAgc3VjY2Vzc01ldHJpY05hbWVzOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAuc3VjY2Vzc01ldHJpY05hbWVzLFxuICAgICAgICAgICAgICAgIHVuaXQ6IG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAuY2FuYXJ5QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlscy51bml0LFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBvcGVyYXRpb24uc2VydmljZS5kZWZhdWx0QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlscyxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgfSBlbHNlIGlmIChvcGVyYXRpb24uY2FuYXJ5VGVzdEF2YWlsYWJpbGl0eU1ldHJpY3NPdmVycmlkZSkge1xuICAgICAgICAgICAgZGVmYXVsdEF2YWlsYWJpbGl0eU1ldHJpY0RldGFpbHMgPSBuZXcgT3BlcmF0aW9uTWV0cmljRGV0YWlscyhcbiAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIG9wZXJhdGlvbk5hbWU6IG9wZXJhdGlvbi5vcGVyYXRpb25OYW1lLFxuICAgICAgICAgICAgICAgIG1ldHJpY05hbWVzcGFjZTogdGVzdC5tZXRyaWNOYW1lc3BhY2UsXG4gICAgICAgICAgICAgICAgc3VjY2Vzc01ldHJpY05hbWVzOiBbXCJTdWNjZXNzXCJdLFxuICAgICAgICAgICAgICAgIGZhdWx0TWV0cmljTmFtZXM6IFtcIkZhdWx0XCIsIFwiRmFpbHVyZVwiXSxcbiAgICAgICAgICAgICAgICBtZXRyaWNEaW1lbnNpb25zOiBuZXcgTWV0cmljRGltZW5zaW9ucyhcbiAgICAgICAgICAgICAgICAgIHsgT3BlcmF0aW9uOiBvcGVyYXRpb24ub3BlcmF0aW9uTmFtZSB9LFxuICAgICAgICAgICAgICAgICAgXCJBWi1JRFwiLFxuICAgICAgICAgICAgICAgICAgXCJSZWdpb25cIixcbiAgICAgICAgICAgICAgICApLFxuXG4gICAgICAgICAgICAgICAgYWxhcm1TdGF0aXN0aWM6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5VGVzdEF2YWlsYWJpbGl0eU1ldHJpY3NPdmVycmlkZVxuICAgICAgICAgICAgICAgICAgICAuYWxhcm1TdGF0aXN0aWMsXG4gICAgICAgICAgICAgICAgZGF0YXBvaW50c1RvQWxhcm06XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5VGVzdEF2YWlsYWJpbGl0eU1ldHJpY3NPdmVycmlkZVxuICAgICAgICAgICAgICAgICAgICAuZGF0YXBvaW50c1RvQWxhcm0sXG4gICAgICAgICAgICAgICAgZXZhbHVhdGlvblBlcmlvZHM6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5VGVzdEF2YWlsYWJpbGl0eU1ldHJpY3NPdmVycmlkZVxuICAgICAgICAgICAgICAgICAgICAuZXZhbHVhdGlvblBlcmlvZHMsXG4gICAgICAgICAgICAgICAgZmF1bHRBbGFybVRocmVzaG9sZDpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlUZXN0QXZhaWxhYmlsaXR5TWV0cmljc092ZXJyaWRlXG4gICAgICAgICAgICAgICAgICAgIC5mYXVsdEFsYXJtVGhyZXNob2xkLFxuICAgICAgICAgICAgICAgIHBlcmlvZDogb3BlcmF0aW9uLmNhbmFyeVRlc3RBdmFpbGFiaWxpdHlNZXRyaWNzT3ZlcnJpZGUucGVyaW9kLFxuICAgICAgICAgICAgICAgIHN1Y2Nlc3NBbGFybVRocmVzaG9sZDpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlUZXN0QXZhaWxhYmlsaXR5TWV0cmljc092ZXJyaWRlXG4gICAgICAgICAgICAgICAgICAgIC5zdWNjZXNzQWxhcm1UaHJlc2hvbGQsXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIHByb3BzLnNlcnZpY2UuZGVmYXVsdEF2YWlsYWJpbGl0eU1ldHJpY0RldGFpbHMsXG4gICAgICAgICAgICApO1xuICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBkZWZhdWx0QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlscyA9IG5ldyBPcGVyYXRpb25NZXRyaWNEZXRhaWxzKFxuICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgb3BlcmF0aW9uTmFtZTogb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUsXG4gICAgICAgICAgICAgICAgbWV0cmljTmFtZXNwYWNlOiB0ZXN0Lm1ldHJpY05hbWVzcGFjZSxcbiAgICAgICAgICAgICAgICBzdWNjZXNzTWV0cmljTmFtZXM6IFtcIlN1Y2Nlc3NcIl0sXG4gICAgICAgICAgICAgICAgZmF1bHRNZXRyaWNOYW1lczogW1wiRmF1bHRcIiwgXCJGYWlsdXJlXCJdLFxuICAgICAgICAgICAgICAgIG1ldHJpY0RpbWVuc2lvbnM6IG5ldyBNZXRyaWNEaW1lbnNpb25zKFxuICAgICAgICAgICAgICAgICAgeyBPcGVyYXRpb246IG9wZXJhdGlvbi5vcGVyYXRpb25OYW1lIH0sXG4gICAgICAgICAgICAgICAgICBcIkFaLUlEXCIsXG4gICAgICAgICAgICAgICAgICBcIlJlZ2lvblwiLFxuICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIHByb3BzLnNlcnZpY2UuZGVmYXVsdEF2YWlsYWJpbGl0eU1ldHJpY0RldGFpbHMsXG4gICAgICAgICAgICApO1xuICAgICAgICAgIH1cblxuICAgICAgICAgIGlmIChvcGVyYXRpb24uY2FuYXJ5TWV0cmljRGV0YWlscz8uY2FuYXJ5TGF0ZW5jeU1ldHJpY0RldGFpbHMpIHtcbiAgICAgICAgICAgIGRlZmF1bHRMYXRlbmN5TWV0cmljRGV0YWlscyA9IG5ldyBPcGVyYXRpb25NZXRyaWNEZXRhaWxzKFxuICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgb3BlcmF0aW9uTmFtZTogb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUsXG4gICAgICAgICAgICAgICAgbWV0cmljRGltZW5zaW9uczogbmV3IE1ldHJpY0RpbWVuc2lvbnMoXG4gICAgICAgICAgICAgICAgICB7IE9wZXJhdGlvbjogb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUgfSxcbiAgICAgICAgICAgICAgICAgIFwiQVotSURcIixcbiAgICAgICAgICAgICAgICAgIFwiUmVnaW9uXCIsXG4gICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICBhbGFybVN0YXRpc3RpYzpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzLmNhbmFyeUxhdGVuY3lNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5hbGFybVN0YXRpc3RpYyxcbiAgICAgICAgICAgICAgICBkYXRhcG9pbnRzVG9BbGFybTpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzLmNhbmFyeUxhdGVuY3lNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5kYXRhcG9pbnRzVG9BbGFybSxcbiAgICAgICAgICAgICAgICBldmFsdWF0aW9uUGVyaW9kczpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzLmNhbmFyeUxhdGVuY3lNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5ldmFsdWF0aW9uUGVyaW9kcyxcbiAgICAgICAgICAgICAgICBmYXVsdEFsYXJtVGhyZXNob2xkOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5TGF0ZW5jeU1ldHJpY0RldGFpbHNcbiAgICAgICAgICAgICAgICAgICAgLmZhdWx0QWxhcm1UaHJlc2hvbGQsXG4gICAgICAgICAgICAgICAgZmF1bHRNZXRyaWNOYW1lczpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzLmNhbmFyeUxhdGVuY3lNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5mYXVsdE1ldHJpY05hbWVzLFxuICAgICAgICAgICAgICAgIGdyYXBoZWRGYXVsdFN0YXRpc3RpY3M6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5TWV0cmljRGV0YWlscy5jYW5hcnlMYXRlbmN5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAuZ3JhcGhlZEZhdWx0U3RhdGlzdGljcyxcbiAgICAgICAgICAgICAgICBncmFwaGVkU3VjY2Vzc1N0YXRpc3RpY3M6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5TWV0cmljRGV0YWlscy5jYW5hcnlMYXRlbmN5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAuZ3JhcGhlZFN1Y2Nlc3NTdGF0aXN0aWNzLFxuICAgICAgICAgICAgICAgIG1ldHJpY05hbWVzcGFjZTpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzLmNhbmFyeUxhdGVuY3lNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5tZXRyaWNOYW1lc3BhY2UsXG4gICAgICAgICAgICAgICAgcGVyaW9kOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5TGF0ZW5jeU1ldHJpY0RldGFpbHNcbiAgICAgICAgICAgICAgICAgICAgLnBlcmlvZCxcbiAgICAgICAgICAgICAgICBzdWNjZXNzQWxhcm1UaHJlc2hvbGQ6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5TWV0cmljRGV0YWlscy5jYW5hcnlMYXRlbmN5TWV0cmljRGV0YWlsc1xuICAgICAgICAgICAgICAgICAgICAuc3VjY2Vzc0FsYXJtVGhyZXNob2xkLFxuICAgICAgICAgICAgICAgIHN1Y2Nlc3NNZXRyaWNOYW1lczpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlNZXRyaWNEZXRhaWxzLmNhbmFyeUxhdGVuY3lNZXRyaWNEZXRhaWxzXG4gICAgICAgICAgICAgICAgICAgIC5zdWNjZXNzTWV0cmljTmFtZXMsXG4gICAgICAgICAgICAgICAgdW5pdDogb3BlcmF0aW9uLmNhbmFyeU1ldHJpY0RldGFpbHMuY2FuYXJ5TGF0ZW5jeU1ldHJpY0RldGFpbHNcbiAgICAgICAgICAgICAgICAgIC51bml0LFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBvcGVyYXRpb24uc2VydmljZS5kZWZhdWx0TGF0ZW5jeU1ldHJpY0RldGFpbHMsXG4gICAgICAgICAgICApO1xuICAgICAgICAgIH0gZWxzZSBpZiAob3BlcmF0aW9uLmNhbmFyeVRlc3RMYXRlbmN5TWV0cmljc092ZXJyaWRlKSB7XG4gICAgICAgICAgICBkZWZhdWx0TGF0ZW5jeU1ldHJpY0RldGFpbHMgPSBuZXcgT3BlcmF0aW9uTWV0cmljRGV0YWlscyhcbiAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIG9wZXJhdGlvbk5hbWU6IG9wZXJhdGlvbi5vcGVyYXRpb25OYW1lLFxuICAgICAgICAgICAgICAgIG1ldHJpY05hbWVzcGFjZTogdGVzdC5tZXRyaWNOYW1lc3BhY2UsXG4gICAgICAgICAgICAgICAgc3VjY2Vzc01ldHJpY05hbWVzOiBbXCJTdWNjZXNzTGF0ZW5jeVwiXSxcbiAgICAgICAgICAgICAgICBmYXVsdE1ldHJpY05hbWVzOiBbXCJGYXVsdExhdGVuY3lcIl0sXG4gICAgICAgICAgICAgICAgbWV0cmljRGltZW5zaW9uczogbmV3IE1ldHJpY0RpbWVuc2lvbnMoXG4gICAgICAgICAgICAgICAgICB7IE9wZXJhdGlvbjogb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUgfSxcbiAgICAgICAgICAgICAgICAgIFwiQVotSURcIixcbiAgICAgICAgICAgICAgICAgIFwiUmVnaW9uXCIsXG4gICAgICAgICAgICAgICAgKSxcblxuICAgICAgICAgICAgICAgIGFsYXJtU3RhdGlzdGljOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeVRlc3RMYXRlbmN5TWV0cmljc092ZXJyaWRlLmFsYXJtU3RhdGlzdGljLFxuICAgICAgICAgICAgICAgIGRhdGFwb2ludHNUb0FsYXJtOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeVRlc3RMYXRlbmN5TWV0cmljc092ZXJyaWRlLmRhdGFwb2ludHNUb0FsYXJtLFxuICAgICAgICAgICAgICAgIGV2YWx1YXRpb25QZXJpb2RzOlxuICAgICAgICAgICAgICAgICAgb3BlcmF0aW9uLmNhbmFyeVRlc3RMYXRlbmN5TWV0cmljc092ZXJyaWRlLmV2YWx1YXRpb25QZXJpb2RzLFxuICAgICAgICAgICAgICAgIGZhdWx0QWxhcm1UaHJlc2hvbGQ6XG4gICAgICAgICAgICAgICAgICBvcGVyYXRpb24uY2FuYXJ5VGVzdExhdGVuY3lNZXRyaWNzT3ZlcnJpZGVcbiAgICAgICAgICAgICAgICAgICAgLmZhdWx0QWxhcm1UaHJlc2hvbGQsXG4gICAgICAgICAgICAgICAgcGVyaW9kOiBvcGVyYXRpb24uY2FuYXJ5VGVzdExhdGVuY3lNZXRyaWNzT3ZlcnJpZGUucGVyaW9kLFxuICAgICAgICAgICAgICAgIHN1Y2Nlc3NBbGFybVRocmVzaG9sZDpcbiAgICAgICAgICAgICAgICAgIG9wZXJhdGlvbi5jYW5hcnlUZXN0TGF0ZW5jeU1ldHJpY3NPdmVycmlkZVxuICAgICAgICAgICAgICAgICAgICAuc3VjY2Vzc0FsYXJtVGhyZXNob2xkLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBwcm9wcy5zZXJ2aWNlLmRlZmF1bHRMYXRlbmN5TWV0cmljRGV0YWlscyxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGRlZmF1bHRMYXRlbmN5TWV0cmljRGV0YWlscyA9IG5ldyBPcGVyYXRpb25NZXRyaWNEZXRhaWxzKFxuICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgb3BlcmF0aW9uTmFtZTogb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUsXG4gICAgICAgICAgICAgICAgbWV0cmljTmFtZXNwYWNlOiB0ZXN0Lm1ldHJpY05hbWVzcGFjZSxcbiAgICAgICAgICAgICAgICBzdWNjZXNzTWV0cmljTmFtZXM6IFtcIlN1Y2Nlc3NMYXRlbmN5XCJdLFxuICAgICAgICAgICAgICAgIGZhdWx0TWV0cmljTmFtZXM6IFtcIkZhdWx0TGF0ZW5jeVwiXSxcbiAgICAgICAgICAgICAgICBtZXRyaWNEaW1lbnNpb25zOiBuZXcgTWV0cmljRGltZW5zaW9ucyhcbiAgICAgICAgICAgICAgICAgIHsgT3BlcmF0aW9uOiBvcGVyYXRpb24ub3BlcmF0aW9uTmFtZSB9LFxuICAgICAgICAgICAgICAgICAgXCJBWi1JRFwiLFxuICAgICAgICAgICAgICAgICAgXCJSZWdpb25cIixcbiAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBwcm9wcy5zZXJ2aWNlLmRlZmF1bHRMYXRlbmN5TWV0cmljRGV0YWlscyxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgfVxuXG4gICAgICAgICAgbGV0IG5ld09wZXJhdGlvbiA9IG5ldyBPcGVyYXRpb24oe1xuICAgICAgICAgICAgc2VydmVyU2lkZUF2YWlsYWJpbGl0eU1ldHJpY0RldGFpbHM6XG4gICAgICAgICAgICAgIG9wZXJhdGlvbi5zZXJ2ZXJTaWRlQXZhaWxhYmlsaXR5TWV0cmljRGV0YWlscyxcbiAgICAgICAgICAgIHNlcnZlclNpZGVMYXRlbmN5TWV0cmljRGV0YWlsczpcbiAgICAgICAgICAgICAgb3BlcmF0aW9uLnNlcnZlclNpZGVMYXRlbmN5TWV0cmljRGV0YWlscyxcbiAgICAgICAgICAgIHNlcnZlclNpZGVDb250cmlidXRvckluc2lnaHRSdWxlRGV0YWlsczpcbiAgICAgICAgICAgICAgb3BlcmF0aW9uLnNlcnZlclNpZGVDb250cmlidXRvckluc2lnaHRSdWxlRGV0YWlscyxcbiAgICAgICAgICAgIHNlcnZpY2U6IG9wZXJhdGlvbi5zZXJ2aWNlLFxuICAgICAgICAgICAgb3BlcmF0aW9uTmFtZTogb3BlcmF0aW9uLm9wZXJhdGlvbk5hbWUsXG4gICAgICAgICAgICBwYXRoOiBvcGVyYXRpb24ucGF0aCxcbiAgICAgICAgICAgIGNyaXRpY2FsOiBvcGVyYXRpb24uY3JpdGljYWwsXG4gICAgICAgICAgICBodHRwTWV0aG9kczogb3BlcmF0aW9uLmh0dHBNZXRob2RzLFxuICAgICAgICAgICAgY2FuYXJ5TWV0cmljRGV0YWlsczogbmV3IENhbmFyeU1ldHJpY3Moe1xuICAgICAgICAgICAgICBjYW5hcnlBdmFpbGFiaWxpdHlNZXRyaWNEZXRhaWxzOiBkZWZhdWx0QXZhaWxhYmlsaXR5TWV0cmljRGV0YWlscyxcbiAgICAgICAgICAgICAgY2FuYXJ5TGF0ZW5jeU1ldHJpY0RldGFpbHM6IGRlZmF1bHRMYXRlbmN5TWV0cmljRGV0YWlscyxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgIH0pO1xuXG4gICAgICAgICAgcHJvcHMuc2VydmljZS5vcGVyYXRpb25zW2ldID0gbmV3T3BlcmF0aW9uO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLm91dGxpZXJEZXRlY3Rpb25BbGdvcml0aG0gIT0gT3V0bGllckRldGVjdGlvbkFsZ29yaXRobS5TVEFUSUMpIHtcbiAgICAgIGxldCBvdXRsaWVyRGV0ZWN0aW9uU3RhY2s6IFN0YWNrV2l0aER5bmFtaWNTb3VyY2UgPVxuICAgICAgICBuZXcgU3RhY2tXaXRoRHluYW1pY1NvdXJjZSh0aGlzLCBcIk91dGxpZXJEZXRlY3Rpb25TdGFja1wiLCB7XG4gICAgICAgICAgYXNzZXRzQnVja2V0c1BhcmFtZXRlck5hbWU6IHByb3BzLmFzc2V0c0J1Y2tldFBhcmFtZXRlck5hbWUsXG4gICAgICAgICAgYXNzZXRzQnVja2V0UHJlZml4UGFyYW1ldGVyTmFtZTpcbiAgICAgICAgICAgIHByb3BzLmFzc2V0c0J1Y2tldFByZWZpeFBhcmFtZXRlck5hbWUsXG4gICAgICAgIH0pO1xuXG4gICAgICB0aGlzLm91dGxpZXJEZXRlY3Rpb25GdW5jdGlvbiA9IG5ldyBPdXRsaWVyRGV0ZWN0aW9uRnVuY3Rpb24oXG4gICAgICAgIG91dGxpZXJEZXRlY3Rpb25TdGFjayxcbiAgICAgICAgXCJPdXRsaWVyRGV0ZWN0aW9uRnVuY3Rpb25cIixcbiAgICAgICAge30sXG4gICAgICApLmZ1bmN0aW9uO1xuICAgIH1cblxuICAgIHRoaXMucGVyT3BlcmF0aW9uQWxhcm1zQW5kUnVsZXMgPSBPYmplY3QuZnJvbUVudHJpZXMoXG4gICAgICBwcm9wcy5zZXJ2aWNlLm9wZXJhdGlvbnMubWFwKChvcGVyYXRpb246IElPcGVyYXRpb24pID0+IHtcbiAgICAgICAgbGV0IG5lc3RlZFN0YWNrOiBOZXN0ZWRTdGFjayA9IG5ldyBOZXN0ZWRTdGFjayhcbiAgICAgICAgICB0aGlzLFxuICAgICAgICAgIG9wZXJhdGlvbi5vcGVyYXRpb25OYW1lICsgXCJPcGVyYXRpb25BbGFybXNBbmRSdWxlc05lc3RlZFN0YWNrXCIsXG4gICAgICAgICk7XG5cbiAgICAgICAgcmV0dXJuIFtcbiAgICAgICAgICBvcGVyYXRpb24ub3BlcmF0aW9uTmFtZSxcbiAgICAgICAgICBuZXcgT3BlcmF0aW9uQWxhcm1zQW5kUnVsZXMobmVzdGVkU3RhY2ssIG9wZXJhdGlvbi5vcGVyYXRpb25OYW1lLCB7XG4gICAgICAgICAgICBvcGVyYXRpb246IG9wZXJhdGlvbixcbiAgICAgICAgICAgIG91dGxpZXJEZXRlY3Rpb25BbGdvcml0aG06IHByb3BzLm91dGxpZXJEZXRlY3Rpb25BbGdvcml0aG0sXG4gICAgICAgICAgICBvdXRsaWVyVGhyZXNob2xkOiBvdXRsaWVyVGhyZXNob2xkLFxuICAgICAgICAgICAgbG9hZEJhbGFuY2VyOiBwcm9wcy5zZXJ2aWNlLmxvYWRCYWxhbmNlcixcbiAgICAgICAgICAgIGF6TWFwcGVyOiB0aGlzLmF6TWFwcGVyLFxuICAgICAgICAgICAgb3V0bGllckRldGVjdGlvbkZ1bmN0aW9uOiB0aGlzLm91dGxpZXJEZXRlY3Rpb25GdW5jdGlvbixcbiAgICAgICAgICB9KSxcbiAgICAgICAgXTtcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICB0aGlzLnBlck9wZXJhdGlvblpvbmFsSW1wYWN0QWxhcm1zID0gT2JqZWN0LmZyb21FbnRyaWVzKFxuICAgICAgT2JqZWN0LmVudHJpZXModGhpcy5wZXJPcGVyYXRpb25BbGFybXNBbmRSdWxlcykubWFwKChba2V5LCB2YWx1ZV0pID0+IHtcbiAgICAgICAgcmV0dXJuIFtrZXksIHZhbHVlLmFnZ3JlZ2F0ZVpvbmFsQWxhcm1zTWFwXTtcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICBsZXQgc2VydmljZUFsYXJtc1N0YWNrOiBOZXN0ZWRTdGFjayA9IG5ldyBOZXN0ZWRTdGFjayhcbiAgICAgIHRoaXMsXG4gICAgICBcIlNlcnZpY2VBbGFybXNOZXN0ZWRTdGFja1wiLFxuICAgICk7XG5cbiAgICB0aGlzLnNlcnZpY2VBbGFybXMgPSBuZXcgU2VydmljZUFsYXJtc0FuZFJ1bGVzKFxuICAgICAgc2VydmljZUFsYXJtc1N0YWNrLFxuICAgICAgcHJvcHMuc2VydmljZS5zZXJ2aWNlTmFtZSxcbiAgICAgIHtcbiAgICAgICAgcGVyT3BlcmF0aW9uQWxhcm1zQW5kUnVsZXM6IHRoaXMucGVyT3BlcmF0aW9uQWxhcm1zQW5kUnVsZXMsXG4gICAgICAgIHNlcnZpY2U6IHByb3BzLnNlcnZpY2UsXG4gICAgICAgIGF6TWFwcGVyOiB0aGlzLmF6TWFwcGVyLFxuICAgICAgfSxcbiAgICApO1xuXG4gICAgaWYgKHByb3BzLmNyZWF0ZURhc2hib2FyZHMpIHtcbiAgICAgIHRoaXMub3BlcmF0aW9uRGFzaGJvYXJkcyA9IFtdO1xuXG4gICAgICBwcm9wcy5zZXJ2aWNlLm9wZXJhdGlvbnMuZm9yRWFjaCgoeCkgPT4ge1xuICAgICAgICBsZXQgZGFzaGJvYXJkU3RhY2s6IE5lc3RlZFN0YWNrID0gbmV3IE5lc3RlZFN0YWNrKFxuICAgICAgICAgIHRoaXMsXG4gICAgICAgICAgeC5vcGVyYXRpb25OYW1lICsgXCJEYXNoYm9hcmRcIixcbiAgICAgICAgICB7fSxcbiAgICAgICAgKTtcblxuICAgICAgICBpZiAodGhpcy5vcGVyYXRpb25EYXNoYm9hcmRzKSB7XG4gICAgICAgICAgdGhpcy5vcGVyYXRpb25EYXNoYm9hcmRzLnB1c2goXG4gICAgICAgICAgICBuZXcgT3BlcmF0aW9uQXZhaWxhYmlsaXR5QW5kTGF0ZW5jeURhc2hib2FyZChcbiAgICAgICAgICAgICAgZGFzaGJvYXJkU3RhY2ssXG4gICAgICAgICAgICAgIHgub3BlcmF0aW9uTmFtZSxcbiAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIG9wZXJhdGlvbjogeCxcbiAgICAgICAgICAgICAgICBhek1hcHBlcjogdGhpcy5hek1hcHBlcixcbiAgICAgICAgICAgICAgICBpbnRlcnZhbDogcHJvcHMuaW50ZXJ2YWxcbiAgICAgICAgICAgICAgICAgID8gcHJvcHMuaW50ZXJ2YWxcbiAgICAgICAgICAgICAgICAgIDogRHVyYXRpb24ubWludXRlcyg2MCksXG4gICAgICAgICAgICAgICAgbG9hZEJhbGFuY2VyOiBwcm9wcy5zZXJ2aWNlLmxvYWRCYWxhbmNlcixcblxuICAgICAgICAgICAgICAgIHJlZ2lvbmFsRW5kcG9pbnRDYW5hcnlBdmFpbGFiaWxpdHlBbGFybTpcbiAgICAgICAgICAgICAgICAgIHRoaXMucGVyT3BlcmF0aW9uQWxhcm1zQW5kUnVsZXNbeC5vcGVyYXRpb25OYW1lXVxuICAgICAgICAgICAgICAgICAgICAuY2FuYXJ5UmVnaW9uYWxBbGFybXNBbmRSdWxlcz8uYXZhaWxhYmlsaXR5QWxhcm0sXG5cbiAgICAgICAgICAgICAgICByZWdpb25hbEVuZHBvaW50Q2FuYXJ5TGF0ZW5jeUFsYXJtOlxuICAgICAgICAgICAgICAgICAgdGhpcy5wZXJPcGVyYXRpb25BbGFybXNBbmRSdWxlc1t4Lm9wZXJhdGlvbk5hbWVdXG4gICAgICAgICAgICAgICAgICAgIC5jYW5hcnlSZWdpb25hbEFsYXJtc0FuZFJ1bGVzPy5sYXRlbmN5QWxhcm0sXG5cbiAgICAgICAgICAgICAgICByZWdpb25hbEVuZHBvaW50U2VydmVyQXZhaWxhYmlsaXR5QWxhcm06XG4gICAgICAgICAgICAgICAgICB0aGlzLnBlck9wZXJhdGlvbkFsYXJtc0FuZFJ1bGVzW3gub3BlcmF0aW9uTmFtZV1cbiAgICAgICAgICAgICAgICAgICAgLnNlcnZlclNpZGVSZWdpb25hbEFsYXJtc0FuZFJ1bGVzLmF2YWlsYWJpbGl0eUFsYXJtLFxuXG4gICAgICAgICAgICAgICAgcmVnaW9uYWxFbmRwb2ludFNlcnZlckxhdGVuY3lBbGFybTpcbiAgICAgICAgICAgICAgICAgIHRoaXMucGVyT3BlcmF0aW9uQWxhcm1zQW5kUnVsZXNbeC5vcGVyYXRpb25OYW1lXVxuICAgICAgICAgICAgICAgICAgICAuc2VydmVyU2lkZVJlZ2lvbmFsQWxhcm1zQW5kUnVsZXMubGF0ZW5jeUFsYXJtLFxuXG4gICAgICAgICAgICAgICAgem9uYWxFbmRwb2ludENhbmFyeUF2YWlsYWJpbGl0eUFsYXJtczpcbiAgICAgICAgICAgICAgICAgIHRoaXMucGVyT3BlcmF0aW9uQWxhcm1zQW5kUnVsZXNbXG4gICAgICAgICAgICAgICAgICAgIHgub3BlcmF0aW9uTmFtZVxuICAgICAgICAgICAgICAgICAgXS5jYW5hcnlab25hbEFsYXJtc0FuZFJ1bGVzPy5tYXAoKGEpID0+IGEuYXZhaWxhYmlsaXR5QWxhcm0pLFxuXG4gICAgICAgICAgICAgICAgem9uYWxFbmRwb2ludENhbmFyeUxhdGVuY3lBbGFybXM6XG4gICAgICAgICAgICAgICAgICB0aGlzLnBlck9wZXJhdGlvbkFsYXJtc0FuZFJ1bGVzW1xuICAgICAgICAgICAgICAgICAgICB4Lm9wZXJhdGlvbk5hbWVcbiAgICAgICAgICAgICAgICAgIF0uY2FuYXJ5Wm9uYWxBbGFybXNBbmRSdWxlcz8ubWFwKChhKSA9PiBhLmxhdGVuY3lBbGFybSksXG5cbiAgICAgICAgICAgICAgICB6b25hbEVuZHBvaW50U2VydmVyQXZhaWxhYmlsaXR5QWxhcm1zOlxuICAgICAgICAgICAgICAgICAgdGhpcy5wZXJPcGVyYXRpb25BbGFybXNBbmRSdWxlc1tcbiAgICAgICAgICAgICAgICAgICAgeC5vcGVyYXRpb25OYW1lXG4gICAgICAgICAgICAgICAgICBdLnNlcnZlclNpZGVab25hbEFsYXJtc0FuZFJ1bGVzLm1hcChcbiAgICAgICAgICAgICAgICAgICAgKGEpID0+IGEuYXZhaWxhYmlsaXR5QWxhcm0sXG4gICAgICAgICAgICAgICAgICApLFxuXG4gICAgICAgICAgICAgICAgem9uYWxFbmRwb2ludFNlcnZlckxhdGVuY3lBbGFybXM6XG4gICAgICAgICAgICAgICAgICB0aGlzLnBlck9wZXJhdGlvbkFsYXJtc0FuZFJ1bGVzW1xuICAgICAgICAgICAgICAgICAgICB4Lm9wZXJhdGlvbk5hbWVcbiAgICAgICAgICAgICAgICAgIF0uc2VydmVyU2lkZVpvbmFsQWxhcm1zQW5kUnVsZXMubWFwKChhKSA9PiBhLmxhdGVuY3lBbGFybSksXG5cbiAgICAgICAgICAgICAgICBpc29sYXRlZEFaSW1wYWN0QWxhcm1zOlxuICAgICAgICAgICAgICAgICAgdGhpcy5wZXJPcGVyYXRpb25BbGFybXNBbmRSdWxlc1t4Lm9wZXJhdGlvbk5hbWVdXG4gICAgICAgICAgICAgICAgICAgIC5hZ2dyZWdhdGVab25hbEFsYXJtcyxcblxuICAgICAgICAgICAgICAgIHJlZ2lvbmFsSW1wYWN0QWxhcm06XG4gICAgICAgICAgICAgICAgICB0aGlzLnBlck9wZXJhdGlvbkFsYXJtc0FuZFJ1bGVzW3gub3BlcmF0aW9uTmFtZV1cbiAgICAgICAgICAgICAgICAgICAgLmFnZ3JlZ2F0ZVJlZ2lvbmFsQWxhcm0sXG5cbiAgICAgICAgICAgICAgICBpbnN0YW5jZUNvbnRyaWJ1dG9yc1RvRmF1bHRzOlxuICAgICAgICAgICAgICAgICAgdGhpcy5wZXJPcGVyYXRpb25BbGFybXNBbmRSdWxlc1t4Lm9wZXJhdGlvbk5hbWVdXG4gICAgICAgICAgICAgICAgICAgIC5zZXJ2ZXJTaWRlUmVnaW9uYWxBbGFybXNBbmRSdWxlc1xuICAgICAgICAgICAgICAgICAgICAuaW5zdGFuY2VDb250cmlidXRvcnNUb1JlZ2lvbmFsRmF1bHRzLFxuXG4gICAgICAgICAgICAgICAgaW5zdGFuY2VDb250cmlidXRvcnNUb0hpZ2hMYXRlbmN5OlxuICAgICAgICAgICAgICAgICAgdGhpcy5wZXJPcGVyYXRpb25BbGFybXNBbmRSdWxlc1t4Lm9wZXJhdGlvbk5hbWVdXG4gICAgICAgICAgICAgICAgICAgIC5zZXJ2ZXJTaWRlUmVnaW9uYWxBbGFybXNBbmRSdWxlc1xuICAgICAgICAgICAgICAgICAgICAuaW5zdGFuY2VDb250cmlidXRvcnNUb1JlZ2lvbmFsSGlnaExhdGVuY3ksXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICApLmRhc2hib2FyZCxcbiAgICAgICAgICApO1xuICAgICAgICB9XG4gICAgICB9KTtcblxuICAgICAgbGV0IGRhc2hib2FyZFN0YWNrOiBOZXN0ZWRTdGFjayA9IG5ldyBOZXN0ZWRTdGFjayhcbiAgICAgICAgdGhpcyxcbiAgICAgICAgXCJTZXJ2aWNlRGFzaGJvYXJkXCIsXG4gICAgICAgIHt9LFxuICAgICAgKTtcblxuICAgICAgdGhpcy5zZXJ2aWNlRGFzaGJvYXJkID0gbmV3IFNlcnZpY2VBdmFpbGFiaWxpdHlBbmRMYXRlbmN5RGFzaGJvYXJkKFxuICAgICAgICBkYXNoYm9hcmRTdGFjayxcbiAgICAgICAgcHJvcHMuc2VydmljZS5zZXJ2aWNlTmFtZS50b0xvd2VyQ2FzZSgpLFxuICAgICAgICB7XG4gICAgICAgICAgaW50ZXJ2YWw6IHByb3BzLmludGVydmFsID8gcHJvcHMuaW50ZXJ2YWwgOiBEdXJhdGlvbi5taW51dGVzKDYwKSxcbiAgICAgICAgICBzZXJ2aWNlOiBwcm9wcy5zZXJ2aWNlLFxuICAgICAgICAgIGFnZ3JlZ2F0ZVJlZ2lvbmFsQWxhcm06XG4gICAgICAgICAgICB0aGlzLnNlcnZpY2VBbGFybXMucmVnaW9uYWxGYXVsdENvdW50U2VydmVyU2lkZUFsYXJtLFxuICAgICAgICAgIHpvbmFsQWdncmVnYXRlQWxhcm1zOlxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQWxhcm1zLnpvbmFsQWdncmVnYXRlSXNvbGF0ZWRJbXBhY3RBbGFybXMsXG4gICAgICAgICAgYXpNYXBwZXI6IHRoaXMuYXpNYXBwZXIsXG4gICAgICAgIH0sXG4gICAgICApLmRhc2hib2FyZDtcbiAgICB9XG4gIH1cbn1cbiJdfQ==