"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZonalLatencyMetrics = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const AvailabilityAndLatencyMetrics_1 = require("./AvailabilityAndLatencyMetrics");
class ZonalLatencyMetrics {
    /**
     * Creates a zonal latency metric
     * @param props
     * @returns
     */
    static createZonalLatencyMetrics(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createLatencyMetrics(props, props.metricDetails.metricDimensions.zonalDimensions(props.availabilityZoneId, aws_cdk_lib_1.Fn.ref("AWS::Region")));
    }
    /**
     * Creates an average zonal latency metric
     * @param props
     * @returns
     */
    static createZonalAverageLatencyMetric(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createAverageLatencyMetric(props, props.metricDetails.metricDimensions.zonalDimensions(props.availabilityZoneId, aws_cdk_lib_1.Fn.ref("AWS::Region")));
    }
    /**
     * Creates a count of high latency metric
     * @param props
     * @returns
     */
    static createZonalCountLatencyMetric(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createLatencyCountMetric(props, props.metricDetails.metricDimensions.zonalDimensions(props.availabilityZoneId, aws_cdk_lib_1.Fn.ref("AWS::Region")));
    }
    /**
     * Creates a count of high latency responses for all critical operations
     * @param props
     * @returns
     */
    static createZonalServiceLatencyMetrics(props) {
        let usingMetrics = {};
        let operationMetrics = [];
        let keyPrefix = AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.nextChar("");
        props.latencyMetricProps.forEach((prop, index) => {
            let operationZonalMetric = this.createZonalCountLatencyMetric(prop);
            operationMetrics.push(operationZonalMetric);
            usingMetrics[`${keyPrefix}${index}`] = operationZonalMetric;
            keyPrefix = AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.nextChar(keyPrefix);
        });
        if (Object.keys(usingMetrics).length == 1) {
            operationMetrics.push(Object.values(usingMetrics)[0]);
        }
        else {
            let math = new aws_cloudwatch_1.MathExpression({
                usingMetrics: usingMetrics,
                period: props.period,
                label: props.label,
                expression: Object.keys(usingMetrics).join("+"),
            });
            operationMetrics.splice(0, 0, math);
        }
        return operationMetrics;
    }
}
exports.ZonalLatencyMetrics = ZonalLatencyMetrics;
//# sourceMappingURL=data:application/json;base64,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