"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegionalLatencyMetrics = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const AvailabilityAndLatencyMetrics_1 = require("./AvailabilityAndLatencyMetrics");
class RegionalLatencyMetrics {
    /**
     * Creates a metrics for regional latency, one metric per metric name for the
     * specified type of latency metric. You will need to perform some aggregation
     * of these metrics if there is more than 1 metric name that correponds to
     * SuccessLatency or FaultLatency, like doing an average.
     * @param props
     * @returns
     */
    static createRegionalLatencyMetrics(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createLatencyMetrics(props, props.metricDetails.metricDimensions.regionalDimensions(aws_cdk_lib_1.Fn.ref("AWS::Region")));
    }
    /**
     * Creates a regional average latency metric, averages the values from all of the
     * metric names that represent either SuccessLatency or FaultLatency
     * @param props
     * @returns
     */
    static createRegionalAverageLatencyMetric(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createAverageLatencyMetric(props, props.metricDetails.metricDimensions.regionalDimensions(aws_cdk_lib_1.Fn.ref("AWS::Region")));
    }
    /**
     * Creates a count of high latency metrics for either SuccessLatency or FaultLatency
     * @param props
     * @returns
     */
    static createRegionalLatencyCountMetric(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createLatencyCountMetric(props, props.metricDetails.metricDimensions.regionalDimensions(aws_cdk_lib_1.Fn.ref("AWS::Region")));
    }
    /**
     * Creates a count of high latency responses for all critical operations
     * @param props
     * @returns
     */
    static createRegionalServiceLatencyCountMetrics(props) {
        let usingMetrics = {};
        let operationMetrics = [];
        let keyPrefix = AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.nextChar("");
        props.latencyMetricProps.forEach((prop, index) => {
            let operationRegionalMetric = this.createRegionalLatencyCountMetric(prop);
            operationMetrics.push(operationRegionalMetric);
            usingMetrics[`${keyPrefix}${index}`] = operationRegionalMetric;
            keyPrefix = AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.nextChar(keyPrefix);
        });
        if (Object.keys(usingMetrics).length == 1) {
            operationMetrics.push(Object.values(usingMetrics)[0]);
        }
        else {
            let math = new aws_cloudwatch_1.MathExpression({
                usingMetrics: usingMetrics,
                period: props.period,
                label: props.label,
                expression: Object.keys(usingMetrics).join("+"),
            });
            operationMetrics.splice(0, 0, math);
        }
        return operationMetrics;
    }
}
exports.RegionalLatencyMetrics = RegionalLatencyMetrics;
//# sourceMappingURL=data:application/json;base64,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