import { IMetric } from "aws-cdk-lib/aws-cloudwatch";
import { RegionalLatencyMetricProps } from "./props/RegionalLatencyMetricProps";
import { ServiceLatencyMetricProps } from "./props/ServiceLatencyMericProps";
export declare class RegionalLatencyMetrics {
    /**
     * Creates a metrics for regional latency, one metric per metric name for the
     * specified type of latency metric. You will need to perform some aggregation
     * of these metrics if there is more than 1 metric name that correponds to
     * SuccessLatency or FaultLatency, like doing an average.
     * @param props
     * @returns
     */
    static createRegionalLatencyMetrics(props: RegionalLatencyMetricProps): IMetric[];
    /**
     * Creates a regional average latency metric, averages the values from all of the
     * metric names that represent either SuccessLatency or FaultLatency
     * @param props
     * @returns
     */
    static createRegionalAverageLatencyMetric(props: RegionalLatencyMetricProps): IMetric;
    /**
     * Creates a count of high latency metrics for either SuccessLatency or FaultLatency
     * @param props
     * @returns
     */
    static createRegionalLatencyCountMetric(props: RegionalLatencyMetricProps): IMetric;
    /**
     * Creates a count of high latency responses for all critical operations
     * @param props
     * @returns
     */
    static createRegionalServiceLatencyCountMetrics(props: ServiceLatencyMetricProps): IMetric[];
}
