"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegionalAvailabilityMetrics = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const AvailabilityAndLatencyMetrics_1 = require("./AvailabilityAndLatencyMetrics");
const AvailabilityMetricType_1 = require("../utilities/AvailabilityMetricType");
class RegionalAvailabilityMetrics {
    /**
     * Creates a regional availability metric
     * @param props
     * @returns
     */
    static createRegionalAvailabilityMetric(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createAvailabilityMetric(props, props.metricDetails.metricDimensions.regionalDimensions(aws_cdk_lib_1.Fn.ref("AWS::Region")));
    }
    /**
     * Creates a regional service level availability metrics, one metric for
     * each operation at the regional level and the service.
     * @param props
     * @returns The metric at index 0 is the metric math expression for the whole service. The following metrics
     * are the metrics for each operation included in the request availability metric props.
     */
    static createRegionalServiceAvailabilityMetrics(props) {
        let usingMetrics = {};
        let operationMetrics = [];
        let counter = 0;
        props.availabilityMetricProps.forEach((prop) => {
            let keyPrefix = (prop.keyPrefix === undefined || prop.keyPrefix == ""
                ? ""
                : prop.keyPrefix.toLowerCase() + "_") +
                prop.metricDetails.operationName.toLowerCase() +
                "_" +
                prop.metricType.toString().toLowerCase();
            let regionalOperationAvailabilityMetric = this.createRegionalAvailabilityMetric(prop);
            operationMetrics.push(regionalOperationAvailabilityMetric);
            usingMetrics[`${keyPrefix}${counter++}`] =
                regionalOperationAvailabilityMetric;
        });
        let expression = "";
        switch (props.availabilityMetricProps[0].metricType) {
            case AvailabilityMetricType_1.AvailabilityMetricType.SUCCESS_RATE:
                expression = `(${Object.keys(usingMetrics).join("+")}) / ${props.availabilityMetricProps.length}`;
                break;
            case AvailabilityMetricType_1.AvailabilityMetricType.REQUEST_COUNT:
                expression = `${Object.keys(usingMetrics).join("+")}`;
                break;
            case AvailabilityMetricType_1.AvailabilityMetricType.FAULT_COUNT:
                expression = `${Object.keys(usingMetrics).join("+")}`;
                break;
            case AvailabilityMetricType_1.AvailabilityMetricType.FAULT_RATE:
                expression = `(${Object.keys(usingMetrics).join("+")}) / ${props.availabilityMetricProps.length}`;
                break;
            case AvailabilityMetricType_1.AvailabilityMetricType.SUCCESS_COUNT:
                expression = `${Object.keys(usingMetrics).join("+")}`;
                break;
        }
        let math = new aws_cloudwatch_1.MathExpression({
            usingMetrics: usingMetrics,
            period: props.period,
            label: props.label,
            expression: expression,
        });
        operationMetrics.splice(0, 0, math);
        return operationMetrics;
    }
}
exports.RegionalAvailabilityMetrics = RegionalAvailabilityMetrics;
//# sourceMappingURL=data:application/json;base64,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