import { IMetric } from "aws-cdk-lib/aws-cloudwatch";
import { RegionalAvailabilityMetricProps } from "./props/RegionalAvailabilityMetricProps";
import { ServiceAvailabilityMetricProps } from "./props/ServiceAvailabilityMetricProps";
export declare class RegionalAvailabilityMetrics {
    /**
     * Creates a regional availability metric
     * @param props
     * @returns
     */
    static createRegionalAvailabilityMetric(props: RegionalAvailabilityMetricProps): IMetric;
    /**
     * Creates a regional service level availability metrics, one metric for
     * each operation at the regional level and the service.
     * @param props
     * @returns The metric at index 0 is the metric math expression for the whole service. The following metrics
     * are the metrics for each operation included in the request availability metric props.
     */
    static createRegionalServiceAvailabilityMetrics(props: ServiceAvailabilityMetricProps): IMetric[];
}
