"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerMetrics = void 0;
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class NetworkLoadBalancerMetrics {
    /**
     * Creates a regional processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param period
     * @returns
     */
    static createRegionalNetworkLoadBalancerProcessedBytesMetric(loadBalancerFullName, period) {
        return new aws_cloudwatch_1.Metric({
            metricName: "ProcessedBytes",
            namespace: "AWS/NetworkELB",
            unit: aws_cloudwatch_1.Unit.COUNT,
            period: period,
            statistic: "Sum",
            dimensionsMap: {
                LoadBalancer: loadBalancerFullName,
            },
            label: "ProcessedBytes",
        });
    }
    /**
     * Creates a zonal processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param availabilityZoneName
     * @param period
     * @returns
     */
    static createZonalNetworkLoadBalancerProcessedBytesMetric(loadBalancerFullName, availabilityZoneName, period) {
        return new aws_cloudwatch_1.Metric({
            metricName: "ProcessedBytes",
            namespace: "AWS/NetworkELB",
            unit: aws_cloudwatch_1.Unit.COUNT,
            period: period,
            statistic: "Sum",
            dimensionsMap: {
                LoadBalancer: loadBalancerFullName,
                AvailabilityZone: availabilityZoneName,
            },
            label: "ProcessedBytes",
        });
    }
}
exports.NetworkLoadBalancerMetrics = NetworkLoadBalancerMetrics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTmV0d29ya0xvYWRCYWxhbmNlck1ldHJpY3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvbWV0cmljcy9OZXR3b3JrTG9hZEJhbGFuY2VyTWV0cmljcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSwrREFBbUU7QUFFbkUsTUFBYSwwQkFBMEI7SUFDckM7Ozs7O09BS0c7SUFDSCxNQUFNLENBQUMscURBQXFELENBQzFELG9CQUE0QixFQUM1QixNQUFnQjtRQUVoQixPQUFPLElBQUksdUJBQU0sQ0FBQztZQUNoQixVQUFVLEVBQUUsZ0JBQWdCO1lBQzVCLFNBQVMsRUFBRSxnQkFBZ0I7WUFDM0IsSUFBSSxFQUFFLHFCQUFJLENBQUMsS0FBSztZQUNoQixNQUFNLEVBQUUsTUFBTTtZQUNkLFNBQVMsRUFBRSxLQUFLO1lBQ2hCLGFBQWEsRUFBRTtnQkFDYixZQUFZLEVBQUUsb0JBQW9CO2FBQ25DO1lBQ0QsS0FBSyxFQUFFLGdCQUFnQjtTQUN4QixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0gsTUFBTSxDQUFDLGtEQUFrRCxDQUN2RCxvQkFBNEIsRUFDNUIsb0JBQTRCLEVBQzVCLE1BQWdCO1FBRWhCLE9BQU8sSUFBSSx1QkFBTSxDQUFDO1lBQ2hCLFVBQVUsRUFBRSxnQkFBZ0I7WUFDNUIsU0FBUyxFQUFFLGdCQUFnQjtZQUMzQixJQUFJLEVBQUUscUJBQUksQ0FBQyxLQUFLO1lBQ2hCLE1BQU0sRUFBRSxNQUFNO1lBQ2QsU0FBUyxFQUFFLEtBQUs7WUFDaEIsYUFBYSxFQUFFO2dCQUNiLFlBQVksRUFBRSxvQkFBb0I7Z0JBQ2xDLGdCQUFnQixFQUFFLG9CQUFvQjthQUN2QztZQUNELEtBQUssRUFBRSxnQkFBZ0I7U0FDeEIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBakRELGdFQWlEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IER1cmF0aW9uIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgeyBJTWV0cmljLCBNZXRyaWMsIFVuaXQgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWNsb3Vkd2F0Y2hcIjtcblxuZXhwb3J0IGNsYXNzIE5ldHdvcmtMb2FkQmFsYW5jZXJNZXRyaWNzIHtcbiAgLyoqXG4gICAqIENyZWF0ZXMgYSByZWdpb25hbCBwcm9jZXNzZWQgYnl0ZXMgbWV0cmljIGZvciB0aGUgc3BlY2lmaWVkIGxvYWQgYmFsYW5jZXJcbiAgICogQHBhcmFtIGxvYWRCYWxhbmNlckZ1bGxOYW1lXG4gICAqIEBwYXJhbSBwZXJpb2RcbiAgICogQHJldHVybnNcbiAgICovXG4gIHN0YXRpYyBjcmVhdGVSZWdpb25hbE5ldHdvcmtMb2FkQmFsYW5jZXJQcm9jZXNzZWRCeXRlc01ldHJpYyhcbiAgICBsb2FkQmFsYW5jZXJGdWxsTmFtZTogc3RyaW5nLFxuICAgIHBlcmlvZDogRHVyYXRpb24sXG4gICk6IElNZXRyaWMge1xuICAgIHJldHVybiBuZXcgTWV0cmljKHtcbiAgICAgIG1ldHJpY05hbWU6IFwiUHJvY2Vzc2VkQnl0ZXNcIixcbiAgICAgIG5hbWVzcGFjZTogXCJBV1MvTmV0d29ya0VMQlwiLFxuICAgICAgdW5pdDogVW5pdC5DT1VOVCxcbiAgICAgIHBlcmlvZDogcGVyaW9kLFxuICAgICAgc3RhdGlzdGljOiBcIlN1bVwiLFxuICAgICAgZGltZW5zaW9uc01hcDoge1xuICAgICAgICBMb2FkQmFsYW5jZXI6IGxvYWRCYWxhbmNlckZ1bGxOYW1lLFxuICAgICAgfSxcbiAgICAgIGxhYmVsOiBcIlByb2Nlc3NlZEJ5dGVzXCIsXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIHpvbmFsIHByb2Nlc3NlZCBieXRlcyBtZXRyaWMgZm9yIHRoZSBzcGVjaWZpZWQgbG9hZCBiYWxhbmNlclxuICAgKiBAcGFyYW0gbG9hZEJhbGFuY2VyRnVsbE5hbWVcbiAgICogQHBhcmFtIGF2YWlsYWJpbGl0eVpvbmVOYW1lXG4gICAqIEBwYXJhbSBwZXJpb2RcbiAgICogQHJldHVybnNcbiAgICovXG4gIHN0YXRpYyBjcmVhdGVab25hbE5ldHdvcmtMb2FkQmFsYW5jZXJQcm9jZXNzZWRCeXRlc01ldHJpYyhcbiAgICBsb2FkQmFsYW5jZXJGdWxsTmFtZTogc3RyaW5nLFxuICAgIGF2YWlsYWJpbGl0eVpvbmVOYW1lOiBzdHJpbmcsXG4gICAgcGVyaW9kOiBEdXJhdGlvbixcbiAgKTogSU1ldHJpYyB7XG4gICAgcmV0dXJuIG5ldyBNZXRyaWMoe1xuICAgICAgbWV0cmljTmFtZTogXCJQcm9jZXNzZWRCeXRlc1wiLFxuICAgICAgbmFtZXNwYWNlOiBcIkFXUy9OZXR3b3JrRUxCXCIsXG4gICAgICB1bml0OiBVbml0LkNPVU5ULFxuICAgICAgcGVyaW9kOiBwZXJpb2QsXG4gICAgICBzdGF0aXN0aWM6IFwiU3VtXCIsXG4gICAgICBkaW1lbnNpb25zTWFwOiB7XG4gICAgICAgIExvYWRCYWxhbmNlcjogbG9hZEJhbGFuY2VyRnVsbE5hbWUsXG4gICAgICAgIEF2YWlsYWJpbGl0eVpvbmU6IGF2YWlsYWJpbGl0eVpvbmVOYW1lLFxuICAgICAgfSxcbiAgICAgIGxhYmVsOiBcIlByb2Nlc3NlZEJ5dGVzXCIsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==