import { Duration } from "aws-cdk-lib";
import { IMetric } from "aws-cdk-lib/aws-cloudwatch";
export declare class ApplicationLoadBalancerMetrics {
    /**
     * Creates a regional fault count metric using 5xx target and load balancer
     * metrics against total requests for the specified load balancer
     * @param period
     * @param loadBalancerFullName
     * @returns
     */
    static createRegionalApplicationLoadBalancerFaultRateMetric(loadBalancerFullName: string, period: Duration): IMetric;
    /**
     * Creates a zonal fault count metric using 5xx target and load balancer
     * metrics against total requests for the specified load balancer
     * @param loadBalancerFullName
     * @param availabilityZoneName
     * @param period
     * @returns
     */
    static createZonalApplicationLoadBalancerFaultRateMetric(loadBalancerFullName: string, availabilityZoneName: string, period: Duration): IMetric;
    /**
     * Creates a regional processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param period
     * @returns
     */
    static createRegionalApplicationLoadBalancerProcessedBytesMetric(loadBalancerFullName: string, period: Duration): IMetric;
    /**
     * Creates a zonal processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param availabilityZoneName
     * @param period
     * @returns IMetric
     */
    static createZonalApplicationLoadBalancerProcessedBytesMetric(loadBalancerFullName: string, availabilityZoneName: string, period: Duration): IMetric;
}
