"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContributorInsightsWidget = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * A Contributor Insight dashboard widget
 */
class ContributorInsightsWidget extends aws_cloudwatch_1.ConcreteWidget {
    /**
     * Creates the widget
     * @param props
     */
    constructor(props) {
        super(props.width === undefined ? 6 : props.width, props.height === undefined ? 6 : props.height);
        this.properties = props;
    }
    /**
     * Converts the widget into an array of JSON objects (not string), this returns
     * a single item in the array
     * @returns An array of dictionaries
     */
    toJson() {
        return [
            {
                type: "metric",
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    insightRule: {
                        maxContributorCount: this.properties.topContributors,
                        orderBy: this.properties.orderStatistic,
                        ruleName: this.properties.insightRule.attrRuleName,
                    },
                    region: this.properties.region !== undefined
                        ? this.properties.region
                        : aws_cdk_lib_1.Fn.ref("AWS::Region"),
                    legend: {
                        position: this.properties.legendPosition,
                    },
                    view: "timeSeries",
                    period: this.properties.period.toSeconds(),
                    title: this.properties.title,
                    accountId: this.properties.accountId,
                },
            },
        ];
    }
}
exports.ContributorInsightsWidget = ContributorInsightsWidget;
//# sourceMappingURL=data:application/json;base64,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