"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CanaryTest = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const constructs_1 = require("constructs");
class CanaryTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.timedEventRules = {};
        this.metricNamespace = props.operation.canaryMetricDetails
            ? props.operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                .metricNamespace
            : "canary/metrics";
        props.operation.service.availabilityZoneNames.forEach((availabilityZoneName, index) => {
            let availabilityZoneId = props.azMapper.availabilityZoneIdFromAvailabilityZoneLetter(availabilityZoneName.substring(availabilityZoneName.length - 1));
            let scheme = props.operation.service.baseUrl.split(":")[0];
            let url = scheme +
                "://" +
                availabilityZoneName +
                "." +
                props.loadBalancer.loadBalancerDnsName +
                props.operation.path;
            let data = {
                parameters: {
                    methods: props.httpMethods !== undefined
                        ? props.httpMethods
                        : props.operation.httpMethods,
                    url: url,
                    postData: props.postData === undefined ? "" : props.postData,
                    headers: props.headers === undefined ? {} : props.headers,
                    operation: props.operation.operationName,
                    faultBoundaryId: availabilityZoneId,
                    faultBoundary: "az",
                    metricNamespace: this.metricNamespace,
                    requestCount: props.requestCount,
                },
            };
            this.timedEventRules[availabilityZoneId] = new aws_events_1.Rule(this, "AZ" + index + props.operation.operationName + "TimedEvent", {
                schedule: aws_events_1.Schedule.expression(props.schedule),
                enabled: true,
                targets: [
                    new aws_events_targets_1.LambdaFunction(props.function, {
                        event: aws_events_1.RuleTargetInput.fromObject(data),
                    }),
                ],
            });
        });
        let scheme = props.operation.service.baseUrl.split(":")[0];
        let url = scheme +
            "://" +
            props.loadBalancer.loadBalancerDnsName +
            props.operation.path;
        let data = {
            parameters: {
                methods: props.httpMethods !== undefined
                    ? props.httpMethods
                    : props.operation.httpMethods,
                url: url,
                postData: props.postData === undefined ? "" : props.postData,
                headers: props.headers === undefined ? {} : props.headers,
                operation: props.operation.operationName,
                faultBoundaryId: aws_cdk_lib_1.Fn.ref("AWS::Region"),
                faultBoundary: "region",
                metricNamespace: this.metricNamespace,
                requestCount: props.regionalRequestCount,
            },
        };
        this.timedEventRules[aws_cdk_lib_1.Fn.ref("AWS::Region")] = new aws_events_1.Rule(this, "RegionalTimedEvent", {
            schedule: aws_events_1.Schedule.expression(props.schedule),
            enabled: true,
            targets: [
                new aws_events_targets_1.LambdaFunction(props.function, {
                    event: aws_events_1.RuleTargetInput.fromObject(data),
                }),
            ],
        });
    }
}
exports.CanaryTest = CanaryTest;
//# sourceMappingURL=data:application/json;base64,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