"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerSideOperationRegionalAlarmsAndRules = void 0;
const AvailabilityAndLatencyAlarmsAndRules_1 = require("./AvailabilityAndLatencyAlarmsAndRules");
const BaseOperationRegionalAlarmsAndRules_1 = require("./BaseOperationRegionalAlarmsAndRules");
/**
 * The server side regional alarms and rules for an operation
 */
class ServerSideOperationRegionalAlarmsAndRules extends BaseOperationRegionalAlarmsAndRules_1.BaseOperationRegionalAlarmsAndRules {
    constructor(scope, id, props) {
        super(scope, id, props);
        if (props.contributorInsightRuleDetails !== undefined &&
            props.contributorInsightRuleDetails != null) {
            this.instanceContributorsToRegionalFaults =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalInstanceContributorsToFaults(this, props.availabilityMetricDetails, props.contributorInsightRuleDetails);
            this.instanceContributorsToRegionalHighLatency =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalInstanceContributorsToHighLatency(this, props.latencyMetricDetails, props.contributorInsightRuleDetails);
        }
    }
}
exports.ServerSideOperationRegionalAlarmsAndRules = ServerSideOperationRegionalAlarmsAndRules;
//# sourceMappingURL=data:application/json;base64,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