import { IAlarm } from "aws-cdk-lib/aws-cloudwatch";
import { Construct } from "constructs";
import { ICanaryOperationRegionalAlarmsAndRules } from "./ICanaryOperationRegionalAlarmsAndRules";
import { ICanaryOperationZonalAlarmsAndRules } from "./ICanaryOperationZonalAlarmsAndRules";
import { IOperationAlarmsAndRules } from "./IOperationAlarmsAndRules";
import { IServerSideOperationRegionalAlarmsAndRules } from "./IServerSideOperationRegionalAlarmsAndRules";
import { IServerSideOperationZonalAlarmsAndRules } from "./IServerSideOperationZonalAlarmsAndRules";
import { OperationAlarmsAndRulesProps } from "./props/OperationAlarmsAndRulesProps";
import { IOperation } from "../services/IOperation";
/**
 * Creates alarms and rules for an operation for both regional and zonal metrics
 */
export declare class OperationAlarmsAndRules extends Construct implements IOperationAlarmsAndRules {
    /**
     * The operation the alarms and rules are created for
     */
    readonly operation: IOperation;
    /**
     * The server side regional alarms and rules
     */
    readonly serverSideRegionalAlarmsAndRules: IServerSideOperationRegionalAlarmsAndRules;
    /**
     * The canary regional alarms and rules
     */
    readonly canaryRegionalAlarmsAndRules?: ICanaryOperationRegionalAlarmsAndRules;
    /**
     * The aggregate regional alarm that looks at both canary and server
     * side impact alarms for latency and availability
     */
    readonly aggregateRegionalAlarm: IAlarm;
    /**
     * The server side zonal alarms and rules
     */
    readonly serverSideZonalAlarmsAndRules: IServerSideOperationZonalAlarmsAndRules[];
    /**
     * The canary zonal alarms and rules
     */
    readonly canaryZonalAlarmsAndRules?: ICanaryOperationZonalAlarmsAndRules[];
    /**
     * The aggregate zonal alarms, one per AZ. Each alarm indicates there is either
     * latency or availability impact in that AZ, and the AZ is an outlier for
     * availability or latency impact. Both server side and canary metrics are
     * evaluated
     */
    readonly aggregateZonalAlarms: IAlarm[];
    /**
     * The aggregate zonal alarm indexed by Availability Zone Id.
     */
    readonly aggregateZonalAlarmsMap: {
        [key: string]: IAlarm;
    };
    /**
     * Just the server side zonal alarms
     */
    readonly serverSideZonalAlarmsMap: {
        [key: string]: IAlarm;
    };
    constructor(scope: Construct, id: string, props: OperationAlarmsAndRulesProps);
}
