"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InsightRuleBody = void 0;
/**
 * The insight rule body to be included in a CfnInsightRule construct
 */
class InsightRuleBody {
    constructor() {
        this.schema = {
            name: "CloudWatchLogRule",
            version: 1,
        };
        this.aggregateOn = "";
        this.contribution = {
            keys: [],
        };
        this.logFormat = "";
        this.logGroupNames = [];
    }
    /**
     * Converts the rule to a JSON string
     * @returns
     */
    toJson() {
        let objectKeysToUpperCase = function (input) {
            if (typeof input !== "object")
                return input;
            if (Array.isArray(input))
                return input.map(objectKeysToUpperCase);
            return Object.keys(input).reduce(function (newObj, key) {
                let val = input[key];
                let newVal = typeof val === "object" && val !== null
                    ? objectKeysToUpperCase(val)
                    : val;
                let newKey = key.slice(0, 1).toUpperCase() + key.substring(1);
                newObj[newKey] = newVal;
                return newObj;
            }, {});
        };
        return JSON.stringify(objectKeysToUpperCase(this));
    }
}
exports.InsightRuleBody = InsightRuleBody;
//# sourceMappingURL=data:application/json;base64,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