"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CanaryOperationZonalAlarmsAndRules = void 0;
const AvailabilityAndLatencyAlarmsAndRules_1 = require("./AvailabilityAndLatencyAlarmsAndRules");
const BaseOperationZonalAlarmsAndRules_1 = require("./BaseOperationZonalAlarmsAndRules");
/**
 * Creates the alarms and rules for a particular operation as measured by the canary
 */
class CanaryOperationZonalAlarmsAndRules extends BaseOperationZonalAlarmsAndRules_1.BaseOperationZonalAlarmsAndRules {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.isolatedImpactAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createCanaryIsolatedAZImpactAlarm(this, props.availabilityMetricDetails.operationName, props.availabilityZoneId, props.counter, this.availabilityZoneIsOutlierForFaults, this.availabilityAlarm, this.availabilityZoneIsOutlierForLatency, this.latencyAlarm, props.nameSuffix);
    }
}
exports.CanaryOperationZonalAlarmsAndRules = CanaryOperationZonalAlarmsAndRules;
//# sourceMappingURL=data:application/json;base64,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