"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseOperationZonalAlarmsAndRules = void 0;
const constructs_1 = require("constructs");
const AvailabilityAndLatencyAlarmsAndRules_1 = require("./AvailabilityAndLatencyAlarmsAndRules");
const OutlierDetectionAlgorithm_1 = require("../utilities/OutlierDetectionAlgorithm");
/**
 * The base operation regional alarms and rules
 */
class BaseOperationZonalAlarmsAndRules extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.availabilityZoneId = props.availabilityZoneId;
        this.availabilityAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalAvailabilityAlarm(this, props.availabilityMetricDetails, props.availabilityZoneId, props.counter, props.nameSuffix);
        this.latencyAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalLatencyAlarm(this, props.latencyMetricDetails, props.availabilityZoneId, props.counter, props.nameSuffix);
        this.availabilityOrLatencyAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalAvailabilityOrLatencyCompositeAlarm(this, props.availabilityMetricDetails.operationName, props.availabilityZoneId, props.counter, this.availabilityAlarm, this.latencyAlarm, props.nameSuffix);
        if (props.outlierDetectionAlgorithm == OutlierDetectionAlgorithm_1.OutlierDetectionAlgorithm.STATIC) {
            this.availabilityZoneIsOutlierForFaults =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalFaultRateStaticOutlierAlarm(this, props.availabilityMetricDetails, props.availabilityZoneId, props.counter, props.outlierThreshold, props.nameSuffix);
            this.availabilityZoneIsOutlierForLatency =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalHighLatencyStaticOutlierAlarm(this, props.latencyMetricDetails, props.availabilityZoneId, props.counter, props.outlierThreshold, props.nameSuffix);
        }
        else {
            this.availabilityZoneIsOutlierForFaults =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalFaultRateOutlierAlarm(this, props.availabilityMetricDetails, props.availabilityZoneId, props.operation.service.availabilityZoneNames.map((az) => {
                    return props.azMapper.availabilityZoneIdFromAvailabilityZoneLetter(az.substring(az.length - 1));
                }), props.outlierThreshold, props.outlierDetectionFunction, props.outlierDetectionAlgorithm, props.counter, props.nameSuffix);
            this.availabilityZoneIsOutlierForLatency =
                AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createZonalHighLatencyOutlierAlarm(this, props.latencyMetricDetails, props.availabilityZoneId, props.operation.service.availabilityZoneNames.map((az) => {
                    return props.azMapper.availabilityZoneIdFromAvailabilityZoneLetter(az.substring(az.length - 1));
                }), props.outlierThreshold, props.outlierDetectionFunction, props.outlierDetectionAlgorithm, props.counter, props.nameSuffix);
        }
    }
}
exports.BaseOperationZonalAlarmsAndRules = BaseOperationZonalAlarmsAndRules;
//# sourceMappingURL=data:application/json;base64,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