"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseOperationRegionalAlarmsAndRules = void 0;
const constructs_1 = require("constructs");
const AvailabilityAndLatencyAlarmsAndRules_1 = require("./AvailabilityAndLatencyAlarmsAndRules");
/**
 * Base operation regional alarms and rules
 */
class BaseOperationRegionalAlarmsAndRules extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.availabilityAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalAvailabilityAlarm(this, props.availabilityMetricDetails, props.nameSuffix);
        this.latencyAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalLatencyAlarm(this, props.latencyMetricDetails, props.nameSuffix);
        this.availabilityOrLatencyAlarm =
            AvailabilityAndLatencyAlarmsAndRules_1.AvailabilityAndLatencyAlarmsAndRules.createRegionalCustomerExperienceAlarm(this, props.availabilityMetricDetails.operationName, props.nameSuffix, this.availabilityAlarm, this.latencyAlarm);
    }
}
exports.BaseOperationRegionalAlarmsAndRules = BaseOperationRegionalAlarmsAndRules;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQmFzZU9wZXJhdGlvblJlZ2lvbmFsQWxhcm1zQW5kUnVsZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvYWxhcm1zYW5kcnVsZXMvQmFzZU9wZXJhdGlvblJlZ2lvbmFsQWxhcm1zQW5kUnVsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EsMkNBQXVDO0FBQ3ZDLGlHQUE4RjtBQUk5Rjs7R0FFRztBQUNILE1BQXNCLG1DQUNwQixTQUFRLHNCQUFTO0lBa0JqQixZQUNFLEtBQWdCLEVBQ2hCLEVBQVUsRUFDVixLQUErQztRQUUvQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxpQkFBaUI7WUFDcEIsMkVBQW9DLENBQUMsK0JBQStCLENBQ2xFLElBQUksRUFDSixLQUFLLENBQUMseUJBQXlCLEVBQy9CLEtBQUssQ0FBQyxVQUFVLENBQ2pCLENBQUM7UUFDSixJQUFJLENBQUMsWUFBWTtZQUNmLDJFQUFvQyxDQUFDLDBCQUEwQixDQUM3RCxJQUFJLEVBQ0osS0FBSyxDQUFDLG9CQUFvQixFQUMxQixLQUFLLENBQUMsVUFBVSxDQUNqQixDQUFDO1FBQ0osSUFBSSxDQUFDLDBCQUEwQjtZQUM3QiwyRUFBb0MsQ0FBQyxxQ0FBcUMsQ0FDeEUsSUFBSSxFQUNKLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxhQUFhLEVBQzdDLEtBQUssQ0FBQyxVQUFVLEVBQ2hCLElBQUksQ0FBQyxpQkFBaUIsRUFDdEIsSUFBSSxDQUFDLFlBQVksQ0FDbEIsQ0FBQztJQUNOLENBQUM7Q0FDRjtBQS9DRCxrRkErQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJQWxhcm0gfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWNsb3Vkd2F0Y2hcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBBdmFpbGFiaWxpdHlBbmRMYXRlbmN5QWxhcm1zQW5kUnVsZXMgfSBmcm9tIFwiLi9BdmFpbGFiaWxpdHlBbmRMYXRlbmN5QWxhcm1zQW5kUnVsZXNcIjtcbmltcG9ydCB7IElCYXNlT3BlcmF0aW9uUmVnaW9uYWxBbGFybXNBbmRSdWxlcyB9IGZyb20gXCIuL0lCYXNlT3BlcmF0aW9uUmVnaW9uYWxBbGFybXNBbmRSdWxlc1wiO1xuaW1wb3J0IHsgQmFzZU9wZXJhdGlvblJlZ2lvbmFsQWxhcm1zQW5kUnVsZXNQcm9wcyB9IGZyb20gXCIuL3Byb3BzL0Jhc2VPcGVyYXRpb25SZWdpb25hbEFsYXJtc0FuZFJ1bGVzUHJvcHNcIjtcblxuLyoqXG4gKiBCYXNlIG9wZXJhdGlvbiByZWdpb25hbCBhbGFybXMgYW5kIHJ1bGVzXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBCYXNlT3BlcmF0aW9uUmVnaW9uYWxBbGFybXNBbmRSdWxlc1xuICBleHRlbmRzIENvbnN0cnVjdFxuICBpbXBsZW1lbnRzIElCYXNlT3BlcmF0aW9uUmVnaW9uYWxBbGFybXNBbmRSdWxlc1xue1xuICAvKipcbiAgICogQXZhaWxhYmlsaXR5IGFsYXJtIGZvciB0aGlzIG9wZXJhdGlvblxuICAgKi9cbiAgYXZhaWxhYmlsaXR5QWxhcm06IElBbGFybTtcblxuICAvKipcbiAgICogTGF0ZW5jeSBhbGFybSBmb3IgdGhpcyBvcGVyYXRpb25cbiAgICovXG4gIGxhdGVuY3lBbGFybTogSUFsYXJtO1xuXG4gIC8qKlxuICAgKiBDb21wb3NpdGUgYWxhcm0gZm9yIGVpdGhlciBhdmFpbGFiaWx0aXkgb3IgbGF0ZW5jeSBpbXBhY3QgdG8gdGhpcyBvcGVyYXRpb25cbiAgICovXG4gIGF2YWlsYWJpbGl0eU9yTGF0ZW5jeUFsYXJtOiBJQWxhcm07XG5cbiAgY29uc3RydWN0b3IoXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBpZDogc3RyaW5nLFxuICAgIHByb3BzOiBCYXNlT3BlcmF0aW9uUmVnaW9uYWxBbGFybXNBbmRSdWxlc1Byb3BzLFxuICApIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5hdmFpbGFiaWxpdHlBbGFybSA9XG4gICAgICBBdmFpbGFiaWxpdHlBbmRMYXRlbmN5QWxhcm1zQW5kUnVsZXMuY3JlYXRlUmVnaW9uYWxBdmFpbGFiaWxpdHlBbGFybShcbiAgICAgICAgdGhpcyxcbiAgICAgICAgcHJvcHMuYXZhaWxhYmlsaXR5TWV0cmljRGV0YWlscyxcbiAgICAgICAgcHJvcHMubmFtZVN1ZmZpeCxcbiAgICAgICk7XG4gICAgdGhpcy5sYXRlbmN5QWxhcm0gPVxuICAgICAgQXZhaWxhYmlsaXR5QW5kTGF0ZW5jeUFsYXJtc0FuZFJ1bGVzLmNyZWF0ZVJlZ2lvbmFsTGF0ZW5jeUFsYXJtKFxuICAgICAgICB0aGlzLFxuICAgICAgICBwcm9wcy5sYXRlbmN5TWV0cmljRGV0YWlscyxcbiAgICAgICAgcHJvcHMubmFtZVN1ZmZpeCxcbiAgICAgICk7XG4gICAgdGhpcy5hdmFpbGFiaWxpdHlPckxhdGVuY3lBbGFybSA9XG4gICAgICBBdmFpbGFiaWxpdHlBbmRMYXRlbmN5QWxhcm1zQW5kUnVsZXMuY3JlYXRlUmVnaW9uYWxDdXN0b21lckV4cGVyaWVuY2VBbGFybShcbiAgICAgICAgdGhpcyxcbiAgICAgICAgcHJvcHMuYXZhaWxhYmlsaXR5TWV0cmljRGV0YWlscy5vcGVyYXRpb25OYW1lLFxuICAgICAgICBwcm9wcy5uYW1lU3VmZml4LFxuICAgICAgICB0aGlzLmF2YWlsYWJpbGl0eUFsYXJtLFxuICAgICAgICB0aGlzLmxhdGVuY3lBbGFybSxcbiAgICAgICk7XG4gIH1cbn1cbiJdfQ==