# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['piri2']

package_data = \
{'': ['*']}

install_requires = \
['jsonschema>=3.2.0,<4.0.0',
 'pycountry==19.8.18',
 'returns>=0.14.0,<0.15.0',
 'typing_extensions==3.7.4']

setup_kwargs = {
    'name': 'piri2',
    'version': '0.0.2',
    'description': 'Configurable and documentable Json transformation and mapping',
    'long_description': '# Piri\nConfigurable Data Mapping for mortals\n___\n![test](https://github.com/greenbird/piri/workflows/test/badge.svg)\n[![codecov](https://codecov.io/gh/greenbird/piri/branch/master/graph/badge.svg)](https://codecov.io/gh/greenbird/piri)\n[![Python Version](https://img.shields.io/pypi/pyversions/piri.svg)](https://pypi.org/project/piri/)\n[![wemake-python-styleguide](https://img.shields.io/badge/style-wemake-000000.svg)](https://github.com/wemake-services/wemake-python-styleguide)\n___\n\n**Documentation\n([Stable](https://piri.readthedocs.io/) |\n[Latest](https://piri.readthedocs.io/en/latest/)) |\n[Source Code](https://github.com/greenbird/piri) |\n[Task Tracker](https://github.com/greenbird/piri/issues)**\n\n## What is Piri\n\nPiri is a JSON to JSON mapper. That means that we read input JSON and create output JSON. How the output is created is based on instructions from a configuration file. The configuration file governs the the output structure and tells piri where in the input to find data and where to place it in the output. In addition to this Piri supports data transformation with `data casting`, `if conditions`, `combination of data from multiple places` and of course setting `default` values.\n\n__This enables you to change any input into the output you desire.__\n\n## Typical usecases\n\n* You `GET` data from api, but need to transform it for your backend system\n* `POST`ing data to an api that needs data on a different format than what your system produces\n* All your backends speak different language? pipe it through __Piri__\n* Customer delivers weirdly formatted data? Use __Piri__ to make it sexy\n* Have CSV but need nicely structured JSON? make CSV into a JSON list and transform it with __Piri__\n* Have XML but need to change it? make it into JSON, transform it with __Piri__ and then dump it to XML again.\n* Customers legacy system needs CSV. Use __Piri__ to transform your nicely structured JSON data into a JSON List that can be easily dumped to CSV\n\n## Official Open Piri Solutions\n\n[piri-cli](https://github.com/greenbird/piri-cli), commandline interface for file to file mapping.\n\n[piri-web](https://github.com/greenbird/piri-web), One Click deploy Web REST API for Piri JSON mapping.\n\n## Enterprise solutions\n\nComing...\n\n## Goal\n\nThe goal of this library is to make JSON to JSON transformation/mapping easy, configurable and documentable. We achieve this by using a simple but feature-rich JSON configuration which then also acts as documentation and as a contract between parties.\n\n## Why\n\nPiri was born because we really dislike mapping. Documenting whatever decisions made in your code so that some product owner understands it is also _no me gusto_. Transforming data from one format to another is something software engineers do allmost daily... It should be easy! And documenting it shouldn\'t be something you have to worry about.\n\nAfter the Worst POC in History we never wanted to do mapping by scripts and code again. This lead to the idea that it should be possible to create a file which governs how the structure should look and how the data should be transformed. This would then be the `single source of truth` and with Piri we have achieved this.\n\nWe believe that this will make collaboration between teams faster and easier. Use Piri to agree with data formats between Front-end and Back-end. Between the 3rd party system and your back-end. You can even use Piri for testing existing integrations ;-)\n\n## Features\n\n* Mapping with configuration File.\n* [JSON Schema](https://json-schema.org/) validation of the config file.\n* Structurally Transform JSON\n* Combine multiple values to one.\n* Default values\n* If statements\n    * is, contains, not\n* casting\n    * integer, decimal, iso date\n\n## Contributing\nPlease see [contribute](https://piri.readthedocs.io/en/stable/contributing)\n\n## Installation\n\nPackage is on pypi. Use pip or poetry to install\n\n```sh\npip install piri\n```\n```sh\npoetry add piri\n```\n\n## Introduction\n\nHave a look at our introduction course [here](https://piri.readthedocs.io/en/stable/introduction)\n\n## Quickstart\n```python\nimport simplejson\n\nfrom piri.process import process\n\nmy_config = {\n    \'name\': \'schema\',\n    \'array\': False,\n    \'objects\': [\n        {\n            \'name\': \'invoices\',\n            \'array\': True,\n            \'iterables\': [\n                {\n                    \'alias\': \'invoices\',\n                    \'path\': [\'root\', \'invoices\'],\n                },\n            ],\n            \'attributes\': [\n                {\n                    \'name\': \'amount\',\n                    \'mappings\': [\n                        {\n                            \'path\': [\'invoices\', \'amount\'],\n                        },\n                    ],\n                    \'casting\': {\n                        \'to\': \'decimal\',\n                        \'original_format\': \'integer_containing_decimals\',\n                    },\n                    \'default\': 0,\n                },\n                {\n                    \'name\': \'debtor\',\n                    \'mappings\': [\n                        {\n                            \'path\': [\'root\', \'customer\', \'first_name\'],\n                        },\n                        {\n                            \'path\': [\'root\', \'customer\', \'last_name\'],\n                        },\n                    ],\n                    \'separator\': \' \',\n                },\n            ],\n            \'objects\': [],\n        },\n    ],\n}\n\nexample_data = {\n    \'root\': {\n        \'customer\': {\n            \'first_name\': \'John\',\n            \'last_name\': \'Smith\',\n        },\n        \'invoices\': [\n            {\n                \'amount\': 10050,\n            },\n            {\n                \'amount\': 20050,\n            },\n            {\n                \'amount\': -15005,\n            },\n        ],\n    },\n}\n\nmapped_data = process(example_data, my_config)\n\nwith open(\'resultfile.json\', \'w\') as output_file:\n    output_file.write(simplejson.dumps(mapped_data))\n\n```\n\ncontents of resultfile.json\n```json\n{\n    "invoices": [\n        {\n            "amount": 100.5,\n            "debtor": "John Smith"\n        },\n        {\n            "amount": 200.5,\n            "debtor": "John Smith"\n        },\n        {\n            "amount": -150.05,\n            "debtor": "John Smith"\n        }\n    ]\n}\n```\n',
    'author': 'Thomas Borgen',
    'author_email': 'thomas.borgen@greenbird.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/greenbird/piri',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
