# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddUserGroupRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'locally_managed': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'locally_managed': 'locallyManaged'
    }

    def __init__(self, name=None, locally_managed=None, local_vars_configuration=None):  # noqa: E501
        """AddUserGroupRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._locally_managed = None
        self.discriminator = None

        self.name = name
        if locally_managed is not None:
            self.locally_managed = locally_managed

    @property
    def name(self):
        """Gets the name of this AddUserGroupRequest.  # noqa: E501

        The name of the user group. Should be unique within all user groups.  # noqa: E501

        :return: The name of this AddUserGroupRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AddUserGroupRequest.

        The name of the user group. Should be unique within all user groups.  # noqa: E501

        :param name: The name of this AddUserGroupRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 255):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def locally_managed(self):
        """Gets the locally_managed of this AddUserGroupRequest.  # noqa: E501

        The locallyManaged flag of the user group. Indicates whether this UserGroup is locally managed or not.  # noqa: E501

        :return: The locally_managed of this AddUserGroupRequest.  # noqa: E501
        :rtype: bool
        """
        return self._locally_managed

    @locally_managed.setter
    def locally_managed(self, locally_managed):
        """Sets the locally_managed of this AddUserGroupRequest.

        The locallyManaged flag of the user group. Indicates whether this UserGroup is locally managed or not.  # noqa: E501

        :param locally_managed: The locally_managed of this AddUserGroupRequest.  # noqa: E501
        :type: bool
        """

        self._locally_managed = locally_managed

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddUserGroupRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddUserGroupRequest):
            return True

        return self.to_dict() != other.to_dict()
