#
# Copyright 2021, Robert Dyer,
#                 and University of Nebraska Board of Regents
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from boaapi.boa_client import BoaClient
from typing import Dict, Tuple

class JobHandle:
    client: BoaClient
    id: int
    date: str
    dataset: Dict[str, str]
    compiler_status: int
    exec_status: int

    def __init__(self, client: BoaClient, id: int, date: str, dataset: Dict[str, str], compiler_status: int, exec_status: int) -> None: ...
    def stop(self) -> None: ...
    def resubmit(self) -> None: ...
    def delete(self) -> None: ...
    def get_url(self) -> str: ...
    def set_public(self, status: bool) -> None: ...
    def get_public(self) -> bool: ...
    def get_public_url(self) -> str: ...
    def source(self) -> str: ...
    def get_compiler_errors(self) -> str: ...
    def output(self) -> str: ...
    def output_size(self) -> int: ...
    def output_hash(self) -> Tuple[int, str]: ...
    def wait(self) -> bool: ...
    def refresh(self) -> None: ...
    def is_running(self) -> bool: ...
