#
# Copyright 2021, Robert Dyer,
#                 and University of Nebraska Board of Regents
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import xmlrpc.client
from boaapi.job_handle import JobHandle
from boaapi.util import CookiesTransport, fetch_url, parse_job
from typing import Dict, List, Optional

BOA_API_ENDPOINT: str
BOAC_API_ENDPOINT: str

class NotLoggedInException(Exception): ...
class BoaException(Exception): ...

class BoaClient:
    server: xmlrpc.client.ServerProxy
    trans: xmlrpc.client.Transport

    def __init__(self, endpoint: str = ...) -> None: ...
    def login(self, username: str, password: str): ...
    def close(self) -> None: ...
    def ensure_logged_in(self) -> None: ...
    def datasets(self) -> List[Dict[str, str]]: ...
    def dataset_names(self) -> List[str]: ...
    def get_dataset(self, name: str) -> Optional[Dict[str, str]]: ...
    def last_job(self) -> JobHandle: ...
    def job_count(self, pub_only: bool = ...) -> int: ...
    def query(self, query: str, dataset: Optional[Dict[str, str]] = ...) -> JobHandle: ...
    def get_job(self, id: int) -> JobHandle: ...
    def job_list(self, pub_only: bool = ..., offset: int = ..., length: int = ...) -> List[JobHandle]: ...
