from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

from . import entity, malware_state_for_windows_device, windows_malware_category, windows_malware_severity

class WindowsMalwareInformation(entity.Entity):
    """
    Malware information entity.
    """
    @property
    def additional_information_url(self,) -> Optional[str]:
        """
        Gets the additionalInformationUrl property value. Information URL to learn more about the malware
        Returns: Optional[str]
        """
        return self._additional_information_url
    
    @additional_information_url.setter
    def additional_information_url(self,value: Optional[str] = None) -> None:
        """
        Sets the additionalInformationUrl property value. Information URL to learn more about the malware
        Args:
            value: Value to set for the additionalInformationUrl property.
        """
        self._additional_information_url = value
    
    @property
    def category(self,) -> Optional[windows_malware_category.WindowsMalwareCategory]:
        """
        Gets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
        Returns: Optional[windows_malware_category.WindowsMalwareCategory]
        """
        return self._category
    
    @category.setter
    def category(self,value: Optional[windows_malware_category.WindowsMalwareCategory] = None) -> None:
        """
        Sets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
        Args:
            value: Value to set for the category property.
        """
        self._category = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new windowsMalwareInformation and sets the default values.
        """
        super().__init__()
        # Information URL to learn more about the malware
        self._additional_information_url: Optional[str] = None
        # Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
        self._category: Optional[windows_malware_category.WindowsMalwareCategory] = None
        # List of devices affected by current malware with the malware state on each device
        self._device_malware_states: Optional[List[malware_state_for_windows_device.MalwareStateForWindowsDevice]] = None
        # Malware name
        self._display_name: Optional[str] = None
        # The last time the malware is detected
        self._last_detection_date_time: Optional[datetime] = None
        # The OdataType property
        self.odata_type: Optional[str] = None
        # Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
        self._severity: Optional[windows_malware_severity.WindowsMalwareSeverity] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> WindowsMalwareInformation:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: WindowsMalwareInformation
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return WindowsMalwareInformation()
    
    @property
    def device_malware_states(self,) -> Optional[List[malware_state_for_windows_device.MalwareStateForWindowsDevice]]:
        """
        Gets the deviceMalwareStates property value. List of devices affected by current malware with the malware state on each device
        Returns: Optional[List[malware_state_for_windows_device.MalwareStateForWindowsDevice]]
        """
        return self._device_malware_states
    
    @device_malware_states.setter
    def device_malware_states(self,value: Optional[List[malware_state_for_windows_device.MalwareStateForWindowsDevice]] = None) -> None:
        """
        Sets the deviceMalwareStates property value. List of devices affected by current malware with the malware state on each device
        Args:
            value: Value to set for the deviceMalwareStates property.
        """
        self._device_malware_states = value
    
    @property
    def display_name(self,) -> Optional[str]:
        """
        Gets the displayName property value. Malware name
        Returns: Optional[str]
        """
        return self._display_name
    
    @display_name.setter
    def display_name(self,value: Optional[str] = None) -> None:
        """
        Sets the displayName property value. Malware name
        Args:
            value: Value to set for the displayName property.
        """
        self._display_name = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "additional_information_url": lambda n : setattr(self, 'additional_information_url', n.get_str_value()),
            "category": lambda n : setattr(self, 'category', n.get_enum_value(windows_malware_category.WindowsMalwareCategory)),
            "device_malware_states": lambda n : setattr(self, 'device_malware_states', n.get_collection_of_object_values(malware_state_for_windows_device.MalwareStateForWindowsDevice)),
            "display_name": lambda n : setattr(self, 'display_name', n.get_str_value()),
            "last_detection_date_time": lambda n : setattr(self, 'last_detection_date_time', n.get_datetime_value()),
            "severity": lambda n : setattr(self, 'severity', n.get_enum_value(windows_malware_severity.WindowsMalwareSeverity)),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    @property
    def last_detection_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastDetectionDateTime property value. The last time the malware is detected
        Returns: Optional[datetime]
        """
        return self._last_detection_date_time
    
    @last_detection_date_time.setter
    def last_detection_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastDetectionDateTime property value. The last time the malware is detected
        Args:
            value: Value to set for the lastDetectionDateTime property.
        """
        self._last_detection_date_time = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_str_value("additionalInformationUrl", self.additional_information_url)
        writer.write_enum_value("category", self.category)
        writer.write_collection_of_object_values("deviceMalwareStates", self.device_malware_states)
        writer.write_str_value("displayName", self.display_name)
        writer.write_datetime_value("lastDetectionDateTime", self.last_detection_date_time)
        writer.write_enum_value("severity", self.severity)
    
    @property
    def severity(self,) -> Optional[windows_malware_severity.WindowsMalwareSeverity]:
        """
        Gets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
        Returns: Optional[windows_malware_severity.WindowsMalwareSeverity]
        """
        return self._severity
    
    @severity.setter
    def severity(self,value: Optional[windows_malware_severity.WindowsMalwareSeverity] = None) -> None:
        """
        Sets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
        Args:
            value: Value to set for the severity property.
        """
        self._severity = value
    

