from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

from . import windows_malware_category

class WindowsMalwareCategoryCount(AdditionalDataHolder, Parsable):
    """
    Malware category device count
    """
    @property
    def active_malware_detection_count(self,) -> Optional[int]:
        """
        Gets the activeMalwareDetectionCount property value. Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
        Returns: Optional[int]
        """
        return self._active_malware_detection_count
    
    @active_malware_detection_count.setter
    def active_malware_detection_count(self,value: Optional[int] = None) -> None:
        """
        Sets the activeMalwareDetectionCount property value. Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
        Args:
            value: Value to set for the activeMalwareDetectionCount property.
        """
        self._active_malware_detection_count = value
    
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    @property
    def category(self,) -> Optional[windows_malware_category.WindowsMalwareCategory]:
        """
        Gets the category property value. Malware category id
        Returns: Optional[windows_malware_category.WindowsMalwareCategory]
        """
        return self._category
    
    @category.setter
    def category(self,value: Optional[windows_malware_category.WindowsMalwareCategory] = None) -> None:
        """
        Sets the category property value. Malware category id
        Args:
            value: Value to set for the category property.
        """
        self._category = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new windowsMalwareCategoryCount and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
        self._active_malware_detection_count: Optional[int] = None
        # Malware category id
        self._category: Optional[windows_malware_category.WindowsMalwareCategory] = None
        # Count of devices with malware detections for this malware category
        self._device_count: Optional[int] = None
        # Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
        self._distinct_active_malware_count: Optional[int] = None
        # The Timestamp of the last update for the device count in UTC
        self._last_update_date_time: Optional[datetime] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> WindowsMalwareCategoryCount:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: WindowsMalwareCategoryCount
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return WindowsMalwareCategoryCount()
    
    @property
    def device_count(self,) -> Optional[int]:
        """
        Gets the deviceCount property value. Count of devices with malware detections for this malware category
        Returns: Optional[int]
        """
        return self._device_count
    
    @device_count.setter
    def device_count(self,value: Optional[int] = None) -> None:
        """
        Sets the deviceCount property value. Count of devices with malware detections for this malware category
        Args:
            value: Value to set for the deviceCount property.
        """
        self._device_count = value
    
    @property
    def distinct_active_malware_count(self,) -> Optional[int]:
        """
        Gets the distinctActiveMalwareCount property value. Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
        Returns: Optional[int]
        """
        return self._distinct_active_malware_count
    
    @distinct_active_malware_count.setter
    def distinct_active_malware_count(self,value: Optional[int] = None) -> None:
        """
        Sets the distinctActiveMalwareCount property value. Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
        Args:
            value: Value to set for the distinctActiveMalwareCount property.
        """
        self._distinct_active_malware_count = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "active_malware_detection_count": lambda n : setattr(self, 'active_malware_detection_count', n.get_int_value()),
            "category": lambda n : setattr(self, 'category', n.get_enum_value(windows_malware_category.WindowsMalwareCategory)),
            "device_count": lambda n : setattr(self, 'device_count', n.get_int_value()),
            "distinct_active_malware_count": lambda n : setattr(self, 'distinct_active_malware_count', n.get_int_value()),
            "last_update_date_time": lambda n : setattr(self, 'last_update_date_time', n.get_datetime_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
        }
        return fields
    
    @property
    def last_update_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastUpdateDateTime property value. The Timestamp of the last update for the device count in UTC
        Returns: Optional[datetime]
        """
        return self._last_update_date_time
    
    @last_update_date_time.setter
    def last_update_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastUpdateDateTime property value. The Timestamp of the last update for the device count in UTC
        Args:
            value: Value to set for the lastUpdateDateTime property.
        """
        self._last_update_date_time = value
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_int_value("activeMalwareDetectionCount", self.active_malware_detection_count)
        writer.write_enum_value("category", self.category)
        writer.write_int_value("deviceCount", self.device_count)
        writer.write_int_value("distinctActiveMalwareCount", self.distinct_active_malware_count)
        writer.write_datetime_value("lastUpdateDateTime", self.last_update_date_time)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_additional_data_value(self.additional_data)
    

